/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JanelaHyperLink
extends AbstractDialogoOKCancelar {
    private JLabel labelTitulo = new JLabel("Texto para exibi\u00e7\u00e3o:");
    private JLabel labelTexto = new JLabel("Endere\u00e7o web:");
    private JTextField textNomeLink = new JTextField();
    private JTextField textLink = new JTextField();
    private JLabel img = new JLabel("Clique para adicionar imagem");
    private ImageIcon imagem = new ImageIcon();
    private JRadioButton radioTextButton = new JRadioButton("Texto", false);
    private JRadioButton radioImageButton = new JRadioButton("Imagem", false);

    public JanelaHyperLink(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public JanelaHyperLink(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static JanelaHyperLink getInstancia(Object pai, String titulo) {
        if (pai instanceof Frame) {
            return new JanelaHyperLink((Frame)pai, titulo);
        }
        if (pai instanceof Dialog) {
            return new JanelaHyperLink((Dialog)pai, titulo);
        }
        return null;
    }

    public void iniciar() {
        JPanel panelCampos = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        panelCampos.add((Component)this.labelTexto, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        panelCampos.add((Component)this.textLink, c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets = new Insets(1, 1, 1, 1);
        JPanel panelTexto = new JPanel(new BorderLayout());
        panelTexto.setBorder(new TitledBorder(""));
        this.radioTextButton.setSelected(true);
        panelTexto.add((Component)this.radioTextButton, "West");
        ButtonGroup grup = new ButtonGroup();
        grup.add(this.radioImageButton);
        grup.add(this.radioTextButton);
        JPanel panelCampoTexto = new JPanel(new FlowLayout());
        this.textNomeLink.setPreferredSize(new Dimension(300, 20));
        panelCampoTexto.add(this.labelTitulo);
        panelCampoTexto.add(this.textNomeLink);
        panelTexto.add((Component)panelCampoTexto, "South");
        panelCampos.add((Component)panelTexto, c);
        c.gridy = 2;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        JPanel panelImagem = new JPanel(new BorderLayout());
        panelImagem.setBorder(new TitledBorder(""));
        panelImagem.add((Component)this.radioImageButton, "West");
        c.fill = 2;
        this.img.setBorder(new TitledBorder(""));
        this.img.setHorizontalAlignment(0);
        this.img.setPreferredSize(new Dimension(300, 100));
        this.img.setEnabled(false);
        panelImagem.add((Component)this.img, "South");
        panelCampos.add((Component)panelImagem, c);
        this.radioImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaHyperLink.this.radioTextButton.setSelected(false);
                JanelaHyperLink.this.textNomeLink.setEnabled(false);
                JanelaHyperLink.this.img.setEnabled(true);
            }
        });
        this.radioTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JanelaHyperLink.this.radioImageButton.setSelected(false);
                JanelaHyperLink.this.textNomeLink.setEnabled(true);
                JanelaHyperLink.this.img.setEnabled(false);
            }
        });
        this.img.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!JanelaHyperLink.this.img.isEnabled()) {
                    return;
                }
                JFileChooser file = ComponenteFactory.novoJFileChooser();
                file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (file.showOpenDialog(Laboratorio.getInstancia()) == 0) {
                    if (JanelaHyperLink.this.imagem == null) {
                        JanelaHyperLink.this.imagem = new ImageIcon();
                    }
                    JanelaHyperLink.this.imagem.setImage(Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath()));
                    JanelaHyperLink.this.img.setIcon(JanelaHyperLink.this.imagem);
                    JanelaHyperLink.this.img.setText("");
                    JanelaHyperLink.this.img.setBorder(null);
                }
            }
        });
        this.getPanelCentral().add((Component)panelCampos, "North");
        this.pack();
        this.setSize(new Dimension(480, 300));
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK) {
            if (Funcoes.textoVazio(this.textLink)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Endere\u00e7o web n\u00e3o informado.", 2);
                ScreenUtil.requisitarFoco(this.textLink);
                return;
            }
            if (this.radioImageButton.isSelected() && this.imagem.getImage() == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Imagem n\u00e3o informada.", 2);
                return;
            }
            this.ok = o == this.buttonOK;
        }
        super.actionPerformed(e);
    }

    public String getNomeLink() {
        if (Funcoes.textoVazio(this.textNomeLink)) {
            return this.getLink();
        }
        return this.textNomeLink.getText();
    }

    public String getLink() {
        if (Funcoes.textoVazio(this.textLink)) {
            return "";
        }
        return this.textLink.getText();
    }

    public Image getImagem() {
        if (!this.radioImageButton.isSelected()) {
            return null;
        }
        return this.imagem.getImage();
    }
}

