/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.JanelaHyperLink;
import jalis.laboratorio.cadastro.data.Handler;
import jalis.laboratorio.util.EmailUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.email.EditorHTMLCustomizadoEmail;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.commons.codec.binary.Base64;

class JanelaEdicaoEmail
extends JDialog
implements ActionListener {
    private JPanel panelJanela = new JPanel(new BorderLayout());
    private JPanel panelRodape = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCheckBox = new JPanel(new FlowLayout(0));
    private JPanel panelCentral = new JPanel(new BorderLayout());
    private JPanel panelAssunto = new JPanel(new GridBagLayout());
    private JPanel panelEditor = new JPanel(new GridBagLayout());
    private JToolBar toolBar = new JToolBar(0);
    private JEditorPane editorEmail = new JEditorPane();
    private JScrollPane scrollEmail = new JScrollPane(this.editorEmail);
    private JCheckBox checkAgruparMultiguia = ComponenteFactory.novoJCheckBox("Agrupar requisi\u00e7\u00f5es multiguias", 'A', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonCampos = new JButton();
    private JButton buttonNegrito = new JButton(new StyledEditorKit.BoldAction());
    private JButton buttonItalico = new JButton(new StyledEditorKit.ItalicAction());
    private JButton buttonSublinhado = new JButton(new StyledEditorKit.UnderlineAction());
    private JButton buttonCor = new JButton();
    private JButton buttonImagem = new JButton();
    private JButton buttonHyperLink = new JButton();
    private JButton buttonAlinhamentoEsquerda = new JButton(new StyledEditorKit.AlignmentAction("", 0));
    private JButton buttonAlinhamentoDireita = new JButton(new StyledEditorKit.AlignmentAction("", 2));
    private JButton buttonAlinhamentoCentro = new JButton(new StyledEditorKit.AlignmentAction("", 1));
    private JButton buttonAlinhamentoJustificado = new JButton(new StyledEditorKit.AlignmentAction("", 3));
    private TTextField textAssuntoEmail = new TTextField(100, 3);
    private JLabel labelAssuntoEmail = new JLabel("Assunto:");
    private JComboBox comboFonte = new JComboBox<String>(new String[]{"SansSerif", "Serif", "Monospaced", "Dialog", "DialogInput"});
    private JComboBox comboTamanho = new JComboBox<Object>(new Object[]{6, 8, 10, 12, 14, 16, 20, 24, 32, 36, 48, 72});
    private JLabel labelHoraEnvioEmail = new JLabel("Hora de envio:");
    private TTextField textHoraEnvioEmail = new TTextField(5, 6);
    private JPopupMenu menuCampos = new JPopupMenu();
    private final String[] CAMPOS_DISPONIVEIS = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "nomeSocialPaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "dataEntregaPrevistaRequisicao", "horaEntregaPrevistaRequisicao", "codigoPacienteWeb", "dataHoraAgenda"};
    private final String[] CAMPOS_DISPONIVEIS_RESULTADO_PDF = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "nomeSocialPaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "chaveAcessoRequisicao"};
    private final String[] CAMPOS_DISPONIVEIS_RESULTADO_CERTIFICADO_ANALISE = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "nomeSocialPaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "chaveAcessoRequisicao"};
    private final String[] CAMPOS_DISPONIVEIS_NFSE = new String[]{"numeroNotaFiscal", "codigoVerificacaoNfse", "cnpjPrestador"};
    private final String[] CAMPOS_DISPONIVEIS_SENHA_WEB_MEDICO = new String[]{"nomeMedico", "crmMedico", "enderecoEmailMedico", "senhaWebMedico", "tratamentoMedico"};
    private boolean isOk = false;
    private EmailUtil.TipoEmail tipoEmail = null;

    public JanelaEdicaoEmail(Dialog pai, String email, EmailUtil.TipoEmail tipoEmail, String horaEnvioEmailAniversario, String assuntoEmail, boolean agruparMultiguia) {
        super(pai, "Editando e-mail" + (tipoEmail == null ? "" : " de " + tipoEmail.getDescricao().toLowerCase()));
        this.tipoEmail = tipoEmail;
        this.montaTela();
        this.editorEmail.setEditorKit(new EditorHTMLCustomizadoEmail());
        this.editorEmail.setText(email);
        if (!Funcoes.textoVazio(horaEnvioEmailAniversario)) {
            this.textHoraEnvioEmail.setText(horaEnvioEmailAniversario);
        }
        if (!Funcoes.textoVazio(assuntoEmail)) {
            this.textAssuntoEmail.setText(assuntoEmail);
        }
        this.checkAgruparMultiguia.setSelected(agruparMultiguia);
    }

    public String getEmail() {
        String conteudo = StringUtil.getValor(this.editorEmail.getText(), "body");
        if (Funcoes.textoVazio(conteudo)) {
            return null;
        }
        try {
            conteudo = conteudo.replaceAll("\n\r", "<br/>");
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<head></head>");
            buf.append("<body>");
            buf.append(conteudo);
            buf.append("</body>");
            buf.append("</html>");
            return buf.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isAgruparMultiguia() {
        return this.checkAgruparMultiguia.isSelected();
    }

    public String getHoraEnvioEmail() {
        return this.textHoraEnvioEmail.getText();
    }

    public String getAssuntoEmail() {
        return this.textAssuntoEmail.getText();
    }

    private void montaTela() {
        this.setContentPane(this.panelJanela);
        this.panelJanela.add((Component)this.panelAssunto, "North");
        this.panelJanela.add((Component)this.panelCentral, "Center");
        this.panelJanela.add((Component)this.panelRodape, "South");
        this.setSize(600, 450);
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        JMenuItem item = new JMenuItem();
        Dimension dimensionBotao = new Dimension(20, 20);
        Dimension dimensionComboFonte = new Dimension(110, 20);
        Dimension dimensionComboTamanho = new Dimension(50, 20);
        Dimension dimensionTextHoraEnvio = new Dimension(50, 20);
        this.panelCentral.add((Component)this.toolBar, "North");
        this.panelCentral.add((Component)this.panelEditor, "Center");
        this.panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelEditor.add((Component)this.scrollEmail, c);
        if (this.tipoEmail != null && this.tipoEmail == EmailUtil.TipoEmail.ANIVERSARIO) {
            ++c.gridy;
            c.fill = 0;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 0, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.panelEditor.add((Component)this.labelHoraEnvioEmail, c);
            ++c.gridx;
            this.textHoraEnvioEmail.setPreferredSize(dimensionTextHoraEnvio);
            this.textHoraEnvioEmail.setMinimumSize(dimensionTextHoraEnvio);
            this.panelEditor.add((Component)this.textHoraEnvioEmail, c);
        }
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(3, 1, 3, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelAssunto.add((Component)this.labelAssuntoEmail, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textAssuntoEmail.setPreferredSize(dimensionBotao);
        this.textAssuntoEmail.setMinimumSize(dimensionBotao);
        this.panelAssunto.add((Component)this.textAssuntoEmail, c);
        this.panelAssunto.setBorder(ScreenUtil.criarBordaVazia());
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        if (this.isEmailResultados()) {
            this.panelCheckBox.add(this.checkAgruparMultiguia);
        }
        this.panelRodape.add((Component)this.panelCheckBox, "West");
        this.panelRodape.add((Component)this.panelBotoes, "East");
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.toolBar.setLayout(new FlowLayout(0));
        this.buttonNegrito.setToolTipText("Negrito");
        this.buttonNegrito.setFocusable(false);
        this.buttonNegrito.setIcon(ImagemUtils.carregaImagemJalis("toolbar_negrito.gif"));
        this.buttonNegrito.setMinimumSize(dimensionBotao);
        this.buttonNegrito.setPreferredSize(dimensionBotao);
        this.buttonNegrito.setText("");
        this.toolBar.add(this.buttonNegrito);
        this.buttonItalico.setToolTipText("It\u00e1lico");
        this.buttonItalico.setFocusable(false);
        this.buttonItalico.setIcon(ImagemUtils.carregaImagemJalis("toolbar_italico.gif"));
        this.buttonItalico.setMinimumSize(dimensionBotao);
        this.buttonItalico.setPreferredSize(dimensionBotao);
        this.buttonItalico.setText("");
        this.toolBar.add(this.buttonItalico);
        this.buttonSublinhado.setToolTipText("Sublinhado");
        this.buttonSublinhado.setFocusable(false);
        this.buttonSublinhado.setIcon(ImagemUtils.carregaImagemJalis("toolbar_sublinhado.gif"));
        this.buttonSublinhado.setMinimumSize(dimensionBotao);
        this.buttonSublinhado.setPreferredSize(dimensionBotao);
        this.buttonSublinhado.setText("");
        this.toolBar.add(this.buttonSublinhado);
        this.toolBar.addSeparator();
        this.comboFonte.setToolTipText("Fonte");
        this.comboFonte.setMinimumSize(dimensionComboFonte);
        this.comboFonte.setPreferredSize(dimensionComboFonte);
        this.toolBar.add(this.comboFonte);
        this.comboTamanho.setToolTipText("Tamanho da fonte");
        this.comboTamanho.setMinimumSize(dimensionComboTamanho);
        this.comboTamanho.setPreferredSize(dimensionComboTamanho);
        this.toolBar.add(this.comboTamanho);
        this.buttonCor.setToolTipText("Cor da fonte");
        this.buttonCor.setFocusable(false);
        this.buttonCor.setIcon(ImagemUtils.carregaImagemJalis("toolbar_cor_fonte.gif"));
        this.buttonCor.setMinimumSize(dimensionBotao);
        this.buttonCor.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonCor);
        this.toolBar.addSeparator();
        this.buttonAlinhamentoEsquerda.setToolTipText("Alinhar \u00e0 esquerda");
        this.buttonAlinhamentoEsquerda.setFocusable(false);
        this.buttonAlinhamentoEsquerda.setIcon(ImagemUtils.carregaImagemJalis("toolbar_alinhamento_esquerda.gif"));
        this.buttonAlinhamentoEsquerda.setMinimumSize(dimensionBotao);
        this.buttonAlinhamentoEsquerda.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonAlinhamentoEsquerda);
        this.buttonAlinhamentoCentro.setToolTipText("Centralizar");
        this.buttonAlinhamentoCentro.setFocusable(false);
        this.buttonAlinhamentoCentro.setIcon(ImagemUtils.carregaImagemJalis("toolbar_alinhamento_centro.gif"));
        this.buttonAlinhamentoCentro.setMinimumSize(dimensionBotao);
        this.buttonAlinhamentoCentro.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonAlinhamentoCentro);
        this.buttonAlinhamentoDireita.setToolTipText("Alinhar \u00e0 direita");
        this.buttonAlinhamentoDireita.setFocusable(false);
        this.buttonAlinhamentoDireita.setIcon(ImagemUtils.carregaImagemJalis("toolbar_alinhamento_direita.gif"));
        this.buttonAlinhamentoDireita.setMinimumSize(dimensionBotao);
        this.buttonAlinhamentoDireita.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonAlinhamentoDireita);
        this.buttonAlinhamentoJustificado.setToolTipText("Justificar");
        this.buttonAlinhamentoJustificado.setFocusable(false);
        this.buttonAlinhamentoJustificado.setIcon(ImagemUtils.carregaImagemJalis("toolbar_alinhamento_justificado.gif"));
        this.buttonAlinhamentoJustificado.setMinimumSize(dimensionBotao);
        this.buttonAlinhamentoJustificado.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonAlinhamentoJustificado);
        this.toolBar.addSeparator();
        this.buttonImagem.setToolTipText("Inserir imagem");
        this.buttonImagem.setFocusable(false);
        this.buttonImagem.setIcon(ImagemUtils.carregaImagemJalis("toolbar_imagem.gif"));
        this.buttonImagem.setMinimumSize(dimensionBotao);
        this.buttonImagem.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonImagem);
        this.buttonCampos.setToolTipText("Inserir campo de valor");
        this.buttonCampos.setFocusable(false);
        this.buttonCampos.setIcon(ImagemUtils.carregaImagemJalis("toolbar_campos_email.gif"));
        this.buttonCampos.setMinimumSize(dimensionBotao);
        this.buttonCampos.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonCampos);
        this.buttonHyperLink.setToolTipText("Inserir hyperlink no texto");
        this.buttonHyperLink.setFocusable(false);
        this.buttonHyperLink.setIcon(ImagemUtils.carregaImagemJalis("toolbar_campo_valor.gif"));
        this.buttonHyperLink.setMinimumSize(dimensionBotao);
        this.buttonHyperLink.setPreferredSize(dimensionBotao);
        this.toolBar.add(this.buttonHyperLink);
        Handler.install();
        this.editorEmail.setEditable(true);
        this.editorEmail.setContentType("text/html");
        this.comboFonte.setFocusable(false);
        this.comboTamanho.setFocusable(false);
        this.buttonCor.addActionListener(this);
        this.buttonImagem.addActionListener(this);
        this.buttonCampos.addActionListener(this);
        this.buttonHyperLink.addActionListener(this);
        this.comboFonte.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    new StyledEditorKit.FontFamilyAction("", JanelaEdicaoEmail.this.comboFonte.getSelectedItem().toString()).actionPerformed(null);
                }
            }
        });
        this.comboTamanho.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    new StyledEditorKit.FontSizeAction("", (Integer)JanelaEdicaoEmail.this.comboTamanho.getSelectedItem()).actionPerformed(null);
                }
            }
        });
        switch (this.tipoEmail) {
            case NOTA_FISCAL: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS_NFSE) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                break;
            }
            case RESULTADO_PDF: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS_RESULTADO_PDF) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                break;
            }
            case RESULTADO_CERTIFICADO_ANALISE: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS_RESULTADO_CERTIFICADO_ANALISE) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                break;
            }
            case SENHA_WEB_MEDICO: 
            case SENHA_WEB_COLETADOR: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS_SENHA_WEB_MEDICO) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                break;
            }
            case AGENDAMENTO: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                item = new JMenuItem("chaveAcessoRequisicao");
                this.menuCampos.add(item);
                item.addActionListener(this);
                break;
            }
            case RESULTADO: 
            case REQUISICAO: 
            case ATRASO_ENTREGA: 
            case RECOLETA: {
                this.menuCampos.removeAll();
                for (String aux : this.CAMPOS_DISPONIVEIS) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
                item = new JMenuItem("chaveAcessoRequisicao");
                this.menuCampos.add(item);
                item.addActionListener(this);
                break;
            }
            default: {
                for (String aux : this.CAMPOS_DISPONIVEIS) {
                    item = new JMenuItem(aux);
                    this.menuCampos.add(item);
                    item.addActionListener(this);
                }
            }
        }
    }

    public boolean getOK() {
        return this.isOk;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textAssuntoEmail)) {
            Funcoes.mensagem(this, "O assunto do e-mail deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textAssuntoEmail);
            return false;
        }
        if (this.tipoEmail != null && this.tipoEmail == EmailUtil.TipoEmail.ANIVERSARIO && Funcoes.textoVazio(this.textHoraEnvioEmail)) {
            Funcoes.mensagem(this, "A hora de envio deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textHoraEnvioEmail);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            try {
                this.editorEmail.getDocument().insertString(this.editorEmail.getCaretPosition(), "[" + ((JMenuItem)e.getSource()).getText() + "]", null);
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.buttonCampos) {
            this.menuCampos.show(this.buttonCampos.getParent(), this.buttonCampos.getX(), this.buttonCampos.getY() + this.buttonCampos.getHeight());
        } else if (e.getSource() == this.buttonCancelar) {
            this.isOk = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonOK) {
            if (this.validaCampos()) {
                this.isOk = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.buttonCor) {
            this.escolheCor();
        } else if (e.getSource() == this.buttonImagem) {
            this.insereImagem();
        } else if (e.getSource() == this.buttonHyperLink) {
            this.configurarHyperLink();
        }
    }

    private void configurarHyperLink() {
        JanelaHyperLink janela = JanelaHyperLink.getInstancia(Laboratorio.getInstancia(), "Inserindo HyperLink");
        janela.setVisible(true);
        if (janela.getOK()) {
            if (Funcoes.textoVazio(janela.getLink())) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            if (janela.getLink().contains("http")) {
                buf.append("<a href=\"" + janela.getLink() + "\">");
            } else {
                buf.append("<a href=\"http://" + janela.getLink() + "\">");
            }
            if (janela.getImagem() == null) {
                buf.append(janela.getNomeLink());
            } else {
                String stringImagem = new Base64().encodeAsString(ImagemUtils.imageToByte(janela.getImagem()));
                buf.append("<img src=\"data:image/png;base64,");
                buf.append(this.cortarBase64EmColunas(stringImagem));
                buf.append("\"/>");
            }
            buf.append("</a>");
            HTMLDocument doc = (HTMLDocument)this.editorEmail.getDocument();
            Element[] roots = doc.getRootElements();
            Element body = null;
            for (int i = 0; i < roots[0].getElementCount(); ++i) {
                Element element = roots[0].getElement(i);
                if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                body = element;
                break;
            }
            Element aux = doc.getCharacterElement(this.editorEmail.getCaretPosition());
            try {
                doc.insertAfterEnd(aux, buf.toString());
            }
            catch (IOException | BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private String cortarBase64EmColunas(String base64) {
        int TAMANHO_MAX = 150;
        if (Funcoes.textoVazio(base64)) {
            return "";
        }
        StringBuilder novo = new StringBuilder();
        int tamanho = base64.length();
        int cortar = 0;
        while (cortar < tamanho) {
            if (tamanho - cortar <= 150) {
                novo.append(base64.substring(cortar));
                cortar = tamanho + 1;
                continue;
            }
            novo.append(base64.substring(cortar, cortar + 150)).append("\n");
            cortar += 150;
        }
        return novo.toString();
    }

    private void insereImagem() {
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
        if (file.showOpenDialog(this) == 0) {
            MediaTracker tracker = new MediaTracker(this);
            Image imagem = Toolkit.getDefaultToolkit().getImage(file.getSelectedFile().getAbsolutePath());
            tracker.addImage(imagem, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            if (tracker.isErrorAny()) {
                Funcoes.mensagem(this, "A imagem n\u00e3o \u00e9 suportada.", 2);
                return;
            }
            String stringImagem = new Base64().encodeAsString(ImagemUtils.imageToByte(imagem));
            StringBuilder buf = new StringBuilder();
            buf.append("<img src=\"data:image/png;base64,");
            buf.append(this.cortarBase64EmColunas(stringImagem));
            buf.append("\"/>");
            try {
                HTMLDocument doc = (HTMLDocument)this.editorEmail.getDocument();
                Element[] roots = doc.getRootElements();
                Element body = null;
                for (int i = 0; i < roots[0].getElementCount(); ++i) {
                    Element element = roots[0].getElement(i);
                    if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                    body = element;
                    break;
                }
                Element aux = doc.getCharacterElement(this.editorEmail.getCaretPosition());
                doc.insertAfterEnd(aux, buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isEmailResultados() {
        return this.tipoEmail == EmailUtil.TipoEmail.RESULTADO;
    }

    private void escolheCor() {
        Color cor = JColorChooser.showDialog(this, "Escolha a cor", null);
        if (cor != null) {
            new StyledEditorKit.ForegroundAction("", cor).actionPerformed(null);
        }
    }
}

