/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.EmailUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;

class JanelaConfiguracaoEnvio
extends JDialog
implements ActionListener {
    private final int TIPO_ENVIO_FALHOU = 1;
    private final int TIPO_ENVIO_ENVIANDO = 2;
    private final int TIPO_ENVIO_SUCESSO = 3;
    private final int TIPO_TESTE_CONECTANDO = 4;
    private final int TIPO_TESTE_CONECTADO = 5;
    private final int TIPO_TESTE_FALHOU = 6;
    private JLabel labelServidor = new JLabel("Endere\u00e7o:");
    private JLabel labelPorta = new JLabel("Porta:");
    private JLabel labelSeguranca = new JLabel("Tipo:");
    private JLabel labelAutenticacao = new JLabel("Tipo:");
    private JLabel labelNomeUsuario = new JLabel("Nome do usu\u00e1rio:");
    private JLabel labelSenha = new JLabel("Senha:");
    private JLabel labelTesteConexao = new JLabel();
    private TTextField textServidor = new TTextField(200, 3);
    private TTextField textNomeUsuario = new TTextField(200, 3);
    private TTextField textSenha = new TTextField(25, 3);
    private JComboBox<Object> comboPorta = new JComboBox<Object>(new Object[]{25, 465, 587});
    private JComboBox<String> comboSeguranca = new JComboBox<String>(new String[]{"Sem criptografia", "Criptografia TLS", "Criptografia SSL"});
    private JComboBox<String> comboAutenticacao = new JComboBox<String>(new String[]{"PLAIN", "NTLM/SPA", "GSSAPI", "DIGEST-MD5", "CRAM-MD5", "Login", "POP antes de SMTP"});
    private JCheckBox checkRequerAutenticacao = new JCheckBox("Requer autentica\u00e7\u00e3o");
    private JPanel panelJanela = new JPanel(new GridBagLayout());
    private JPanel panelCentral = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelServidor = new JPanel(new GridBagLayout());
    private JPanel panelSeguranca = new JPanel(new GridBagLayout());
    private JPanel panelAutenticacao = new JPanel(new GridBagLayout());
    private JPanel panelTesteConexao = new JPanel(new BorderLayout());
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonTesteConexao = new JButton("Teste de envio");
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem itemLogin = ComponenteFactory.novoJMenuItem(this.menu, "Login", (ActionListener)this);
    private JMenuItem itemAniversario = ComponenteFactory.novoJMenuItem(this.menu, "Anivers\u00e1rio", (ActionListener)this);
    private JMenuItem itemResultadosProntos = ComponenteFactory.novoJMenuItem(this.menu, "Resultados prontos", (ActionListener)this);
    private JMenuItem itemSenhaWeb = ComponenteFactory.novoJMenuItem(this.menu, "Senha Web", (ActionListener)this);
    private JMenuItem itemRecoletaMaterial = ComponenteFactory.novoJMenuItem(this.menu, "Recoleta de material", (ActionListener)this);
    private JMenuItem itemRequisicao = ComponenteFactory.novoJMenuItem(this.menu, "Requisi\u00e7\u00e3o", (ActionListener)this);
    private JMenuItem itemProposta = ComponenteFactory.novoJMenuItem(this.menu, "Proposta", (ActionListener)this);
    private JMenuItem itemCotacaoFornecedor = ComponenteFactory.novoJMenuItem(this.menu, "Cotacao fornecedor", (ActionListener)this);
    private JMenuItem itemNFSe = ComponenteFactory.novoJMenuItem(this.menu, "NFS-e", (ActionListener)this);
    private JMenuItem itemDataEntrega = ComponenteFactory.novoJMenuItem(this.menu, "Data de entrega", (ActionListener)this);
    private JMenuItem itemSenhaWebMedico = ComponenteFactory.novoJMenuItem(this.menu, "Senha Web M\u00e9dico", (ActionListener)this);
    private boolean isOk = false;
    private String emailAniversario = null;
    private String emailResultados = null;
    private String emailSenhaWeb = null;
    private String emailRecoleta = null;
    private String emailRequisicao = null;
    private String emailProposta = null;
    private String emailCotacaoFornecedor = null;
    private String emailNotaFiscal = null;
    private String emailDataEntrega = null;
    private String assuntoAniversario = null;
    private String assuntoResultados = null;
    private String assuntoSenhaWeb = null;
    private String assuntoRecoleta = null;
    private String assuntoRequisicao = null;
    private String assuntoProposta = null;
    private String assuntoCotacao = null;
    private String assuntoNotaFiscal = null;
    private String assuntoDataEntrega = null;
    private String emailSenhaWebMedico = null;
    private String assuntoSenhaWebMedico = null;

    public JanelaConfiguracaoEnvio(Dialog owner, String xmlConfiguracao) {
        super(owner, "Configurando envio de e-mail");
        this.montaTela();
        this.preencheValores(xmlConfiguracao);
    }

    public void setDados(boolean enviarEmailAniversario, String emailAniversario, boolean enviarEmailResultados, String emailResultados, boolean enviarEmailSenhaWeb, String emailSenhaWeb, boolean enviarEmailRecoleta, String emailRecoleta, boolean enviarEmailRequisicao, String emailRequisicao, boolean enviarEmailCotacaoFornecedor, String emailCotacaoFornecedor, boolean enviarEmailProposta, String emailProposta, boolean enviarEmailNotaFiscal, String emailNotaFiscal, String assuntoAniversario, String assuntoResultados, String assuntoSenhaWeb, String assuntoRecoleta, String assuntoRequisicao, String assuntoProposta, String assuntoCotacao, String assuntoNotaFiscal, boolean enviarDataEntrega, String assuntoDataEntrega, String emailDataEntrega, boolean enviarEmailSenhaWebMedico, String emailSenhaWebMedico) {
        this.itemAniversario.setEnabled(enviarEmailAniversario);
        this.itemResultadosProntos.setEnabled(enviarEmailResultados);
        this.itemSenhaWeb.setEnabled(enviarEmailSenhaWeb);
        this.itemRecoletaMaterial.setEnabled(enviarEmailRecoleta);
        this.itemRequisicao.setEnabled(enviarEmailRequisicao);
        this.itemProposta.setEnabled(enviarEmailProposta);
        this.itemCotacaoFornecedor.setEnabled(enviarEmailCotacaoFornecedor);
        this.itemNFSe.setEnabled(enviarEmailNotaFiscal);
        this.itemDataEntrega.setEnabled(enviarDataEntrega);
        this.itemSenhaWebMedico.setEnabled(enviarEmailSenhaWebMedico);
        this.emailAniversario = emailAniversario;
        this.emailResultados = emailResultados;
        this.emailSenhaWeb = emailSenhaWeb;
        this.emailRecoleta = emailRecoleta;
        this.emailRequisicao = emailRequisicao;
        this.emailProposta = emailProposta;
        this.emailCotacaoFornecedor = emailCotacaoFornecedor;
        this.emailNotaFiscal = emailNotaFiscal;
        this.assuntoAniversario = assuntoAniversario;
        this.assuntoResultados = assuntoResultados;
        this.assuntoSenhaWeb = assuntoSenhaWeb;
        this.assuntoRecoleta = assuntoRecoleta;
        this.assuntoRequisicao = assuntoRequisicao;
        this.assuntoProposta = assuntoProposta;
        this.assuntoCotacao = assuntoCotacao;
        this.assuntoNotaFiscal = assuntoNotaFiscal;
        this.assuntoDataEntrega = assuntoDataEntrega;
        this.emailDataEntrega = emailDataEntrega;
        this.emailSenhaWebMedico = emailSenhaWebMedico;
    }

    private void preencheValores(String xmlConfiguracao) {
        if (Funcoes.textoVazio(xmlConfiguracao)) {
            return;
        }
        String endereco = StringUtil.getValor(xmlConfiguracao, "endereco");
        String porta = StringUtil.getValor(xmlConfiguracao, "porta");
        String requerAutenticacao = StringUtil.getValor(xmlConfiguracao, "requeraut");
        String seguranca = StringUtil.getValor(xmlConfiguracao, "seguranca");
        String autenticacao = StringUtil.getValor(xmlConfiguracao, "autenticacao");
        String nomeUsuario = StringUtil.getValor(xmlConfiguracao, "nomeusuario");
        String senha = StringUtil.getValor(xmlConfiguracao, "senha");
        if (!Funcoes.textoVazio(endereco)) {
            this.textServidor.setText(endereco);
        }
        if (!Funcoes.textoVazio(porta)) {
            this.comboPorta.setSelectedItem(Integer.parseInt(porta));
        }
        if (!Funcoes.textoVazio(requerAutenticacao)) {
            this.checkRequerAutenticacao.setSelected(requerAutenticacao.equalsIgnoreCase("true"));
        }
        if (!Funcoes.textoVazio(seguranca)) {
            if (seguranca.equals("SEM")) {
                this.comboSeguranca.setSelectedIndex(0);
            } else if (seguranca.equals("TLS")) {
                this.comboSeguranca.setSelectedIndex(1);
            } else if (seguranca.equals("SSL")) {
                this.comboSeguranca.setSelectedIndex(2);
            }
        }
        if (!Funcoes.textoVazio(autenticacao)) {
            this.comboAutenticacao.setSelectedItem(autenticacao);
        }
        if (!Funcoes.textoVazio(nomeUsuario)) {
            this.textNomeUsuario.setText(nomeUsuario);
        }
        if (!Funcoes.textoVazio(senha)) {
            this.textSenha.setText(senha);
        }
    }

    private void montaTela() {
        this.setSize(450, 280);
        this.setModal(true);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.panelServidor.setBorder(new TitledBorder("Configura\u00e7\u00e3o do servidor"));
        this.panelSeguranca.setBorder(new TitledBorder("Seguran\u00e7a"));
        this.panelAutenticacao.setBorder(new TitledBorder("Autentica\u00e7\u00e3o"));
        Insets insetsNormal = new Insets(1, 1, 0, 0);
        Insets insetsEspaco = new Insets(1, 20, 0, 0);
        this.setContentPane(this.panelJanela);
        this.panelJanela.setBorder(ScreenUtil.criarBordaVazia());
        Dimension dimension = new Dimension(20, 20);
        Dimension dimensionSenha = new Dimension(120, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelJanela.add((Component)this.panelCentral, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(1, 3, 1, 2);
        this.panelJanela.add((Component)this.panelTesteConexao, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.panelJanela.add((Component)this.panelBotoes, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelCentral.add((Component)this.panelServidor, c);
        ++c.gridy;
        this.panelCentral.add((Component)this.panelSeguranca, c);
        ++c.gridy;
        this.panelCentral.add((Component)this.panelAutenticacao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelServidor.add((Component)this.labelServidor, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textServidor.setPreferredSize(dimension);
        this.textServidor.setMinimumSize(dimension);
        this.panelServidor.add((Component)this.textServidor, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = insetsEspaco;
        this.panelServidor.add((Component)this.labelPorta, c);
        ++c.gridx;
        c.insets = insetsNormal;
        this.panelServidor.add(this.comboPorta, c);
        ++c.gridy;
        c.gridx = 1;
        this.panelServidor.add((Component)this.checkRequerAutenticacao, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelSeguranca.add((Component)this.labelSeguranca, c);
        ++c.gridx;
        this.panelSeguranca.add(this.comboSeguranca, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelSeguranca.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelAutenticacao.add((Component)this.labelAutenticacao, c);
        ++c.gridx;
        this.panelAutenticacao.add(this.comboAutenticacao, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelAutenticacao.add((Component)this.labelNomeUsuario, c);
        ++c.gridx;
        this.textNomeUsuario.setPreferredSize(dimension);
        this.textNomeUsuario.setMinimumSize(dimension);
        c.fill = 2;
        c.weightx = 1.0;
        this.panelAutenticacao.add((Component)this.textNomeUsuario, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelAutenticacao.add((Component)this.labelSenha, c);
        ++c.gridx;
        this.textSenha.setPreferredSize(dimensionSenha);
        this.textSenha.setMinimumSize(dimensionSenha);
        this.panelAutenticacao.add((Component)this.textSenha, c);
        JPanel panelBotoesEsquerdo = new JPanel(new FlowLayout(0));
        this.buttonTesteConexao.setMnemonic('T');
        panelBotoesEsquerdo.add(this.buttonTesteConexao);
        this.panelBotoes.add((Component)panelBotoesEsquerdo, "West");
        JPanel panelBotoesDireito = new JPanel(new FlowLayout(2));
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        panelBotoesDireito.add(this.buttonOK);
        panelBotoesDireito.add(this.buttonCancelar);
        this.panelBotoes.add((Component)panelBotoesDireito, "East");
        this.panelTesteConexao.add(this.labelTesteConexao);
        this.panelTesteConexao.setBorder(new TitledBorder("Mensagens do teste de envio"));
        this.labelTesteConexao.setHorizontalAlignment(0);
        this.labelTesteConexao.setPreferredSize(new Dimension(450, 30));
        this.labelTesteConexao.setMinimumSize(new Dimension(450, 30));
        this.panelTesteConexao.setVisible(false);
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonTesteConexao.addActionListener(this);
        this.checkRequerAutenticacao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JanelaConfiguracaoEnvio.this.controlaCampos();
            }
        });
        Funcoes.montaEnter((JComponent)this.panelJanela);
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean enabled = this.checkRequerAutenticacao.isSelected();
        this.comboSeguranca.setEnabled(enabled);
        this.comboAutenticacao.setEnabled(enabled);
        this.textNomeUsuario.setEnabled(enabled);
        this.textSenha.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            if (this.validaCampos()) {
                this.isOk = true;
                this.setVisible(false);
            }
        } else if (e.getSource() == this.buttonCancelar) {
            this.isOk = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonTesteConexao) {
            Dimension dim = this.menu.getPreferredSize();
            this.menu.show(this.buttonTesteConexao.getParent(), this.buttonTesteConexao.getX(), this.buttonTesteConexao.getY() - dim.height - 1);
        } else if (e.getSource() == this.itemLogin) {
            this.testarConexao();
        } else if (e.getSource() == this.itemSenhaWeb) {
            this.enviarEmailTeste(this.assuntoSenhaWeb, this.emailSenhaWeb);
        } else if (e.getSource() == this.itemProposta) {
            this.enviarEmailTeste(this.assuntoProposta, this.emailProposta);
        } else if (e.getSource() == this.itemCotacaoFornecedor) {
            this.enviarEmailTeste(this.assuntoCotacao, this.emailCotacaoFornecedor);
        } else if (e.getSource() == this.itemAniversario) {
            this.enviarEmailTeste(this.assuntoAniversario, this.emailAniversario);
        } else if (e.getSource() == this.itemRecoletaMaterial) {
            this.enviarEmailTeste(this.assuntoRecoleta, this.emailRecoleta);
        } else if (e.getSource() == this.itemRequisicao) {
            this.enviarEmailTeste(this.assuntoRequisicao, this.emailRequisicao);
        } else if (e.getSource() == this.itemResultadosProntos) {
            this.enviarEmailTeste(this.assuntoResultados, this.emailResultados);
        } else if (e.getSource() == this.itemNFSe) {
            this.enviarEmailTeste(this.assuntoNotaFiscal, this.emailNotaFiscal);
        } else if (e.getSource() == this.itemDataEntrega) {
            this.enviarEmailTeste(this.assuntoDataEntrega, this.emailDataEntrega);
        } else if (e.getSource() == this.itemSenhaWebMedico) {
            this.enviarEmailTeste(this.assuntoSenhaWebMedico, this.emailSenhaWebMedico);
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textServidor)) {
            Funcoes.mensagem(this, "O servidor de e-mail deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.textServidor);
            return false;
        }
        if (this.checkRequerAutenticacao.isSelected()) {
            if (Funcoes.textoVazio(this.textNomeUsuario)) {
                Funcoes.mensagem(this, "O nome do usu\u00e1rio deve ser preenchido.", 2);
                ScreenUtil.requisitarFoco(this.textNomeUsuario);
                return false;
            }
            if (Funcoes.textoVazio(this.textSenha)) {
                Funcoes.mensagem(this, "A senha do usu\u00e1rio deve ser preenchida.", 2);
                ScreenUtil.requisitarFoco(this.textSenha);
                return false;
            }
        }
        return true;
    }

    public String getXMLConfiguracao() {
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("confenvio");
            xml.escrever("endereco", this.textServidor.getText());
            xml.escrever("porta", this.comboPorta.getSelectedItem().toString());
            xml.escrever("requeraut", this.checkRequerAutenticacao.isSelected() ? "true" : "false");
            if (this.comboSeguranca.getSelectedIndex() == 0) {
                xml.escrever("seguranca", "SEM");
            } else if (this.comboSeguranca.getSelectedIndex() == 1) {
                xml.escrever("seguranca", "TLS");
            } else if (this.comboSeguranca.getSelectedIndex() == 2) {
                xml.escrever("seguranca", "SSL");
            }
            xml.escrever("autenticacao", this.comboAutenticacao.getSelectedItem().toString());
            xml.escrever("nomeusuario", this.textNomeUsuario.getText());
            xml.escrever("senha", this.textSenha.getText());
            xml.fechar("confenvio");
            return xml.getXML();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar XML de configura\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public void enviarEmailTeste(final String assunto, final String email) {
        this.validaCampos();
        this.controlaCampos(true);
        this.controlaPanelTeste();
        this.atualizaLabel(this.labelTesteConexao, 4, this.textServidor.getText());
        new Thread(){

            @Override
            public void run() {
                try {
                    if (EmailUtil.testarEmail(null, null, JanelaConfiguracaoEnvio.this.getXMLConfiguracao())) {
                        JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 2, JanelaConfiguracaoEnvio.this.textNomeUsuario.getText());
                        if (EmailUtil.enviaEmailTeste(JanelaConfiguracaoEnvio.this.getXMLConfiguracao(), Variaveis.filialPadrao, assunto, email)) {
                            JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 3, JanelaConfiguracaoEnvio.this.textNomeUsuario.getText());
                        } else {
                            JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 1, JanelaConfiguracaoEnvio.this.textNomeUsuario.getText());
                        }
                    } else {
                        JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 6, JanelaConfiguracaoEnvio.this.textServidor.getText());
                    }
                    JanelaConfiguracaoEnvio.this.controlaCampos(false);
                }
                catch (Exception e1) {
                    JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 1, JanelaConfiguracaoEnvio.this.textNomeUsuario.getText());
                    JanelaConfiguracaoEnvio.this.controlaCampos(false);
                }
            }
        }.start();
    }

    private void controlaCampos(boolean isTestando) {
        this.buttonTesteConexao.setEnabled(!isTestando);
    }

    public void atualizaLabel(JLabel label, int tipo, String endereco) {
        label.setForeground(null);
        label.setText("");
        if (tipo == 1) {
            label.setForeground(Color.RED);
            label.setText("<html><center>FALHA ao enviar e-mail para \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"</html>");
        } else if (tipo == 2) {
            label.setForeground(null);
            label.setText("<html><center>Enviando e-mail para \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"</html>");
        } else if (tipo == 3) {
            label.setForeground(Color.BLUE);
            label.setText("<html><center>E-mail enviado com SUCESSO para \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"</html>");
        } else if (tipo == 5) {
            label.setForeground(Color.BLUE);
            label.setText("<html><center>Conectado com SUCESSO ao servidor \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"</html>");
        } else if (tipo == 4) {
            label.setForeground(null);
            label.setText("<html><center>Conectando ao servidor \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"</html>");
        } else if (tipo == 6) {
            label.setForeground(Color.RED);
            label.setText("<html><center>FALHA ao conectar em \"" + (Funcoes.textoVazio(endereco) ? "" : endereco) + "\"<br>Verifique as configura\u00e7\u00f5es, usu\u00e1rio e senha</html>");
        }
    }

    public void testarConexao() {
        this.validaCampos();
        this.controlaCampos(true);
        this.controlaPanelTeste();
        this.atualizaLabel(this.labelTesteConexao, 4, this.textServidor.getText());
        new Thread(){

            @Override
            public void run() {
                if (EmailUtil.testarEmail(null, null, JanelaConfiguracaoEnvio.this.getXMLConfiguracao())) {
                    JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 5, JanelaConfiguracaoEnvio.this.textServidor.getText());
                } else {
                    JanelaConfiguracaoEnvio.this.atualizaLabel(JanelaConfiguracaoEnvio.this.labelTesteConexao, 6, JanelaConfiguracaoEnvio.this.textServidor.getText());
                }
                JanelaConfiguracaoEnvio.this.controlaCampos(false);
            }
        }.start();
    }

    private void controlaPanelTeste() {
        if (!this.panelTesteConexao.isVisible()) {
            this.setSize(450, 340);
            this.panelTesteConexao.setVisible(true);
        }
    }

    public boolean getOK() {
        return this.isOk;
    }
}

