/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.TipoCertificado;
import jalis.laboratorio.cadastro.TipoFilial;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

class JanelaAssinaturaDigital
extends AbstractDialogoOKCancelar {
    private final int ALTURA_VISUALIZACAO_LOGO = 130;
    private JLabel labelTipoCertificacao = new JLabel("Tipo de certifica\u00e7\u00e3o:");
    private JLabel labelUsuarioMsgVencimentoCertificado = new JLabel("Usu\u00e1rios de mensagem de vencimento de certificado:");
    private JLabel labelMotivoAssinatura = new JLabel("Motivo da Assinatura (opcional):");
    private JLabel labelLocalAssinatura = new JLabel("Local da Assinatura (opcional):");
    private JLabel labelCertificadoRT = new JLabel("Certificado:");
    private JLabel labelCertificadoRTSub = new JLabel("Certificado:");
    private JLabel labelSenhaRT = new JLabel("Senha:");
    private JLabel labelSenhaRTSub = new JLabel("Senha:");
    private JLabel labelLogoRT = new JLabel("Logo (opcional):");
    private JLabel labelLogoRTSub = new JLabel("Logo (opcional):");
    private DialogoFiltro dfUsuarioErro = DialogoFiltro.novaInstancia(this, "Pesquisando usu\u00e1rios");
    private Map<Integer, String[]> selecionadosdfUsuarioErro = new HashMap<Integer, String[]>();
    private JLabel labelVisualizacaoLogoRT = new JLabel(){

        @Override
        public void paint(Graphics g) {
            super.paintBorder(g);
            ImageIcon imagem = (ImageIcon)this.getIcon();
            if (imagem != null) {
                float proporcao = 13000 / imagem.getIconHeight();
                int largura = (int)((float)imagem.getIconWidth() * proporcao / 100.0f);
                if (largura > this.getWidth()) {
                    largura = this.getWidth();
                }
                g.drawImage(imagem.getImage(), (this.getWidth() - largura) / 2, 0, largura, 130, null);
            }
        }
    };
    private JLabel labelVisualizacaoLogoRTSub = new JLabel(){

        @Override
        public void paint(Graphics g) {
            super.paintBorder(g);
            ImageIcon imagem = (ImageIcon)this.getIcon();
            if (imagem != null) {
                float proporcao = 13000 / imagem.getIconHeight();
                int largura = (int)((float)imagem.getIconWidth() * proporcao / 100.0f);
                if (largura > this.getWidth()) {
                    largura = this.getWidth();
                }
                g.drawImage(imagem.getImage(), (this.getWidth() - largura) / 2, 0, largura, 130, null);
            }
        }
    };
    private JLabel labelValidadeRT = new JLabel("Validade:");
    private JLabel labelValidadeRTSub = new JLabel("Validade:");
    private JLabel labelValidadeRTValor = ComponenteFactory.novoJLabel("", null, ComponenteFactory.novoTitledEtchedBorder(""));
    private JLabel labelValidadeRTSubValor = ComponenteFactory.novoJLabel("", null, ComponenteFactory.novoTitledEtchedBorder(""));
    private JButton buttonImportarCertificadoRT = new JButton("Importar");
    private JButton buttonImportarCertificadoRTSub = new JButton("Importar");
    private JButton buttonImportarLogoRT = new JButton("Importar");
    private JButton buttonImportarLogoRTSub = new JButton("Importar");
    private JButton buttonRemoverCertificadoRT = new JButton("Remover");
    private JButton buttonRemoverCertificadoRTSub = new JButton("Remover");
    private JButton buttonRemoverLogoRT = new JButton("Remover");
    private JButton buttonRemoverLogoRTSub = new JButton("Remover");
    private JButton buttonValidarRT = new JButton("Validar");
    private JButton buttonValidarRTSub = new JButton("Validar");
    private JButton buttonUsuarioMsgVencimentoCertificado = ComponenteFactory.novoJButton(this, true);
    private TTextField textUsuarioMsgVencimentoCertificado = new TTextField(50, 3);
    private TTextField textMotivoAssinatura = new TTextField(50, 3);
    private TTextField textLocalAssinatura = new TTextField(50, 3);
    private TTextField textSenhaAssinaturaRT = new TTextField(50, 3);
    private TTextField textSenhaAssinaturaRTSub = new TTextField(50, 3);
    private JComboBox comboboxTipoCertificado = ComponenteFactory.novoJComboBox(this);
    private JPanel panelRT = new JPanel(new GridBagLayout());
    private JPanel panelRTSub = new JPanel(new GridBagLayout());
    private JCheckBox checkCertificadoRTImportado = new JCheckBox("Importado");
    private JCheckBox checkCertificadoRTSubImportado = new JCheckBox("Importado");
    private String senhaRT = null;
    private String senhaRTSub = null;
    private String motivoAssinatura = null;
    private String localAssinatura = null;
    private byte[] certificadoRT = null;
    private byte[] certificadoRTSub = null;
    private byte[] logoRT = null;
    private byte[] logoRTSub = null;
    private boolean isCertificadoRTAlterado = false;
    private boolean isCertificadoRTSubAlterado = false;
    private boolean isLogoRTAlterado = false;
    private boolean isLogoRTSubAlterado = false;

    public static JanelaAssinaturaDigital getInstancia(Window janelaPai, byte[] certificadoRT, byte[] certificadoRTSub, String senhaRT, String senhaRTSub, String motivoAssinatura, String localAssinatura, byte[] logoAssinaturaRT, byte[] logoAssinaturaRTSub, TipoFilial tipoFilial, String tipoCertificado, Date validadeCertificadoRT, Date validadeCertificadoRTSub, String usuariosMensagemVencimento) {
        if (janelaPai instanceof Dialog) {
            return new JanelaAssinaturaDigital((Dialog)janelaPai, "Assinatura Digital", certificadoRT, certificadoRTSub, senhaRT, senhaRTSub, motivoAssinatura, localAssinatura, logoAssinaturaRT, logoAssinaturaRTSub, tipoFilial, tipoCertificado, validadeCertificadoRT, validadeCertificadoRTSub, usuariosMensagemVencimento);
        }
        return new JanelaAssinaturaDigital((Frame)janelaPai, "Assinatura Digital", certificadoRT, certificadoRTSub, senhaRT, senhaRTSub, motivoAssinatura, localAssinatura, logoAssinaturaRT, logoAssinaturaRTSub, tipoFilial, tipoCertificado, validadeCertificadoRT, validadeCertificadoRTSub, usuariosMensagemVencimento);
    }

    @Override
    protected boolean acaoOk() {
        if (this.certificadoRT != null && Funcoes.textoVazio(this.textSenhaAssinaturaRT)) {
            Funcoes.mensagem(this, "A senha do certificado digital do respons\u00e1vel t\u00e9cnico deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenhaAssinaturaRT);
            return false;
        }
        if (this.certificadoRTSub != null && Funcoes.textoVazio(this.textSenhaAssinaturaRTSub)) {
            Funcoes.mensagem(this, "A senha do certificado digital do respons\u00e1vel t\u00e9cnico substituto deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textSenhaAssinaturaRTSub);
            return false;
        }
        if (this.certificadoRT != null) {
            if (Funcoes.textoVazio(this.labelValidadeRTValor.getText())) {
                Funcoes.mensagem(this, "A validade do certificado n\u00e3o foi verificada.", 2);
                ScreenUtil.requisitarFoco(this.buttonValidarRT);
                return false;
            }
            if (!this.validarCertificado(this.certificadoRT, this.textSenhaAssinaturaRT.getText(), this.labelValidadeRTValor)) {
                return false;
            }
        }
        if (this.certificadoRTSub != null) {
            if (Funcoes.textoVazio(this.labelValidadeRTSubValor.getText())) {
                Funcoes.mensagem(this, "A validade do certificado substituto n\u00e3o foi verificada.", 2);
                ScreenUtil.requisitarFoco(this.buttonValidarRTSub);
                return false;
            }
            if (!this.validarCertificado(this.certificadoRTSub, this.textSenhaAssinaturaRTSub.getText(), this.labelValidadeRTSubValor)) {
                return false;
            }
        }
        return true;
    }

    public String getLocalAssinatura() {
        return this.textLocalAssinatura.getText();
    }

    public String getMotivoAssinatura() {
        return this.textMotivoAssinatura.getText();
    }

    public String getSenhaRTSub() {
        return this.textSenhaAssinaturaRTSub.getText();
    }

    public String getSenhaRT() {
        return this.textSenhaAssinaturaRT.getText();
    }

    public byte[] getLogoAssinaturaRTSub() {
        return this.logoRTSub;
    }

    public boolean getLogoAssinaturaRTSubAlterada() {
        return this.isLogoRTSubAlterado;
    }

    public byte[] getLogoAssinaturaRT() {
        return this.logoRT;
    }

    public boolean getLogoAssinaturaRTAlterada() {
        return this.isLogoRTAlterado;
    }

    public byte[] getCertificadoRTSub() {
        return this.certificadoRTSub;
    }

    public boolean getCertificadoRTSubAlterado() {
        return this.isCertificadoRTSubAlterado;
    }

    public byte[] getCertificadoRT() {
        return this.certificadoRT;
    }

    public boolean getCertificadoRTAlterado() {
        return this.isCertificadoRTAlterado;
    }

    public Date getValidadeRT() {
        if (!Funcoes.textoVazio(this.labelValidadeRTValor.getText())) {
            return Funcoes.getData("dd/MM/yyyy", this.labelValidadeRTValor.getText());
        }
        return null;
    }

    public Date getValidadeRTSub() {
        if (!Funcoes.textoVazio(this.labelValidadeRTSubValor.getText())) {
            return Funcoes.getData("dd/MM/yyyy", this.labelValidadeRTSubValor.getText());
        }
        return null;
    }

    public String getTipoCertificado() {
        return ((TipoCertificado)this.comboboxTipoCertificado.getSelectedItem()).codigo;
    }

    public String getUsuarioMsgVencimentoCertificado() {
        return this.textUsuarioMsgVencimentoCertificado.getText();
    }

    private JanelaAssinaturaDigital(Dialog janelaPai, String titulo, byte[] certificadoRT, byte[] certificadoRTSub, String senhaRT, String senhaRTSub, String motivoAssinatura, String localAssinatura, byte[] logoAssinaturaRT, byte[] logoAssinaturaRTSub, TipoFilial tipoFilial, String tipoCertificado, Date validadeCertificadoRT, Date validadeCertificadoRTSub, String usuariosMensagemVencimento) {
        super(janelaPai, titulo);
        this.montaTela();
        this.preencheDados(certificadoRT, certificadoRTSub, senhaRT, senhaRTSub, motivoAssinatura, localAssinatura, logoAssinaturaRT, logoAssinaturaRTSub, tipoFilial, tipoCertificado, validadeCertificadoRT, validadeCertificadoRTSub, usuariosMensagemVencimento);
    }

    private JanelaAssinaturaDigital(Frame pai, String titulo, byte[] certificadoRT, byte[] certificadoRTSub, String senhaRT, String senhaRTSub, String motivoAssinatura, String localAssinatura, byte[] logoAssinaturaRT, byte[] logoAssinaturaRTSub, TipoFilial tipoFilial, String tipoCertificado, Date validadeCertificadoRT, Date validadeCertificadoRTSub, String usuariosMensagemVencimento) {
        super(pai, titulo);
        this.montaTela();
        this.preencheDados(certificadoRT, certificadoRTSub, senhaRT, senhaRTSub, motivoAssinatura, localAssinatura, logoAssinaturaRT, logoAssinaturaRTSub, tipoFilial, tipoCertificado, validadeCertificadoRT, validadeCertificadoRTSub, usuariosMensagemVencimento);
    }

    private void montaTela() {
        this.setModal(true);
        this.setResizable(false);
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        Dimension dim = new Dimension(20, 20);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelTipoCertificacao.setDisplayedMnemonic('u');
        this.labelTipoCertificacao.setLabelFor(this.comboboxTipoCertificado);
        panelCentral.add((Component)this.labelTipoCertificacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.comboboxTipoCertificado.setPreferredSize(dim);
        this.comboboxTipoCertificado.setMinimumSize(dim);
        panelCentral.add((Component)this.comboboxTipoCertificado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelUsuarioMsgVencimentoCertificado.setDisplayedMnemonic('u');
        this.labelUsuarioMsgVencimentoCertificado.setLabelFor(this.textUsuarioMsgVencimentoCertificado);
        panelCentral.add((Component)this.labelUsuarioMsgVencimentoCertificado, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.textUsuarioMsgVencimentoCertificado.setPreferredSize(new Dimension(153, 20));
        this.textUsuarioMsgVencimentoCertificado.setMinimumSize(new Dimension(153, 20));
        panelCentral.add((Component)this.textUsuarioMsgVencimentoCertificado, c);
        c.weightx = 0.0;
        ++c.gridx;
        c.fill = 0;
        this.buttonUsuarioMsgVencimentoCertificado.setPreferredSize(dim);
        this.buttonUsuarioMsgVencimentoCertificado.setMinimumSize(dim);
        panelCentral.add((Component)this.buttonUsuarioMsgVencimentoCertificado, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 2;
        this.labelMotivoAssinatura.setDisplayedMnemonic('u');
        this.labelMotivoAssinatura.setLabelFor(this.textMotivoAssinatura);
        panelCentral.add((Component)this.labelMotivoAssinatura, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textMotivoAssinatura.setPreferredSize(dim);
        this.textMotivoAssinatura.setMinimumSize(dim);
        panelCentral.add((Component)this.textMotivoAssinatura, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelLocalAssinatura.setDisplayedMnemonic('L');
        this.labelLocalAssinatura.setLabelFor(this.textLocalAssinatura);
        panelCentral.add((Component)this.labelLocalAssinatura, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textMotivoAssinatura.setPreferredSize(dim);
        this.textMotivoAssinatura.setMinimumSize(dim);
        panelCentral.add((Component)this.textLocalAssinatura, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 2.0;
        c.gridwidth = 3;
        c.fill = 1;
        panelCentral.add((Component)this.panelRT, c);
        ++c.gridy;
        panelCentral.add((Component)this.panelRTSub, c);
        this.montaPanelRT();
        this.montaPanelRTSub();
        Funcoes.montaEnter((JComponent)panelCentral);
        this.montaListeners();
        this.setSize(500, 610);
        ScreenUtil.centralizar(this);
    }

    private void montaListeners() {
        this.buttonImportarCertificadoRT.addActionListener(this);
        this.buttonImportarCertificadoRTSub.addActionListener(this);
        this.buttonImportarLogoRT.addActionListener(this);
        this.buttonImportarLogoRTSub.addActionListener(this);
        this.buttonRemoverCertificadoRT.addActionListener(this);
        this.buttonRemoverCertificadoRTSub.addActionListener(this);
        this.buttonRemoverLogoRT.addActionListener(this);
        this.buttonRemoverLogoRTSub.addActionListener(this);
        this.buttonValidarRT.addActionListener(this);
        this.buttonValidarRTSub.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonImportarCertificadoRT) {
            byte[] arrayAux = this.importaCertificado();
            if (arrayAux != null) {
                this.certificadoRT = arrayAux;
                this.isCertificadoRTAlterado = true;
                Funcoes.mensagem(this, "Certificado importado com sucesso.", 5);
                ScreenUtil.requisitarFoco(this.textSenhaAssinaturaRT);
            }
            this.controlaCampos();
        } else if (e.getSource() == this.buttonImportarCertificadoRTSub) {
            byte[] arrayAux = this.importaCertificado();
            if (arrayAux != null) {
                this.certificadoRTSub = arrayAux;
                this.isCertificadoRTSubAlterado = true;
                Funcoes.mensagem(this, "Certificado importado com sucesso.", 5);
                ScreenUtil.requisitarFoco(this.textSenhaAssinaturaRTSub);
            }
            this.controlaCampos();
        } else if (e.getSource() == this.buttonImportarLogoRT) {
            byte[] arrayAux = this.importaLogo(this.labelVisualizacaoLogoRT);
            if (arrayAux != null) {
                this.logoRT = arrayAux;
                this.isLogoRTAlterado = true;
            }
            this.controlaCampos();
        } else if (e.getSource() == this.buttonImportarLogoRTSub) {
            byte[] arrayAux = this.importaLogo(this.labelVisualizacaoLogoRTSub);
            if (arrayAux != null) {
                this.logoRTSub = arrayAux;
                this.isLogoRTSubAlterado = true;
            }
            this.controlaCampos();
        } else if (e.getSource() == this.buttonRemoverCertificadoRT) {
            this.removeCertificadoRT();
            this.isCertificadoRTAlterado = true;
            this.controlaCampos();
        } else if (e.getSource() == this.buttonRemoverCertificadoRTSub) {
            this.removeCertificadoRTSub();
            this.isCertificadoRTSubAlterado = true;
            this.controlaCampos();
        } else if (e.getSource() == this.buttonRemoverLogoRT) {
            this.removeLogoRT();
            this.isLogoRTAlterado = true;
            this.controlaCampos();
        } else if (e.getSource() == this.buttonRemoverLogoRTSub) {
            this.removeLogoRTSub();
            this.isLogoRTSubAlterado = true;
            this.controlaCampos();
        } else if (e.getSource() == this.buttonUsuarioMsgVencimentoCertificado) {
            this.buscaUsuarios();
        } else if (e.getSource() == this.buttonValidarRT) {
            this.validarCertificado(this.certificadoRT, this.textSenhaAssinaturaRT.getText(), this.labelValidadeRTValor);
        } else if (e.getSource() == this.buttonValidarRTSub) {
            this.validarCertificado(this.certificadoRTSub, this.textSenhaAssinaturaRTSub.getText(), this.labelValidadeRTSubValor);
        }
    }

    private boolean validarCertificado(byte[] certificado, String senhaCertificado, JLabel labelValidade) {
        try {
            Date data = ResultadosUtil.validarCertificado(certificado, senhaCertificado);
            if (data != null) {
                labelValidade.setText(Funcoes.formataData("dd/MM/yyyy", data));
                return true;
            }
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel validar o certificado.\nVerifique se a senha est\u00e1 correta e se o certificado \u00e9 v\u00e1lido.", 2);
            labelValidade.setText("");
        }
        catch (Exception e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel validar o certificado.\nVerifique se a senha est\u00e1 correta e se o certificado \u00e9 v\u00e1lido.", 2);
            labelValidade.setText("");
        }
        return false;
    }

    private void buscaUsuarios() {
        if (!Funcoes.textoVazio(this.textUsuarioMsgVencimentoCertificado)) {
            this.selecionadosdfUsuarioErro.put(0, this.textUsuarioMsgVencimentoCertificado.getText().split(","));
        }
        this.dfUsuarioErro.setDados(this.selecionadosdfUsuarioErro, "usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{150, 0}, " fil_codigo = " + Variaveis.filialPadrao);
        this.dfUsuarioErro.setVisible(true);
        if (this.dfUsuarioErro != null && this.dfUsuarioErro.getSelecionados(0) != null && this.dfUsuarioErro.ok()) {
            this.selecionadosdfUsuarioErro.put(0, this.dfUsuarioErro.getSelecionados(0));
            this.textUsuarioMsgVencimentoCertificado.setText(StringUtil.implode(this.dfUsuarioErro.getSelecionados(0), ","));
        }
    }

    private void removeLogoRTSub() {
        this.logoRTSub = null;
        this.labelVisualizacaoLogoRTSub.setIcon(null);
    }

    private void removeLogoRT() {
        this.logoRT = null;
        this.labelVisualizacaoLogoRT.setIcon(null);
    }

    private void removeCertificadoRT() {
        this.certificadoRT = null;
        this.textSenhaAssinaturaRT.clear();
        this.logoRT = null;
        this.labelVisualizacaoLogoRT.setIcon(null);
        this.labelValidadeRTValor.setText("");
        this.controlaCampos();
    }

    private void removeCertificadoRTSub() {
        this.certificadoRTSub = null;
        this.textSenhaAssinaturaRTSub.clear();
        this.logoRTSub = null;
        this.labelVisualizacaoLogoRTSub.setIcon(null);
        this.labelValidadeRTSubValor.setText("");
        this.controlaCampos();
    }

    private byte[] importaLogo(JLabel componente) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
        if (fileChooser.showOpenDialog(this) == 0) {
            return this.carregaLogo(fileChooser.getSelectedFile().getAbsolutePath(), componente);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] carregaLogo(String caminhoImagem, JLabel componente) {
        try {
            File arquivo = new File(caminhoImagem);
            FileInputStream fais = null;
            ArrayList<Byte> dados = new ArrayList<Byte>();
            int carac = -1;
            try {
                fais = new FileInputStream(arquivo);
                while ((carac = fais.read()) > -1) {
                    dados.add((byte)carac);
                }
            }
            finally {
                if (fais != null) {
                    fais.close();
                }
            }
            byte[] array = new byte[dados.size()];
            for (int i = 0; i < dados.size(); ++i) {
                array[i] = (Byte)dados.get(i);
            }
            ImageIcon imagem = new ImageIcon();
            imagem.setImage(Toolkit.getDefaultToolkit().getImage(caminhoImagem));
            componente.setIcon(imagem);
            return array;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a imagem da logo.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private byte[] importaCertificado() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de certificado", "pfx"));
        if (fileChooser.showOpenDialog(this) == 0) {
            return this.carregaCertificado(fileChooser.getSelectedFile().getAbsolutePath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] carregaCertificado(String caminhoCertificado) {
        try {
            File arquivo = new File(caminhoCertificado);
            FileInputStream fais = null;
            ArrayList<Byte> dados = new ArrayList<Byte>();
            int carac = -1;
            try {
                fais = new FileInputStream(arquivo);
                while ((carac = fais.read()) > -1) {
                    dados.add((byte)carac);
                }
            }
            finally {
                if (fais != null) {
                    fais.close();
                }
            }
            byte[] array = new byte[dados.size()];
            for (int i = 0; i < dados.size(); ++i) {
                array[i] = (Byte)dados.get(i);
            }
            return array;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o certificado.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    private void montaPanelRT() {
        this.panelRT.setBorder(new TitledBorder("Respons\u00e1vel T\u00e9cnico"));
        Dimension dimVisualizacao = new Dimension(20, 130);
        JPanel panelLogo = new JPanel(new GridBagLayout());
        JPanel panelCertificado = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCertificado.add((Component)this.labelCertificadoRT, c);
        ++c.gridx;
        this.buttonImportarCertificadoRT.setPreferredSize(new Dimension(90, this.buttonImportarCertificadoRT.getPreferredSize().height));
        this.buttonImportarCertificadoRT.setMnemonic('I');
        panelCertificado.add((Component)this.buttonImportarCertificadoRT, c);
        ++c.gridx;
        this.buttonRemoverCertificadoRT.setMnemonic('R');
        panelCertificado.add((Component)this.buttonRemoverCertificadoRT, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        this.checkCertificadoRTImportado.setEnabled(false);
        panelCertificado.add((Component)this.checkCertificadoRTImportado, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelSenhaRT.setDisplayedMnemonic('S');
        this.labelSenhaRT.setLabelFor(this.textSenhaAssinaturaRT);
        panelCertificado.add((Component)this.labelSenhaRT, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        panelCertificado.add((Component)this.textSenhaAssinaturaRT, c);
        this.buttonValidarRT.setPreferredSize(new Dimension(80, 18));
        this.buttonValidarRT.setMinimumSize(new Dimension(80, 18));
        this.buttonValidarRT.setMnemonic('V');
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx += 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        panelCertificado.add((Component)this.buttonValidarRT, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelValidadeRT.setLabelFor(this.labelValidadeRTValor);
        panelCertificado.add((Component)this.labelValidadeRT, c);
        c.insets = new Insets(0, 1, 0, 1);
        this.labelValidadeRTValor.setPreferredSize(new Dimension(90, 18));
        this.labelValidadeRTValor.setMinimumSize(new Dimension(90, 18));
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        panelCertificado.add((Component)this.labelValidadeRTValor, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        this.panelRT.add((Component)panelCertificado, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelRT.add((Component)panelLogo, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVisualizacaoLogoRT.setPreferredSize(dimVisualizacao);
        this.labelVisualizacaoLogoRT.setMinimumSize(dimVisualizacao);
        this.labelVisualizacaoLogoRT.setBorder(new TitledBorder(""));
        this.panelRT.add((Component)this.labelVisualizacaoLogoRT, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelLogo.add((Component)this.labelLogoRT, c);
        ++c.gridx;
        this.buttonImportarLogoRT.setMnemonic('t');
        panelLogo.add((Component)this.buttonImportarLogoRT, c);
        ++c.gridy;
        this.buttonRemoverLogoRT.setMnemonic('n');
        panelLogo.add((Component)this.buttonRemoverLogoRT, c);
    }

    private void montaPanelRTSub() {
        this.panelRTSub.setBorder(new TitledBorder("Respons\u00e1vel T\u00e9cnico Substituto (opcional)"));
        Dimension dimVisualizacao = new Dimension(20, 130);
        JPanel panelLogo = new JPanel(new GridBagLayout());
        JPanel panelCertificado = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCertificado.add((Component)this.labelCertificadoRTSub, c);
        ++c.gridx;
        this.buttonImportarCertificadoRTSub.setPreferredSize(new Dimension(90, this.buttonImportarCertificadoRTSub.getPreferredSize().height));
        this.buttonImportarCertificadoRTSub.setMnemonic('p');
        panelCertificado.add((Component)this.buttonImportarCertificadoRTSub, c);
        ++c.gridx;
        this.buttonRemoverCertificadoRTSub.setMnemonic('e');
        panelCertificado.add((Component)this.buttonRemoverCertificadoRTSub, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 1, 1);
        this.checkCertificadoRTSubImportado.setEnabled(false);
        panelCertificado.add((Component)this.checkCertificadoRTSubImportado, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelSenhaRTSub.setDisplayedMnemonic('n');
        this.labelSenhaRTSub.setLabelFor(this.textSenhaAssinaturaRTSub);
        panelCertificado.add((Component)this.labelSenhaRTSub, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.fill = 2;
        panelCertificado.add((Component)this.textSenhaAssinaturaRTSub, c);
        this.buttonValidarRTSub.setPreferredSize(new Dimension(80, 18));
        this.buttonValidarRTSub.setMinimumSize(new Dimension(80, 18));
        this.buttonValidarRTSub.setMnemonic('l');
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx += 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        panelCertificado.add((Component)this.buttonValidarRTSub, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelValidadeRTSub.setLabelFor(this.labelValidadeRTSubValor);
        panelCertificado.add((Component)this.labelValidadeRTSub, c);
        c.insets = new Insets(0, 1, 0, 1);
        this.labelValidadeRTSubValor.setPreferredSize(new Dimension(90, 18));
        this.labelValidadeRTSubValor.setMinimumSize(new Dimension(90, 18));
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        panelCertificado.add((Component)this.labelValidadeRTSubValor, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.fill = 2;
        this.panelRTSub.add((Component)panelCertificado, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 0;
        this.panelRTSub.add((Component)panelLogo, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelVisualizacaoLogoRTSub.setPreferredSize(dimVisualizacao);
        this.labelVisualizacaoLogoRTSub.setMinimumSize(dimVisualizacao);
        this.labelVisualizacaoLogoRTSub.setBorder(new TitledBorder(""));
        this.panelRTSub.add((Component)this.labelVisualizacaoLogoRTSub, c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelLogo.add((Component)this.labelLogoRTSub, c);
        ++c.gridx;
        this.buttonImportarLogoRTSub.setMnemonic('a');
        panelLogo.add((Component)this.buttonImportarLogoRTSub, c);
        ++c.gridy;
        this.buttonRemoverLogoRTSub.setMnemonic('m');
        panelLogo.add((Component)this.buttonRemoverLogoRTSub, c);
    }

    private void preencheDados(byte[] certificadoRT, byte[] certificadoRTSub, String senhaRT, String senhaRTSub, String motivoAssinatura, String localAssinatura, byte[] logoAssinaturaRT, byte[] logoAssinaturaRTSub, TipoFilial tipoFilial, String tipoCertificado, Date validadeCertificadoRT, Date validadeCertificadoRTSub, String usuariosMensagemVencimento) {
        this.certificadoRT = certificadoRT;
        this.certificadoRTSub = certificadoRTSub;
        this.senhaRT = senhaRT;
        this.senhaRTSub = senhaRTSub;
        this.motivoAssinatura = motivoAssinatura;
        this.localAssinatura = localAssinatura;
        this.logoRT = logoAssinaturaRT;
        this.logoRTSub = logoAssinaturaRTSub;
        this.textMotivoAssinatura.setText(motivoAssinatura);
        this.textLocalAssinatura.setText(localAssinatura);
        if (certificadoRT != null) {
            this.textSenhaAssinaturaRT.setText(senhaRT);
            if (this.logoRT != null) {
                this.labelVisualizacaoLogoRT.setIcon(new ImageIcon(this.logoRT));
            }
        }
        if (certificadoRTSub != null) {
            this.textSenhaAssinaturaRTSub.setText(senhaRTSub);
            if (this.logoRTSub != null) {
                this.labelVisualizacaoLogoRTSub.setIcon(new ImageIcon(this.logoRTSub));
            }
        }
        this.textSenhaAssinaturaRT.setText(senhaRT);
        this.textSenhaAssinaturaRTSub.setText(senhaRTSub);
        if (tipoFilial != null) {
            this.comboboxTipoCertificado.addItem(new TipoCertificado("N", Tipos.getTipoCertificacaoAssinatura("N")));
            this.comboboxTipoCertificado.addItem(new TipoCertificado("F", Tipos.getTipoCertificacaoAssinatura("F")));
            if (!tipoFilial.codigo.equalsIgnoreCase("A")) {
                this.comboboxTipoCertificado.addItem(new TipoCertificado("U", Tipos.getTipoCertificacaoAssinatura("U")));
            }
            if (tipoFilial.codigo.equalsIgnoreCase("A")) {
                this.comboboxTipoCertificado.addItem(new TipoCertificado("S", Tipos.getTipoCertificacaoAssinatura("S")));
            }
            if (tipoCertificado != null) {
                this.comboboxTipoCertificado.setSelectedItem(new TipoCertificado(tipoCertificado, Tipos.getTipoCertificacaoAssinatura(tipoCertificado)));
            } else {
                this.comboboxTipoCertificado.setSelectedItem(0);
            }
        }
        this.textUsuarioMsgVencimentoCertificado.setText(usuariosMensagemVencimento);
        this.labelValidadeRTValor.setText(Funcoes.formataData(validadeCertificadoRT));
        this.labelValidadeRTSubValor.setText(Funcoes.formataData(validadeCertificadoRTSub));
        this.controlaCampos();
    }

    private void controlaCampos() {
        boolean ativarRT = this.certificadoRT != null;
        boolean ativarRTSub = this.certificadoRTSub != null;
        this.textSenhaAssinaturaRT.setEnabled(ativarRT);
        this.buttonImportarLogoRT.setEnabled(ativarRT);
        this.buttonRemoverCertificadoRT.setEnabled(ativarRT);
        this.checkCertificadoRTImportado.setSelected(ativarRT);
        this.buttonValidarRT.setEnabled(ativarRT);
        this.buttonRemoverLogoRT.setEnabled(this.logoRT != null);
        this.textSenhaAssinaturaRTSub.setEnabled(ativarRTSub);
        this.buttonImportarLogoRTSub.setEnabled(ativarRTSub);
        this.buttonRemoverCertificadoRTSub.setEnabled(ativarRTSub);
        this.checkCertificadoRTSubImportado.setSelected(ativarRTSub);
        this.textUsuarioMsgVencimentoCertificado.setEditable(false);
        this.buttonValidarRTSub.setEnabled(ativarRTSub);
        this.buttonRemoverLogoRTSub.setEnabled(this.logoRTSub != null);
    }
}

