/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.cadastro.interfaceamento.consulta.ConsultaLog;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class Interface
extends FrmCadPadrao
implements ActionListener {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private TTextField txtFabricante;
    private JLabel jLabel2;
    private JButton jButton2;
    private JLabel jLabel6;
    private TTextField txtCodSetor;
    private TTextField txtDescSetor;
    private JLabel jLabel7;
    private TTextField txtDataAquisicao;
    private JLabel jLabel11;
    private JCheckBox checkComodato;
    private JButton buttonBuscaData = new JButton();
    private JCheckBox checkContadorCelulas = new JCheckBox("Permitir contador de c\u00e9lulas na Libera\u00e7\u00e3o de Exame");
    private JCheckBox checkNaoGravarLog = new JCheckBox("N\u00e3o gravar os logs de comunica\u00e7\u00e3o");
    private JCheckBox checkInativo = ComponenteFactory.novoJCheckBox("Inativo", 'I');
    private JButton buttonConsultar;
    private JPanel panelMaterial = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Materiais que comp\u00f5em o equipamento"));
    private TTextField textCodigoMaterial = new TTextField(5, 1);
    private JLabel labelDescricaoMaterial = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JComboBox comboPatrimonio = new JComboBox();
    private HashMap<String, String> patrimonioSetor = new HashMap();
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", this);
    private ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Patrim\u00f4nio"});
    private JTable tabelaMaterial = new JTable(this.modeloMaterial);
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_PATRIMONIO = 2;
    private String retornoParaPesquisa = "";
    private String nomeInterface = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Interface.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901301"));
        this.setModuloEdita(Long.parseLong("0101901302"));
        this.setModuloApaga(Long.parseLong("0101901303"));
    }

    public Interface() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Interface");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Interface");
        this.setLabelDescricao("Cadastro de equipamentos para interfaceamento de exames");
        this.setLabelFormulario("Cadastro de interfaces");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/p_interfac.jpg"));
        this.comboPatrimonio.setName("comboPatrimonio");
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.txtFabricante = new TTextField(80);
        this.txtFabricante.setName("txtFabricante");
        this.jLabel2 = new JLabel();
        this.jButton2 = new JButton();
        this.jLabel6 = new JLabel();
        this.txtCodSetor = new TTextField(5, 1);
        this.txtCodSetor.setName("txtCodSetor");
        this.txtDescSetor = new TTextField();
        this.jLabel7 = new JLabel();
        this.txtDataAquisicao = new TTextField(10, 4);
        this.txtDataAquisicao.setName("txtDataAquisicao");
        this.checkComodato = new JCheckBox("Comodato");
        this.checkComodato.setName("checkComodato");
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(5, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(97, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(5, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel11.setBounds(new Rectangle(5, 51, 90, 14));
        this.jLabel11.setText("Fabricante:");
        this.txtFabricante.setText("");
        this.txtFabricante.setBounds(new Rectangle(97, 49, 400, 20));
        this.jLabel6.setText("Setor:");
        this.jLabel6.setBounds(new Rectangle(5, 93, 63, 14));
        this.txtCodSetor.setText("");
        this.txtCodSetor.setBounds(new Rectangle(97, 91, 69, 20));
        this.jButton2.setBounds(new Rectangle(167, 91, 20, 20));
        this.jButton2.setFocusable(false);
        this.jButton2.setText("");
        Funcoes.imagemPesquisa(this.jButton2);
        this.txtDescSetor.setText("");
        this.txtDescSetor.setEditable(false);
        this.txtDescSetor.setFocusable(false);
        this.txtDescSetor.setBounds(new Rectangle(188, 91, 309, 20));
        this.jLabel7.setBounds(new Rectangle(5, 72, 90, 14));
        this.jLabel7.setText("Aquisi\u00e7\u00e3o:");
        this.txtDataAquisicao.setBounds(new Rectangle(97, 70, 100, 20));
        this.txtDataAquisicao.setText("");
        this.buttonBuscaData.setBounds(new Rectangle(198, 70, 20, 20));
        this.buttonBuscaData.setName("buttonBuscaData");
        this.buttonBuscaData.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaData);
        this.checkComodato.setBounds(new Rectangle(97, 112, 123, 20));
        this.checkComodato.setName("checkComodato");
        this.checkContadorCelulas.setBounds(new Rectangle(220, 112, 420, 20));
        this.checkContadorCelulas.setName("checkContadorCelulas");
        this.checkNaoGravarLog.setBounds(new Rectangle(97, 132, this.checkNaoGravarLog.getPreferredSize().width, 20));
        this.checkNaoGravarLog.setName("checkNaoGravarLog");
        this.panelMaterial.setBounds(97, 152, 497, 300);
        this.checkInativo.setBounds(new Rectangle(97, 455, 100, 20));
        this.checkInativo.setName("checkInativo");
        this.buttonConsultar = new JButton("Consultar Log");
        this.buttonConsultar.setName("buttonConsultar");
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.temCodigo()) {
                    ConsultaLog.abrirTela(this.getCodigoInterface(), Interface.this.nomeInterface);
                }
            }

            private boolean temCodigo() {
                return !Funcoes.textoVazio(Interface.this.txtCodigo.getText());
            }

            private Integer getCodigoInterface() {
                return Integer.valueOf(Interface.this.txtCodigo.getText());
            }
        });
        this.buttonConsultar.setBounds(new Rectangle(468, 455, 120, 22));
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel11, null);
        this.painelCentral.add((Component)this.txtCodSetor, null);
        this.painelCentral.add((Component)this.jButton2, null);
        this.painelCentral.add((Component)this.txtDescSetor, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtFabricante, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.txtDataAquisicao, null);
        this.painelCentral.add(this.buttonBuscaData);
        this.painelCentral.add((Component)this.checkComodato, null);
        this.painelCentral.add((Component)this.checkContadorCelulas, null);
        this.painelCentral.add((Component)this.checkNaoGravarLog, null);
        this.painelCentral.add((Component)this.checkInativo, null);
        this.painelCentral.add((Component)this.buttonConsultar, null);
        this.painelCentral.add(this.panelMaterial);
        this.montaPanelMaterial();
        this.controlaCampos();
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interface.this.buscaSetor();
            }
        });
        this.buttonBuscaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(Interface.this.txtDataAquisicao, Interface.this.buttonBuscaData, Interface.this.painelCentral, true);
            }
        });
        this.txtCodSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Interface.this.txtCodSetor.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select set_descricao from setores where fil_codigo = " + Variaveis.filialPadrao + " and set_codigo=" + Interface.this.txtCodSetor.getTextDBEscape());
                        if (rs.next()) {
                            Interface.this.txtDescSetor.setText(rs.getString("set_descricao"));
                        } else {
                            Interface.this.txtDescSetor.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Interface.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        ErrorLogger.mostraMensagem(Interface.this, sqlex.getMessage(), sqlex.getStackTrace(), "Interface");
                        Interface.this.setStatus(1);
                        Interface.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (Interface.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Interface.this.txtCodigo.getText().trim())) {
                    Statement st;
                    block9: {
                        st = Conexao.getStatement();
                        try {
                            if (st == null) break block9;
                            StringBuilder buf = new StringBuilder("select a.int_descricao, a.int_descricao, a.int_dataaquisicao, a.int_fabricante, a.int_contadorcelulas, a.int_inativo, ");
                            buf.append(" a.int_ignorarloginterface, a.int_comodato, a.set_codigo, b.set_descricao from interface a ");
                            buf.append("left join setores b on a.fil_codigo = b.fil_codigo and a.set_codigo = b.set_codigo ");
                            buf.append(" where a.fil_codigo=");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and a.int_codigo=");
                            buf.append(Interface.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Interface.this.txtDescricao.setText(rs.getString("int_descricao"));
                                Interface.this.nomeInterface = rs.getString("int_descricao");
                                Interface.this.txtFabricante.setText(rs.getString("int_fabricante"));
                                if (!DBUtil.campoNull(rs.getString("set_codigo"))) {
                                    Interface.this.txtCodSetor.setText(rs.getString("set_codigo"));
                                    Interface.this.txtDescSetor.setText(rs.getString("set_descricao"));
                                }
                                if (!DBUtil.campoNull(rs.getString("int_dataaquisicao"))) {
                                    Interface.this.txtDataAquisicao.setText(Funcoes.formataData(rs.getDate("int_dataaquisicao")));
                                }
                                Interface.this.checkComodato.setSelected(rs.getBoolean("int_comodato"));
                                Interface.this.checkContadorCelulas.setSelected(rs.getBoolean("int_contadorcelulas"));
                                Interface.this.checkNaoGravarLog.setSelected(rs.getBoolean("int_ignorarloginterface"));
                                Interface.this.checkInativo.setSelected(rs.getBoolean("int_inativo"));
                                buf.setLength(0);
                                buf.append("select a.mat_codigo, a.mtp_patrimonio, b.mat_descricao from interfacematerial a ");
                                buf.append("left join material b on a.fil_codigo = b.fil_codigo and a.mat_codigo = b.mat_codigo ");
                                buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                                buf.append(" and a.int_codigo = ").append(Interface.this.txtCodigo.getText());
                                rs = Conexao.executeQuery(st, buf);
                                while (rs.next()) {
                                    Interface.this.modeloMaterial.addLine(new String[]{rs.getString("mat_codigo"), rs.getString("mat_descricao"), rs.getString("mtp_patrimonio")});
                                }
                                Interface.this.txtCodigo.setEnabled(false);
                                break block9;
                            }
                            Funcoes.mensagem(Interface.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                            Interface.this.setStatus(1);
                            Interface.this.controlaCampos();
                        }
                        catch (SQLException sqlex) {
                            try {
                                ErrorLogger.mostraMensagem(Interface.this, sqlex.getMessage(), sqlex.getStackTrace(), "Interface");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
        this.textCodigoMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Interface.this.buscaMaterialPatrimonio();
            }
        });
        this.textCodigoMaterial.setName("textCodigoMaterial");
        this.textCodigoMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Interface.this.buttonBuscaMaterial.doClick();
                }
            }
        });
        this.tabelaMaterial.setName("tabelaMaterial");
    }

    private void montaPanelMaterial() {
        this.modeloMaterial.setColumnSize(new int[]{70, 0, 150}, this.tabelaMaterial);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.panelMaterial.add((Component)new JLabel("Material"), c);
        c.gridx = 3;
        this.panelMaterial.add((Component)new JLabel("Patrim\u00f4nio"), c);
        c.gridx = 0;
        ++c.gridy;
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        this.textCodigoMaterial.setMaximumSize(new Dimension(70, 20));
        this.panelMaterial.add((Component)this.textCodigoMaterial, c);
        ++c.gridx;
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.panelMaterial.add((Component)this.buttonBuscaMaterial, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(100, 20));
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(50, 20));
        this.panelMaterial.add((Component)this.labelDescricaoMaterial, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.comboPatrimonio.setPreferredSize(new Dimension(150, 20));
        this.comboPatrimonio.setMaximumSize(new Dimension(150, 20));
        this.comboPatrimonio.setMinimumSize(new Dimension(150, 20));
        this.panelMaterial.add((Component)this.comboPatrimonio, c);
        ++c.gridx;
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setName("buttonOK");
        this.panelMaterial.add((Component)this.buttonOK, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 5;
        this.panelMaterial.add((Component)new JScrollPane(this.tabelaMaterial), c);
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Interface.this.tabelaMaterial.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(Interface.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Interface.this.modeloMaterial.removeLine(Interface.this.tabelaMaterial.getSelectedRow());
                }
            }
        });
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.interfaces(this.getTopLevelAncestor(), false, true);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("int_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("interface", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("int_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaInterface());
                    Conexao.arquivaSQL();
                }
            }
            catch (SQLException sqlex) {
                try {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao efetuar a opera\u00e7\u00e3o no banco de dados", 1);
                }
                catch (Exception ex) {
                    Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                }
            }
            catch (Exception ex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "interface", true);
                }
                SalvaDados salvar = new SalvaDados("interface", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("int_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("int_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("int_fabricante", 0, true, false, this.txtFabricante.getTextDBEscape());
                salvar.adicionaCampo("int_dataaquisicao", 1, true, false, this.txtDataAquisicao.getText());
                salvar.adicionaCampo("int_comodato", 4, true, false, this.checkComodato.isSelected());
                salvar.adicionaCampo("int_contadorcelulas", 4, true, false, this.checkContadorCelulas.isSelected());
                salvar.adicionaCampo("int_ignorarloginterface", 4, true, false, this.checkNaoGravarLog.isSelected());
                salvar.adicionaCampo("int_inativo", 4, true, false, this.checkInativo.isSelected());
                salvar.adicionaCampo("set_codigo", 2, true, false, this.txtCodSetor.getText());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaInterface(), "interface", Integer.parseInt(codigo));
                salvar = new SalvaDados("interfacematerial", 1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("int_codigo", 2, false, true, codigo);
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaInterface(), "interfacematerial", Integer.parseInt(codigo));
                for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                    salvar = new SalvaDados("interfacematerial", 0);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("int_codigo", 2, false, true, codigo);
                    salvar.adicionaCampo("mat_codigo", 2, false, true, this.modeloMaterial.getValueAt(i, 0).toString());
                    salvar.adicionaCampo("mtp_patrimonio", 0, false, true, this.modeloMaterial.getValueAt(i, 2).toString());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaInterface(), "interfacematerial", Integer.parseInt(codigo));
                }
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Interface");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFabricante.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodSetor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDataAquisicao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaData.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkComodato.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkContadorCelulas.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkNaoGravarLog.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativo.setEnabled(this.getStatus() == 3);
        this.textCodigoMaterial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaMaterial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonOK.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboPatrimonio.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonConsultar.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtFabricante.setText("");
        this.txtCodSetor.setText("");
        this.txtDescSetor.setText("");
        this.txtDataAquisicao.setText("");
        this.textCodigoMaterial.clear();
        this.comboPatrimonio.removeAllItems();
        this.modeloMaterial.clear();
        this.labelDescricaoMaterial.setText("");
        this.checkComodato.setSelected(false);
        this.checkContadorCelulas.setSelected(false);
        this.checkNaoGravarLog.setSelected(false);
        this.checkInativo.setSelected(false);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodSetor.getText())) {
            Funcoes.mensagem(this, "Setor n\u00e3o informado", 1);
            this.txtCodSetor.selectAll();
            this.txtCodSetor.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodSetor.getText()) && this.txtDescSetor.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Setor n\u00e3o localizado", 1);
            this.txtCodSetor.selectAll();
            this.txtCodSetor.grabFocus();
            return false;
        }
        return true;
    }

    private void buscaSetor() {
        Hashtable resultado = Pesquisas.setor(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodSetor.setText(resultado.get("set_codigo").toString());
        }
        this.txtCodSetor.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodSetor.hasFocus()) {
            this.buscaSetor();
        } else if (this.txtDataAquisicao.hasFocus()) {
            Funcoes.mostraData(this.txtDataAquisicao, this.buttonBuscaData, this.painelCentral, true);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901300");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaMaterial) {
            this.pesquisaMaterial();
        } else if (e.getSource() == this.buttonOK) {
            this.adicionarMaterial();
        }
    }

    private void pesquisaMaterial() {
        Hashtable resultado = Pesquisas.materialAtivo(this.getTopLevelAncestor(), false);
        if (resultado != null) {
            this.textCodigoMaterial.setText(resultado.get("mat_codigo").toString());
        }
        this.textCodigoMaterial.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaMaterialPatrimonio() {
        if (!Funcoes.textoVazio(this.textCodigoMaterial.getText())) {
            Statement st;
            block7: {
                st = Conexao.getStatement();
                try {
                    StringBuilder buf = new StringBuilder("select a.mat_descricao,  b.mtp_patrimonio, b.set_codigo from material a ");
                    buf.append("left join materialpatrimonio b on a.fil_codigo = b.fil_codigo and a.mat_codigo = b.mat_codigo ");
                    buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append(" and a.mat_codigo = ").append(this.textCodigoMaterial.getText());
                    buf.append(" order by b.mtp_patrimonio ");
                    ResultSet rs = Conexao.executeQuery(st, buf);
                    this.comboPatrimonio.removeAllItems();
                    this.patrimonioSetor.clear();
                    if (rs.next()) {
                        this.labelDescricaoMaterial.setText(rs.getString("mat_descricao"));
                        do {
                            this.comboPatrimonio.addItem(rs.getString("mtp_patrimonio"));
                            this.patrimonioSetor.put(rs.getString("mtp_patrimonio"), rs.getString("set_codigo"));
                        } while (rs.next());
                        break block7;
                    }
                    this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    ScreenUtil.requisitarFoco(this.textCodigoMaterial);
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Interface: 558");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adicionarMaterial() {
        if (this.comboPatrimonio.getSelectedItem() == null) {
            Funcoes.mensagem(this, "Patrim\u00f4nio n\u00e3o informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMaterial);
            return;
        }
        int linha = this.modeloMaterial.localizar(2, this.comboPatrimonio.getSelectedItem().toString());
        if (Funcoes.isNumeric(this.textCodigoMaterial.getText()) && !this.labelDescricaoMaterial.getText().equals("N\u00e3o cadastrado") && linha < 0) {
            if (!this.isMesmoSetor()) {
                Funcoes.mensagem(this, "O Material n\u00e3o possui Patrim\u00f4nio associado ao 'Setor' informado.", 2);
                ScreenUtil.requisitarFoco(this.textCodigoMaterial);
                return;
            }
            this.modeloMaterial.addLine(new String[]{this.textCodigoMaterial.getText(), this.labelDescricaoMaterial.getText(), this.comboPatrimonio.getSelectedItem().toString()});
        }
        this.textCodigoMaterial.clear();
        this.comboPatrimonio.removeAllItems();
        this.labelDescricaoMaterial.setText("");
        ScreenUtil.requisitarFoco(this.textCodigoMaterial);
    }

    private boolean isMesmoSetor() {
        String codigoPatrimonio = this.comboPatrimonio.getSelectedItem().toString();
        return this.patrimonioSetor.get(codigoPatrimonio).equalsIgnoreCase(this.txtCodSetor.getText());
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "int_codigo";
    }
}

