/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.model.bean.cadastro.IdentificadorLaminaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.IdentificadorLaminaVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.IdentificadorLaminaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class IdentificadorLamina
extends FrmCadPadrao {
    private static final long ACESSO_ACESSAR = Long.parseLong("0101901700");
    private static final long ACESSO_INSERIR = Long.parseLong("0101901701");
    private static final long ACESSO_EDITAR = Long.parseLong("0101901702");
    private static final long ACESSO_APAGAR = Long.parseLong("0101901703");
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelSigla = new JLabel("Sigla:");
    private TTextField textCodigo = new TTextField(10, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textSigla = new TTextField(3, 3);
    private String retornoParaPesquisa = "";
    private IdentificadorLaminaBean identificadorAux = null;

    public IdentificadorLamina() {
        this.montaTela();
    }

    private void montaTela() {
        this.setName("IdentificadorLamina");
        this.setLabelDescricao("Cadastro de identificadores para impress\u00e3o de etiqueta de l\u00e2mina");
        this.setLabelFormulario("Cadastro de identificador de l\u00e2mina");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_setor.jpg"));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(new Dimension(80, 20));
        this.textCodigo.setMinimumSize(new Dimension(80, 20));
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(new Dimension(20, 20));
        this.textDescricao.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelSigla, c);
        this.textSigla.setName("textSigla");
        this.textSigla.setPreferredSize(new Dimension(50, 20));
        this.textSigla.setMinimumSize(new Dimension(50, 20));
        ++c.gridx;
        this.painelCentral.add((Component)this.textSigla, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        this.painelCentral.add((Component)new JLabel(""), c);
        Funcoes.montaEnter((JComponent)this);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(IdentificadorLamina.getModuloAcesso());
        this.setModuloInsere(ACESSO_INSERIR);
        this.setModuloEdita(ACESSO_EDITAR);
        this.setModuloApaga(ACESSO_APAGAR);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(enabled);
        this.textSigla.setEnabled(enabled);
    }

    private void limparCampos() {
        this.textCodigo.clear();
        this.textDescricao.clear();
        this.textSigla.clear();
        this.identificadorAux = null;
    }

    @Override
    public void salvar() {
        IdentificadorLaminaBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                new IdentificadorLaminaService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private IdentificadorLaminaBean getBeanPreenchido() {
        IdentificadorLaminaBean bean = null;
        if (this.identificadorAux == null) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            bean = new IdentificadorLaminaBean();
            bean.setFilial(filial);
        } else {
            bean = this.identificadorAux;
        }
        bean.setCodigo(!Funcoes.textoVazio(this.textCodigo) ? Integer.valueOf(Integer.parseInt(this.textCodigo.getText())) : null);
        bean.setDescricao(this.textDescricao.getText());
        bean.setSigla(this.textSigla.getText());
        return bean;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void excluir() {
        final IdentificadorLaminaBean beanDelete = this.pesquisar();
        if (beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdentificadorLamina.this.preencherCampos(beanDelete);
                    if (Funcoes.mensagem(IdentificadorLamina.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            new IdentificadorLaminaService().gravaAutoCopiaSemCommit(beanDelete, 2, Variaveis.filialPadrao, null);
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(IdentificadorLamina.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
                        }
                    }
                    IdentificadorLamina.this.limparCampos();
                }
            });
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        IdentificadorLaminaBean identificador = this.pesquisar();
        if (identificador != null) {
            this.setStatus(3);
            this.controlaCampos();
            this.preencherCampos(identificador);
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    private void preencherCampos(IdentificadorLaminaBean identificador) {
        if (identificador != null) {
            this.textCodigo.setText(identificador.getCodigo().toString());
            this.textDescricao.setText(identificador.getDescricao());
            this.textSigla.setText(identificador.getSigla());
            this.identificadorAux = identificador;
        }
    }

    private IdentificadorLaminaBean pesquisar() {
        IdentificadorLaminaVO vo = new IdentificadorLaminaVO();
        vo = (IdentificadorLaminaVO)new IdentificadorLaminaService().pesquisaVO(this.getTopLevelAncestor(), vo, "Pesquisando identificadores de l\u00e2mina", false);
        if (vo != null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", vo.getFilial().getCodigo());
            chaves.put("ide_codigo", vo.getCodigo());
            try {
                return (IdentificadorLaminaBean)new IdentificadorLaminaService().getBean(chaves);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do identificador de l\u00e2mina.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        return null;
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar a descri\u00e7\u00e3o do identificador de l\u00e2mina.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.textSigla)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar a sigla do identificador de l\u00e2mina.", 2);
            ScreenUtil.requisitarFoco(this.textSigla);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ide_codigo";
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    public String getCopiaFiliais() {
        return ParametrosGerais.getCopiaIdentificadorLamina();
    }
}

