/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.cadastro.DocumentoStyledHistorico;
import jalis.laboratorio.cadastro.EditorKitNoWrap;
import jalis.laboratorio.cadastro.PanelEdicao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.exame.HistoricoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Historico
extends FrmCadPadrao {
    private int maxLength = 500;
    private TTextField textCodigo = new TTextField(5, 1);
    private JTextPane textDescricao = new JTextPane();
    private PanelEdicao panelEdicao = new PanelEdicao(this.textDescricao, this.maxLength);
    private TTextField textMnemonico = new TTextField(5);
    private final int NEGRITO = 1;
    private final int ITALICO = 2;
    private final int SUBLINHADO = 4;
    private final int SUP = 8;
    private final int SUB = 16;
    private String retornoParaPesquisa = "";

    public Historico() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Historico (31)");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Historico");
        this.setLabelDescricao("Cadastro de textos padr\u00f5es para digita\u00e7\u00e3o");
        this.setLabelFormulario("Cadastro de hist\u00f3ricos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_historico.jpg"));
        this.textDescricao.setBorder(BorderFactory.createEtchedBorder());
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setEditorKit(new EditorKitNoWrap());
        DocumentoStyledHistorico style = new DocumentoStyledHistorico(this.textDescricao);
        style.setMaxLength(this.maxLength);
        this.textDescricao.setDocument(style);
        this.painelCentral.setBorder(BorderFactory.createEmptyBorder(9, 0, 0, 0));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        Insets ioriginal = c.insets;
        this.painelCentral.add((Component)new JLabel("C\u00f3digo:"), c);
        ++c.gridx;
        this.textCodigo.setPreferredSize(new Dimension(70, 20));
        this.textCodigo.setMinimumSize(this.textCodigo.getPreferredSize());
        this.textCodigo.setName("textCodigo");
        this.painelCentral.add((Component)this.textCodigo, c);
        c.gridx = 2;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)new JPanel(), c);
        Insets insets = c.insets;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridx = 4;
        c.gridy = 0;
        this.painelCentral.add((Component)new JLabel("Mnem\u00f4nico:"), c);
        ++c.gridx;
        c.insets = new Insets(insets.top, insets.left, insets.bottom, 2);
        this.textMnemonico.setPreferredSize(new Dimension(70, 20));
        this.textMnemonico.setMinimumSize(new Dimension(70, 20));
        this.painelCentral.add((Component)this.textMnemonico, c);
        this.textMnemonico.setName("textMnemonico");
        c.gridx = 0;
        ++c.gridy;
        this.painelCentral.add((Component)new JLabel("Descri\u00e7\u00e3o:"), c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 5;
        c.insets = ioriginal;
        this.textDescricao.setPreferredSize(new Dimension(400, 50));
        this.painelCentral.add((Component)this.textDescricao, c);
        c.gridx = 1;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.painelCentral.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, this.panelEdicao), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 6;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.controlaCampos();
        this.textCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Historico.this.textCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Historico.this.textCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder bui = new StringBuilder("select his_codigo, his_descricao, his_mnemonico from historicos where fil_codigo = ");
                            bui.append(Variaveis.filialPadrao);
                            bui.append(" and his_codigo = ");
                            bui.append(Historico.this.textCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, bui.toString());
                            if (rs.next()) {
                                Historico.this.textDescricao.setText(rs.getString("his_descricao").replaceAll("&gt;", ">").replaceAll("&lt;", "<"));
                                Historico.this.textMnemonico.setText(rs.getString("his_mnemonico"));
                                Historico.this.textCodigo.setEnabled(false);
                                Historico.this.textMnemonico.grabFocus();
                            } else {
                                Funcoes.mensagem(Historico.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Historico.this.setStatus(1);
                                Historico.this.controlaCampos();
                            }
                            st.close();
                        }
                    }
                    catch (Exception sqlex) {
                        ErrorLogger.mostraMensagem(Historico.this, sqlex.getMessage(), sqlex.getStackTrace(), "Historico");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Historico.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900701"));
        this.setModuloEdita(Long.parseLong("0101900702"));
        this.setModuloApaga(Long.parseLong("0101900703"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.historico(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (resultado != null) {
            this.textCodigo.setText(resultado.get("his_codigo").toString());
        }
        this.textCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.textCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("historicos", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("his_codigo", 2, false, true, this.textCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaHistorico());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Historico");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.textMnemonico.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.textCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "historicos", true);
                }
                SalvaDados salvar = new SalvaDados("historicos", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("his_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("his_descricao", 0, true, false, StringUtil.textoDBEscape(Historico.descricao2Texto(this.textDescricao)));
                salvar.adicionaCampo("his_mnemonico", 0, true, false, StringUtil.textoDBEscape(this.textMnemonico.getText()));
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaHistorico(), "historicos", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Historico");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.textCodigo.setEnabled(this.getStatus() == 3);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textMnemonico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        if (this.getStatus() == 3 || this.getStatus() == 2) {
            this.panelEdicao.habilitar();
        } else {
            this.panelEdicao.desabilitar();
        }
    }

    private void limparCampos() {
        this.textCodigo.setText("");
        this.textMnemonico.clear();
        this.textDescricao.setText("");
        this.textDescricao.setEditorKit(new EditorKitNoWrap());
        DocumentoStyledHistorico style = new DocumentoStyledHistorico(this.textDescricao);
        style.setMaxLength(this.maxLength);
        this.textDescricao.setDocument(style);
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.textCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.textCodigo.grabFocus();
                return false;
            }
            if (this.textCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.textCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.textCodigo.selectAll();
                this.textCodigo.grabFocus();
                return false;
            }
        }
        if (!Funcoes.textoVazio(this.textMnemonico.getText())) {
            HistoricoService service = new HistoricoService();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            boolean jaExiste = false;
            try {
                jaExiste = service.existeMnemonicoRepetido(filial, this.textCodigo.getText(), this.textMnemonico.getText());
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Historico: 391");
            }
            if (jaExiste) {
                Funcoes.mensagem(this, "O mnem\u00f4nico informado j\u00e1 existe", 1);
                this.textMnemonico.selectAll();
                this.textMnemonico.grabFocus();
                return false;
            }
        }
        if (this.textDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.textDescricao.selectAll();
            this.textDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900700");
    }

    public static String descricao2Texto(JTextPane editor) throws IOException, BadLocationException {
        StyledDocument doc = editor.getStyledDocument();
        ElementIterator it = new ElementIterator(doc.getDefaultRootElement());
        it.current();
        Element next = null;
        StringBuilder bui = new StringBuilder("");
        boolean aplicouEstilo = false;
        boolean negritoAberto = false;
        boolean italicoAberto = false;
        boolean sublinhadoAberto = false;
        boolean subAberto = false;
        boolean supAberto = false;
        while ((next = it.next()) != null) {
            String tmp = doc.getText(next.getStartOffset(), next.getEndOffset() - next.getStartOffset()).replaceAll(">", "&gt;").replaceAll("<", "&lt;");
            if (!next.isLeaf() || tmp.equals("\n")) continue;
            AttributeSet a = next.getAttributes();
            if (StyleConstants.isBold(a) && !negritoAberto) {
                bui.append("<b>");
                negritoAberto = true;
                aplicouEstilo = true;
            } else if (!StyleConstants.isBold(a) && negritoAberto) {
                bui.append("</b>");
                negritoAberto = false;
            }
            if (StyleConstants.isItalic(a) && !italicoAberto) {
                bui.append("<i>");
                italicoAberto = true;
                aplicouEstilo = true;
            } else if (!StyleConstants.isItalic(a) && italicoAberto) {
                bui.append("</i>");
                italicoAberto = false;
            }
            if (StyleConstants.isUnderline(a) && !sublinhadoAberto) {
                bui.append("<u>");
                aplicouEstilo = true;
                sublinhadoAberto = true;
            } else if (!StyleConstants.isUnderline(a) && sublinhadoAberto) {
                sublinhadoAberto = false;
                bui.append("</u>");
            }
            if (StyleConstants.isSubscript(a) && !subAberto) {
                bui.append("<sub>");
                aplicouEstilo = true;
                subAberto = true;
            } else if (!StyleConstants.isSubscript(a) && subAberto) {
                subAberto = false;
                bui.append("</sub>");
            }
            if (StyleConstants.isSuperscript(a) && !supAberto) {
                bui.append("<sup>");
                aplicouEstilo = true;
                supAberto = true;
            } else if (!StyleConstants.isSuperscript(a) && supAberto) {
                supAberto = false;
                bui.append("</sup>");
            }
            bui.append(tmp.replace("\n", ""));
        }
        if (aplicouEstilo) {
            if (supAberto) {
                bui.append("</sup>");
                supAberto = false;
            }
            if (subAberto) {
                bui.append("</sub>");
                subAberto = false;
            }
            if (sublinhadoAberto) {
                bui.append("</u>");
                sublinhadoAberto = false;
            }
            if (italicoAberto) {
                bui.append("</i>");
                italicoAberto = false;
            }
            if (negritoAberto) {
                bui.append("</b>");
                negritoAberto = false;
            }
            bui.insert(0, "<html>");
            bui.append("</html>");
        }
        return bui.toString();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "his_codigo";
    }
}

