/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;

public class Grupo
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private String retornoParaPesquisa = "";

    public Grupo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Grupo");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodigo.setUpperCase(true);
    }

    public void jbInit() throws Exception {
        this.setName("Grupo");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.setLabelDescricao("Cadastro de grupos para agrupamento de exames");
        this.setLabelFormulario("Cadastro de grupos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_sus.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Grupo.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select grp_codigo, grp_descricao from grupo where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(grp_codigo)=upper(");
                            buf.append(Grupo.this.txtCodigo.getTextDBEscape());
                            buf.append(") ");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                Grupo.this.txtDescricao.setText(rs.getString("grp_descricao"));
                                if (Grupo.this.getStatus() == 2) {
                                    Grupo.this.setStatus(3);
                                }
                                Grupo.this.txtCodigo.setEnabled(false);
                            } else if (Grupo.this.getStatus() == 3) {
                                Funcoes.mensagem(Grupo.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Grupo.this.setStatus(1);
                                Grupo.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Grupo.this, sqlex.getMessage(), sqlex.getStackTrace(), "Grupo");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Grupo.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101900801"));
        this.setModuloEdita(Long.parseLong("0101900802"));
        this.setModuloApaga(Long.parseLong("0101900803"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.grupo(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("grp_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("grupo", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("grp_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaGrupo());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Grupo");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getTextDBEscape();
                SalvaDados salvar = new SalvaDados("grupo", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("grp_codigo", 0, false, true, codigo);
                salvar.adicionaCampo("grp_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaGrupo());
                this.retornoParaPesquisa = this.txtCodigo.getText();
                Conexao.arquivaSQL();
            }
            catch (SQLException exsql) {
                try {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao efetuar a opera\u00e7\u00e3o no banco de dados\n" + exsql.getMessage(), 1);
                    ErrorLogger.mostraMensagem(this, exsql.getMessage(), exsql.getStackTrace(), "Grupo");
                }
                catch (Exception ex) {
                    Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Grupo");
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select grp_codigo from grupo where fil_codigo = " + Variaveis.filialPadrao + " and upper(grp_codigo)=upper(" + this.txtCodigo.getTextDBEscape() + ")");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Grupo j\u00e1 cadastrado", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() != 0) return true;
        Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
        this.txtDescricao.selectAll();
        this.txtDescricao.grabFocus();
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101900800");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "grp_codigo";
    }
}

