/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.GeladeiraBean;
import jalis.model.bean.cadastro.triagem.GeladeiraPrateleiraBean;
import jalis.model.dao.cadastro.triagem.GeladeiraDao;
import jalis.model.dao.cadastro.triagem.GeladeiraPrateleiraDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.cadastro.triagem.GeladeiraService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Geladeira
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelSetor = new JLabel("Setor:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textCodigoSetor = new TTextField(5, 1);
    private TTextField textDescricaoSetor = new TTextField();
    private JCheckBox checkInativa = new JCheckBox("Inativa");
    private JButton buttonBuscaSetor = new JButton();
    private JPanel panelPrateleiras = new JPanel(new GridBagLayout());
    private DefaultTableModel modelPrateleiras;
    private JTable tablePrateleiras;
    private JScrollPane scrollPrateleiras;
    private JLabel labelPrateleira = new JLabel("Prateleira");
    private TTextField textPrateleira = new TTextField(5, 3);
    private JButton buttonAdicionarPrateleira = new JButton("OK");
    private SetorService setorService = new SetorService();
    private ArrayList<GeladeiraPrateleiraBean> prateleiras;
    GeladeiraBean beanDelete = null;
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Geladeira.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0102000101"));
        this.setModuloEdita(Long.parseLong("0102000102"));
        this.setModuloApaga(Long.parseLong("0102000103"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0102000100");
    }

    public Geladeira() {
        this.setName("Geladeira");
        this.setLabelDescricao("Cadastro de Geladeiras");
        this.setLabelFormulario("Cadastro de geladeiras");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/geladeira.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        d = new Dimension(350, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        d = new Dimension(60, 20);
        this.textCodigoSetor.setSize(d);
        this.textCodigoSetor.setName("textCodigoSetor");
        this.textCodigoSetor.setPreferredSize(d);
        this.textCodigoSetor.setMinimumSize(d);
        this.textCodigoSetor.setMaximumSize(d);
        this.textCodigoSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Geladeira.this.buscaSetor(Geladeira.this.textCodigoSetor.getText());
            }
        });
        this.buttonBuscaSetor.setFocusable(false);
        this.buttonBuscaSetor.setName("buttonBuscaSetor");
        this.buttonBuscaSetor.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaSetor.setSize(d);
        this.buttonBuscaSetor.setPreferredSize(d);
        this.buttonBuscaSetor.setMinimumSize(d);
        this.buttonBuscaSetor.setMaximumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaSetor);
        this.buttonBuscaSetor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geladeira.this.buscaSetor();
            }
        });
        d = new Dimension(200, 20);
        this.textDescricaoSetor.setSize(d);
        this.textDescricaoSetor.setName("textDescricaoSetor");
        this.textDescricaoSetor.setPreferredSize(d);
        this.textDescricaoSetor.setMinimumSize(d);
        this.textDescricaoSetor.setMaximumSize(d);
        this.textDescricaoSetor.setEditable(false);
        this.textDescricaoSetor.setFocusable(false);
        d = new Dimension(95, 20);
        this.textPrateleira.setSize(d);
        this.textPrateleira.setName("textPrateleira");
        this.textPrateleira.setPreferredSize(d);
        this.textPrateleira.setMinimumSize(d);
        this.textPrateleira.setMaximumSize(d);
        d = new Dimension(30, 20);
        this.buttonAdicionarPrateleira.setSize(d);
        this.buttonAdicionarPrateleira.setName("buttonAdicionarPrateleira");
        this.buttonAdicionarPrateleira.setPreferredSize(d);
        this.buttonAdicionarPrateleira.setMinimumSize(d);
        this.buttonAdicionarPrateleira.setMaximumSize(d);
        this.buttonAdicionarPrateleira.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarPrateleira.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Geladeira.this.adicionarPrateleira();
            }
        });
        this.panelPrateleiras.setBorder(new TitledBorder("Prateleiras da geladeira"));
        d = new Dimension(200, 250);
        this.panelPrateleiras.setSize(d);
        this.panelPrateleiras.setPreferredSize(d);
        this.panelPrateleiras.setMaximumSize(d);
        this.panelPrateleiras.setMinimumSize(d);
        this.modelPrateleiras = new DefaultTableModel(new Object[0][], new String[]{"Prateleiras"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tablePrateleiras = new JTable(this.modelPrateleiras);
        this.tablePrateleiras.setName("tablePrateleiras");
        TableRowSorter<TableModel> sorterPrateleiras = new TableRowSorter<TableModel>(this.tablePrateleiras.getModel());
        this.tablePrateleiras.setRowSorter(sorterPrateleiras);
        this.tablePrateleiras.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Geladeira.this.removerPrateleira();
                }
            }
        });
        this.scrollPrateleiras = new JScrollPane(this.tablePrateleiras);
        d = new Dimension(100, 150);
        this.scrollPrateleiras.setSize(d);
        this.scrollPrateleiras.setPreferredSize(d);
        this.scrollPrateleiras.setMaximumSize(d);
        this.scrollPrateleiras.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelSetor, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoSetor, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaSetor, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricaoSetor, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.checkInativa, c);
        this.checkInativa.setName("checkInativa");
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 4;
        this.painelCentral.add((Component)this.panelPrateleiras, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        this.panelPrateleiras.add((Component)this.labelPrateleira, c);
        ++c.gridy;
        this.panelPrateleiras.add((Component)this.textPrateleira, c);
        ++c.gridx;
        this.panelPrateleiras.add((Component)this.buttonAdicionarPrateleira, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPrateleiras.add((Component)this.scrollPrateleiras, c);
        this.service = new GeladeiraService();
        this.tablePrateleiras.getRowSorter().toggleSortOrder(0);
        this.controlaCampos();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void buscaSetor(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoSetor.setText("");
            this.textDescricaoSetor.setText("");
            return;
        }
        try {
            AbstractThreadVO setor = this.setorService.getVO(Variaveis.filialPadrao, codigo);
            if (setor != null) {
                this.textDescricaoSetor.setText(((SetorVO)setor).getDescricao());
            } else {
                this.textDescricaoSetor.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Geladeira:252");
        }
    }

    private void buscaSetor() {
        try {
            this.textCodigoSetor.setText("");
            this.textDescricaoSetor.setText("");
            AbstractThreadVO bean = this.setorService.pesquisaVO(this.getTopLevelAncestor(), new SetorVO(), "Pesquisando setores", false);
            if (bean != null) {
                SetorVO setVO = (SetorVO)bean;
                this.textCodigoSetor.setText(Integer.toString(setVO.getCodigo()));
                this.textDescricaoSetor.setText(setVO.getDescricao());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Geladeira:268");
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoSetor.hasFocus()) {
            this.buscaSetor();
        }
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoSetor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textDescricaoSetor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaSetor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonAdicionarPrateleira.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textPrateleira.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textCodigoSetor.setText("");
        this.textDescricaoSetor.setText("");
        this.checkInativa.setSelected(false);
        this.textPrateleira.setText("");
        this.limparPrateleiras();
        this.prateleiras = new ArrayList();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new GeladeiraVO(), "Pesquisando geladeiras", false);
            if (vo != null) {
                GeladeiraBean gelBean = (GeladeiraBean)this.service.voToBean((GeladeiraVO)vo, GeladeiraBean.class);
                return gelBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Geladeira:216");
        }
        return null;
    }

    private void limparPrateleiras() {
        while (this.modelPrateleiras.getRowCount() > 0) {
            this.modelPrateleiras.removeRow(0);
        }
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        GeladeiraBean bean = new GeladeiraBean();
        FilialVO filial = new FilialVO();
        SetorVO setor = new SetorVO();
        if (this.getStatus() == 2) {
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            bean.setUsuario(usuario);
        } else {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setDescricao(this.textDescricao.getText());
        bean.setInativa(this.checkInativa.isSelected());
        bean.setFilial(filial);
        setor.setFilial(filial);
        setor.setCodigo(Integer.parseInt(this.textCodigoSetor.getText()));
        bean.setSetor(setor);
        bean.setPrateleiras(this.prateleiras);
        return bean;
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textCodigoSetor.getText()) || this.textDescricaoSetor.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Setor n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSetor);
            return false;
        }
        if (this.modelPrateleiras.getRowCount() == 0) {
            Funcoes.mensagem(this, "N\u00e3o existem prateleiras cadastradas.", 2);
            ScreenUtil.requisitarFoco(this.textPrateleira);
            return false;
        }
        try {
            if (!Funcoes.textoVazio(this.textCodigo.getText()) && this.checkInativa.isSelected() && !new GeladeiraDao().podeDesativarRemoverGeladeira(Variaveis.filialPadrao, this.textCodigo.getText())) {
                Funcoes.mensagem(this, "A geladeira n\u00e3o pode ser inativada.\nH\u00e1 estantes/pacotes com tubos na mesma.", 2);
                return false;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se a geladeira pode ser inativada.", e.getStackTrace());
            return false;
        }
        try {
            for (int i = 0; i < this.prateleiras.size(); ++i) {
                GeladeiraPrateleiraBean prat = this.prateleiras.get(i);
                if (!prat.isRemover() || prat.isInserir() || new GeladeiraPrateleiraDao().podeRemoverPrateleira(prat.getFilial().getCodigo().toString(), prat.getGeladeira().getCodigo().toString(), prat.getCodigo().toString())) continue;
                Funcoes.mensagem(this, "A prateleira \"" + prat.getCodigo() + "\" n\u00e3o pode ser exclu\u00edda.\nH\u00e1 estantes/pacotes com tubos na mesma.", 2);
                return false;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se as prateleiras podem ser exclu\u00eddas.", e.getStackTrace());
            return false;
        }
        return !Funcoes.textoVazio(this.textDescricao.getText()) && this.modelPrateleiras.getRowCount() > 0;
    }

    public void adicionarPrateleira() {
        if (this.prateleiras == null) {
            this.prateleiras = new ArrayList();
        }
        GeladeiraPrateleiraBean prateleira = null;
        if (!Funcoes.textoVazio(this.textPrateleira.getText())) {
            for (GeladeiraPrateleiraBean gpb : this.prateleiras) {
                if (!gpb.getCodigo().equalsIgnoreCase(this.textPrateleira.getText())) continue;
                if (!gpb.isRemover()) {
                    Funcoes.mensagem(this, "Prateleira j\u00e1 cadastrada", 2);
                    return;
                }
                prateleira = gpb;
                prateleira.setRemover(false);
            }
            if (prateleira == null) {
                prateleira = new GeladeiraPrateleiraBean();
                prateleira.setCodigo(this.textPrateleira.getText());
                prateleira.setInserir(true);
                this.prateleiras.add(prateleira);
            }
            this.limparPrateleiras();
            this.popularPrateleiras();
        }
        this.textPrateleira.setText("");
        ScreenUtil.requisitarFoco(this.textPrateleira);
    }

    public void removerPrateleira() {
        if (this.tablePrateleiras.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tablePrateleiras.getRowSorter().convertRowIndexToModel(this.tablePrateleiras.getSelectedRow());
            String prat = (String)this.modelPrateleiras.getValueAt(row, 0);
            for (GeladeiraPrateleiraBean gpb : this.prateleiras) {
                if (!prat.equalsIgnoreCase(gpb.getCodigo())) continue;
                gpb.setRemover(true);
                this.limparPrateleiras();
                this.popularPrateleiras();
            }
        }
    }

    @Override
    public void salvar() {
        GeladeiraBean bean;
        GeladeiraService service = new GeladeiraService();
        if (this.validaCampos() && (bean = (GeladeiraBean)this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar geladeira.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void excluir() {
        this.beanDelete = (GeladeiraBean)this.pesquisar();
        if (this.beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Geladeira.this.preencherCampos(Geladeira.this.beanDelete);
                    if (Funcoes.mensagem(Geladeira.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            new GeladeiraService().gravaAutoCopiaSemCommit(Geladeira.this.beanDelete, 2, Variaveis.filialPadrao, Geladeira.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel excluir geladeira.\n" + e.getMessage(), 2);
                        }
                    }
                    Geladeira.this.limparCampos();
                    Geladeira.this.beanDelete = null;
                }
            });
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        GeladeiraBean gelBean = (GeladeiraBean)bean;
        this.textCodigo.setText(Integer.toString(gelBean.getCodigo()));
        this.textDescricao.setText(gelBean.getDescricao());
        this.textCodigoSetor.setText(Integer.toString(gelBean.getSetor().getCodigo()));
        this.textDescricaoSetor.setText(gelBean.getSetor().getDescricao());
        this.checkInativa.setSelected(gelBean.getInativa());
        this.limparPrateleiras();
        this.prateleiras = new ArrayList<GeladeiraPrateleiraBean>(gelBean.getPrateleiras());
        this.popularPrateleiras();
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getCopiaFiliais() {
        return ParametrosGerais.getCopiaGeladeira();
    }

    private void popularPrateleiras() {
        for (GeladeiraPrateleiraBean gpb : this.prateleiras) {
            if (gpb.isRemover()) continue;
            this.modelPrateleiras.addRow(new Object[]{gpb.getCodigo()});
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "gel_codigo";
    }
}

