/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoBean;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoParcelaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class FormaPagamento
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(40, 3);
    private JPanel panelParcelas = new JPanel(new GridBagLayout());
    private DefaultTableModel modelParcelas;
    private JTable tableParcelas;
    private JScrollPane scrollParcelas;
    private JLabel labelIntervalo = new JLabel("Intervalo (dias):");
    private TTextField textIntervalo = new TTextField(5, 1);
    private JButton buttonAdicionarParcela = new JButton("Adicionar");
    private JButton buttonParaBaixo = new JButton("\u25bc");
    private JButton buttonParaCima = new JButton("\u25b2");
    private JPanel panelBaixoCima = new JPanel(new GridBagLayout());
    private ArrayList<FormaPagamentoParcelaBean> parcelas;
    private final int COLUNA_INTERVALO = 1;
    private String retornoParaPesquisa = "";

    public FormaPagamento() {
        this.setName("FormaPagamento");
        this.setLabelDescricao("Cadastro de formas de pagamento");
        this.setLabelFormulario("Cadastro de formas de pagamento para parcelamento");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/forma_pgto.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setName("textCodigo");
        this.textIntervalo.setPreferredSize(d);
        this.textIntervalo.setName("textIntervalo");
        this.textIntervalo.setMinimumSize(d);
        d = new Dimension(350, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setMinimumSize(d);
        this.buttonParaBaixo.setName("buttonParaBaixo");
        this.buttonParaBaixo.setMargin(new Insets(0, 0, 0, 0));
        d = new Dimension(30, 20);
        this.buttonParaBaixo.setPreferredSize(d);
        this.buttonParaBaixo.setMinimumSize(d);
        this.buttonParaBaixo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = FormaPagamento.this.tableParcelas.getSelectedRow();
                if (row > -1) {
                    row = FormaPagamento.this.tableParcelas.getRowSorter().convertRowIndexToModel(row);
                    FormaPagamentoParcelaBean bean = (FormaPagamentoParcelaBean)FormaPagamento.this.modelParcelas.getValueAt(row, FormaPagamento.this.modelParcelas.findColumn("Objeto"));
                    FormaPagamento.this.moverParcelaBaixo(bean);
                }
            }
        });
        this.buttonParaCima.setName("buttonParaCima");
        this.buttonParaCima.setMargin(new Insets(0, 0, 0, 0));
        this.buttonParaCima.setPreferredSize(d);
        this.buttonParaCima.setMinimumSize(d);
        this.buttonParaCima.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = FormaPagamento.this.tableParcelas.getSelectedRow();
                if (row > -1) {
                    row = FormaPagamento.this.tableParcelas.getRowSorter().convertRowIndexToModel(row);
                    FormaPagamentoParcelaBean bean = (FormaPagamentoParcelaBean)FormaPagamento.this.modelParcelas.getValueAt(row, FormaPagamento.this.modelParcelas.findColumn("Objeto"));
                    FormaPagamento.this.moverParcelaCima(bean);
                }
            }
        });
        this.buttonAdicionarParcela.setName("buttonAdicionarParcela");
        d = new Dimension(90, 20);
        this.buttonAdicionarParcela.setPreferredSize(d);
        this.buttonAdicionarParcela.setMinimumSize(d);
        this.buttonAdicionarParcela.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarParcela.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FormaPagamento.this.adicionarParcela();
            }
        });
        this.panelParcelas.setBorder(new TitledBorder("Parcelas"));
        d = new Dimension(165, 250);
        this.panelParcelas.setPreferredSize(d);
        this.panelParcelas.setMinimumSize(d);
        this.modelParcelas = new DefaultTableModel(new Object[0][], new String[]{"Parcela", "Intervalo", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tableParcelas = new JTable(this.modelParcelas);
        this.tableParcelas.setName("tableParcelas");
        TableRowSorter<TableModel> sorterPrateleiras = new TableRowSorter<TableModel>(this.tableParcelas.getModel());
        this.tableParcelas.setRowSorter(sorterPrateleiras);
        this.tableParcelas.removeColumn(this.tableParcelas.getColumnModel().getColumn(this.tableParcelas.getColumnCount() - 1));
        this.tableParcelas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    FormaPagamento.this.removerParcela();
                }
            }
        });
        this.scrollParcelas = new JScrollPane(this.tableParcelas);
        d = new Dimension(165, 150);
        this.scrollParcelas.setPreferredSize(d);
        this.scrollParcelas.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 4;
        this.painelCentral.add((Component)this.textDescricao, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JPanel aux1 = new JPanel();
        d = new Dimension(10, 10);
        aux1.setPreferredSize(d);
        aux1.setMinimumSize(d);
        this.painelCentral.add((Component)aux1, c);
        c.gridx = 0;
        ++c.gridy;
        this.painelCentral.add((Component)this.labelIntervalo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textIntervalo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonAdicionarParcela, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        c.gridheight = 4;
        this.painelCentral.add((Component)this.panelParcelas, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.gridheight = 1;
        JPanel aux2 = new JPanel();
        aux2.setPreferredSize(d);
        aux2.setMinimumSize(d);
        this.painelCentral.add((Component)aux2, c);
        ++c.gridx;
        c.gridheight = 4;
        this.painelCentral.add((Component)this.panelBaixoCima, c);
        c.gridy = 8;
        c.gridx = 5;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelParcelas.add((Component)this.scrollParcelas, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 17;
        this.panelBaixoCima.add((Component)new JLabel(), c);
        ++c.gridy;
        c.weighty = 0.0;
        this.panelBaixoCima.add((Component)this.buttonParaCima, c);
        ++c.gridy;
        this.panelBaixoCima.add((Component)this.buttonParaBaixo, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.panelBaixoCima.add((Component)new JLabel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new FormaPagamentoService();
        this.tableParcelas.getRowSorter().toggleSortOrder(0);
        this.tableParcelas.setName("tableParcelas");
        this.controlaCampos();
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                for (int i = 0; i < this.parcelas.size(); ++i) {
                    this.parcelas.get(i).setInserir(true);
                }
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((FormaPagamentoBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    public void moverParcelaCima(FormaPagamentoParcelaBean bean) {
        FormaPagamentoParcelaBean beanAux = null;
        if (this.getRowParcela(bean) == 0) {
            return;
        }
        for (int i = 0; i < this.parcelas.size(); ++i) {
            beanAux = this.parcelas.get(i);
            if (beanAux.getParcela() != bean.getParcela() - 1) continue;
            beanAux.setParcela(beanAux.getParcela() + 1);
            break;
        }
        bean.setParcela(bean.getParcela() - 1);
        this.limparParcelas();
        this.popularParcelas();
        int linha = this.getRowParcela(bean);
        if (linha != -1) {
            this.tableParcelas.setRowSelectionInterval(linha, linha);
        }
    }

    public void moverParcelasCima(FormaPagamentoParcelaBean bean) {
        FormaPagamentoParcelaBean beanAux = null;
        if (this.getRowParcela(bean) == 1) {
            return;
        }
        for (int i = 0; i < this.parcelas.size(); ++i) {
            beanAux = this.parcelas.get(i);
            if (beanAux.getParcela() <= bean.getParcela()) continue;
            beanAux.setParcela(beanAux.getParcela() - 1);
        }
    }

    public void moverParcelaBaixo(FormaPagamentoParcelaBean bean) {
        FormaPagamentoParcelaBean beanAux = null;
        if (this.getRowParcela(bean) == this.tableParcelas.getRowCount() - 1) {
            return;
        }
        for (int i = 0; i < this.parcelas.size(); ++i) {
            beanAux = this.parcelas.get(i);
            if (beanAux.getParcela() != bean.getParcela() + 1) continue;
            beanAux.setParcela(beanAux.getParcela() - 1);
            break;
        }
        bean.setParcela(bean.getParcela() + 1);
        this.limparParcelas();
        this.popularParcelas();
        int linha = this.getRowParcela(bean);
        if (linha != -1) {
            this.tableParcelas.setRowSelectionInterval(linha, linha);
        }
    }

    private int getRowParcela(FormaPagamentoParcelaBean bean) {
        for (int i = 0; i < this.tableParcelas.getRowCount(); ++i) {
            int row = this.tableParcelas.getRowSorter().convertRowIndexToModel(i);
            FormaPagamentoParcelaBean aux = (FormaPagamentoParcelaBean)this.modelParcelas.getValueAt(row, this.modelParcelas.findColumn("Objeto"));
            if (bean != aux) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(FormaPagamento.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300201"));
        this.setModuloEdita(Long.parseLong("0600300202"));
        this.setModuloApaga(Long.parseLong("0600300203"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300200");
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textIntervalo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonAdicionarParcela.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        FormaPagamentoBean bean = new FormaPagamentoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setParcelas(new HashSet<FormaPagamentoParcelaBean>(this.parcelas));
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaFormaPagamento();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textIntervalo.setText("");
        this.limparParcelas();
        this.parcelas = new ArrayList();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new FormaPagamentoVO(), "Pesquisando formas de pagamento", false);
            if (vo != null) {
                FormaPagamentoBean formaBean = (FormaPagamentoBean)this.service.voToBean((FormaPagamentoVO)vo, FormaPagamentoBean.class);
                return formaBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FormaPagamento:283");
        }
        return null;
    }

    private void limparParcelas() {
        while (this.modelParcelas.getRowCount() > 0) {
            this.modelParcelas.removeRow(0);
        }
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        FormaPagamentoBean formaBean = (FormaPagamentoBean)bean;
        this.textCodigo.setText(Integer.toString(formaBean.getCodigo()));
        this.textDescricao.setText(formaBean.getDescricao());
        this.limparParcelas();
        this.parcelas = new ArrayList(formaBean.getParcelas());
        this.popularParcelas();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "A descri\u00e7\u00e3o deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (this.modelParcelas.getRowCount() > 0) {
            return true;
        }
        Funcoes.mensagem(this, "O parcelamento n\u00e3o foi definido para a forma de pagamento.", 2);
        ScreenUtil.requisitarFoco(this.textIntervalo);
        return false;
    }

    private void adicionarParcela() {
        if (this.parcelas == null) {
            this.parcelas = new ArrayList();
        }
        FormaPagamentoParcelaBean parcela = null;
        if (!Funcoes.textoVazio(this.textIntervalo.getText())) {
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            if (parcela == null) {
                parcela = new FormaPagamentoParcelaBean();
                parcela.setFilialVO(filial);
                parcela.setParcela(this.getNumeroProximaParcela());
                parcela.setIntervalo(Integer.parseInt(this.textIntervalo.getText()));
                parcela.setInserir(true);
                this.parcelas.add(parcela);
            }
            this.limparParcelas();
            this.popularParcelas();
        }
        this.textIntervalo.setText("");
        ScreenUtil.requisitarFoco(this.textIntervalo);
    }

    private int getNumeroProximaParcela() {
        int parcela = 0;
        for (int i = 0; i < this.parcelas.size(); ++i) {
            if (this.parcelas.get(i).getParcela() <= parcela) continue;
            parcela = this.parcelas.get(i).getParcela();
        }
        return parcela + 1;
    }

    private void removerParcela() {
        if (this.tableParcelas.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int rowTable = this.tableParcelas.getSelectedRow();
            int row = this.tableParcelas.getRowSorter().convertRowIndexToModel(rowTable);
            FormaPagamentoParcelaBean parcela = (FormaPagamentoParcelaBean)this.modelParcelas.getValueAt(row, this.modelParcelas.findColumn("Objeto"));
            this.parcelas.remove(parcela);
            this.moverParcelasCima(parcela);
            this.limparParcelas();
            this.popularParcelas();
        }
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void popularParcelas() {
        for (FormaPagamentoParcelaBean parcela : this.parcelas) {
            if (parcela.isRemover()) continue;
            this.modelParcelas.addRow(new Object[]{(int)parcela.getParcela(), parcela.getIntervalo(), parcela});
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "fpg_codigo";
    }
}

