/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.model.bean.cadastro.material.FichaTecnicaBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.dao.cadastro.material.FichaTecnicaDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.MaterialService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class FichaTecnica
extends FrmCadPadrao {
    private JLabel labelMaterialPai = new JLabel();
    private JLabel labelDescricaoMaterialPai = new JLabel();
    private JLabel labelComposicao = new JLabel();
    private JLabel labelDescricaoComposicao = new JLabel();
    private JLabel labelQuantidade = new JLabel();
    private TTextField textMaterialPai = new TTextField(18, 3);
    private TTextField textComposicao = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(8, 2);
    private JButton buttonMaterialPai = new JButton();
    private JButton buttonOk = new JButton();
    private JButton buttonComposicao = new JButton();
    private JPanel panelComposicao = new JPanel();
    private JTable tableComposicao = null;
    private ModeloGridTable modeloComposicao = null;
    private JScrollPane scrollComposicao = null;
    private static final long ACESSO_INCLUIR = Long.parseLong("0101300601");
    private static final long ACESSO_ALTERAR = Long.parseLong("0101300602");
    private static final long ACESSO_EXCLUIR = Long.parseLong("0101300603");
    private MaterialBean materialPaiAux = null;
    private MaterialBean materialComposicao = null;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_QUANTIDADE = 2;
    private static final int COLUNA_OBJETO = 3;
    private int linhaAlterada = -1;

    public FichaTecnica() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Funcoes.criaBarraDescricao(this, "Ficha T\u00e9cnica", "Ficha T\u00e9cnica de materiais", "cadastros/cad_materiais_ficha_tecnica.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterialPai, this.labelDescricaoComposicao}, new TitledBorder(""));
        this.modeloComposicao = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o Material", "Quantidade"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }
        };
        this.tableComposicao = new JTable(this.modeloComposicao);
        this.tableComposicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int resp;
                    int row2 = ((JTable)e.getSource()).getSelectedRow();
                    if (row2 >= 0 && (resp = Funcoes.mensagem(FichaTecnica.this, "Deseja remover o material da composi\u00e7\u00e3o?", 4)) == 0) {
                        FichaTecnica.this.modeloComposicao.removeLine(row2);
                    }
                } else if (e.getKeyCode() == 32 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    FichaTecnica.this.linhaAlterada = row;
                    FichaTecnicaBean ficha = (FichaTecnicaBean)FichaTecnica.this.modeloComposicao.getValueAt(row, 3);
                    FichaTecnica.this.textComposicao.setText(ficha.getMaterialFilho().getCodigo().toString());
                    FichaTecnica.this.labelDescricaoComposicao.setText(ficha.getMaterialFilho().getDescricao());
                    FichaTecnica.this.textQuantidade.setText(Funcoes.formataDecimal(ficha.getQuantidade()));
                    ScreenUtil.requisitarFoco(FichaTecnica.this.textComposicao);
                }
            }
        });
        this.modeloComposicao.setColumnSize(new int[]{70, 0, 90}, this.tableComposicao);
        this.tableComposicao.getTableHeader().addMouseListener(this.modeloComposicao);
        this.scrollComposicao = new JScrollPane(this.tableComposicao);
        this.textMaterialPai.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    FichaTecnica.this.buttonMaterialPai.doClick();
                }
            }
        });
        this.textMaterialPai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (FichaTecnica.this.textMaterialPai.getText().isEmpty()) {
                    FichaTecnica.this.labelDescricaoMaterialPai.setText("");
                    FichaTecnica.this.materialPaiAux = null;
                    return;
                }
                MaterialBean bean = null;
                if (Funcoes.isNumeric(FichaTecnica.this.textMaterialPai.getText())) {
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, FichaTecnica.this.textMaterialPai.getText(), null, null);
                    }
                    catch (Exception e1) {
                        FichaTecnica.this.labelDescricaoMaterialPai.setText("N\u00e3o cadastrado");
                        FichaTecnica.this.materialPaiAux = null;
                        return;
                    }
                }
                if ((bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, FichaTecnica.this.textMaterialPai)) != null) {
                    FichaTecnica.this.textMaterialPai.setText(bean.getCodigo().toString());
                    FichaTecnica.this.labelDescricaoMaterialPai.setText(bean.getDescricao());
                    FichaTecnica.this.materialPaiAux = bean;
                } else {
                    FichaTecnica.this.labelDescricaoMaterialPai.setText("N\u00e3o cadastrado");
                    FichaTecnica.this.materialPaiAux = null;
                }
            }
        });
        this.buttonMaterialPai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(FichaTecnica.this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                        return;
                    }
                    if (bean != null) {
                        FichaTecnica.this.textMaterialPai.setText(String.valueOf(bean.getCodigo()));
                        FichaTecnica.this.labelDescricaoMaterialPai.setText(bean.getDescricao());
                        FichaTecnica.this.materialPaiAux = bean;
                        if (FichaTecnica.this.textComposicao.isFocusable() && FichaTecnica.this.textComposicao.isEnabled()) {
                            FichaTecnica.this.textComposicao.grabFocus();
                        }
                    } else {
                        FichaTecnica.this.textMaterialPai.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        FichaTecnica.this.labelDescricaoMaterialPai.setText("N\u00e3o cadastrado");
                        FichaTecnica.this.materialPaiAux = null;
                    }
                }
            }
        });
        this.textComposicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    FichaTecnica.this.buttonComposicao.doClick();
                }
            }
        });
        this.textComposicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (FichaTecnica.this.textComposicao.getText().isEmpty()) {
                    FichaTecnica.this.labelDescricaoComposicao.setText("");
                    FichaTecnica.this.materialComposicao = null;
                    return;
                }
                MaterialBean bean = null;
                if (Funcoes.isNumeric(FichaTecnica.this.textComposicao.getText())) {
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, FichaTecnica.this.textComposicao.getText(), null, null);
                    }
                    catch (Exception e1) {
                        FichaTecnica.this.labelDescricaoComposicao.setText("N\u00e3o cadastrado");
                        FichaTecnica.this.materialComposicao = null;
                        return;
                    }
                }
                if ((bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, FichaTecnica.this.textComposicao)) != null) {
                    FichaTecnica.this.textComposicao.setText(bean.getCodigo().toString());
                    FichaTecnica.this.labelDescricaoComposicao.setText(bean.getDescricao());
                    FichaTecnica.this.materialComposicao = bean;
                } else {
                    FichaTecnica.this.labelDescricaoComposicao.setText("N\u00e3o cadastrado");
                    FichaTecnica.this.materialComposicao = null;
                }
            }
        });
        this.buttonComposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(FichaTecnica.this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                        return;
                    }
                    if (bean != null) {
                        FichaTecnica.this.textComposicao.setText(String.valueOf(bean.getCodigo()));
                        FichaTecnica.this.labelDescricaoComposicao.setText(bean.getDescricao());
                        FichaTecnica.this.materialComposicao = bean;
                        if (FichaTecnica.this.textQuantidade.isFocusable() && FichaTecnica.this.textQuantidade.isEnabled()) {
                            FichaTecnica.this.textQuantidade.grabFocus();
                        }
                    } else {
                        FichaTecnica.this.textComposicao.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        FichaTecnica.this.labelDescricaoComposicao.setText("N\u00e3o cadastrado");
                        FichaTecnica.this.materialComposicao = null;
                    }
                }
            }
        });
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FichaTecnica.this.textQuantidade.getText().isEmpty()) {
                    Funcoes.mensagem(FichaTecnica.this, "A quantidade n\u00e3o foi informada.", 2);
                    if (FichaTecnica.this.textQuantidade.isEnabled() && FichaTecnica.this.textQuantidade.isFocusable()) {
                        FichaTecnica.this.textQuantidade.grabFocus();
                    }
                    return;
                }
                if (Double.valueOf(FichaTecnica.this.textQuantidade.getText()) <= 0.0) {
                    Funcoes.mensagem(FichaTecnica.this, "A quantidade informada deve ser maior que zero.", 2);
                    if (FichaTecnica.this.textQuantidade.isEnabled() && FichaTecnica.this.textQuantidade.isFocusable()) {
                        FichaTecnica.this.textQuantidade.grabFocus();
                    }
                    return;
                }
                if (FichaTecnica.this.materialComposicao != null) {
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    FichaTecnicaBean ficha = new FichaTecnicaBean();
                    ficha.setFilial(filial);
                    ficha.setMaterial((MaterialVO)FichaTecnica.this.materialPaiAux.toVO());
                    ficha.setMaterialFilho((MaterialVO)FichaTecnica.this.materialComposicao.toVO());
                    ficha.setQuantidade(Double.parseDouble(FichaTecnica.this.textQuantidade.getText()));
                    FichaTecnica.this.adicionarFichaTecnica(ficha);
                }
                FichaTecnica.this.textComposicao.setText("");
                FichaTecnica.this.labelDescricaoComposicao.setText("");
                FichaTecnica.this.textQuantidade.setText("");
                FichaTecnica.this.materialComposicao = null;
                ScreenUtil.requisitarFoco(FichaTecnica.this.textComposicao);
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelMaterialPai.setText("Material Pai:");
        this.labelMaterialPai.setDisplayedMnemonic('P');
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 17;
        this.labelMaterialPai.setLabelFor(this.textMaterialPai);
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.painelCentral.add((Component)this.labelMaterialPai, gridBagConstraints);
        this.textMaterialPai.setMaximumSize(null);
        this.textMaterialPai.setMinimumSize(new Dimension(70, 20));
        this.textMaterialPai.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        ++gridBagConstraints.gridx;
        this.painelCentral.add((Component)this.textMaterialPai, gridBagConstraints);
        Funcoes.imagemPesquisa(this.buttonMaterialPai);
        this.buttonMaterialPai.setFocusable(false);
        this.buttonMaterialPai.setMaximumSize(null);
        this.buttonMaterialPai.setMinimumSize(new Dimension(20, 20));
        this.buttonMaterialPai.setPreferredSize(new Dimension(20, 20));
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.painelCentral.add((Component)this.buttonMaterialPai, gridBagConstraints);
        this.labelDescricaoMaterialPai.setMaximumSize(null);
        this.labelDescricaoMaterialPai.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterialPai.setPreferredSize(new Dimension(20, 20));
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.labelDescricaoMaterialPai, gridBagConstraints);
        this.panelComposicao.setBorder(BorderFactory.createTitledBorder("Composi\u00e7\u00e3o"));
        this.panelComposicao.setLayout(new GridBagLayout());
        this.labelComposicao.setText("Material:");
        this.labelComposicao.setDisplayedMnemonic('M');
        this.labelComposicao.setLabelFor(this.textComposicao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        this.panelComposicao.add((Component)this.labelComposicao, gridBagConstraints);
        this.textComposicao.setMaximumSize(null);
        this.textComposicao.setMinimumSize(new Dimension(70, 20));
        this.textComposicao.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panelComposicao.add((Component)this.textComposicao, gridBagConstraints);
        Funcoes.imagemPesquisa(this.buttonComposicao);
        this.buttonComposicao.setFocusable(false);
        this.buttonComposicao.setMaximumSize(null);
        this.buttonComposicao.setMinimumSize(new Dimension(20, 20));
        this.buttonComposicao.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panelComposicao.add((Component)this.buttonComposicao, gridBagConstraints);
        this.labelDescricaoComposicao.setMaximumSize(null);
        this.labelDescricaoComposicao.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoComposicao.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelComposicao.add((Component)this.labelDescricaoComposicao, gridBagConstraints);
        this.labelQuantidade.setText("Quantidade:");
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.panelComposicao.add((Component)this.labelQuantidade, gridBagConstraints);
        this.textQuantidade.setMaximumSize(null);
        this.textQuantidade.setMinimumSize(new Dimension(70, 20));
        this.textQuantidade.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.panelComposicao.add((Component)this.textQuantidade, gridBagConstraints);
        this.buttonOk.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOk.setText("OK");
        this.buttonOk.setMnemonic('O');
        this.buttonOk.setMaximumSize(null);
        this.buttonOk.setMinimumSize(new Dimension(30, 20));
        this.buttonOk.setPreferredSize(new Dimension(30, 20));
        this.panelComposicao.add((Component)this.buttonOk, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelComposicao.add((Component)this.scrollComposicao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelComposicao, gridBagConstraints);
        this.setName("FichaTecnica");
        this.tableComposicao.setName("tableComposicao");
        this.textMaterialPai.setName("textMaterialPai");
        this.textComposicao.setName("textComposicao");
        this.textQuantidade.setName("textQuantidade");
        this.buttonMaterialPai.setName("buttonMaterialPai");
        this.buttonOk.setName("buttonOk");
        this.buttonComposicao.setName("buttonComposicao");
        this.modeloComposicao.ordenarColunaSemTrocarSentido(this.modeloComposicao.findColumn("Descri\u00e7\u00e3o Material"));
        this.controlaCampos();
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textMaterialPai.setEnabled(habilitar && this.modeloComposicao.getRowCount() == 0);
        this.buttonMaterialPai.setEnabled(habilitar && this.modeloComposicao.getRowCount() == 0);
        this.textComposicao.setEnabled(habilitar);
        this.buttonComposicao.setEnabled(habilitar);
        this.textQuantidade.setEnabled(habilitar);
        this.buttonOk.setEnabled(habilitar);
        this.tableComposicao.setEnabled(habilitar);
    }

    private void limparCampos() {
        this.textMaterialPai.setText("");
        this.labelDescricaoMaterialPai.setText("");
        this.textComposicao.setText("");
        this.labelDescricaoComposicao.setText("");
        this.textQuantidade.setText("");
        this.modeloComposicao.clear();
        this.materialPaiAux = null;
    }

    @Override
    public void editar() {
        this.limparCampos();
        this.materialPaiAux = this.pesquisar();
        if (this.materialPaiAux != null) {
            this.setStatus(3);
            this.preencherCampos(this.materialPaiAux);
            this.controlaCampos();
            if (this.textMaterialPai.isFocusable() && this.textMaterialPai.isEnabled()) {
                this.textMaterialPai.grabFocus();
            }
        }
    }

    private MaterialBean pesquisar() {
        try {
            MaterialBean material;
            Hashtable resultado = Pesquisas.materialTodosComFichaTecnica(this.getTopLevelAncestor(), false);
            if (resultado != null && (material = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, resultado.get("mat_codigo").toString(), null, null)) != null) {
                return material;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material.", 2);
        }
        return null;
    }

    private void preencherCampos(MaterialBean material) {
        if (material == null) {
            return;
        }
        this.textMaterialPai.setText(String.valueOf(material.getCodigo()));
        this.labelDescricaoMaterialPai.setText(material.getDescricao());
        if (material.getMateriaisComposicao() != null) {
            ArrayList<FichaTecnicaBean> materiais = material.getMateriaisComposicao();
            for (int i = 0; i < materiais.size(); ++i) {
                this.adicionarFichaTecnica(materiais.get(i));
            }
        }
    }

    private void adicionarFichaTecnica(FichaTecnicaBean ficha) {
        if (ficha == null) {
            return;
        }
        if (ficha.getMaterialFilho().getCodigo().intValue() == this.materialPaiAux.getCodigo().intValue()) {
            Funcoes.mensagem(this, "O material pai n\u00e3o pode ser adicionado \u00e0 pr\u00f3pria composi\u00e7\u00e3o.", 2);
            if (this.textComposicao.isFocusable() && this.textComposicao.isEnabled()) {
                this.textComposicao.grabFocus();
            }
            return;
        }
        for (int i = 0; i < this.modeloComposicao.getRowCount(); ++i) {
            FichaTecnicaBean aux;
            if (i == this.linhaAlterada || (aux = (FichaTecnicaBean)this.modeloComposicao.getValueAt(i, 3)) == null || aux.getMaterialFilho().getCodigo().intValue() != ficha.getMaterialFilho().getCodigo().intValue()) continue;
            Funcoes.mensagem(this, "Material j\u00e1 inserido.", 2);
            if (this.textComposicao.isFocusable() && this.textComposicao.isEnabled()) {
                this.textComposicao.grabFocus();
            }
            return;
        }
        if (this.linhaAlterada > -1) {
            this.modeloComposicao.setValueAt(ficha.getMaterialFilho().getCodigo().toString(), this.linhaAlterada, 0);
            this.modeloComposicao.setValueAt(ficha.getMaterialFilho().getDescricao(), this.linhaAlterada, 1);
            this.modeloComposicao.setValueAt(Funcoes.formataDecimal(ficha.getQuantidade()), this.linhaAlterada, 2);
            this.modeloComposicao.setValueAt(ficha, this.linhaAlterada, 3);
        } else {
            this.modeloComposicao.addLine(new Object[]{ficha.getMaterialFilho().getCodigo(), ficha.getMaterialFilho().getDescricao(), Funcoes.formataDecimal(ficha.getQuantidade()), ficha});
        }
        if (this.modeloComposicao.getColunaOrdenacao() != -1) {
            this.modeloComposicao.ordenarColunaSemTrocarSentido(this.modeloComposicao.getColunaOrdenacao());
        } else {
            this.modeloComposicao.ordenarColunaSemTrocarSentido(1);
        }
        this.controlaCampos();
        this.linhaAlterada = -1;
    }

    @Override
    public void excluir() {
        int resp;
        MaterialBean material = this.pesquisar();
        if (material != null && (resp = Funcoes.mensagem(this, "Deseja realmente excluir a ficha t\u00e9cnica do material?", 4)) == 0) {
            try {
                new FichaTecnicaDao().removerMateriaisFilhos(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getCodigo()));
                material.setFichaTecnica(false);
                material.setMateriaisComposicao(null);
                new MaterialService().update(material, material.getCodigo(), String.valueOf(material.getFilial().getCodigo()), null);
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel excluir a ficha t\u00e9cnica do material.", 2);
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.textMaterialPai.isEnabled() && this.textMaterialPai.isFocusable()) {
            this.textMaterialPai.grabFocus();
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    private MaterialBean getBeanPreenchido() {
        if (this.materialPaiAux == null) {
            return null;
        }
        ArrayList<FichaTecnicaBean> lista = null;
        if (this.modeloComposicao.getRowCount() > 0) {
            lista = new ArrayList<FichaTecnicaBean>();
            for (int i = 0; i < this.modeloComposicao.getRowCount(); ++i) {
                lista.add((FichaTecnicaBean)this.modeloComposicao.getValueAt(i, 3));
            }
        }
        this.materialPaiAux.setMateriaisComposicao(lista);
        return this.materialPaiAux;
    }

    @Override
    public void salvar() {
        MaterialService service = new MaterialService();
        MaterialBean bean = this.getBeanPreenchido();
        if (this.validaCampos() && this.validaCampos(bean)) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a ficha t\u00e9cnica.", 2);
            }
        }
    }

    private boolean validaCampos(MaterialBean bean) {
        if (bean == null || bean.getMateriaisComposicao() == null || bean.getMateriaisComposicao().size() == 0) {
            Funcoes.mensagem(this.getTopLevelAncestor(), "Informe os materiais que comp\u00f5em o material pai.", 2);
            ScreenUtil.requisitarFoco(this.textComposicao);
            return false;
        }
        return true;
    }

    @Override
    public boolean validaCampos() {
        if (!this.validaMaterialPai()) {
            Funcoes.mensagem(this.getTopLevelAncestor(), "Informe o material pai.", 2);
            ScreenUtil.requisitarFoco(this.textMaterialPai);
            return false;
        }
        return true;
    }

    private boolean validaMaterialComposicao() {
        return this.textComposicao.getText() != null && !this.textComposicao.getText().trim().isEmpty();
    }

    private boolean validaMaterialPai() {
        return this.textMaterialPai.getText() != null && !this.textMaterialPai.getText().trim().isEmpty();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300600");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

