/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class Feriado
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtDia;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JButton jButton1;
    private JCheckBox checkFixo;
    private JCheckBox checkPermitirAgendamento = new JCheckBox("Permitir agendamento");
    private String retornoParaPesquisa = "";

    public Feriado() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Feriado");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Feriado");
        this.jLabel1 = new JLabel();
        this.txtDia = new TTextField(10, 4);
        this.txtDia.setName("txtDia");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton("");
        this.jButton1.setIcon(ImagemUtils.carregaImagemJalis("zoom.gif"));
        this.checkFixo = new JCheckBox("Fixar feriado");
        this.checkFixo.setName("checkFixo");
        this.checkFixo.setToolTipText("Define o feriado com sendo repetitivo anualmente");
        this.setLabelDescricao("Cadastro de feriados para c\u00e1lculo de prazo de entrega de exames");
        this.setLabelFormulario("Cadastro de feriados");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_feriado.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtDia);
        this.jLabel1.setText("Data:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.jButton1.setBounds(new Rectangle(173, 7, 20, 20));
        this.txtDia.setText("");
        this.txtDia.setBounds(new Rectangle(72, 7, 100, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Motivo:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('M');
        this.checkFixo.setBounds(new Rectangle(72, 49, 150, 20));
        this.checkFixo.setMnemonic('F');
        this.checkPermitirAgendamento.setBounds(new Rectangle(72, 70, 200, 20));
        this.checkPermitirAgendamento.setName("checkPermitirAgendamento");
        this.checkPermitirAgendamento.setMnemonic('P');
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtDia, null);
        this.painelCentral.add((Component)this.jButton1, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.checkFixo, null);
        this.painelCentral.add((Component)this.checkPermitirAgendamento, null);
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Feriado.this.pegaData();
            }
        });
        this.txtDia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Feriado.this.txtDia.getText().trim().length() > 0 && Funcoes.verificaData(Feriado.this.txtDia.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            String data = Feriado.this.txtDia.getText();
                            StringBuffer buf = new StringBuffer("select fer_dia from feriados where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and extract(month from fer_dia) = ");
                            buf.append(Funcoes.formataData("MM", data));
                            buf.append(" and extract(day from fer_dia) = ");
                            buf.append(Funcoes.formataData("dd", data));
                            buf.append(" and fer_fixo=true");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                data = Funcoes.formataData(Funcoes.pgDatetoDate(rs.getString("fer_dia")));
                            }
                            if ((rs = Conexao.executeQuery(st, "select fer_motivo, fer_fixo, COALESCE(fer_permitiragendamento, false) as fer_permitiragendamento from feriados where fil_codigo = " + Variaveis.filialPadrao + " and fer_dia='" + Funcoes.formataData("MM/dd/yyyy", data) + "'")).next()) {
                                Feriado.this.txtDescricao.setText(rs.getString("fer_motivo"));
                                Feriado.this.checkFixo.setSelected(rs.getBoolean("fer_fixo"));
                                Feriado.this.checkPermitirAgendamento.setSelected(rs.getBoolean("fer_permitiragendamento"));
                                Feriado.this.txtDia.setEnabled(false);
                                Feriado.this.jButton1.setEnabled(false);
                                Feriado.this.txtDescricao.grabFocus();
                                if (Feriado.this.getStatus() == 2) {
                                    Feriado.this.setStatus(3);
                                }
                            } else if (Feriado.this.getStatus() == 3) {
                                Funcoes.mensagem(Feriado.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Feriado.this.setStatus(1);
                                Feriado.this.controlaCampos();
                            }
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Feriado.this, sqlex.getMessage(), sqlex.getStackTrace(), "Feriado");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Feriado.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101100001"));
        this.setModuloEdita(Long.parseLong("0101100002"));
        this.setModuloApaga(Long.parseLong("0101100003"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.feriado(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtDia.setText(Funcoes.formataData(Funcoes.stringToDate(resultado.get("fer_dia").toString())));
        }
        this.txtDia.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtDia.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null && Funcoes.verificaData(this.txtDia.getText())) {
                    SalvaDados salvar = new SalvaDados("feriados", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("fer_dia", 1, false, true, this.txtDia.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaFeriado());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Feriado");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDia.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                SalvaDados salvar = new SalvaDados("feriados", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("fer_dia", 1, false, true, this.txtDia.getText());
                salvar.adicionaCampo("fer_motivo", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("fer_fixo", 4, true, false, this.checkFixo.isSelected());
                salvar.adicionaCampo("fer_permitiragendamento", 4, true, false, this.checkPermitirAgendamento.isSelected());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaFeriado());
                Util.gravaAlteracaoFeriado(statement, this.txtDia.getText());
                this.retornoParaPesquisa = this.txtDia.getText();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Feriado");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtDia.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton1.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkFixo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkPermitirAgendamento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtDia.setText("");
        this.txtDescricao.setText("");
        this.checkFixo.setSelected(true);
        this.checkPermitirAgendamento.setSelected(false);
    }

    @Override
    public boolean validaCampos() {
        if (this.txtDia.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo data n\u00e3o informado", 1);
            this.txtDia.grabFocus();
            return false;
        }
        if (this.txtDia.getText().trim().length() > 0 && !Funcoes.verificaData(this.txtDia.getText())) {
            Funcoes.mensagem(this, "Campo data com valor incorreto", 1);
            this.txtDia.selectAll();
            this.txtDia.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDia.hasFocus()) {
            this.pegaData();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101100000");
    }

    public void pegaData() {
        Funcoes.mostraData(this.txtDia, this.jButton1, this.painelCentral, true);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "fer_dia";
    }
}

