/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.DadosExportaExames;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ExportarExames
extends JDialog
implements ActionListener {
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private JLabel labelFilial = new JLabel("Filial origem");
    private JLabel labelCodFilial = ComponenteFactory.novoJLabel("", null, BorderFactory.createTitledBorder(""));
    private JLabel labelDescFilial = ComponenteFactory.novoJLabel("", null, BorderFactory.createTitledBorder(""));
    private JLabel labelCodFilialDestino = ComponenteFactory.novoJLabel("Filial destino", null);
    private JLabel labelCodExame = ComponenteFactory.novoJLabel("Exame", null);
    private JButton buttonBuscaFilial = ComponenteFactory.novoJButton(this, null, null, true);
    private JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, null, null, true);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", '\u0000', this, null, null);
    private TTextField txtCodFilial = new TTextField(5, 1);
    private TTextField txtCodExame = new TTextField(5);
    private JLabel labelDescFilialDestino = ComponenteFactory.novoJLabel("", null, BorderFactory.createTitledBorder(""));
    private JLabel labelDescExame = ComponenteFactory.novoJLabel("", null, BorderFactory.createTitledBorder(""));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3d.Filial", "Filial", "C\u00f3d.Exame", "Exame"});
    private JTable tabela = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private boolean ok = false;
    private String codigoFilialExportacao = null;
    private final int CODIGO_FILIAL = 0;
    private final int DESCRICAO_FILIAL = 1;
    private final int CODIGO_EXAME = 2;
    private final int DESCRICAO_EXAME = 3;

    public ExportarExames(Frame owner) {
        super(owner, "Exportar exames entre filiais");
        this.montaTela();
        this.aplicaEventoFoco();
        this.aplicaKeyListener();
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setSize(600, 300);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.buttonBuscaFilial.setFocusable(false);
        this.buttonBuscaExame.setFocusable(false);
        this.txtCodExame.setUpperCase(true);
        this.modelo.setColumnSize(new int[]{70, 0, 70, 0}, this.tabela);
        this.buttonOK.setMargin(new Insets(0, 0, 0, 0));
        this.txtCodFilial.setToolTipText("C\u00f3digo da filial destino para onde os exames ser\u00e3o exportados");
        this.txtCodExame.setToolTipText("C\u00f3digo do exame na filial origem a ser exportado para a filial destino");
        this.labelCodFilial.setHorizontalAlignment(4);
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 11;
        this.panelCentro.add((Component)this.labelFilial, cons);
        cons.gridy = 1;
        cons.fill = 2;
        this.labelCodFilial.setPreferredSize(new Dimension(this.labelFilial.getPreferredSize().height, 20));
        this.labelCodFilial.setMinimumSize(new Dimension(this.labelFilial.getPreferredSize().height, 20));
        this.panelCentro.add((Component)this.labelCodFilial, cons);
        cons.gridx = 1;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.gridwidth = 6;
        this.labelDescFilial.setPreferredSize(new Dimension(70, 20));
        this.labelDescFilial.setMinimumSize(new Dimension(70, 20));
        this.panelCentro.add((Component)this.labelDescFilial, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        cons.fill = 0;
        this.panelCentro.add((Component)this.labelCodFilialDestino, cons);
        cons.gridx = 3;
        this.panelCentro.add((Component)this.labelCodExame, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        cons.fill = 2;
        this.txtCodFilial.setPreferredSize(new Dimension(this.labelCodFilialDestino.getPreferredSize().height, 20));
        this.txtCodFilial.setMinimumSize(new Dimension(this.labelCodFilialDestino.getPreferredSize().height, 20));
        this.panelCentro.add((Component)this.txtCodFilial, cons);
        cons.gridx = 1;
        cons.fill = 0;
        this.buttonBuscaFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaFilial.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonBuscaFilial, cons);
        cons.gridx = 3;
        cons.fill = 2;
        this.txtCodExame.setPreferredSize(new Dimension(70, 20));
        this.txtCodExame.setMinimumSize(new Dimension(70, 20));
        this.panelCentro.add((Component)this.txtCodExame, cons);
        cons.gridx = 4;
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExame.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonBuscaExame, cons);
        cons.gridx = 6;
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.panelCentro.add((Component)this.buttonOK, cons);
        cons.gridx = 2;
        this.labelDescFilialDestino.setMinimumSize(new Dimension(100, 20));
        cons.weightx = 1.0;
        cons.fill = 2;
        this.panelCentro.add((Component)this.labelDescFilialDestino, cons);
        cons.gridx = 5;
        this.labelDescExame.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.labelDescExame, cons);
        cons.gridx = 0;
        cons.gridy = 4;
        cons.weighty = 1.0;
        cons.gridwidth = 7;
        cons.fill = 1;
        this.panelCentro.add((Component)this.scroll, cons);
    }

    private void aplicaEventoFoco() {
        this.txtCodFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ExportarExames.this.txtCodFilial.getText()) && Funcoes.isNumeric(ExportarExames.this.txtCodFilial.getText())) {
                    try {
                        ExportarExames.this.labelDescFilialDestino.setText(DBUtil.getDescricao("select fil_descricao from filiais_postocoleta", "fil_codigo = " + ExportarExames.this.txtCodFilial.getText(), "fil_descricao"));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(ExportarExames.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
        this.txtCodExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ExportarExames.this.txtCodExame.getText())) {
                    try {
                        ExportarExames.this.labelDescExame.setText(DBUtil.getDescricao("exa_codigo", "exa_descricao", ExportarExames.this.txtCodExame.getText(), "exames", ExportarExames.this.codigoFilialExportacao));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(ExportarExames.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
    }

    private void aplicaKeyListener() {
        this.txtCodFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarExames.this.pesquisaFilialDestino();
                }
            }
        });
        this.txtCodExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ExportarExames.this.pesquisaExame();
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ExportarExames.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(ExportarExames.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ExportarExames.this.modelo.removeLine(ExportarExames.this.tabela.getSelectedRow());
                }
            }
        });
    }

    private void pesquisaFilialDestino() {
        Hashtable resultado = Pesquisas.filial(this.getParent(), false);
        if (resultado != null) {
            this.txtCodFilial.setText(resultado.get("fil_codigo").toString());
        }
        this.txtCodFilial.requestFocus();
    }

    private void pesquisaExame() {
        Hashtable resultado = Pesquisas.exame(this.getParent(), false, false, this.codigoFilialExportacao);
        if (resultado != null) {
            this.txtCodExame.setText(resultado.get("exa_codigo").toString());
        }
        this.txtCodExame.requestFocus();
    }

    private void adicionaTabela() {
        if (!Funcoes.textoVazio(this.txtCodFilial.getText()) && Funcoes.isNumeric(this.labelCodFilial.getText()) && Integer.parseInt(this.txtCodFilial.getText()) == Integer.parseInt(this.labelCodFilial.getText())) {
            Funcoes.mensagem(this, "A filial n\u00e3o pode exportar exames para ela mesma", 2);
        } else if (!(Funcoes.textoVazio(this.txtCodFilial.getText()) || Funcoes.textoVazio(this.txtCodExame.getText()) || this.labelDescFilialDestino.getText().equals("N\u00e3o cadastrado") || this.labelDescExame.getText().equals("N\u00e3o cadastrado"))) {
            if (!this.localizar(this.txtCodFilial.getText(), this.txtCodExame.getText())) {
                this.modelo.addLine(new Object[]{this.txtCodFilial.getText(), this.labelDescFilialDestino.getText(), this.txtCodExame.getText(), this.labelDescExame.getText()});
            }
            this.txtCodFilial.clear();
            this.txtCodExame.clear();
            this.labelDescFilialDestino.setText("");
            this.labelDescExame.setText("");
        }
        this.txtCodFilial.grabFocus();
    }

    private boolean localizar(String codigo, String exame) {
        boolean retorno = false;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!this.modelo.getValueAt(i, 0).toString().equals(codigo) || !this.modelo.getValueAt(i, 2).toString().equals(exame)) continue;
            retorno = true;
            break;
        }
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSalvar || e.getSource() == this.buttonCancelar) {
            this.ok = e.getSource() == this.buttonSalvar;
            this.dispose();
        } else if (e.getSource() == this.buttonBuscaFilial) {
            this.pesquisaFilialDestino();
        } else if (e.getSource() == this.buttonBuscaExame) {
            this.pesquisaExame();
        } else if (e.getSource() == this.buttonOK) {
            this.adicionaTabela();
        }
    }

    public boolean ok() {
        return this.ok;
    }

    public void setFilialOrigem(String codigo, String descricao) {
        this.labelCodFilial.setText(codigo);
        this.labelDescFilial.setText(descricao);
        this.codigoFilialExportacao = !Funcoes.textoVazio(codigo) ? codigo : Variaveis.filialPadrao;
    }

    public void setDadosExportacao(ArrayList<DadosExportaExames> dados) {
        if (dados == null) {
            return;
        }
        for (DadosExportaExames d : dados) {
            this.modelo.addLine(new Object[]{String.valueOf(d.getFilialDestino()), d.getDescricaoFilial(), d.getCodigoExame(), d.getDescricaoExame()});
        }
    }

    public int getDadosExportacaoCount() {
        return this.modelo.getRowCount();
    }

    public DadosExportaExames getDadosExportacao(int i) {
        if (i > -1 && i < this.modelo.getRowCount()) {
            return new DadosExportaExames(Integer.parseInt(this.modelo.getValueAt(i, 0).toString()), this.modelo.getValueAt(i, 1).toString(), this.modelo.getValueAt(i, 2).toString(), this.modelo.getValueAt(i, 3).toString());
        }
        return null;
    }

    public void clearDados() {
        this.modelo.clear();
    }
}

