/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ExameHistorico
extends JDialog
implements DisposeListener {
    private JPanel panelCentro = new JPanel(new BorderLayout());
    private JPanel panelMovimento = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonLevaUnico = new JButton(">");
    private JButton buttonDevolveUnico = new JButton("<");
    private JButton buttonLevaTudo = new JButton(">>");
    private JButton buttonDevolveTudo = new JButton("<<");
    private JTable tableEsquerdo = new JTable();
    private JTable tableDireito = new JTable();
    private JScrollPane scrollEsquerdo = new JScrollPane(this.tableEsquerdo);
    private JScrollPane scrollDireito = new JScrollPane(this.tableDireito);
    private ModeloGridTable modeloEsquerdo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mnem\u00f4nico", "Hist\u00f3rico"});
    private ModeloGridTable modeloDireito = new ModeloGridTable(new String[]{"C\u00f3digo", "Mnem\u00f4nico", "Hist\u00f3rico"});
    private ArrayList selecao = new ArrayList();
    private boolean ok = false;

    public ExameHistorico(JFrame owner) {
        super(owner);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public ExameHistorico(JDialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setTitle("Intervalo de hist\u00f3ricos");
        this.setSize(600, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.scrollEsquerdo.setPreferredSize(new Dimension(270, 100));
        this.scrollDireito.setPreferredSize(new Dimension(270, 100));
        this.buttonLevaUnico.setBounds(5, 10, 40, 40);
        this.buttonDevolveUnico.setBounds(5, 55, 40, 40);
        this.buttonLevaTudo.setBounds(5, 100, 40, 40);
        this.buttonDevolveTudo.setBounds(5, 145, 40, 40);
        this.buttonLevaUnico.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDevolveUnico.setMargin(new Insets(2, 2, 2, 2));
        this.buttonLevaTudo.setMargin(new Insets(2, 2, 2, 2));
        this.buttonDevolveTudo.setMargin(new Insets(2, 2, 2, 2));
        this.buttonFechar.setMnemonic('F');
        this.buttonSalvar.setMnemonic('S');
        this.tableEsquerdo.setModel(this.modeloEsquerdo);
        this.tableDireito.setModel(this.modeloDireito);
        this.tableEsquerdo.getTableHeader().addMouseListener(this.modeloEsquerdo);
        this.tableDireito.getTableHeader().addMouseListener(this.modeloDireito);
        this.modeloEsquerdo.setColumnSize(new int[]{70, 70, 0}, this.tableEsquerdo);
        this.modeloDireito.setColumnSize(new int[]{70, 70, 0}, this.tableDireito);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonFechar);
        this.panelCentro.add((Component)this.scrollEsquerdo, "West");
        this.panelCentro.add((Component)this.scrollDireito, "East");
        this.panelCentro.add((Component)this.panelMovimento, "Center");
        this.panelMovimento.add(this.buttonLevaUnico);
        this.panelMovimento.add(this.buttonDevolveUnico);
        this.panelMovimento.add(this.buttonLevaTudo);
        this.panelMovimento.add(this.buttonDevolveTudo);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExameHistorico.this.selecao = null;
                ExameHistorico.this.ok = false;
                ExameHistorico.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < ExameHistorico.this.modeloDireito.getRowCount(); ++i) {
                    ExameHistorico.this.selecao.add(new Object[]{ExameHistorico.this.modeloDireito.getValueAt(i, 0), ExameHistorico.this.modeloDireito.getValueAt(i, 1), ExameHistorico.this.modeloDireito.getValueAt(i, 2)});
                }
                ExameHistorico.this.ok = true;
                ExameHistorico.this.setVisible(false);
            }
        });
        this.buttonLevaUnico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExameHistorico.this.levaUnico();
            }
        });
        this.buttonDevolveUnico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExameHistorico.this.devolveUnico();
            }
        });
        this.buttonLevaTudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExameHistorico.this.levaTudo();
            }
        });
        this.buttonDevolveTudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExameHistorico.this.devolveTudo();
            }
        });
        this.tableEsquerdo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExameHistorico.this.levaUnico();
                }
            }
        });
        this.tableEsquerdo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ExameHistorico.this.levaUnico();
                }
            }
        });
        this.tableDireito.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExameHistorico.this.devolveUnico();
                }
            }
        });
        this.tableDireito.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    ExameHistorico.this.devolveUnico();
                }
            }
        });
    }

    public boolean ok() {
        return this.ok;
    }

    private void levaUnico() {
        if (this.tableEsquerdo.getSelectedRow() > -1) {
            int i;
            int[] linha = this.tableEsquerdo.getSelectedRows();
            for (i = 0; i < linha.length; ++i) {
                this.modeloDireito.addLine(new Object[]{this.modeloEsquerdo.getValueAt(linha[i], 0), this.modeloEsquerdo.getValueAt(linha[i], 1), this.modeloEsquerdo.getValueAt(linha[i], 2)});
            }
            for (i = linha.length - 1; i >= 0; --i) {
                this.modeloEsquerdo.removeLine(linha[i]);
            }
            this.modeloDireito.ordenarColuna(0, 1);
        }
        this.tableEsquerdo.grabFocus();
    }

    private void devolveUnico() {
        if (this.tableDireito.getSelectedRow() > -1) {
            int i;
            int[] linha = this.tableDireito.getSelectedRows();
            for (i = 0; i < linha.length; ++i) {
                this.modeloEsquerdo.addLine(new Object[]{this.modeloDireito.getValueAt(linha[i], 0), this.modeloDireito.getValueAt(linha[i], 1), this.modeloDireito.getValueAt(linha[i], 2)});
            }
            for (i = linha.length - 1; i >= 0; --i) {
                this.modeloDireito.removeLine(linha[i]);
            }
            this.modeloEsquerdo.ordenarColuna(0, 1);
        }
        this.tableDireito.grabFocus();
    }

    private void levaTudo() {
        while (this.modeloEsquerdo.getRowCount() > 0) {
            this.modeloDireito.addLine(new Object[]{this.modeloEsquerdo.getValueAt(0, 0), this.modeloEsquerdo.getValueAt(0, 1), this.modeloEsquerdo.getValueAt(0, 2)});
            this.modeloEsquerdo.removeLine(0);
        }
        this.modeloDireito.ordenarColuna(0, 1);
    }

    private void devolveTudo() {
        while (this.modeloDireito.getRowCount() > 0) {
            this.modeloEsquerdo.addLine(new Object[]{this.modeloDireito.getValueAt(0, 0), this.modeloDireito.getValueAt(0, 1), this.modeloDireito.getValueAt(0, 2)});
            this.modeloDireito.removeLine(0);
        }
        this.modeloEsquerdo.ordenarColuna(0, 1);
    }

    public void setHistoricos(ArrayList historicos) {
        this.modeloEsquerdo.clear();
        for (int i = 0; i < historicos.size(); ++i) {
            if (this.modeloDireito.getRowCount() != 0 && this.modeloDireito.localizar(0, (String)((Object[])historicos.get(i))[0]) >= 0) continue;
            this.modeloEsquerdo.addLine((Object[])historicos.get(i));
        }
    }

    public void setHistoricosSelecionados(ArrayList historicos) {
        this.modeloDireito.clear();
        for (int i = 0; i < historicos.size(); ++i) {
            this.modeloDireito.addLine((Object[])historicos.get(i));
        }
        this.modeloDireito.ordenarColuna(0, 1);
    }

    public ArrayList getHistoricosSelecionados() {
        return this.selecao;
    }
}

