/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.triagem.EstanteService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Estante
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelLinhas = new JLabel("Linhas:");
    private JLabel labelColunas = new JLabel("Colunas:");
    private JLabel labelIdentificador = new JLabel("Identificador:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textLinhas = new TTextField(5, 1);
    private TTextField textColunas = new TTextField(5, 1);
    private TTextField textIdentificador = new TTextField(10, 3);
    private JCheckBox checkboxIgnorar = new JCheckBox("Ignorar linhas/colunas");
    private JCheckBox checkboxReutilizar = new JCheckBox("Reutilizar");
    private boolean podeAlterar = true;
    private EstanteBean beanDelete = null;
    AbstractThreadService service = new EstanteService();
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Estante.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0102000201"));
        this.setModuloEdita(Long.parseLong("0102000202"));
        this.setModuloApaga(Long.parseLong("0102000203"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0102000200");
    }

    public Estante() {
        this.setName("Estante");
        this.setLabelDescricao("Cadastro de estantes");
        this.setLabelFormulario("Cadastro de estantes");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/estante.jpg"));
        this.checkboxIgnorar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Estante.this.verificaIgnorar();
            }
        });
        this.checkboxIgnorar.setName("checkboxIgnorar");
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        d = new Dimension(60, 20);
        this.textLinhas.setSize(d);
        this.textLinhas.setName("textLinhas");
        this.textLinhas.setPreferredSize(d);
        this.textLinhas.setMinimumSize(d);
        this.textLinhas.setMaximumSize(d);
        d = new Dimension(60, 20);
        this.textColunas.setSize(d);
        this.textColunas.setName("textColunas");
        this.textColunas.setPreferredSize(d);
        this.textColunas.setMinimumSize(d);
        this.textColunas.setMaximumSize(d);
        d = new Dimension(100, 20);
        this.textIdentificador.setSize(d);
        this.textIdentificador.setName("textIdentificador");
        this.textIdentificador.setPreferredSize(d);
        this.textIdentificador.setMinimumSize(d);
        this.textIdentificador.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelIdentificador, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textIdentificador, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelLinhas, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textLinhas, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelColunas, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textColunas, c);
        ++c.gridy;
        this.painelCentral.add((Component)this.checkboxIgnorar, c);
        this.checkboxIgnorar.setName("checkboxIgnorar");
        ++c.gridy;
        this.painelCentral.add((Component)this.checkboxReutilizar, c);
        this.checkboxReutilizar.setName("checkboxReutilizar");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.controlaCampos();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void verificaIgnorar() {
        this.textLinhas.setEnabled(!this.checkboxIgnorar.isSelected());
        this.textColunas.setEnabled(!this.checkboxIgnorar.isSelected());
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textLinhas.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.podeAlterar);
        this.textColunas.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.podeAlterar);
        this.textIdentificador.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkboxIgnorar.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.podeAlterar);
        this.checkboxReutilizar.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        EstanteBean bean = new EstanteBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setIdentificador(this.textIdentificador.getText());
        if (this.checkboxIgnorar.isSelected()) {
            bean.setPacote(true);
        } else {
            bean.setPacote(false);
            bean.setLinhas(Integer.parseInt(this.textLinhas.getText()));
            bean.setColunas(Integer.parseInt(this.textColunas.getText()));
        }
        bean.setReutilizar(this.checkboxReutilizar.isSelected());
        return bean;
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textLinhas.setText("");
        this.textColunas.setText("");
        this.textIdentificador.setText("");
        this.checkboxIgnorar.setSelected(false);
        this.checkboxReutilizar.setSelected(false);
        this.podeAlterar = true;
        this.beanDelete = null;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new EstanteVO(), "Pesquisando estantes", false);
            if (vo != null) {
                EstanteBean estBean = (EstanteBean)this.service.voToBean((EstanteVO)vo, EstanteBean.class);
                return estBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Estante:149");
        }
        return null;
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textIdentificador.getText())) {
            Funcoes.mensagem(this, "Campo Identificador n\u00e3o preenchido!", 2);
            ScreenUtil.requisitarFoco(this.textIdentificador);
            return false;
        }
        if (!this.checkboxIgnorar.isSelected()) {
            if (Funcoes.textoVazio(this.textLinhas.getText())) {
                Funcoes.mensagem(this, "Campo Linhas n\u00e3o preenchido!", 2);
                ScreenUtil.requisitarFoco(this.textLinhas);
                return false;
            }
            if (Funcoes.textoVazio(this.textColunas.getText())) {
                Funcoes.mensagem(this, "Campo Colunas n\u00e3o preenchido!", 2);
                ScreenUtil.requisitarFoco(this.textColunas);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        EstanteBean estBean = (EstanteBean)bean;
        this.textCodigo.setText(Integer.toString(estBean.getCodigo()));
        if (estBean.isPacote().booleanValue()) {
            this.checkboxIgnorar.setSelected(true);
        } else {
            this.textLinhas.setText(Integer.toString(estBean.getLinhas()));
            this.textColunas.setText(Integer.toString(estBean.getColunas()));
        }
        this.textIdentificador.setText(estBean.getIdentificador());
        this.checkboxIgnorar.setSelected(estBean.isPacote() == null ? false : estBean.isPacote());
        this.checkboxReutilizar.setSelected(estBean.getReutilizar() == null ? false : estBean.getReutilizar());
        try {
            this.podeAlterar = ((EstanteService)this.service).podeAlterarRemoverEstante(Variaveis.filialPadrao, estBean.getCodigo().toString());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da estante.\n" + e.getMessage(), e.getStackTrace());
        }
        if (!this.podeAlterar && this.beanDelete == null) {
            Funcoes.mensagem(this, "A estante possui tubos.\nSomente o identificador da estante poder\u00e1 ser modificado.", 2);
        }
        this.verificaIgnorar();
        this.controlaCampos();
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textIdentificador);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textIdentificador);
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaEstante();
    }

    @Override
    public void excluir() {
        this.beanDelete = (EstanteBean)this.pesquisar();
        if (this.beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Estante.this.preencherCampos(Estante.this.beanDelete);
                    if (Funcoes.mensagem(Estante.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            Estante.this.service.gravaAutoCopiaSemCommit(Estante.this.beanDelete, 2, Variaveis.filialPadrao, Estante.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Funcoes.mensagem(Laboratorio.getInstancia(), e.getMessage(), 2);
                        }
                    }
                    Estante.this.limparCampos();
                    Estante.this.beanDelete = null;
                }
            });
        }
    }

    @Override
    public void salvar() {
        EstanteBean bean;
        if (this.validaCampos() && (bean = (EstanteBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ett_codigo";
    }
}

