/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.animal.EspecieBean;
import jalis.model.bean.cadastro.animal.RacaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.animal.EspecieVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.animal.EspecieService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Especie
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelCientificoEspecie = new JLabel("Nome Cientifico:");
    private TTextField textCodigo = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textCientificoEspecie = new TTextField(200, 3);
    private JPanel panelRacas = new JPanel(new GridBagLayout());
    private DefaultTableModel modelRacas;
    private JTable tableRacas;
    private JScrollPane scrollRacas;
    private JLabel labelRaca = new JLabel("Ra\u00e7a");
    private JLabel labelCientificoRaca = new JLabel("Nome Cientifico:");
    private TTextField textRaca = new TTextField(150, 3);
    private TTextField textCientificoRaca = new TTextField(200, 3);
    private JButton buttonAdicionarRaca = new JButton("Ok");
    private ArrayList<RacaBean> racas;
    private String retornoParaPesquisa = "";

    public Especie() {
        this.setName("Especie");
        this.setLabelDescricao("Cadastro de esp\u00e9cies e ra\u00e7as para animais");
        this.setLabelFormulario("Cadastro de esp\u00e9cies");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/especie.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        d = new Dimension(350, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        d = new Dimension(450, 20);
        this.textCientificoEspecie.setSize(d);
        this.textCientificoEspecie.setName("textCientificoEspecie");
        this.textCientificoEspecie.setPreferredSize(d);
        this.textCientificoEspecie.setMinimumSize(d);
        this.textCientificoEspecie.setMaximumSize(d);
        d = new Dimension(230, 20);
        this.textRaca.setSize(d);
        this.textRaca.setName("textRaca");
        this.textRaca.setPreferredSize(d);
        this.textRaca.setMinimumSize(d);
        this.textRaca.setMaximumSize(d);
        d = new Dimension(250, 20);
        this.textCientificoRaca.setSize(d);
        this.textCientificoRaca.setName("textCientificoRaca");
        this.textCientificoRaca.setPreferredSize(d);
        this.textCientificoRaca.setMinimumSize(d);
        this.textCientificoRaca.setMaximumSize(d);
        d = new Dimension(30, 20);
        this.buttonAdicionarRaca.setSize(d);
        this.buttonAdicionarRaca.setName("buttonAdicionarRaca");
        this.buttonAdicionarRaca.setPreferredSize(d);
        this.buttonAdicionarRaca.setMinimumSize(d);
        this.buttonAdicionarRaca.setMaximumSize(d);
        this.buttonAdicionarRaca.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAdicionarRaca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Especie.this.adicionarRaca();
            }
        });
        this.panelRacas.setBorder(new TitledBorder("Ra\u00e7as"));
        d = new Dimension(520, 250);
        this.panelRacas.setSize(d);
        this.panelRacas.setPreferredSize(d);
        this.panelRacas.setMaximumSize(d);
        this.panelRacas.setMinimumSize(d);
        this.modelRacas = new DefaultTableModel(new Object[0][], new String[]{"Ra\u00e7a", "Nome Cient\u00edfico"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }
        };
        this.tableRacas = new JTable(this.modelRacas);
        this.tableRacas.setName("tableRacas");
        TableRowSorter<TableModel> sorterRacas = new TableRowSorter<TableModel>(this.tableRacas.getModel());
        this.tableRacas.setRowSorter(sorterRacas);
        this.tableRacas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Especie.this.removerRaca();
                }
            }
        });
        this.scrollRacas = new JScrollPane(this.tableRacas);
        d = new Dimension(450, 150);
        this.scrollRacas.setSize(d);
        this.scrollRacas.setPreferredSize(d);
        this.scrollRacas.setMaximumSize(d);
        this.scrollRacas.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelCientificoEspecie, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCientificoEspecie, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.panelRacas, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.insets = new Insets(0, 1, 0, 1);
        c.gridy = 0;
        c.gridx = 0;
        c.anchor = 17;
        this.panelRacas.add((Component)this.labelRaca, c);
        ++c.gridx;
        this.panelRacas.add((Component)this.labelCientificoRaca, c);
        ++c.gridy;
        c.gridx = 0;
        this.panelRacas.add((Component)this.textRaca, c);
        ++c.gridx;
        this.panelRacas.add((Component)this.textCientificoRaca, c);
        ++c.gridx;
        this.panelRacas.add((Component)this.buttonAdicionarRaca, c);
        this.buttonAdicionarRaca.setName("buttonAdicionarRaca");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelRacas.add((Component)this.scrollRacas, c);
        this.service = new EspecieService();
        this.tableRacas.getRowSorter().toggleSortOrder(0);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos();
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Especie.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0103000101"));
        this.setModuloEdita(Long.parseLong("0103000102"));
        this.setModuloApaga(Long.parseLong("0103000103"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0103000100");
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textRaca.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonAdicionarRaca.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCientificoEspecie.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCientificoRaca.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        EspecieBean bean = new EspecieBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setCientifico(this.textCientificoEspecie.getText());
        bean.setRacas(new HashSet<RacaBean>(this.racas));
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaEspecie();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.textCientificoEspecie.setText("");
        this.textRaca.setText("");
        this.textCientificoRaca.setText("");
        this.limparRacas();
        this.racas = new ArrayList();
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new EspecieVO(), "Pesquisando especies", false);
            if (vo != null) {
                EspecieBean especieBean = (EspecieBean)this.service.voToBean((EspecieVO)vo, EspecieBean.class);
                return especieBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Especie:238");
        }
        return null;
    }

    private void limparRacas() {
        while (this.modelRacas.getRowCount() > 0) {
            this.modelRacas.removeRow(0);
        }
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        EspecieBean especieBean = (EspecieBean)bean;
        this.textCodigo.setText(Integer.toString(especieBean.getCodigo()));
        this.textDescricao.setText(especieBean.getDescricao());
        this.textCientificoEspecie.setText(especieBean.getCientifico());
        this.limparRacas();
        this.racas = new ArrayList(especieBean.getRacas());
        this.popularRacas();
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textDescricao.getText()) && this.modelRacas.getRowCount() > 0) {
            return true;
        }
        if (this.modelRacas.getRowCount() == 0) {
            Funcoes.mensagem(this, "Ra\u00e7as n\u00e3o cadastradas", 2);
            ScreenUtil.requisitarFoco(this.textRaca);
            return false;
        }
        return false;
    }

    public void adicionarRaca() {
        if (this.racas == null) {
            this.racas = new ArrayList();
        }
        RacaBean raca = null;
        if (!Funcoes.textoVazio(this.textRaca.getText())) {
            for (RacaBean rac : this.racas) {
                if (!rac.getDescricao().equalsIgnoreCase(this.textRaca.getText())) continue;
                if (!rac.isRemover()) {
                    Funcoes.mensagem(this, "Ra\u00e7a j\u00e1 cadastrada", 2);
                    return;
                }
                raca = rac;
                raca.setRemover(false);
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            if (raca == null) {
                raca = new RacaBean();
                raca.setDescricao(this.textRaca.getText());
                raca.setCientifico(this.textCientificoRaca.getText());
                raca.setFilial(filial);
                raca.setInserir(true);
                this.racas.add(raca);
            }
            this.limparRacas();
            this.popularRacas();
        }
        this.textRaca.setText("");
        this.textCientificoRaca.setText("");
        ScreenUtil.requisitarFoco(this.textRaca);
    }

    public void removerRaca() {
        if (this.tableRacas.getSelectedRowCount() > 0 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            int row = this.tableRacas.getRowSorter().convertRowIndexToModel(this.tableRacas.getSelectedRow());
            String desc = (String)this.modelRacas.getValueAt(row, 0);
            for (RacaBean r : this.racas) {
                if (!r.getDescricao().equalsIgnoreCase(desc)) continue;
                r.setRemover(true);
                this.limparRacas();
                this.popularRacas();
                break;
            }
        }
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    private void popularRacas() {
        for (RacaBean raca : this.racas) {
            if (raca.isRemover()) continue;
            this.modelRacas.addRow(new Object[]{raca.getDescricao(), raca.getCientifico()});
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((EspecieBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "Especie:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "epc_codigo";
    }
}

