/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.SenhaWeb;
import jalis.laboratorio.cadastro.VisualizarPesquisaFornecedor;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.EntidadeBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.ArraysUtil;
import jalis.util.CEP;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Entidade
extends FrmCadPadraoBean
implements ActionListener {
    public static final int FORNECEDOR = 1;
    public static final int FUNCIONARIO = 2;
    public static final int COLETADOR = 3;
    public static final int REPRESENTANTE = 4;
    public static final int FISCAL = 5;
    public static final int RESPONSAVEL = 6;
    public static final int EMPRESA = 7;
    private static final long ACESSO_WEB_FISCAL = 104400104L;
    private static final long ACESSO_WEB_RESPONSAVEL = 104500104L;
    private static long[] auxAcessos = new long[]{0L, 100000L, 200000L, 300000L, 400000L, 500000L, 600000L};
    private int tipoCadastro = 1;
    private String senhaWeb = "";
    private String codigo = "";
    CidadeService cidadeService = new CidadeService();
    BairroService bairroService = new BairroService();
    JLabel labelCodigo = new JLabel("C\u00f3digo:");
    JLabel labelPessoa = new JLabel("Pessoa:");
    JLabel labelRazao = new JLabel("Raz\u00e3o social:");
    JLabel labelFantasia = new JLabel("Fantasia:");
    JLabel labelCNPJ = new JLabel("CNPJ:");
    JLabel labelIE = new JLabel("Insc.Estadual:");
    JLabel labelCidade = new JLabel("Cidade:");
    JLabel labelEndereco = new JLabel("Endere\u00e7o:");
    JLabel labelNumeroEndereco = new JLabel("Nr.:");
    JLabel labelComplemento = new JLabel("Complemento:");
    JLabel labelBairro = new JLabel("Bairro:");
    JLabel labelCEP = new JLabel("CEP:");
    JLabel labelFone = new JLabel("Fone:");
    JLabel labelFax = new JLabel("Fax:");
    JLabel labelEmail = new JLabel("E-mail:");
    JLabel labelSite = new JLabel("Site:");
    JLabel labelContato = new JLabel("Contato:");
    JLabel labelFoneContato = new JLabel("Fone:");
    JLabel labelDataHoraCadastro = new JLabel();
    JLabel labelCelular = new JLabel("Celular:");
    JLabel labelDataNascimento = new JLabel("Data Nasc.:");
    JLabel labelCargo = new JLabel("Cargo:");
    JLabel labelTipoFornecedor = new JLabel("Tipo:");
    JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o:");
    JLabel labelIntegracao = new JLabel("Integra\u00e7\u00e3o:");
    TTextField textCodigo = new TTextField(5, 1);
    TTextField textRazaoSocial = new TTextField(150);
    TTextField textFantasia = new TTextField(100);
    TTextField textCnpj = new TTextField(18, 7);
    TTextField textCpf = new TTextField(14, 8);
    TTextField textInscEstadual = new TTextField(20);
    TTextField textCodCidade = new TTextField(5, 1);
    JButton buttonBuscaCidade = ComponenteFactory.novoJButton(this, true);
    TTextField textDescCidade = new TTextField();
    TTextField textEndereco = new TTextField(100);
    TTextField textNumeroEndereco = new TTextField(15);
    TTextField textComplemento = new TTextField(80);
    TTextField textCodBairro = new TTextField(5);
    JButton buttonBuscaBairro = ComponenteFactory.novoJButton(this, true);
    TTextField textDescBairro = new TTextField();
    TTextField textCep = new TTextField(9, 9);
    TTextFieldTelefone textFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextFieldTelefone textFax = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextField textContato = new TTextField(100);
    TTextFieldTelefone textFoneContato = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextField textEmail = new TTextField(100);
    TTextField textSite = new TTextField(100);
    TTextFieldTelefone textCelular = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextField textDataNascimento = new TTextField(10, 4);
    TTextField textCargo = new TTextField(80);
    TTextField textIntegracao = new TTextField(10);
    JButton buttonBuscaData = ComponenteFactory.novoJButton(this, true);
    JButton buttonSenhaWeb = ComponenteFactory.novoJButton("Senha web", this);
    JButton buttonHistoricoPesquisaFornecedor = ComponenteFactory.novoJButton("Hist\u00f3rico de Pesquisa", this);
    JButton bBuscaCep = ComponenteFactory.novoJButton(this, true);
    EntidadeBean entidadeAux;
    private JTextArea txtAreaObs = new JTextArea(new TTextAreaDocument(1000));
    private JScrollPane scrollObs;
    JComboBox comboPessoa = ComponenteFactory.novoJComboBox(new String[]{Tipos.tipoPessoa("F"), Tipos.tipoPessoa("J")}, this, null);
    JComboBox comboTipoFornecedor = ComponenteFactory.novoJComboBox(new String[]{"", Tipos.getTipoFornecedor("P"), Tipos.getTipoFornecedor("S"), Tipos.getTipoFornecedor("A"), Tipos.getTipoFornecedor("E")}, this, null);
    JComboBox comboTipoLogradouro = new JComboBox<String>(Tipos.arrayTiposLogradouro);
    JCheckBox checkInativo = new JCheckBox("Inativo");
    private final Component[] naoLimpar = new Component[]{this.textCodCidade, this.textDescCidade, this.textEndereco, this.textComplemento, this.textCodBairro, this.textDescBairro, this.textFone, this.textCep, this.textFax, this.textContato, this.textFoneContato, this.textEmail};
    private String retornoParaPesquisa = "";

    public Entidade(int tipo) {
        this.tipoCadastro = tipo;
        switch (this.tipoCadastro) {
            case 2: {
                this.setLabelDescricao("Cadastro de funcion\u00e1rios");
                this.setLabelFormulario("Cadastro de funcion\u00e1rios");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_funcionario.jpg"));
                this.comboPessoa.setSelectedIndex(0);
                break;
            }
            case 3: {
                this.setLabelDescricao("Cadastro de coletadores, captadores de amostras");
                this.setLabelFormulario("Cadastro de coletadores");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_coletador.jpg"));
                this.comboPessoa.setSelectedIndex(0);
                break;
            }
            case 4: {
                this.setLabelDescricao("Cadastro de representantes do laborat\u00f3rio");
                this.setLabelFormulario("Cadastro de representantes");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_representante.jpg"));
                this.comboPessoa.setSelectedIndex(0);
                break;
            }
            case 5: {
                this.setLabelDescricao("Cadastro de fiscais do solicitante");
                this.setLabelFormulario("Cadastro de fiscais");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_fiscal.jpg"));
                this.comboPessoa.setSelectedIndex(0);
                break;
            }
            case 6: {
                this.setLabelDescricao("Cadastro de respons\u00e1veis do solicitante");
                this.setLabelFormulario("Cadastro de respons\u00e1veis");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_responsavel.jpg"));
                this.comboPessoa.setSelectedIndex(0);
                break;
            }
            case 7: {
                this.setLabelDescricao("Cadastro de empresas do laborat\u00f3rio");
                this.setLabelFormulario("Cadastro de empresas");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_fornecedor.jpg"));
                this.comboPessoa.setSelectedIndex(1);
                break;
            }
            default: {
                this.setLabelDescricao("Cadastro de fornecedores de material, equipamentos para o laborat\u00f3rio");
                this.setLabelFormulario("Cadastro de fornecedores");
                this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_fornecedor.jpg"));
                this.comboPessoa.setSelectedIndex(1);
            }
        }
        this.montaTela();
        this.service = new EntidadeService();
        this.controlaCampos();
        this.textCep.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CEP.buscarCEP(Entidade.this.comboTipoLogradouro, Entidade.this.textCep, Entidade.this.textEndereco, Entidade.this.textCodCidade, Entidade.this.textDescCidade, Entidade.this.textCodBairro, Entidade.this.textDescBairro, Entidade.this);
                }
            }
        });
        this.textCep.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean validaCEP;
                if (!Funcoes.textoVazio(Entidade.this.textCep) && e.getOppositeComponent() != null && e.getOppositeComponent().getParent() == Entidade.this.textCep.getParent() && !(validaCEP = CEP.cepValido(Entidade.this.textCep))) {
                    ScreenUtil.requisitarFoco(Entidade.this.textCep);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void montaTela() {
        this.setName("Entidade");
        int diferenca = 0;
        int diferencaBotao = 0;
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            diferenca = 20;
        }
        if (this.tipoCadastro == 5 || this.tipoCadastro == 2 || this.tipoCadastro == 6) {
            diferencaBotao = 20;
        }
        this.painelCentral.setLayout(null);
        this.labelRazao.setDisplayedMnemonic('o');
        this.labelRazao.setLabelFor(this.textRazaoSocial);
        this.labelCodigo.setBounds(new Rectangle(5, 7, 88, 20));
        this.labelPessoa.setBounds(190, 7, 50, 20);
        this.labelDataHoraCadastro.setBounds(new Rectangle(369, 7, 130, 20));
        this.labelRazao.setBounds(new Rectangle(5, 28, 88, 20));
        this.labelFantasia.setBounds(new Rectangle(5, 48, 95, 20));
        this.labelCNPJ.setBounds(new Rectangle(5, 68, 58, 20));
        this.labelIE.setBounds(new Rectangle(339, 68, 95, 20));
        this.labelCidade.setBounds(new Rectangle(5, 88, 54, 20));
        this.labelEndereco.setBounds(new Rectangle(5, 108, 80, 20));
        this.labelNumeroEndereco.setBounds(new Rectangle(407, 108, 50, 20));
        this.labelComplemento.setBounds(new Rectangle(5, 128, 96, 20));
        this.labelBairro.setBounds(new Rectangle(5, 148, 48, 20));
        this.labelCEP.setBounds(new Rectangle(342, 148, 38, 20));
        this.labelFone.setBounds(new Rectangle(5, 168, 48, 20));
        this.labelFax.setBounds(new Rectangle(344, 168, 36, 20));
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            this.labelCelular.setBounds(new Rectangle(5, 188, 48, 20));
            this.labelDataNascimento.setBounds(new Rectangle(300, 188, 110, 20));
        } else if (this.tipoCadastro == 1) {
            this.labelTipoFornecedor.setBounds(new Rectangle(5, 248 + diferenca, 88, 20));
            this.labelObservacao.setBounds(new Rectangle(5, 268 + diferenca, 88, 20));
        }
        this.labelContato.setBounds(new Rectangle(5, 188 + diferenca, 58, 20));
        this.labelFoneContato.setBounds(new Rectangle(335, 188 + diferenca, 58, 20));
        this.labelEmail.setBounds(new Rectangle(5, 208 + diferenca, 60, 20));
        this.labelSite.setBounds(new Rectangle(5, 228 + diferenca, 35, 20));
        this.labelCargo.setBounds(new Rectangle(5, 248 + diferenca, 60, 20));
        this.labelIntegracao.setBounds(new Rectangle(5, 248 + diferenca, 80, 20));
        this.textCodigo.setBounds(new Rectangle(99, 7, 69, 20));
        this.textCodigo.setName("textCodigo");
        this.comboPessoa.setBounds(240, 7, 90, 20);
        this.comboPessoa.setName("comboPessoa");
        this.textRazaoSocial.setBounds(new Rectangle(99, 28, 400, 20));
        this.textRazaoSocial.setName("textRazaoSocial");
        this.textFantasia.setBounds(new Rectangle(99, 48, 400, 20));
        this.textFantasia.setName("textFantasia");
        this.textCnpj.setBounds(new Rectangle(99, 68, 180, 20));
        this.textCnpj.setName("textCnpj");
        this.textCpf.setBounds(new Rectangle(99, 68, 180, 20));
        this.textCpf.setName("textCpf");
        this.textInscEstadual.setBounds(new Rectangle(370, 68, 129, 20));
        this.textInscEstadual.setName("textInscEstadual");
        this.textCodCidade.setBounds(new Rectangle(99, 88, 69, 20));
        this.textCodCidade.setName("textCodCidade");
        this.buttonBuscaCidade.setBounds(new Rectangle(169, 88, 20, 20));
        this.buttonBuscaCidade.setName("buttonBuscaCidade");
        this.textDescCidade.setEditable(false);
        this.textDescCidade.setName("textDescCidade");
        this.textDescCidade.setFocusable(false);
        this.textDescCidade.setBounds(new Rectangle(190, 88, 309, 20));
        this.comboTipoLogradouro.setBounds(new Rectangle(99, 108, 105, 19));
        this.comboTipoLogradouro.setName("comboTipoLogradouro");
        this.textEndereco.setBounds(new Rectangle(205, 108, 200, 20));
        this.textEndereco.setName("textEndereco");
        this.textNumeroEndereco.setBounds(new Rectangle(430, 108, 69, 20));
        this.textNumeroEndereco.setName("textNumeroEndereco");
        this.textComplemento.setBounds(new Rectangle(99, 128, 400, 20));
        this.textComplemento.setName("textComplemento");
        this.textCodBairro.setBounds(new Rectangle(99, 148, 69, 20));
        this.textCodBairro.setName("textCodBairro");
        this.buttonBuscaBairro.setBounds(new Rectangle(169, 148, 20, 20));
        this.buttonBuscaBairro.setName("buttonBuscaBairro");
        this.textDescBairro.setBounds(new Rectangle(190, 148, 137, 20));
        this.textDescBairro.setName("textDescBairro");
        this.textDescBairro.setEnabled(false);
        this.textDescBairro.setEditable(false);
        this.textDescBairro.setFocusable(false);
        this.textCep.setBounds(new Rectangle(372, 148, 105, 20));
        this.textCep.setName("textCep");
        this.bBuscaCep.setBounds(new Rectangle(478, 148, 20, 20));
        this.bBuscaCep.setName("bBuscaCep");
        this.textFone.setBounds(new Rectangle(99, 168, 116, 20));
        this.textFone.setName("textFone");
        this.textFax.setBounds(new Rectangle(372, 168, 127, 20));
        this.textFax.setName("textFax");
        this.textCelular.setName("textCelular");
        this.textDataNascimento.setName("textDataNascimento");
        this.buttonBuscaData.setName("buttonBuscaData");
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            this.textCelular.setBounds(99, 188, 116, 20);
            this.textDataNascimento.setBounds(372, 188, 107, 20);
            this.buttonBuscaData.setBounds(479, 188, 20, 20);
        } else if (this.tipoCadastro == 1) {
            this.comboTipoFornecedor.setBounds(new Rectangle(99, 248 + diferenca, 150, 19));
            this.scrollObs = new JScrollPane(this.txtAreaObs);
            this.scrollObs.setBounds(new Rectangle(99, 268 + diferenca, 400, 40));
        }
        this.comboTipoFornecedor.setName("comboTipoFornecedor");
        this.txtAreaObs.setName("txtAreaObs");
        this.textContato.setBounds(new Rectangle(99, 188 + diferenca, 230, 20));
        this.textContato.setName("textContato");
        this.textFoneContato.setBounds(new Rectangle(372, 188 + diferenca, 127, 20));
        this.textFoneContato.setName("textFoneContato");
        this.textEmail.setBounds(new Rectangle(99, 208 + diferenca, 400, 20));
        this.textEmail.setName("textEmail");
        this.textSite.setBounds(new Rectangle(99, 228 + diferenca, 400, 20));
        this.textSite.setName("textSite");
        this.textCargo.setBounds(new Rectangle(99, 248 + diferenca, 400, 20));
        this.textCargo.setName("textCargo");
        this.textIntegracao.setBounds(new Rectangle(99, 248 + diferenca, 100, 20));
        this.textIntegracao.setName("textIntegracao");
        if (this.tipoCadastro == 1) {
            this.checkInativo.setBounds(new Rectangle(99, 308 + diferenca + diferencaBotao, 200, 20));
        } else {
            this.checkInativo.setBounds(new Rectangle(99, 268 + diferenca + diferencaBotao, 200, 20));
        }
        this.buttonHistoricoPesquisaFornecedor.setName("buttonHistoricoPesquisaFornecedor");
        this.buttonHistoricoPesquisaFornecedor.setBounds(new Rectangle(299, 308 + diferenca + diferencaBotao, 200, 20));
        this.buttonHistoricoPesquisaFornecedor.setMnemonic('h');
        this.buttonSenhaWeb.setName("buttonSenhaWeb");
        this.buttonSenhaWeb.setBounds(new Rectangle(379, 248 + diferenca + diferencaBotao, 120, 20));
        this.buttonSenhaWeb.setMnemonic('w');
        this.painelCentral.add(this.labelDataHoraCadastro);
        this.painelCentral.add(this.labelCodigo);
        this.painelCentral.add(this.labelPessoa);
        this.painelCentral.add(this.labelRazao);
        this.painelCentral.add(this.labelFantasia);
        this.painelCentral.add(this.labelCNPJ);
        this.painelCentral.add(this.labelIE);
        this.painelCentral.add(this.labelCidade);
        this.painelCentral.add(this.labelEndereco);
        this.painelCentral.add(this.labelComplemento);
        this.painelCentral.add(this.labelBairro);
        this.painelCentral.add(this.labelCEP);
        this.painelCentral.add(this.labelFone);
        this.painelCentral.add(this.labelFax);
        this.painelCentral.add(this.labelEmail);
        this.painelCentral.add(this.labelSite);
        this.painelCentral.add(this.labelContato);
        this.painelCentral.add(this.textCodigo);
        this.painelCentral.add(this.comboPessoa);
        this.painelCentral.add(this.textRazaoSocial);
        this.painelCentral.add(this.textFantasia);
        this.painelCentral.add(this.textCnpj);
        this.painelCentral.add(this.textCpf);
        this.painelCentral.add(this.textInscEstadual);
        this.painelCentral.add(this.textCodCidade);
        this.painelCentral.add(this.buttonBuscaCidade);
        this.painelCentral.add(this.textDescCidade);
        this.painelCentral.add(this.comboTipoLogradouro);
        this.painelCentral.add(this.textEndereco);
        this.painelCentral.add(this.labelNumeroEndereco);
        this.painelCentral.add(this.textNumeroEndereco);
        this.painelCentral.add(this.textComplemento);
        this.painelCentral.add(this.textCodBairro);
        this.painelCentral.add(this.buttonBuscaBairro);
        this.painelCentral.add(this.bBuscaCep);
        this.painelCentral.add(this.textDescBairro);
        this.painelCentral.add(this.textCep);
        this.painelCentral.add(this.textFone);
        this.painelCentral.add(this.textFax);
        this.painelCentral.add(this.textContato);
        this.painelCentral.add(this.textEmail);
        this.painelCentral.add(this.textSite);
        if (this.tipoCadastro == 1) {
            this.painelCentral.add(this.labelTipoFornecedor);
            this.painelCentral.add(this.comboTipoFornecedor);
            this.painelCentral.add(this.labelObservacao);
            this.painelCentral.add(this.scrollObs);
            this.painelCentral.add(this.buttonHistoricoPesquisaFornecedor);
        }
        this.painelCentral.add(this.textFoneContato);
        this.painelCentral.add(this.labelFoneContato);
        if (this.tipoCadastro == 5 || this.tipoCadastro == 6) {
            this.painelCentral.add(this.buttonSenhaWeb);
        }
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            this.painelCentral.add(this.labelCelular);
            this.painelCentral.add(this.labelDataNascimento);
            this.painelCentral.add(this.textCelular);
            this.painelCentral.add(this.textDataNascimento);
            this.painelCentral.add(this.buttonBuscaData);
        }
        if (this.tipoCadastro == 5 || this.tipoCadastro == 2 || this.tipoCadastro == 6) {
            this.painelCentral.add(this.labelCargo);
            this.painelCentral.add(this.textCargo);
        }
        if (this.tipoCadastro == 7) {
            this.painelCentral.add(this.labelIntegracao);
            this.painelCentral.add(this.textIntegracao);
        }
        this.painelCentral.add(this.checkInativo);
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.textFone, this.textFax, this.textFoneContato, this.textCelular);
        this.labelDataHoraCadastro.setBorder(BorderFactory.createTitledBorder(""));
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.textEmail.setUpperCase(false);
        this.textSite.setUpperCase(false);
        this.textCodBairro.setUpperCase(true);
        this.txtAreaObs.setWrapStyleWord(true);
        this.txtAreaObs.setLineWrap(true);
        this.txtAreaObs.setWrapStyleWord(true);
        this.txtAreaObs.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.txtAreaObs);
        this.textCodCidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JButton)) {
                    try {
                        Entidade.this.buscaDadosCidade();
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Entidade.this, e1.getMessage(), e1.getStackTrace(), "Entidade (229)");
                    }
                }
            }
        });
        this.textCodBairro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JButton)) {
                    try {
                        Entidade.this.buscaDadosBairro();
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Entidade.this, e1.getMessage(), e1.getStackTrace(), "Entidade (239)");
                    }
                }
            }
        });
        this.textRazaoSocial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(Entidade.this.textFantasia.getText()) && !Funcoes.textoVazio(Entidade.this.textRazaoSocial.getText())) {
                    Entidade.this.textFantasia.setText(Entidade.this.textRazaoSocial.getText());
                    Entidade.this.textFantasia.selectAll();
                }
            }
        });
        this.textCnpj.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EntidadeBean bean;
                if (Entidade.this.getStatus() == 2 && !Funcoes.textoVazio(Entidade.this.textCnpj.getText()) && ValidaDoc.checkDoc(Entidade.this.textCnpj.getText(), 7) && (bean = ((EntidadeService)Entidade.this.service).localizarPeloDocumento(Variaveis.filialPadrao, Entidade.this.textCnpj.getText(), Entidade.this.getTipo())) != null) {
                    int opcao = Funcoes.mensagem(Entidade.this, "CNPJ j\u00e1 cadastrado com o c\u00f3digo " + String.valueOf(bean.getCodigo()) + "\n(" + bean.getFantasia() + ")\nDeseja alterar o CNPJ digitado?\nClique [Sim] para alterar o CNPJ e clique [N\u00e3o] para localizar o CNPJ j\u00e1 cadastrado", 4);
                    Entidade.this.textCnpj.clear();
                    if (opcao == 1) {
                        Entidade.this.limparCampos();
                        Entidade.this.setStatus(3);
                        Entidade.this.controlaCampos();
                        Entidade.this.preencherCampos(bean);
                    } else {
                        ScreenUtil.requisitarFoco(Entidade.this.textCnpj);
                    }
                }
            }
        });
        this.textCpf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EntidadeBean bean;
                if (Entidade.this.getStatus() == 2 && !Funcoes.textoVazio(Entidade.this.textCpf.getText()) && ValidaDoc.checkDoc(Entidade.this.textCpf.getText(), 8) && (bean = ((EntidadeService)Entidade.this.service).localizarPeloDocumento(Variaveis.filialPadrao, Entidade.this.textCpf.getText(), Entidade.this.getTipo())) != null) {
                    int opcao = Funcoes.mensagem(Entidade.this, "CPF j\u00e1 cadastrado com o c\u00f3digo " + String.valueOf(bean.getCodigo()) + "\n(" + bean.getFantasia() + ")\nDeseja alterar o CPF digitado?\nClique [Sim] para alterar o CPF e clique [N\u00e3o] para localizar o CPF j\u00e1 cadastrado", 4);
                    Entidade.this.textCpf.clear();
                    if (opcao == 1) {
                        Entidade.this.limparCampos();
                        Entidade.this.setStatus(3);
                        Entidade.this.controlaCampos();
                        Entidade.this.preencherCampos(bean);
                    } else {
                        ScreenUtil.requisitarFoco(Entidade.this.textCpf);
                    }
                }
            }
        });
    }

    @Override
    public void salvar() {
        if (Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 2) {
            this.senhaWeb = Funcoes.gerarSenhaWeb();
        } else if ((this.tipoCadastro == 5 || this.tipoCadastro == 6) && Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 3 && Funcoes.mensagem(this, "A senha web n\u00e3o foi definida, deseja gerar uma senha autom\u00e1tica?", 4) == 0) {
            this.senhaWeb = Funcoes.gerarSenhaWeb();
        }
        if (this.validaCampos()) {
            this.salvar(false);
            boolean continuarCadastrando = false;
            if (this.getStatus() == 2 && (this.tipoCadastro == 5 || this.tipoCadastro == 6)) {
                boolean bl = continuarCadastrando = Funcoes.mensagem(this, "Deseja adicionar um novo cadastro utilizando os dados anteriores?", 4) == 0;
            }
            if (continuarCadastrando) {
                this.limparCampos(true);
                this.controlaCampos();
                ScreenUtil.requisitarFoco(this.textRazaoSocial);
            } else {
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
        }
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((EntidadeBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    @Override
    protected void controlaCampos() {
        this.labelDataHoraCadastro.setVisible(this.getStatus() == 3);
        for (Component c : this.painelCentral.getComponents()) {
            if (!(c instanceof TTextField)) continue;
            ((TTextField)c).setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        }
        this.comboPessoa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoLogradouro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        if (this.tipoCadastro == 1) {
            this.comboTipoFornecedor.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
            this.txtAreaObs.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
            this.scrollObs.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        }
        this.buttonBuscaBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaCep.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonSenhaWeb.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaData.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonHistoricoPesquisaFornecedor.setEnabled(this.existeNotaFiscalEntrada() && this.getStatus() == 3);
        this.textCodigo.setEnabled(false);
        this.checkInativo.setEnabled(this.getStatus() == 3);
        this.buttonSenhaWeb.setVisible(this.tipoCadastro == 5 && Acesso.getAcesso(104400104L) || this.tipoCadastro == 6 && Acesso.getAcesso(104500104L));
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        EntidadeBean bean = new EntidadeBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        BairroVO bairro = new BairroVO();
        bairro.setCodigo(this.textCodBairro.getText());
        CidadeVO cidade = new CidadeVO();
        cidade.setCodigo(Integer.parseInt(this.textCodCidade.getText()));
        bean.setFilial(filial);
        bean.setBairro(bairro);
        bean.setCidade(cidade);
        bean.setCep(this.textCep.getText());
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setComplemento(this.textComplemento.getText());
        if (this.textCnpj.isVisible()) {
            bean.setCpfCnpj(this.textCnpj.getText());
        } else {
            bean.setCpfCnpj(this.textCpf.getText());
        }
        bean.setEmail(this.textEmail.getText());
        bean.setEndereco(this.textEndereco.getText());
        bean.setNumeroEndereco(this.textNumeroEndereco.getText());
        bean.setTipoLogradrouroEndereco(Tipos.tipoLogradouro(this.comboTipoLogradouro.getSelectedItem().toString()));
        bean.setFantasia(this.textFantasia.getText());
        bean.setFax(this.textFax.getText());
        bean.setFone(this.textFone.getText());
        bean.setFoneContato(this.textFoneContato.getText());
        bean.setNomeContato(this.textContato.getText());
        bean.setRazaoSocial(this.textRazaoSocial.getText());
        bean.setRgIE(this.textInscEstadual.getText());
        bean.setSite(this.textSite.getText());
        bean.setTipo(this.getTipo());
        bean.setTipoPessoa(this.comboPessoa.getSelectedItem().toString().equals(Tipos.tipoPessoa("F")) ? "F" : "J");
        if (this.tipoCadastro == 5 || this.tipoCadastro == 6) {
            if (this.senhaWeb == null) {
                this.senhaWeb = "";
            }
            bean.setSenhaWeb(this.senhaWeb);
        }
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            bean.setDataNascimento(Funcoes.verificaData(this.textDataNascimento.getText()) ? Funcoes.stringToDate(this.textDataNascimento.getText()) : null);
            bean.setCelular(this.textCelular.getText());
        }
        if (this.tipoCadastro == 1) {
            bean.setTipoFornecedor(Tipos.tipoFornecedor(this.comboTipoFornecedor.getSelectedItem().toString()));
            bean.setObservacao(this.txtAreaObs.getText());
            ScreenUtil.posicionaTextoTopo(this.txtAreaObs);
        }
        if (this.tipoCadastro == 5 || this.tipoCadastro == 2 || this.tipoCadastro == 6) {
            bean.setCargo(this.textCargo.getText());
        }
        if (this.tipoCadastro == 7) {
            bean.setIntegracao("<soc>" + this.textIntegracao.getText() + "</soc>");
        }
        if (this.getStatus() == 2) {
            bean.setDataHoraCadastro(new Date());
        }
        bean.setInativo(this.checkInativo.isSelected());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaEntidade();
    }

    @Override
    protected void limparCampos() {
        this.limparCampos(false);
    }

    protected void limparCampos(boolean cadastrando) {
        for (Component c : this.painelCentral.getComponents()) {
            if (!(c instanceof TTextField) || cadastrando && (!cadastrando || ArraysUtil.contem(this.naoLimpar, c))) continue;
            ((TTextField)c).clear();
        }
        this.txtAreaObs.setText("");
        this.comboTipoFornecedor.setSelectedItem(0);
        this.senhaWeb = "";
        this.checkInativo.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = ((EntidadeService)this.service).pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new EntidadeVO(), "Pesquisando " + this.getDescricaoTipoTela(), this.tipoCadastro, this.getTipo(), false, true);
            if (vo != null) {
                EntidadeBean entidadeBean;
                this.entidadeAux = entidadeBean = (EntidadeBean)this.service.voToBean((EntidadeVO)vo, EntidadeBean.class);
                return entidadeBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Entidade:95");
        }
        return null;
    }

    private String getTipo() {
        return this.tipoCadastro == 1 ? "F" : (this.tipoCadastro == 2 ? "U" : (this.tipoCadastro == 3 ? "C" : (this.tipoCadastro == 5 ? "I" : (this.tipoCadastro == 6 ? "P" : (this.tipoCadastro == 7 ? "E" : "R")))));
    }

    public void setBean(int status, EntidadeBean bean) {
        if (bean != null) {
            this.setStatus(status);
            this.controlaCampos();
            this.preencherCampos(bean);
        }
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        EntidadeBean entidadeBean = (EntidadeBean)bean;
        if (entidadeBean.getCodigo() != null) {
            this.textCodigo.setText(Integer.toString(entidadeBean.getCodigo()));
        }
        this.codigo = this.textCodigo.getText();
        if (entidadeBean.getBairro() != null) {
            this.textCodBairro.setText(entidadeBean.getBairro().getCodigo());
            this.textDescBairro.setText(entidadeBean.getBairro().getDescricao());
        }
        if (entidadeBean.getCidade() != null) {
            this.textCodCidade.setText(String.valueOf(entidadeBean.getCidade().getCodigo()));
            this.textDescCidade.setText(entidadeBean.getCidade().getNome() + " (" + entidadeBean.getCidade().getUf() + ")");
        }
        this.textCep.setText(entidadeBean.getCep());
        this.textComplemento.setText(entidadeBean.getComplemento());
        this.comboPessoa.setSelectedItem(Tipos.tipoPessoa(entidadeBean.getTipoPessoa()));
        if (this.textCnpj.isVisible()) {
            this.textCnpj.setText(entidadeBean.getCpfCnpj());
        } else {
            this.textCpf.setText(entidadeBean.getCpfCnpj());
        }
        this.textEmail.setText(entidadeBean.getEmail());
        this.textEndereco.setText(entidadeBean.getEndereco());
        this.textNumeroEndereco.setText(entidadeBean.getNumeroEndereco());
        this.comboTipoLogradouro.setSelectedItem(Tipos.tipoLogradouroDescricao(entidadeBean.getTipoLogradrouroEndereco()));
        this.textFantasia.setText(entidadeBean.getFantasia());
        this.textFax.setText(entidadeBean.getFax());
        this.textFone.setText(entidadeBean.getFone());
        this.textFoneContato.setText(entidadeBean.getFoneContato());
        this.textContato.setText(entidadeBean.getNomeContato());
        this.textRazaoSocial.setText(entidadeBean.getRazaoSocial());
        this.textInscEstadual.setText(entidadeBean.getRgIE());
        this.textSite.setText(entidadeBean.getSite());
        this.textCargo.setText(entidadeBean.getCargo());
        if (this.tipoCadastro == 7 && entidadeBean.getIntegracao() != null) {
            this.textIntegracao.setText(StringUtil.getValor(entidadeBean.getIntegracao(), "soc"));
        }
        this.labelDataHoraCadastro.setText(Funcoes.formataData("dd/MM/yyyy HH:mm", entidadeBean.getDataHoraCadastro()));
        if (this.tipoCadastro != 1 && this.tipoCadastro != 7) {
            this.textCelular.setText(entidadeBean.getCelular());
            this.textDataNascimento.setText(entidadeBean.getDataNascimento() != null ? Funcoes.formataData(entidadeBean.getDataNascimento()) : "");
        }
        if (this.tipoCadastro == 1) {
            this.comboTipoFornecedor.setSelectedItem(Tipos.getTipoFornecedor(entidadeBean.getTipoFornecedor()));
            this.txtAreaObs.setText(entidadeBean.getObservacao());
        }
        this.senhaWeb = entidadeBean.getSenhaWeb();
        this.checkInativo.setSelected(entidadeBean.getInativo());
        if (this.comboPessoa.isVisible()) {
            this.comboPessoa.grabFocus();
        } else {
            this.textRazaoSocial.grabFocus();
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textRazaoSocial.getText())) {
            Funcoes.mensagem(this, "Campo raz\u00e3o social n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textRazaoSocial);
            return false;
        }
        if (Funcoes.textoVazio(this.textFantasia.getText())) {
            Funcoes.mensagem(this, "Campo fantasia n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textFantasia);
            return false;
        }
        if (this.comboPessoa.getSelectedItem().toString().equals(Tipos.tipoPessoa("F")) && !Funcoes.textoVazio(this.textCpf.getText()) && !ValidaDoc.checkDoc(this.textCpf.getText(), 8)) {
            Funcoes.mensagem(this, "Campo CPF inv\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCpf);
            return false;
        }
        if (this.comboPessoa.getSelectedItem().toString().equals(Tipos.tipoPessoa("J")) && !Funcoes.textoVazio(this.textCnpj.getText()) && !ValidaDoc.checkDoc(this.textCnpj.getText(), 7)) {
            Funcoes.mensagem(this, "Campo CNPJ inv\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCnpj);
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodCidade.getText()) && this.textDescCidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cidade n\u00e3o localizada", 2);
            ScreenUtil.requisitarFoco(this.textCodCidade);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodCidade.getText())) {
            Funcoes.mensagem(this, "Campo cidade n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textCodCidade);
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodBairro.getText()) && this.textDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Bairro n\u00e3o localizado", 2);
            ScreenUtil.requisitarFoco(this.textCodBairro);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodBairro.getText())) {
            Funcoes.mensagem(this, "Campo bairro n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textCodBairro);
            return false;
        }
        if (!Funcoes.textoVazio(this.textDataNascimento.getText()) && !Funcoes.verificaData(this.textDataNascimento.getText())) {
            Funcoes.mensagem(this, "Campo data de nascimento incorreto", 2);
            ScreenUtil.requisitarFoco(this.textDataNascimento);
            return false;
        }
        if (!Funcoes.textoVazio(this.textCep) && !CEP.tamanhoDoCepCorreto(this.textCep)) {
            Funcoes.mensagem(this, "CEP Inv\u00e1lido", 1);
            this.textCep.grabFocus();
            return false;
        }
        return true;
    }

    private String getDescricaoTipoTela() {
        String retorno = "";
        switch (this.tipoCadastro) {
            case 2: {
                retorno = "Funcion\u00e1rio";
                break;
            }
            case 3: {
                retorno = "Coletador";
                break;
            }
            case 4: {
                retorno = "Representante";
                break;
            }
            case 6: {
                retorno = "Respons\u00e1vel";
                break;
            }
            case 5: {
                retorno = "Fiscal";
                break;
            }
            case 7: {
                retorno = "Empresa";
                break;
            }
            default: {
                retorno = "Fornecedor";
            }
        }
        return retorno;
    }

    @Override
    public void defineAcessos() {
        int tipo = this.tipoCadastro;
        long inserir = auxAcessos[tipo - 1] + 104000101L;
        long editar = auxAcessos[tipo - 1] + 104000102L;
        long excluir = auxAcessos[tipo - 1] + 104000103L;
        this.setModuloAcesso(Entidade.getModuloAcesso(tipo));
        this.setModuloInsere(inserir);
        this.setModuloEdita(editar);
        this.setModuloApaga(excluir);
    }

    public static long getModuloAcesso(int tipo) {
        return auxAcessos[tipo - 1] + 104000100L;
    }

    @Override
    public void novo() {
        super.novo();
        if (this.comboPessoa.isVisible()) {
            ScreenUtil.requisitarFoco(this.comboPessoa);
        } else {
            ScreenUtil.requisitarFoco(this.textRazaoSocial);
        }
    }

    @Override
    public void editar() {
        super.editar();
        if (this.textRazaoSocial.isEnabled()) {
            ScreenUtil.requisitarFoco(this.textRazaoSocial);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaBairro) {
            this.buscaBairro();
        } else if (e.getSource() == this.buttonBuscaCidade) {
            this.buscaCidade();
        } else if (e.getSource() == this.buttonBuscaData) {
            Funcoes.mostraData(this.textDataNascimento, this.buttonBuscaData, this.painelCentral, true);
        } else if (e.getSource() == this.buttonSenhaWeb) {
            this.senhaWeb();
        } else if (e.getSource() == this.bBuscaCep) {
            CEP.buscarCEP(this.comboTipoLogradouro, this.textCep, this.textEndereco, this.textCodCidade, this.textDescCidade, this.textCodBairro, this.textDescBairro, this);
            ScreenUtil.requisitarFoco(this.textCep);
        } else if (e.getSource() == this.comboPessoa) {
            this.textCnpj.clear();
            this.textCpf.clear();
            if (this.comboPessoa.getSelectedItem().toString().equals(Tipos.tipoPessoa("F"))) {
                this.labelCNPJ.setText("CPF:");
                this.labelIE.setText("RG:");
                this.textCpf.setVisible(true);
                this.textCnpj.setVisible(false);
            } else {
                this.labelCNPJ.setText("CNPJ:");
                this.labelIE.setText("IE:");
                this.textCpf.setVisible(false);
                this.textCnpj.setVisible(true);
            }
        } else if (e.getSource() == this.buttonHistoricoPesquisaFornecedor) {
            this.mostraHistoricoPesquisaFornecedor();
        }
    }

    private void mostraHistoricoPesquisaFornecedor() {
        if (this.entidadeAux == null) {
            return;
        }
        VisualizarPesquisaFornecedor visualizaHistorico = new VisualizarPesquisaFornecedor((Frame)Laboratorio.getInstancia(), this.entidadeAux);
        visualizaHistorico.setVisible(true);
    }

    private boolean existeNotaFiscalEntrada() {
        if (this.entidadeAux == null) {
            return false;
        }
        NotaFiscalService serviceNota = new NotaFiscalService();
        ArrayList<Object[]> listaNotas = null;
        try {
            listaNotas = serviceNota.buscaNotasFiscaisCadastroFornecedor(Variaveis.filialPadrao, this.entidadeAux.getCodigo().toString(), this.entidadeAux.getTipo(), Conexao.getStatement(), false);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar notas fiscais do fornecedor." + e.getMessage(), e.getStackTrace());
        }
        return listaNotas != null && listaNotas.size() > 0;
    }

    private void senhaWeb() {
        SenhaWeb senha = SenhaWeb.novaInstancia(this.getTopLevelAncestor(), true);
        if (Funcoes.textoVazio(this.senhaWeb)) {
            this.senhaWeb = Funcoes.gerarSenhaWeb();
        }
        if (senha != null) {
            senha.setSenha(this.senhaWeb);
            senha.setVisible(true);
            if (senha.getSalvarPressionado()) {
                this.senhaWeb = senha.getSenha();
            }
            senha = null;
        } else {
            Funcoes.mensagem(this.getTopLevelAncestor(), "Senha web:" + this.senhaWeb, 3);
        }
    }

    private void buscaBairro() {
        BairroVO bairroVO = new BairroVO();
        bairroVO = (BairroVO)this.bairroService.pesquisaVO(this.getTopLevelAncestor(), bairroVO, "Pesquisando bairro", true);
        if (bairroVO != null) {
            this.textCodBairro.setText(String.valueOf(bairroVO.getCodigo()));
            this.textDescBairro.setText(bairroVO.getDescricao());
        }
    }

    private void buscaCidade() {
        CidadeVO cidadeVO = new CidadeVO();
        cidadeVO = (CidadeVO)this.cidadeService.pesquisaVO(this.getTopLevelAncestor(), cidadeVO, "Pesquisando cidade", true);
        if (cidadeVO != null) {
            this.textCodCidade.setText(String.valueOf(cidadeVO.getCodigo()));
            this.textDescCidade.setText(cidadeVO.getNome() + " (" + cidadeVO.getUf() + ")");
        }
    }

    private void buscaDadosCidade() throws Exception {
        if (!Funcoes.textoVazio(this.textCodCidade.getText())) {
            CidadeVO cidadeVO = (CidadeVO)this.cidadeService.getVO(this.textCodCidade.getText());
            if (cidadeVO != null) {
                this.textCodCidade.setText(String.valueOf(cidadeVO.getCodigo()));
                this.textDescCidade.setText(cidadeVO.getNome() + " (" + cidadeVO.getUf() + ")");
            } else {
                this.textDescCidade.setText("N\u00e3o cadastrado");
            }
        }
    }

    private void buscaDadosBairro() throws Exception {
        if (!Funcoes.textoVazio(this.textCodBairro.getText())) {
            BairroVO bairroVO = (BairroVO)this.bairroService.getVO(this.textCodBairro.getText());
            if (bairroVO != null) {
                this.textCodBairro.setText(String.valueOf(bairroVO.getCodigo()));
                this.textDescBairro.setText(bairroVO.getDescricao());
            } else {
                this.textDescBairro.setText("N\u00e3o cadastrado");
            }
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodBairro.hasFocus()) {
            this.buscaBairro();
        } else if (this.textCodCidade.hasFocus()) {
            this.buscaCidade();
        } else if (this.textDataNascimento.hasFocus()) {
            Funcoes.mostraData(this.textDataNascimento, this.buttonBuscaData, this.painelCentral, true);
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ent_codigo";
    }
}

