/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.material.EmbalagemRecebidaBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.material.EmbalagemRecebidaVO;
import jalis.service.cadastro.material.EmbalagemRecebidaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EmbalagemRecebida
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textCodigo = new TTextField(2, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private String retornoParaPesquisa = "";

    public EmbalagemRecebida() {
        this.setName("EmbalagemRecebida");
        this.setLabelDescricao("Cadastro de embalagens utilizadas para acomodar os produtos recebidos para an\u00e1lises");
        this.setLabelFormulario("Cadastro de embalagens recebidas");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/embalagens_recebidas.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        this.textCodigo.setUpperCase(true);
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.service = new EmbalagemRecebidaService();
        this.controlaCampos();
        Funcoes.defineUpperCase(this.painelCentral, ParametrosGerais.getUpperCase());
    }

    @Override
    protected void controlaCampos() {
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        EmbalagemRecebidaBean bean = new EmbalagemRecebidaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaEmbalagemProduto();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new EmbalagemRecebidaVO(), "Pesquisando embalagens recebidas", false);
            if (vo != null) {
                EmbalagemRecebidaBean embalagemBean = (EmbalagemRecebidaBean)this.service.voToBean((EmbalagemRecebidaVO)vo, EmbalagemRecebidaBean.class);
                return embalagemBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EmbalagemRecebida:130");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        EmbalagemRecebidaBean embalagemBean = (EmbalagemRecebidaBean)bean;
        this.textCodigo.setText(Integer.toString(embalagemBean.getCodigo()));
        this.textDescricao.setText(embalagemBean.getDescricao());
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        if (!Funcoes.textoVazio(this.textDescricao.getText())) {
            return true;
        }
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchida", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        return false;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(EmbalagemRecebida.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101300401"));
        this.setModuloEdita(Long.parseLong("0101300402"));
        this.setModuloApaga(Long.parseLong("0101300403"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300400");
    }

    @Override
    public void editar() {
        super.editar();
        if (this.textDescricao.isFocusable() && this.textDescricao.isEnabled()) {
            ScreenUtil.requisitarFoco(this.textDescricao);
        }
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((EmbalagemRecebidaBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "EmbalagemRecebida:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "emb_codigo";
    }
}

