/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.cadastro.Atributos;
import jalis.laboratorio.cadastro.Historico;
import jalis.laboratorio.configurador.Constantes;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;

class DocumentoStyledHistorico
extends DefaultStyledDocument {
    public static final String REGEX_TAGS_HTML = "\\<.[html]*[b]*[i]*[u]*[sup]*[sub]*\\>";
    private int maxLength = 0;
    private JTextPane editor = null;

    public DocumentoStyledHistorico(JTextPane editor) {
        this.editor = editor;
    }

    @Override
    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        if (this.maxLength > 0 && this.getLength() + length > this.maxLength) {
            return;
        }
        super.setCharacterAttributes(offset, length, s, replace);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        int strTotal;
        int lenght = 0;
        try {
            if (this.editor != null) {
                lenght = Historico.descricao2Texto(this.editor).length();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.maxLength > 0 && (strTotal = lenght + str.length()) > this.maxLength) {
            int posicaoFinal = Math.abs(strTotal - this.maxLength - str.length());
            str = str.substring(0, posicaoFinal);
        }
        SimpleAttributeSet s = new SimpleAttributeSet(a);
        StringBuilder buf = new StringBuilder(str);
        ArrayList<Atributos> aplicar = new ArrayList<Atributos>();
        if (str.indexOf("<html>") > -1) {
            buf.delete(0, 6);
            buf.delete(buf.length() - 7, buf.length());
            boolean abriu = false;
            String tag = "";
            int posicaoAbriu = -1;
            int posicaoFechou = -1;
            int posicaoAtual = 0;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (String.valueOf(c).equals("<") && !abriu) {
                    posicaoAbriu = posicaoAtual;
                    abriu = true;
                    continue;
                }
                if (String.valueOf(c).equals(">") && abriu) {
                    if (Constantes.estilos.containsKey(tag) && Constantes.estilos.get(tag) != null) {
                        Atributos at = new Atributos();
                        at.posicaoInicial = posicaoAbriu;
                        at.estilo = Constantes.estilos.get(tag);
                        aplicar.add(at);
                    }
                    posicaoAbriu = -1;
                    abriu = false;
                    tag = "";
                    continue;
                }
                if (abriu) {
                    int pos;
                    if ((tag = tag + String.valueOf(c)).length() > 4) {
                        tag = "";
                        posicaoAbriu = -1;
                        abriu = false;
                        continue;
                    }
                    if (tag.length() == 2 && tag.indexOf("/") > -1 && Constantes.estilos.containsKey(tag.substring(1))) {
                        int pos2 = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)));
                        if (pos2 <= -1) continue;
                        aplicar.get((int)pos2).posicaoFinal = posicaoAbriu;
                        continue;
                    }
                    if (tag.length() != 4 || tag.indexOf("/") <= -1 || !Constantes.estilos.containsKey(tag.substring(1)) || (pos = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)))) <= -1) continue;
                    aplicar.get((int)pos).posicaoFinal = posicaoAbriu;
                    continue;
                }
                ++posicaoAtual;
            }
        }
        super.insertString(offset, buf.toString().replaceAll(REGEX_TAGS_HTML, ""), s);
        for (Atributos at : aplicar) {
            SimpleAttributeSet mat = new SimpleAttributeSet();
            mat.addAttribute(at.estilo, Boolean.TRUE);
            this.setCharacterAttributes(at.posicaoInicial, at.posicaoFinal - at.posicaoInicial, mat, false);
        }
    }

    private int achaPosicaoTagAberta(ArrayList<Atributos> lista, Object estilo) {
        int retorno = -1;
        for (int i = lista.size() - 1; i >= 0; --i) {
            Atributos a = lista.get(i);
            if (!a.estilo.equals(estilo) || a.posicaoFinal != -1) continue;
            return i;
        }
        return retorno;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

