/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class DialogoPortes
extends AbstractDialogoOKCancelar {
    private JLabel labelPorte = new JLabel("Porte");
    private JLabel labelValor = new JLabel("Valor");
    private TTextField textPorte = new TTextField(3);
    private TTextField textValor = new TTextField(8, 2, 2);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("OK", 'K', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Porte", "Valor"});
    private JTable tabela = new JTable(this.modelo);
    private Map<String, PorteTabelaCBHPM> removidos = new HashMap<String, PorteTabelaCBHPM>();

    public DialogoPortes(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public DialogoPortes(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public static DialogoPortes novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoPortes((Frame)pai, "Portes CBHPM");
        }
        return new DialogoPortes((Dialog)pai, "Portes CBHPM");
    }

    private void montaTela() {
        this.setSize(new Dimension(200, 400));
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.modelo.setColumnSize(new int[]{40, 0}, this.tabela);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        panel.add((Component)this.labelPorte, c);
        c.gridx = 1;
        panel.add((Component)this.labelValor, c);
        c.gridx = 0;
        c.gridy = 1;
        this.textPorte.setPreferredSize(new Dimension(69, 20));
        this.textPorte.setMinimumSize(new Dimension(69, 20));
        panel.add((Component)this.textPorte, c);
        c.gridx = 2;
        this.buttonAdicionar.setPreferredSize(new Dimension(40, 20));
        this.buttonAdicionar.setMinimumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonAdicionar, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.textValor.setPreferredSize(new Dimension(69, 20));
        this.textValor.setMinimumSize(new Dimension(69, 20));
        panel.add((Component)this.textValor, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridwidth = 3;
        panel.add((Component)new JScrollPane(this.tabela), c);
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    DialogoPortes.this.editarLinha(DialogoPortes.this.tabela.getSelectedRow());
                } else if (e.getKeyCode() == 127 && DialogoPortes.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(DialogoPortes.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    String porte = (String)DialogoPortes.this.modelo.getValueAt(DialogoPortes.this.tabela.getSelectedRow(), 0);
                    double valor = Double.parseDouble(Funcoes.limpaDecimal((String)DialogoPortes.this.modelo.getValueAt(DialogoPortes.this.tabela.getSelectedRow(), 1)));
                    DialogoPortes.this.removidos.put(porte, new PorteTabelaCBHPM(porte, valor));
                    DialogoPortes.this.modelo.removeLine(DialogoPortes.this.tabela.getSelectedRow());
                }
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DialogoPortes.this.editarLinha(DialogoPortes.this.tabela.getSelectedRow());
                }
            }
        });
        ScreenUtil.requisitarFoco(this.tabela);
    }

    public Map<String, PorteTabelaCBHPM> getRemovidos() {
        return this.removidos;
    }

    private void editarLinha(int linha) {
        if (linha < this.modelo.getRowCount()) {
            this.textPorte.setText(this.modelo.getValueAt(linha, 0).toString());
            this.textValor.setText(this.modelo.getValueAt(linha, 1).toString());
            this.textPorte.setEnabled(false);
            this.textValor.selectAll();
            ScreenUtil.requisitarFoco(this.textValor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAdicionar) {
            this.novoPorte();
        } else {
            super.actionPerformed(e);
        }
    }

    private void novoPorte() {
        String porte = this.textPorte.getText();
        double valor = Funcoes.isNumeric(this.textValor.getText()) ? Double.parseDouble(this.textValor.getText()) : 0.0;
        int pos = -1;
        if (Funcoes.textoVazio(porte)) {
            Funcoes.mensagem(this, "Campo Porte n\u00e3o informado", 2);
        } else {
            pos = this.modelo.localizar(0, porte);
            if (pos > -1) {
                this.modelo.setValueAt(Funcoes.formataDecimal(valor), pos, 1);
            } else {
                this.modelo.addLine(new String[]{porte, Funcoes.formataDecimal(valor)});
            }
            this.textPorte.clear();
            this.textValor.clear();
            if (!this.textPorte.isEnabled()) {
                this.textPorte.setEnabled(true);
            }
            ScreenUtil.requisitarFoco(this.textPorte);
        }
    }

    public void setPortes(ArrayList<PorteTabelaCBHPM> portes) {
        this.modelo.clear();
        for (PorteTabelaCBHPM p : portes) {
            this.modelo.addLine(new String[]{p.getPorte(), Funcoes.formataDecimal(p.getValor())});
        }
    }

    public ArrayList<PorteTabelaCBHPM> getPortes() {
        ArrayList<PorteTabelaCBHPM> retorno = new ArrayList<PorteTabelaCBHPM>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!Funcoes.isNumeric(this.modelo.getValueAt(i, 1).toString())) continue;
            retorno.add(new PorteTabelaCBHPM(this.modelo.getValueAt(i, 0).toString(), Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 1).toString()))));
        }
        return retorno;
    }
}

