/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class DialogoFiltroConvenio
extends DialogoFiltro {
    private static final String TITULO = "Selecionando Conv\u00eanio";
    private Map<String, String> convenioCodigoDescricao = new HashMap<String, String>();
    private StringBuilder filiaisSelecionadas = new StringBuilder();

    public DialogoFiltroConvenio(Dialog pai, String filtroConvenio, String filialSelecionada) {
        super(pai, TITULO, true);
        this.setDados(filtroConvenio, filialSelecionada);
        this.setVisible(true);
    }

    public DialogoFiltroConvenio(Frame pai, String filtroConvenio, String filialSelecionada) {
        super(pai, TITULO, true);
        this.setDados(filtroConvenio, filialSelecionada);
        this.setVisible(true);
    }

    public static DialogoFiltroConvenio novaInstancia(Component pai, String filtroConvenio, String filiaisSelecionada) {
        return pai instanceof Frame ? new DialogoFiltroConvenio((Frame)pai, filtroConvenio, filiaisSelecionada) : new DialogoFiltroConvenio((Dialog)pai, filtroConvenio, filiaisSelecionada);
    }

    protected void setDados(String filtroConvenio, String filialSelecionada) {
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        if (!Funcoes.textoVazio(filtroConvenio)) {
            map.put(0, filtroConvenio.split(","));
        }
        this.setDados(map, "convenios", new String[]{"con_codigo", "con_razao"}, new String[]{"C\u00f3digo", "Fastasia"}, new int[]{70, 0}, "fil_codigo = " + filialSelecionada);
    }

    private String[] getConvenioCodigo() {
        return this.getSelecionados(0);
    }

    private String[] getConvenioDescricao() {
        return this.getSelecionados(1);
    }

    public void marcarOk() {
        this.filiaisSelecionadas = new StringBuilder();
        if (this.getConvenioCodigo() != null && this.getConvenioCodigo().length > 0) {
            for (int i = 0; i < this.getConvenioCodigo().length; ++i) {
                this.convenioCodigoDescricao.put(this.getConvenioCodigo()[i], this.getConvenioDescricao()[i]);
                this.filiaisSelecionadas.append(this.getConvenioCodigo()[i]).append(i < this.getConvenioCodigo().length - 1 ? "," : "");
            }
        }
    }

    public String getConvenioSelecionadas() {
        return this.filiaisSelecionadas.toString();
    }

    public Map<String, String> getMapConvenioCodigoDescricao() {
        return this.convenioCodigoDescricao;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonMarcarTodos) {
            this.marcarDesmarcarTodos(true);
        } else if (o == this.buttonDesmarcarTodos) {
            this.marcarDesmarcarTodos(false);
        } else if (o == this.buttonOk) {
            this.marcarOk();
            this.ok = o == this.buttonOk;
            this.setVisible(false);
        } else if (o == this.buttonCancelar) {
            this.setVisible(false);
        } else if (o == this.buttonFiltro) {
            this.filtrar();
        }
    }
}

