/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.cadastro.SenhaWeb;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.bean.cadastro.DestinoBean;
import jalis.model.bean.cadastro.TaxaBean;
import jalis.model.bean.cadastro.TaxaDestinoBean;
import jalis.model.vo.cadastro.Cid10VO;
import jalis.model.vo.cadastro.DestinoVO;
import jalis.model.vo.cadastro.TaxaDestinoVO;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.relatorio.Editor;
import jalis.service.cadastro.DestinoService;
import jalis.service.cadastro.TaxaDestinoService;
import jalis.service.cadastro.TaxaService;
import jalis.util.ArraysUtil;
import jalis.util.CEP;
import jalis.util.ComponenteUtils;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.InsetsUIResource;

public class Destino
extends FrmCadPadrao
implements ActionListener {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TTextField txtCidade;
    private JButton jButton1;
    private JButton jButton2;
    private TTextField txtDescCidade;
    private JLabel jLabel4;
    private TTextField txtEndereco;
    private JLabel jLabel5;
    private TTextField txtComplemento;
    private JLabel jLabel6;
    private TTextField txtCodBairro;
    private TTextField txtDescBairro;
    private JLabel jLabel7;
    private TTextField txtCEP;
    private JLabel jLabel8;
    private TTextFieldTelefone txtFone;
    private JPanel panelImpressao;
    private JCheckBox chkImpressao;
    private JLabel jLabel10;
    private JComboBox comboImpressora;
    private JLabel jLabel11;
    private TTextField txtComissao;
    private JLabel jLabel12;
    private JLabel jPercComis;
    private TTextField txtDescontoProducao;
    private TitledBorder tbComissDesc;
    private TTextField textHoraSaida = new TTextField(5, 6);
    private TTextField textHoraSaidaSabado = new TTextField(5, 6);
    private JLabel jPercDesc;
    private JPanel panelDescontoComissao;
    private JCheckBox checkPRP = new JCheckBox("Solicitar PRP");
    private JCheckBox checkComplemento = new JCheckBox("Solicitar complemento do destino na requisi\u00e7\u00e3o");
    private JButton buttonSenhaWeb = ComponenteFactory.novoJButton("Senha web", '\u0000', this);
    private JCheckBox checkWeb = new JCheckBox("Enviar resultados para web");
    private JButton bBuscaCep = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkPermitirConexao = ComponenteFactory.novoJCheckBox("Permitir visualiza\u00e7\u00e3o de resultados na web", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Destino.this.buttonSenhaWeb.setEnabled(Destino.this.checkPermitirConexao.isSelected());
        }
    });
    private JPanel panelWeb = ComponenteFactory.novoJPanel(new GridBagLayout(), null);
    private JButton buttonProtocolo = ComponenteFactory.novoJButton("Protocolo", 'o', this);
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem itemAlterar = ComponenteFactory.novoJMenuItem(this.menu, "Novo/Alterar", 'l', this);
    private JMenuItem itemCopiar = ComponenteFactory.novoJMenuItem(this.menu, "Copiar protocolo", '\u0000', this);
    String protocolo = "";
    String senhaWeb = "";
    private String retornoParaPesquisa = "";
    private boolean isBaseAlimentos = Variaveis.tipoFilialPadrao.equals("A");
    private JTabbedPane abasInferior = new JTabbedPane();
    private JPanel panelTaxas = new JPanel();
    private JPanel panelSMSEmail = new JPanel();
    private JLabel jLabelCodTaxa = new JLabel("C\u00f3digo");
    private JLabel jLabelDescTaxa = new JLabel();
    private JLabel labelHoraSaida = new JLabel("Dias \u00fateis:");
    private JLabel labelHoraSaidaSabado = new JLabel("Dias n\u00e3o \u00fateis:");
    private TTextField textFieldCodTaxa = new TTextField(9, 1);
    private JButton buttonPesqTaxa = ComponenteFactory.novoJButton(this, true);
    private JLabel jLabelVlrDescTaxa = new JLabel();
    private JButton buttonAddTaxa = ComponenteFactory.novoJButton("OK", 'O', this);
    private ModeloGridTable modeloGridTable = null;
    private JTable table = null;
    private JScrollPane scroll = null;
    private TaxaVO taxaVO = new TaxaVO();
    private TaxaBean taxaBean = new TaxaBean();
    private TaxaService serviceTaxa = new TaxaService();
    private Set<TaxaDestinoVO> taxaDestinoVOs = new HashSet<TaxaDestinoVO>();
    private TaxaDestinoVO taxaDestinoVO = new TaxaDestinoVO();
    private DestinoBean destinoBean = new DestinoBean();
    private DestinoService destinoService = new DestinoService();
    private TaxaDestinoService serviceTaxaDestino = new TaxaDestinoService();
    private JPanel panelSMS = new JPanel(new GridBagLayout());
    private JPanel panelEmail = new JPanel(new GridBagLayout());
    private JPanel panelPush = new JPanel(new GridBagLayout());
    private JPanel panelWhatsApp = new JPanel(new GridBagLayout());
    private JCheckBox checkBloquearSMSResultadoPronto = new JCheckBox("N\u00e3o enviar SMS de aviso de resultado pronto");
    private JCheckBox checkBloquearSMSRecoleta = new JCheckBox("N\u00e3o enviar SMS de aviso de recoleta");
    private JCheckBox checkBloquearEmailResultadoPronto = new JCheckBox("N\u00e3o enviar e-mail de aviso de resultado pronto");
    private JCheckBox checkBloquearEmailRecoleta = new JCheckBox("N\u00e3o enviar e-mail de aviso de recoleta");
    private JCheckBox checkBloquearPushResultadoPronto = new JCheckBox("N\u00e3o enviar Push de aviso de resultado pronto");
    private JCheckBox checkBloquearPushRecoleta = new JCheckBox("N\u00e3o enviar Push de aviso de recoleta");
    private JCheckBox checkBloquearWhatsAppResultadoPronto = new JCheckBox("N\u00e3o enviar WhatsApp de aviso de resultado pronto");
    private JCheckBox checkBloquearWhatsAppRecoleta = new JCheckBox("N\u00e3o enviar WhatsApp de aviso de recoleta");

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Destino.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0100700001"));
        this.setModuloEdita(Long.parseLong("0100700002"));
        this.setModuloApaga(Long.parseLong("0100700003"));
    }

    public Destino() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Destino");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodigo.setUpperCase(true);
        this.txtCodBairro.setUpperCase(true);
    }

    public void jbInit() throws Exception {
        this.setName("Destino");
        this.configuraTitulo();
        this.abasInferior.setBounds(new Rectangle(5, 173, 493, 300));
        this.abasInferior.setName("abasInferior");
        this.panelTaxas.setBounds(new Rectangle(5, 156, 493, 75));
        this.panelSMSEmail.setBounds(new Rectangle(5, 156, 493, 75));
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtCidade = new TTextField(5, 1);
        this.txtCidade.setName("txtCidade");
        this.jButton1 = new JButton();
        this.jButton1.setName("jButton1");
        this.jButton2 = new JButton();
        this.jButton2.setName("jButton2");
        this.txtDescCidade = new TTextField(80);
        this.txtDescBairro = new TTextField(80);
        this.jLabel4 = new JLabel();
        this.txtEndereco = new TTextField(80);
        this.txtEndereco.setName("txtEndereco");
        this.jLabel5 = new JLabel();
        this.txtComplemento = new TTextField(50);
        this.txtComplemento.setName("txtComplemento");
        this.jLabel6 = new JLabel();
        this.txtCodBairro = new TTextField(5);
        this.txtCodBairro.setName("txtCodBairro");
        this.jLabel7 = new JLabel();
        this.txtCEP = new TTextField(9, 9);
        this.txtCEP.setName("txtCEP");
        this.jLabel8 = new JLabel();
        this.txtFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
        this.txtFone.setName("txtFone");
        this.jLabel11 = new JLabel();
        this.jPercComis = new JLabel("%");
        this.txtComissao = new TTextField(6, 2);
        this.txtComissao.setName("txtComissao");
        this.jLabel12 = new JLabel();
        this.jPercDesc = new JLabel("%");
        this.txtDescontoProducao = new TTextField(6, 2);
        this.txtDescontoProducao.setName("txtDescontoProducao");
        this.panelDescontoComissao = new JPanel(new GridBagLayout());
        this.panelImpressao = new JPanel();
        this.comboImpressora = new JComboBox();
        this.comboImpressora.setName("comboImpressora");
        this.chkImpressao = new JCheckBox("N\u00e3o imprimir laudos para este destino");
        this.chkImpressao.setName("chkImpressao");
        this.chkImpressao.setMnemonic('N');
        this.jLabel10 = new JLabel("Impressora padr\u00e3o:");
        this.jLabel10.setDisplayedMnemonic('p');
        this.jLabel10.setLabelFor(this.comboImpressora);
        this.chkImpressao.setBounds(126, 28, 300, 20);
        this.chkImpressao.setName("chkImpressao");
        this.comboImpressora.setEditable(true);
        this.comboImpressora.setBounds(new Rectangle(130, 5, 355, 20));
        this.jLabel10.setBounds(new Rectangle(7, 5, 130, 14));
        this.panelImpressao.setLayout(null);
        this.panelImpressao.add(this.jLabel10);
        this.panelImpressao.add(this.comboImpressora);
        this.panelImpressao.add(this.chkImpressao);
        this.chkImpressao.setName("chkImpressao");
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.txtFone);
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(5, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(97, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(5, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Cidade:");
        this.jLabel3.setBounds(new Rectangle(5, 51, 63, 14));
        this.txtCidade.setText("");
        this.txtCidade.setBounds(new Rectangle(97, 49, 69, 20));
        this.jButton1.setBounds(new Rectangle(167, 49, 20, 20));
        this.jButton1.setFocusable(false);
        this.jButton1.setText("");
        Funcoes.imagemPesquisa(this.jButton1);
        this.txtDescCidade.setText("");
        this.txtDescCidade.setEditable(false);
        this.txtDescCidade.setFocusable(false);
        this.txtDescCidade.setBounds(new Rectangle(188, 49, 309, 20));
        this.jLabel4.setText("Endere\u00e7o:");
        this.jLabel4.setBounds(new Rectangle(5, 72, 63, 14));
        this.txtEndereco.setText("");
        this.txtEndereco.setBounds(new Rectangle(97, 70, 400, 20));
        this.jLabel5.setText("Complemento:");
        this.jLabel5.setBounds(new Rectangle(5, 93, 92, 14));
        this.txtComplemento.setText("");
        this.txtComplemento.setBounds(new Rectangle(97, 91, 400, 19));
        this.jLabel6.setText("Bairro:");
        this.jLabel6.setBounds(new Rectangle(5, 114, 63, 14));
        this.txtCodBairro.setText("");
        this.txtCodBairro.setBounds(new Rectangle(97, 112, 69, 20));
        this.jButton2.setBounds(new Rectangle(167, 112, 20, 20));
        this.jButton2.setFocusable(false);
        this.jButton2.setText("");
        Funcoes.imagemPesquisa(this.jButton2);
        this.txtDescBairro.setText("");
        this.txtDescBairro.setEditable(false);
        this.txtDescBairro.setFocusable(false);
        this.txtDescBairro.setBounds(new Rectangle(188, 112, 130, 20));
        this.jLabel7.setBounds(new Rectangle(350, 114, 35, 14));
        this.jLabel7.setText("CEP:");
        this.txtCEP.setBounds(new Rectangle(381, 112, 93, 20));
        this.txtCEP.setText("");
        this.bBuscaCep.setBounds(new Rectangle(476, 112, 20, 20));
        this.bBuscaCep.setFocusable(false);
        this.bBuscaCep.setText("");
        Funcoes.imagemPesquisa(this.bBuscaCep);
        this.jLabel8.setBounds(new Rectangle(5, 135, 63, 14));
        this.jLabel8.setText("Fone:");
        this.txtFone.setBounds(new Rectangle(97, 133, 116, 20));
        this.txtFone.clear();
        JPanel panelHoras = new JPanel(null);
        panelHoras.setBounds(new Rectangle(2, 155, 498, 45));
        panelHoras.setBorder(new TitledBorder("Hor\u00e1rio de entrega"));
        this.labelHoraSaida.setBounds(new Rectangle(8, 18, 100, 20));
        this.textHoraSaida.setBounds(new Rectangle(80, 18, 100, 20));
        panelHoras.add(this.labelHoraSaida);
        panelHoras.add(this.textHoraSaida);
        this.textHoraSaida.setName("textHoraSaida");
        this.labelHoraSaidaSabado.setBounds(new Rectangle(240, 18, 100, 20));
        this.textHoraSaidaSabado.setBounds(new Rectangle(340, 18, 100, 20));
        panelHoras.add(this.labelHoraSaidaSabado);
        panelHoras.add(this.textHoraSaidaSabado);
        this.textHoraSaidaSabado.setName("textHoraSaidaSabado");
        this.checkWeb.setMnemonic('w');
        this.buttonProtocolo.setBounds(new Rectangle(400, 528, 100, 25));
        this.buttonProtocolo.setName("buttonProtocolo");
        this.checkPRP.setBounds(350, 200, 116, 20);
        this.checkPRP.setName("checkPRP");
        this.checkComplemento.setBounds(30, 200, 302, 20);
        this.checkComplemento.setName("checkComplemento");
        this.panelDescontoComissao.setBounds(new Rectangle(5, 325, 493, 70));
        GridBagConstraints bagLayoutComissaoDesconto = new GridBagConstraints();
        bagLayoutComissaoDesconto.gridx = 0;
        bagLayoutComissaoDesconto.gridy = 0;
        bagLayoutComissaoDesconto.weightx = 0.0;
        bagLayoutComissaoDesconto.weighty = 0.0;
        bagLayoutComissaoDesconto.anchor = 17;
        bagLayoutComissaoDesconto.insets = new Insets(1, 0, 0, 1);
        bagLayoutComissaoDesconto.fill = 0;
        this.jLabel11.setText("Comiss\u00e3o:");
        this.panelDescontoComissao.add((Component)this.jLabel11, bagLayoutComissaoDesconto);
        this.txtComissao.setPreferredSize(new Dimension(55, 20));
        this.txtComissao.setMinimumSize(new Dimension(55, 20));
        this.txtComissao.setText("");
        this.txtComissao.setName("txtComissao");
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.txtComissao, bagLayoutComissaoDesconto);
        ++bagLayoutComissaoDesconto.gridx;
        this.jPercComis.setPreferredSize(new Dimension(30, 14));
        this.jPercComis.setMinimumSize(new Dimension(30, 14));
        this.panelDescontoComissao.add((Component)this.jPercComis, bagLayoutComissaoDesconto);
        bagLayoutComissaoDesconto.weightx = 1.0;
        bagLayoutComissaoDesconto.fill = 2;
        this.panelDescontoComissao.add((Component)new JLabel(), bagLayoutComissaoDesconto);
        bagLayoutComissaoDesconto.weightx = 0.0;
        bagLayoutComissaoDesconto.fill = 0;
        this.jLabel12.setText("Desconto de produ\u00e7\u00e3o:");
        bagLayoutComissaoDesconto.gridx = 0;
        ++bagLayoutComissaoDesconto.gridy;
        this.panelDescontoComissao.add((Component)this.jLabel12, bagLayoutComissaoDesconto);
        this.txtDescontoProducao.setPreferredSize(new Dimension(55, 20));
        this.txtDescontoProducao.setMinimumSize(new Dimension(55, 20));
        this.txtDescontoProducao.setText("");
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.txtDescontoProducao, bagLayoutComissaoDesconto);
        this.jPercDesc.setPreferredSize(new Dimension(30, 14));
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.jPercDesc, bagLayoutComissaoDesconto);
        ++bagLayoutComissaoDesconto.gridy;
        bagLayoutComissaoDesconto.weightx = 1.0;
        bagLayoutComissaoDesconto.weighty = 1.0;
        bagLayoutComissaoDesconto.gridwidth = 3;
        bagLayoutComissaoDesconto.fill = 1;
        this.panelDescontoComissao.add((Component)new JLabel(), bagLayoutComissaoDesconto);
        this.panelWeb.setBounds(new Rectangle(5, 248, 493, 75));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 2.0;
        c.anchor = 17;
        this.panelWeb.add((Component)this.checkWeb, c);
        this.checkWeb.setName("checkWeb");
        c.gridy = 1;
        c.weightx = 1.0;
        this.panelWeb.add((Component)this.checkPermitirConexao, c);
        this.checkPermitirConexao.setName("checkPermitirConexao");
        c.anchor = 13;
        c.gridx = 1;
        this.panelWeb.add((Component)this.buttonSenhaWeb, c);
        this.buttonSenhaWeb.setName("buttonSenhaWeb");
        c.weightx = 1.0;
        c.weighty = 1.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        this.panelWeb.add((Component)new JLabel(), c);
        this.panelSMSEmail.add(this.panelSMS);
        this.panelSMSEmail.add(this.panelEmail);
        if (!this.isBaseAlimentos) {
            this.panelSMSEmail.add(this.panelPush);
        }
        this.panelSMSEmail.add(this.panelWhatsApp);
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.panelSMS.add((Component)this.checkBloquearSMSResultadoPronto, gb);
        ++gb.gridy;
        this.panelSMS.add((Component)this.checkBloquearSMSRecoleta, gb);
        this.panelSMS.setBorder(new TitledBorder("SMS"));
        this.panelSMS.setPreferredSize(new Dimension(490, 62));
        this.panelSMS.setVisible(true);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.panelEmail.add((Component)this.checkBloquearEmailResultadoPronto, gb);
        ++gb.gridy;
        this.panelEmail.add((Component)this.checkBloquearEmailRecoleta, gb);
        this.panelEmail.setBorder(new TitledBorder("E-mail"));
        this.panelEmail.setPreferredSize(new Dimension(490, 62));
        this.panelEmail.setVisible(true);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.panelPush.add((Component)this.checkBloquearPushResultadoPronto, gb);
        ++gb.gridy;
        this.panelPush.add((Component)this.checkBloquearPushRecoleta, gb);
        this.panelPush.setBorder(new TitledBorder("Push"));
        this.panelPush.setPreferredSize(new Dimension(490, 62));
        this.panelPush.setVisible(!this.isBaseAlimentos);
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        gb.fill = 2;
        gb.weightx = 1.0;
        this.panelWhatsApp.add((Component)this.checkBloquearWhatsAppResultadoPronto, gb);
        ++gb.gridy;
        this.panelWhatsApp.add((Component)this.checkBloquearWhatsAppRecoleta, gb);
        this.panelWhatsApp.setBorder(new TitledBorder("WhatsApp"));
        this.panelWhatsApp.setPreferredSize(new Dimension(490, 62));
        this.panelWhatsApp.setVisible(true);
        this.panelTaxas.setLayout(new GridBagLayout());
        GridBagConstraints layoutTaxa = new GridBagConstraints();
        layoutTaxa.fill = 13;
        layoutTaxa.anchor = 17;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridy = 0;
        layoutTaxa.weightx = 0.0;
        layoutTaxa.weighty = 0.0;
        layoutTaxa.insets = new Insets(1, 0, 0, 1);
        this.panelTaxas.add((Component)this.jLabelCodTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        ++layoutTaxa.gridx;
        this.panelTaxas.add((Component)this.jLabelDescTaxa, layoutTaxa);
        layoutTaxa.gridx = 0;
        ++layoutTaxa.gridy;
        layoutTaxa.insets = new InsetsUIResource(1, 0, 0, 0);
        this.textFieldCodTaxa.setPreferredSize(new Dimension(80, 20));
        this.textFieldCodTaxa.setMinimumSize(new Dimension(80, 20));
        this.panelTaxas.add((Component)this.textFieldCodTaxa, layoutTaxa);
        this.textFieldCodTaxa.setName("textFieldCodTaxa");
        layoutTaxa.insets = new InsetsUIResource(1, 0, 0, 1);
        ++layoutTaxa.gridx;
        this.buttonPesqTaxa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesqTaxa.setName("buttonPesqTaxa");
        this.buttonPesqTaxa.setMinimumSize(new Dimension(20, 20));
        this.panelTaxas.add((Component)this.buttonPesqTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.jLabelVlrDescTaxa.setPreferredSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setMinimumSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setBorder(new TitledBorder(""));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.fill = 2;
        this.panelTaxas.add((Component)this.jLabelVlrDescTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.buttonAddTaxa.setPreferredSize(new Dimension(40, 20));
        this.buttonAddTaxa.setMinimumSize(new Dimension(40, 20));
        layoutTaxa.weightx = 0.0;
        layoutTaxa.fill = 13;
        this.panelTaxas.add((Component)this.buttonAddTaxa, layoutTaxa);
        this.buttonAddTaxa.setName("buttonAddTaxa");
        this.modeloGridTable = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Autom\u00e1tica"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Integer.class, String.class, Boolean.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{false, false, true};
                return valores[columnIndex];
            }
        };
        this.table = new JTable(this.modeloGridTable);
        this.table.setName("table");
        this.modeloGridTable.setColumnSize(new int[]{72, 0, 70}, this.table);
        this.scroll = new JScrollPane(this.table);
        this.scroll.setPreferredSize(new Dimension(100, 100));
        this.scroll.setMinimumSize(new Dimension(100, 100));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.weighty = 1.0;
        ++layoutTaxa.gridy;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridwidth = 4;
        layoutTaxa.fill = 1;
        this.panelTaxas.add((Component)this.scroll, layoutTaxa);
        this.painelCentral.add((Component)panelHoras, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel8, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel5, null);
        this.painelCentral.add((Component)this.jLabel4, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtFone, null);
        this.painelCentral.add((Component)this.txtCodBairro, null);
        this.painelCentral.add((Component)this.jButton2, null);
        this.painelCentral.add((Component)this.txtDescBairro, null);
        this.painelCentral.add((Component)this.txtComplemento, null);
        this.painelCentral.add((Component)this.txtEndereco, null);
        this.painelCentral.add((Component)this.txtCidade, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jButton1, null);
        this.painelCentral.add((Component)this.txtDescCidade, null);
        this.painelCentral.add(this.jLabel7);
        this.painelCentral.add(this.txtCEP);
        this.painelCentral.add(this.bBuscaCep);
        this.painelCentral.add(this.checkComplemento);
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.painelCentral.add(this.checkPRP);
        }
        this.painelCentral.add(this.panelDescontoComissao);
        this.painelCentral.add(this.buttonProtocolo);
        JPanel panelAbas = new JPanel(null);
        this.abasInferior.setPreferredSize(new Dimension(498, 318));
        this.abasInferior.setName("abasInferior");
        panelAbas.setBounds(new Rectangle(1, 50, 500, 500));
        this.abasInferior.add((Component)this.panelImpressao, "Impress\u00e3o");
        this.abasInferior.add((Component)this.panelWeb, "Internet");
        this.abasInferior.add((Component)this.panelDescontoComissao, "Comiss\u00e3o/Desconto");
        this.abasInferior.add((Component)this.panelTaxas, "Taxas");
        this.abasInferior.add((Component)this.panelSMSEmail, "Envios autom\u00e1ticos");
        panelAbas.add(this.abasInferior);
        this.painelCentral.add(panelAbas);
        this.comboImpressora.removeAllItems();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        this.comboImpressora.addItem("Impressora local");
        for (int i = 0; i < printService.length; ++i) {
            this.comboImpressora.addItem(printService[i].getName());
        }
        this.controlaCampos();
        this.textFieldCodTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Destino.this.buttonPesqTaxa.doClick();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(Destino.this.painelCentral, "Deseja remover a taxa da composi\u00e7\u00e3o ?", 4)) == 0) {
                    Destino.this.modeloGridTable.removeLine(row);
                    Destino.this.ordenarTabelaTaxa();
                }
            }
        });
        this.textFieldCodTaxa.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    Destino.this.jLabelVlrDescTaxa.setText("");
                    if (!Funcoes.textoVazio(Destino.this.textFieldCodTaxa.getText())) {
                        Destino.this.taxaVO = (TaxaVO)Destino.this.serviceTaxa.getVO(Variaveis.filialPadrao, Destino.this.textFieldCodTaxa.getText());
                        if (Destino.this.taxaVO != null) {
                            Destino.this.textFieldCodTaxa.setText(Destino.this.taxaVO.getCodigo().toString());
                            Destino.this.jLabelVlrDescTaxa.setText(Destino.this.taxaVO.getDescricao());
                        } else {
                            Destino.this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
                            Destino.this.textFieldCodTaxa.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(Destino.this.painelCentral, "N\u00e3o foi poss\u00edvel consultar setor.", 1);
                }
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Destino.this.buscaCidade();
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Destino.this.buscaBairro();
            }
        });
        this.bBuscaCep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CEP.buscarCEP(null, Destino.this.txtCEP, Destino.this.txtEndereco, Destino.this.txtCidade, Destino.this.txtDescCidade, Destino.this.txtCodBairro, Destino.this.txtDescBairro, Destino.this);
            }
        });
        this.txtCEP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CEP.buscarCEP(null, Destino.this.txtCEP, Destino.this.txtEndereco, Destino.this.txtCidade, Destino.this.txtDescCidade, Destino.this.txtCodBairro, Destino.this.txtDescBairro, Destino.this);
                }
            }
        });
        this.txtCEP.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean validaCEP;
                if (!Funcoes.textoVazio(Destino.this.txtCEP) && e.getOppositeComponent() != null && e.getOppositeComponent().getParent() == Destino.this.txtCEP.getParent() && !(validaCEP = CEP.cepValido(Destino.this.txtCEP))) {
                    ScreenUtil.requisitarFoco(Destino.this.txtCEP);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.txtCidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Destino.this.txtCidade.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select cid_nome, cid_uf from cidades where fil_codigo = " + Variaveis.filialPadrao + " and cid_codigo=" + Destino.this.txtCidade.getText());
                        if (rs.next()) {
                            Destino.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                        } else {
                            Destino.this.txtDescCidade.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Destino.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Destino.this.setStatus(1);
                        Destino.this.controlaCampos();
                    }
                }
            }
        });
        this.txtCodBairro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (Destino.this.txtCodBairro.getText().trim().length() > 0) {
                        Statement st = Conexao.getStatement();
                        if (st != null) {
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select bai_descricao from bairro where fil_codigo = " + Variaveis.filialPadrao + " and upper(bai_codigo)=upper(" + Destino.this.txtCodBairro.getTextDBEscape() + ")");
                                if (rs.next()) {
                                    Destino.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                    break block6;
                                }
                                Destino.this.txtDescBairro.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(Destino.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                                Destino.this.setStatus(1);
                                Destino.this.controlaCampos();
                            }
                        }
                    } else {
                        Destino.this.txtDescBairro.setText("");
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Destino.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            boolean isExisteHoraSaida = DBUtil.campoExiste(st, "destino", "des_horasaida") && DBUtil.campoExiste(st, "destino", "des_horasaidasabado");
                            StringBuilder buf = new StringBuilder("select a.des_descricao, a.cid_codigo, a.des_cep, a.des_endereco, a.des_cep, ");
                            buf.append(" a.des_complemento, a.des_fone, b.cid_nome, b.cid_uf, c.bai_descricao, a.bai_codigo, a.des_impressora, a.des_solicitarcomplemento, ");
                            buf.append(" a.des_naoimprimir, a.des_enviarweb, a.des_protocolo, a.des_conectarweb, a.des_senhaweb, a.des_solicitarprp, a.des_comissao , a.des_descontoproducao, ");
                            buf.append(" a.des_bloquearsmsexamepronto, a.des_bloquearsmsrecoleta, a.des_bloquearemailexamepronto, a.des_bloquearemailrecoleta, ");
                            buf.append(" a.des_bloquearpushexamepronto, a.des_bloquearpushrecoleta, des_bloquearwhatsappexamepronto, des_bloquearwhatsapprecoleta ");
                            if (isExisteHoraSaida) {
                                buf.append(", a.des_horasaida, a.des_horasaidasabado ");
                            }
                            buf.append(" from destino a ");
                            buf.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo=b.cid_codigo ");
                            buf.append(" left  join bairro c on a.fil_codigo = c.fil_codigo and upper(a.bai_codigo)=upper(c.bai_codigo) ");
                            buf.append(" where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(a.des_codigo)=upper(");
                            buf.append(Destino.this.txtCodigo.getTextDBEscape());
                            buf.append(") ");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                if (Destino.this.getStatus() == 2) {
                                    Destino.this.setStatus(3);
                                }
                                Destino.this.txtDescricao.setText(rs.getString("des_descricao"));
                                Destino.this.txtCidade.setText(rs.getString("cid_codigo"));
                                if (!DBUtil.campoNull(rs.getString("cid_nome"))) {
                                    Destino.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                                }
                                Destino.this.txtEndereco.setText(rs.getString("des_endereco"));
                                Destino.this.txtComplemento.setText(rs.getString("des_complemento"));
                                Destino.this.txtCodBairro.setText(rs.getString("bai_codigo"));
                                Destino.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                Destino.this.txtCEP.setText(rs.getString("des_cep"));
                                Destino.this.txtFone.setText(rs.getString("des_fone"));
                                Destino.this.checkWeb.setSelected(rs.getBoolean("des_enviarweb"));
                                Destino.this.comboImpressora.setSelectedItem(rs.getString("des_impressora"));
                                Destino.this.chkImpressao.setSelected(rs.getBoolean("des_naoimprimir"));
                                Destino.this.checkPermitirConexao.setSelected(rs.getBoolean("des_conectarweb"));
                                Destino.this.checkPRP.setSelected(rs.getBoolean("des_solicitarprp"));
                                Destino.this.checkComplemento.setSelected(rs.getBoolean("des_solicitarcomplemento"));
                                Destino.this.protocolo = rs.getString("des_protocolo");
                                Destino.this.senhaWeb = rs.getString("des_senhaweb");
                                Destino.this.txtComissao.setText(rs.getString("des_comissao") == null ? "" : Funcoes.formataDecimal(Destino.this.txtComissao.getMaskDecimal(), rs.getDouble("des_comissao")));
                                Destino.this.txtDescontoProducao.setText(rs.getString("des_descontoproducao") == null ? "" : Funcoes.formataDecimal(Destino.this.txtDescontoProducao.getMaskDecimal(), rs.getDouble("des_descontoproducao")));
                                Destino.this.checkBloquearEmailRecoleta.setSelected(rs.getBoolean("des_bloquearemailrecoleta"));
                                Destino.this.checkBloquearEmailResultadoPronto.setSelected(rs.getBoolean("des_bloquearemailexamepronto"));
                                Destino.this.checkBloquearSMSRecoleta.setSelected(rs.getBoolean("des_bloquearsmsrecoleta"));
                                Destino.this.checkBloquearSMSResultadoPronto.setSelected(rs.getBoolean("des_bloquearsmsexamepronto"));
                                Destino.this.checkBloquearPushRecoleta.setSelected(rs.getBoolean("des_bloquearpushrecoleta"));
                                Destino.this.checkBloquearPushResultadoPronto.setSelected(rs.getBoolean("des_bloquearpushexamepronto"));
                                Destino.this.checkBloquearWhatsAppResultadoPronto.setSelected(rs.getBoolean("des_bloquearwhatsappexamepronto"));
                                Destino.this.checkBloquearWhatsAppRecoleta.setSelected(rs.getBoolean("des_bloquearwhatsapprecoleta"));
                                if (isExisteHoraSaida) {
                                    Destino.this.textHoraSaida.setText(rs.getString("des_horasaida"));
                                    Destino.this.textHoraSaidaSabado.setText(rs.getString("des_horasaidasabado"));
                                }
                                Destino.this.buttonSenhaWeb.setEnabled(Destino.this.checkPermitirConexao.isSelected());
                                Destino.this.txtCodigo.setEnabled(false);
                                try {
                                    Set taxaDestinoBeans = Destino.this.serviceTaxaDestino.load(" where des_codigo = " + StringUtil.textoDBEscape(Destino.this.txtCodigo.getText()) + " and fil_codigo = " + Variaveis.filialPadrao);
                                    for (TaxaDestinoBean taxaDestinoBean : taxaDestinoBeans) {
                                        Destino.this.modeloGridTable.addLine(new Object[]{taxaDestinoBean.getTaxa().getCodigo(), taxaDestinoBean.getTaxa().getDescricao(), taxaDestinoBean.getAutomatica(), taxaDestinoBean.getTaxa()});
                                    }
                                    Destino.this.ordenarTabelaTaxa();
                                }
                                catch (Exception ex) {
                                    ErrorLogger.mostraMensagem(Destino.this.getTopLevelAncestor(), "Erro ao buscar a lista de taxas do registro de destino.", ex.getStackTrace());
                                }
                            } else if (Destino.this.getStatus() == 3) {
                                Funcoes.mensagem(Destino.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Destino.this.setStatus(1);
                                Destino.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Destino.this, sqlex.getMessage(), sqlex.getStackTrace(), "Destino");
                    }
                }
            }
        });
    }

    private void configuraTitulo() {
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.setLabelDescricao("Cadastro de modalidades da requisi\u00e7\u00e3o");
            this.setLabelFormulario("Cadastro de modalidades");
        } else {
            this.setLabelDescricao("Cadastro de destino de exames");
            this.setLabelFormulario("Cadastro de destinos");
        }
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_destino.jpg"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.destino(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("des_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(5, 3));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("des_codigo", this.txtCodigo.getText());
                    chaves.put("fil_codigo", Variaveis.filialPadrao);
                    DestinoBean destinoBean = (DestinoBean)this.destinoService.getBean(chaves);
                    destinoBean.setTaxaDestinoVOsModelo(this.getTaxaDestinoVOsModelo());
                    this.destinoService.delete(destinoBean, destinoBean.getCodigo(), Variaveis.filialPadrao, ParametrosGerais.getCopiaDestino());
                    String[] comando = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoDestino", this.txtCodigo.getText()};
                    if (Variaveis.exportarWebFilial) {
                        DBUtil.insereExportaWeb(statement, "destinos", "D", ParametrosGerais.getCopiaDestino(), comando);
                    }
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao efetuar a opera\u00e7\u00e3o no banco de dados", 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(5, 18));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCidade.setText(String.valueOf(ParametrosGerais.getCidCodigo()));
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                if (Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 2) {
                    this.senhaWeb = Funcoes.gerarSenhaWeb();
                } else if (this.checkPermitirConexao.isSelected() && Funcoes.textoVazio(this.senhaWeb) && this.getStatus() == 3 && Funcoes.mensagem(this, "A senha web n\u00e3o foi definida, deseja gerar uma senha autom\u00e1tica?", 4) == 0) {
                    this.senhaWeb = Funcoes.gerarSenhaWeb();
                }
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                Cid10VO cid10vo = new Cid10VO();
                cid10vo.setCodigo(this.txtCidade.getText());
                BairroVO bairroVO = new BairroVO();
                bairroVO.setCodigo(this.txtCodBairro.getText());
                this.destinoBean.setBairro(bairroVO);
                this.destinoBean.setCep(this.txtCEP.getText());
                this.destinoBean.setCid(cid10vo);
                this.destinoBean.setCodigo(this.txtCodigo.getText());
                this.destinoBean.setComissao(Double.valueOf(!Funcoes.textoVazio(this.txtComissao.getText()) ? Funcoes.limpaDecimal(this.txtComissao.getText()) : "0"));
                this.destinoBean.setComplemento(this.txtComplemento.getText());
                this.destinoBean.setConectarWeb(this.checkPermitirConexao.isSelected());
                this.destinoBean.setDescontoProducao(Double.parseDouble(!Funcoes.textoVazio(this.txtDescontoProducao.getText()) ? Funcoes.limpaDecimal(this.txtDescontoProducao.getText()) : "0"));
                this.destinoBean.setDescricao(this.txtDescricao.getText());
                this.destinoBean.setEnderecoDestino(this.txtEndereco.getText());
                this.destinoBean.setEnviarWeb(this.checkWeb.isSelected());
                this.destinoBean.setFilial(filial);
                this.destinoBean.setFoneDestino(this.txtFone.getText());
                this.destinoBean.setImpressoraDestino(this.comboImpressora.getSelectedItem() != null ? this.comboImpressora.getSelectedItem().toString() : "");
                this.destinoBean.setNaoImprimir(this.chkImpressao.isSelected());
                this.destinoBean.setProtocolo(this.protocolo);
                this.destinoBean.setSenhaWeb(this.senhaWeb);
                this.destinoBean.setSolicitarComplemento(this.checkComplemento.isSelected());
                this.destinoBean.setSolicitarPrp(this.checkPRP.isSelected());
                this.destinoBean.setTaxaDestinoVOsModelo(this.getTaxaDestinoVOsModelo());
                this.destinoBean.setBloquearEmailExamePronto(this.checkBloquearEmailResultadoPronto.isSelected());
                this.destinoBean.setBloquearEmailRecoleta(this.checkBloquearEmailRecoleta.isSelected());
                this.destinoBean.setBloquearSMSExamePronto(this.checkBloquearSMSResultadoPronto.isSelected());
                this.destinoBean.setBloquearSMSRecoleta(this.checkBloquearSMSRecoleta.isSelected());
                this.destinoBean.setBloquearPushExamePronto(this.checkBloquearPushResultadoPronto.isSelected());
                this.destinoBean.setBloquearPushRecoleta(this.checkBloquearPushRecoleta.isSelected());
                this.destinoBean.setBloquearWhatsAppExamePronto(this.checkBloquearWhatsAppResultadoPronto.isSelected());
                this.destinoBean.setBloquearWhatsAppRecoleta(this.checkBloquearWhatsAppRecoleta.isSelected());
                if (this.getStatus() == 2) {
                    this.destinoService.insert(this.destinoBean, this.txtCodigo.getText(), Variaveis.filialPadrao, ParametrosGerais.getCopiaDestino());
                }
                if (this.getStatus() == 3) {
                    this.destinoService.update(this.destinoBean, this.txtCodigo.getText(), Variaveis.filialPadrao, ParametrosGerais.getCopiaDestino());
                }
                Util.gravaAlteracaoDestino(statement, this.txtCodigo.getText());
                String[] comando = new String[10];
                comando[0] = "codigoBase";
                comando[1] = Variaveis.codigoBaseWeb;
                comando[2] = "codigoDestino";
                comando[3] = this.txtCodigo.getTextDB();
                comando[4] = "descricaoDestino";
                comando[5] = this.txtDescricao.getText();
                comando[6] = "senhaDestino";
                comando[7] = this.senhaWeb;
                comando[8] = "ativadoDestino";
                String string = comando[9] = this.checkPermitirConexao.isSelected() ? "true" : "false";
                if (Variaveis.exportarWebFilial) {
                    DBUtil.insereExportaWeb(statement, "destinos", this.getStatus() == 2 ? "I" : "A", ParametrosGerais.getCopiaDestino(), comando);
                }
                this.retornoParaPesquisa = this.txtCodigo.getText();
                if (DBUtil.campoExiste(statement, "destino", "des_horasaida") && DBUtil.campoExiste(statement, "destino", "des_horasaidasabado")) {
                    this.atualizaHoraSaida(statement, this.destinoBean.getFilial().getCodigo().toString(), this.destinoBean.getCodigo(), this.textHoraSaida.getText(), this.textHoraSaidaSabado.getText());
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Destino");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void atualizaHoraSaida(Statement statement, String filialPadrao, String codigoDestino, String horaSaida, String horaSaidaSabado) throws SQLException {
        if (!Funcoes.textoVazio(codigoDestino)) {
            StringBuilder buf = new StringBuilder();
            buf.append("update destino set ");
            buf.append(" des_horasaida = ").append(!Funcoes.textoVazio(horaSaida) ? "'" + horaSaida + "'" : null);
            buf.append(" ,des_horasaidasabado = ").append(!Funcoes.textoVazio(horaSaidaSabado) ? "'" + horaSaidaSabado + "'" : null);
            buf.append(" where fil_codigo = ").append(filialPadrao);
            buf.append("   and des_codigo = '").append(codigoDestino).append("' ");
            Conexao.executeUpdate(filialPadrao, statement, buf.toString());
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEndereco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComplemento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCEP.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFone.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComissao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescontoProducao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton1.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaCep.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboImpressora.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.chkImpressao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkWeb.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkPermitirConexao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkPRP.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkComplemento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonSenhaWeb.setEnabled(this.checkPermitirConexao.isSelected());
        this.buttonProtocolo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textFieldCodTaxa.setEditable(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonAddTaxa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonPesqTaxa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textHoraSaida.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearEmailRecoleta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearEmailResultadoPronto.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearSMSRecoleta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearSMSResultadoPronto.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearPushRecoleta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearPushResultadoPronto.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearWhatsAppResultadoPronto.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkBloquearWhatsAppRecoleta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private Set<TaxaDestinoVO> getTaxaDestinoVOsModelo() {
        HashSet<TaxaDestinoVO> destinoVOs = new HashSet<TaxaDestinoVO>();
        FilialVO filial = new FilialVO();
        DestinoVO destinoVO = new DestinoVO();
        destinoVO.setCodigo(this.destinoBean.getCodigo());
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            TaxaDestinoVO taxaDestinoVO = new TaxaDestinoVO();
            taxaDestinoVO.setFilial(filial);
            taxaDestinoVO.setDestinoVO(destinoVO);
            taxaDestinoVO.setTaxa((TaxaVO)this.modeloGridTable.getValueAt(i, 3));
            taxaDestinoVO.setAutomatica((Boolean)this.modeloGridTable.getValueAt(i, 2));
            destinoVOs.add(taxaDestinoVO);
        }
        return destinoVOs;
    }

    private void addicionarTaxa() {
        if (this.taxaVO != null && this.taxaVO.getCodigo() != null) {
            this.modeloGridTable.addLine(new Object[]{this.taxaVO.getCodigo(), this.taxaVO.getDescricao(), false, this.taxaVO});
            this.taxaVO = null;
            this.jLabelVlrDescTaxa.setText("");
            this.textFieldCodTaxa.clear();
            this.ordenarTabelaTaxa();
            ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
        } else {
            Funcoes.mensagem(this.getTopLevelAncestor(), "Informe a taxa.", 2);
            ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
        }
    }

    private void ordenarTabelaTaxa() {
        this.modeloGridTable.ordenarColunaSemTrocarSentido(this.modeloGridTable.findColumn("C\u00f3digo"));
    }

    private void pesquisarTaxa() {
        this.taxaVO = (TaxaVO)this.serviceTaxa.pesquisaVO(this.getTopLevelAncestor(), new TaxaVO(), "Pesquisando taxas", true);
        if (this.taxaVO != null) {
            this.textFieldCodTaxa.setText(this.taxaVO.getCodigo().toString());
            this.jLabelVlrDescTaxa.setText(this.taxaVO.getDescricao());
        } else {
            this.textFieldCodTaxa.selectAll();
            this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
        }
    }

    private void limparCampos() {
        this.textHoraSaida.clear();
        this.textHoraSaidaSabado.clear();
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtCidade.setText("");
        this.txtDescCidade.setText("");
        this.txtEndereco.setText("");
        this.txtComplemento.setText("");
        this.txtCodBairro.setText("");
        this.txtDescBairro.setText("");
        this.txtCEP.setText("");
        this.txtFone.clear();
        this.checkComplemento.setSelected(false);
        this.chkImpressao.setSelected(false);
        this.checkPermitirConexao.setSelected(false);
        this.protocolo = "";
        this.senhaWeb = "";
        this.txtComissao.setText("");
        this.txtDescontoProducao.setText("");
        this.modeloGridTable.clear();
        this.jLabelVlrDescTaxa.setText("");
        this.textFieldCodTaxa.clear();
        this.taxaVO = new TaxaVO();
        this.checkBloquearEmailRecoleta.setSelected(false);
        this.checkBloquearEmailResultadoPronto.setSelected(false);
        this.checkBloquearSMSRecoleta.setSelected(false);
        this.checkBloquearSMSResultadoPronto.setSelected(false);
        this.checkBloquearPushRecoleta.setSelected(false);
        this.checkBloquearPushResultadoPronto.setSelected(false);
        this.checkBloquearWhatsAppResultadoPronto.setSelected(false);
        this.checkBloquearWhatsAppRecoleta.setSelected(false);
        if (this.comboImpressora.getItemCount() > 0) {
            this.comboImpressora.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select des_codigo from destino where fil_codigo = " + Variaveis.filialPadrao + " and upper(des_codigo)=upper(" + this.txtCodigo.getTextDBEscape().trim() + ")");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Destino j\u00e1 cadastrado", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (Funcoes.textoVazio(this.txtDescCidade.getText()) || Funcoes.textoVazio(this.txtCidade) || this.txtDescCidade.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe a cidade.", 2);
            ScreenUtil.requisitarFoco(this.txtCidade);
            return false;
        }
        if (Funcoes.textoVazio(this.txtDescBairro.getText()) || Funcoes.textoVazio(this.txtCodBairro) || this.txtDescBairro.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe um bairro.", 2);
            ScreenUtil.requisitarFoco(this.txtCodBairro);
            return false;
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo cidade n\u00e3o informado", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodBairro.getText())) {
            Funcoes.mensagem(this, "Campo bairro n\u00e3o informado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() > 0 && this.txtDescCidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cidade n\u00e3o localizada", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (this.txtCodBairro.getText().trim().length() > 0 && this.txtDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Bairro n\u00e3o localizado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (this.txtComissao.getText().trim().length() > 0 && Double.parseDouble(Funcoes.limpaDecimal(this.txtComissao.getText())) > 100.0) {
            Funcoes.mensagem(this, "Campo comiss\u00e3o com valor incorreto", 1);
            this.txtComissao.selectAll();
            this.txtComissao.grabFocus();
            return false;
        }
        if (this.txtDescontoProducao.getText().trim().length() > 0 && Double.parseDouble(Funcoes.limpaDecimal(this.txtDescontoProducao.getText())) > 100.0) {
            Funcoes.mensagem(this, "Campo comiss\u00e3o com valor incorreto", 1);
            this.txtDescontoProducao.selectAll();
            this.txtDescontoProducao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCEP)) return true;
        if (CEP.tamanhoDoCepCorreto(this.txtCEP)) return true;
        Funcoes.mensagem(this, "CEP Inv\u00e1lido", 1);
        this.txtCEP.grabFocus();
        return false;
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCidade.setText(resultado.get("cid_codigo").toString());
        }
        this.txtCidade.requestFocus();
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodBairro.setText(resultado.get("bai_codigo").toString());
        }
        this.txtCodBairro.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCidade.hasFocus()) {
            this.buscaCidade();
        } else if (this.txtCodBairro.hasFocus()) {
            this.buscaBairro();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0100700000");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonProtocolo) {
            this.menu.show(this.painelCentral, this.buttonProtocolo.getX(), this.buttonProtocolo.getY() + this.buttonProtocolo.getHeight());
        } else if (e.getSource() == this.itemAlterar) {
            this.configurarProtocolo();
        } else if (e.getSource() == this.itemCopiar) {
            this.copiarProtocolo();
        } else if (e.getSource() == this.buttonSenhaWeb) {
            this.mostrarSenhaWeb();
        }
        if (e.getSource().equals(this.buttonPesqTaxa)) {
            this.pesquisarTaxa();
        } else if (e.getSource().equals(this.buttonAddTaxa)) {
            if (this.taxaJaAdicionada()) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Taxa j\u00e1 foi informada", 2);
                this.jLabelVlrDescTaxa.setText("");
                this.textFieldCodTaxa.clear();
                ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
                return;
            }
            this.addicionarTaxa();
        }
    }

    private boolean taxaJaAdicionada() {
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            TaxaVO tVO = (TaxaVO)this.modeloGridTable.getValueAt(i, 3);
            if (tVO == null || this.taxaVO == null || this.taxaVO.getCodigo() == null || !tVO.getCodigo().equals(this.taxaVO.getCodigo())) continue;
            return true;
        }
        return false;
    }

    private void mostrarSenhaWeb() {
        SenhaWeb senha = null;
        senha = this.getTopLevelAncestor() instanceof JFrame ? new SenhaWeb((Frame)((JFrame)this.getTopLevelAncestor()), true) : new SenhaWeb((JDialog)this.getTopLevelAncestor(), true);
        senha.setSenha(this.senhaWeb);
        senha.setVisible(true);
        if (senha.getSalvarPressionado()) {
            this.senhaWeb = senha.getSenha();
        }
        senha = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copiarProtocolo() {
        Hashtable resultado = Pesquisas.destino(this.getTopLevelAncestor(), false);
        if (resultado != null) {
            Statement st;
            block5: {
                String codigo = resultado.get("des_codigo").toString();
                st = Conexao.getStatement();
                try {
                    StringBuilder bui = new StringBuilder("select des_protocolo from destino where ");
                    bui.append("fil_codigo = ").append(Variaveis.filialPadrao);
                    bui.append(" and des_codigo = ").append(StringUtil.textoDBEscape(codigo));
                    ResultSet rs = Conexao.executeQuery(st, bui);
                    if (!rs.next() || Funcoes.textoVazio(rs.getString("des_protocolo"))) break block5;
                    this.protocolo = rs.getString("des_protocolo");
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "Destino (645)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void configurarProtocolo() {
        Editor relatorio = null;
        relatorio = this.getTopLevelAncestor() instanceof JFrame ? new Editor((JFrame)this.getTopLevelAncestor(), "Configurando protocolo", true) : new Editor((Dialog)this.getTopLevelAncestor(), "Configurando protocolo", true);
        if (!Funcoes.textoVazio(this.protocolo)) {
            relatorio.setAtributos(this.protocolo);
        }
        String[] perguntasFilial = RecepcaoUtil.getPerguntasFilial(Variaveis.filialPadrao);
        String[] camposBanco = Impressao.getCamposProtocoloDestino();
        if (perguntasFilial.length > 0) {
            camposBanco = ArraysUtil.concatenar(camposBanco, perguntasFilial);
        }
        relatorio.setCamposDoBanco(camposBanco);
        relatorio.setVisible(true);
        if (relatorio.ok()) {
            this.protocolo = relatorio.getAtributos();
        }
        relatorio = null;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "des_codigo";
    }
}

