/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoDesmBean;
import jalis.service.cadastro.exame.ExameMatColetaLabExternoService;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Desmembrar
extends JDialog {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(this.grid);
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JLabel labelDesmExame = new JLabel("Exame");
    private TTextField txtCodExameDesm = new TTextField(5);
    private JButton buttonBuscaExameDesm = new JButton();
    private TTextField txtDescExameDesm = new TTextField();
    private JLabel labelMatExameDesm = new JLabel("Material");
    private SteppedComboBox comboMatExameDesm = new SteppedComboBox();
    private JButton buttonOKExameDesm = new JButton("OK");
    private JTable tableExameDesm = new JTable();
    private JScrollPane scrollExameDesm = new JScrollPane(this.tableExameDesm);
    private ModeloGridTable modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame", "Alternativo", ""});
    private JLabel labelCondicaoAmostra = new JLabel("Condi\u00e7\u00e3o da amostra");
    private TTextField txtCondicaoAmostra = new TTextField(80);
    private boolean isExibirCondicaoAmostra = false;
    private boolean isLabExternoHPardini = false;
    private boolean isOK = false;
    private int linhaAlteradaDesmembrar = -1;
    private int codigoInterfaceamentoPai = -1;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_ALTERNATIVO = 3;
    private final int COLUNA_RECIPIENTE = 4;
    private final int COLUNA_DESCRICAO_HP = 1;
    private final int COLUNA_MATERIAL_HP = 2;
    private final int COLUNA_CONDICAO_AMOSTRA = 3;
    private boolean ocultarAlternativo = false;
    private boolean isLabExterno = false;
    private String codigoLabExterno;
    private String examePai;

    public Desmembrar(Dialog owner, String aparelho, boolean ocultarAlternativo, boolean isLabExterno, boolean isLabHPardini) {
        super(owner);
        this.ocultarAlternativo = ocultarAlternativo;
        this.isLabExterno = isLabExterno;
        this.isLabExternoHPardini = isLabHPardini;
        this.montaTelaDesmHPardini(owner, aparelho);
        this.isExibirCondicaoAmostra = true;
    }

    public Desmembrar(Dialog owner, String aparelho, boolean ocultarAlternativo, boolean isLabExterno) {
        super(owner);
        this.ocultarAlternativo = ocultarAlternativo;
        this.isLabExterno = isLabExterno;
        this.montaTela(owner, aparelho);
    }

    public void setCodigoLabExterno(String codigoLabExterno) {
        this.codigoLabExterno = codigoLabExterno;
    }

    private String getCodigoRecipiente(String exaCodigo, int matCodigo) {
        Statement st = Conexao.getStatement();
        try {
            if (this.isAgruparPorColeta()) {
                return new ExameService().getCodigoRecipiente(Variaveis.filialPadrao, exaCodigo, matCodigo, "recipcoleta");
            }
            return new ExameService().getCodigoRecipiente(Variaveis.filialPadrao, exaCodigo, matCodigo, "reciptriagem");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel recuperar o codigo do recipiente\n" + e.getMessage(), e.getStackTrace(), "Desmembrar (281)");
            return "";
        }
    }

    private boolean isAgruparPorColeta() {
        return ParametrosGerais.getAgruparInterface() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buscaAlternativo(String filial, String interfaceamento, String exame, String material) {
        String retorno = "";
        if (!this.ocultarAlternativo) {
            Statement st;
            block5: {
                st = Conexao.getStatement();
                try {
                    StringBuilder buf = new StringBuilder("select emi_alternativo from examematinterface ");
                    buf.append(" where fil_codigo = ").append(filial);
                    buf.append(" and int_codigo = ").append(interfaceamento);
                    buf.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
                    buf.append(" and mco_codigo = ").append(material);
                    ResultSet rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) break block5;
                    retorno = rs.getString("emi_alternativo");
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Desmembrar (198)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    public void setCodigoInterfaceamentoPai(int codigoInterfaceamento) {
        this.codigoInterfaceamentoPai = codigoInterfaceamento;
    }

    public void setExamePai(String examePai) {
        this.examePai = examePai;
    }

    private int exameJaAdicionado(String exame, DadosMaterial material) {
        int retorno = -1;
        for (int i = 0; i < this.modeloDesmembrar.getRowCount(); ++i) {
            DadosMaterial mat = null;
            String cod = this.modeloDesmembrar.getValueAt(i, 0).toString();
            mat = this.isLabExternoHPardini ? (DadosMaterial)this.modeloDesmembrar.getValueAt(i, 2) : (DadosMaterial)this.modeloDesmembrar.getValueAt(i, 1);
            if (!cod.equalsIgnoreCase(exame) || mat.getCodigo() != material.getCodigo()) continue;
            retorno = i;
            break;
        }
        return retorno;
    }

    public void montaTelaDesmHPardini(Dialog owner, String aparelho) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(930, 355);
        this.setLocationRelativeTo(owner);
        this.setTitle("Desmembrando exame para " + aparelho);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Exame", "Material", "Condi\u00e7\u00e3o da Amostra"});
        this.tableExameDesm.setModel(this.modeloDesmembrar);
        this.modeloDesmembrar.setColumnSize(new int[]{60, 600, 99, 170, 0}, this.tableExameDesm);
        this.buttonOKExameDesm.setMargin(new Insets(2, 2, 2, 2));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDesmExame, this.constraints);
        this.constraints.gridx = 3;
        this.panelCentro.add((Component)this.labelMatExameDesm, this.constraints);
        this.constraints.gridx = 4;
        this.panelCentro.add((Component)this.labelCondicaoAmostra, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.txtCodExameDesm.setPreferredSize(new Dimension(60, 20));
        this.txtCodExameDesm.setMinimumSize(new Dimension(60, 20));
        this.panelCentro.add((Component)this.txtCodExameDesm, this.constraints);
        this.constraints.gridx = 1;
        this.buttonBuscaExameDesm.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExameDesm.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonBuscaExameDesm, this.constraints);
        this.constraints.gridx = 3;
        this.comboMatExameDesm.setPreferredSize(new Dimension(100, 20));
        this.comboMatExameDesm.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.comboMatExameDesm, this.constraints);
        this.constraints.gridx = 4;
        this.txtCondicaoAmostra.setPreferredSize(new Dimension(125, 20));
        this.txtCondicaoAmostra.setMinimumSize(new Dimension(125, 20));
        this.panelCentro.add((Component)this.txtCondicaoAmostra, this.constraints);
        this.constraints.gridx = 5;
        this.buttonOKExameDesm.setPreferredSize(new Dimension(40, 20));
        this.buttonOKExameDesm.setMinimumSize(new Dimension(40, 20));
        this.panelCentro.add((Component)this.buttonOKExameDesm, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.txtDescExameDesm.setPreferredSize(new Dimension(100, 20));
        this.txtDescExameDesm.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.txtDescExameDesm, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 7;
        this.panelCentro.add((Component)this.scrollExameDesm, this.constraints);
        this.buttonBuscaExameDesm.setFocusable(false);
        this.txtDescExameDesm.setFocusable(false);
        this.txtDescExameDesm.setEditable(false);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.labelDesmExame.setDisplayedMnemonic('x');
        this.labelDesmExame.setLabelFor(this.txtCodExameDesm);
        Funcoes.imagemPesquisa(this.buttonBuscaExameDesm);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.txtCodExameDesm.setUpperCase(true);
        this.setListeners();
    }

    public void montaTela(Dialog owner, String aparelho) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(630, 255);
        this.setLocationRelativeTo(owner);
        this.setTitle("Desmembrando exame para " + aparelho);
        this.setResizable(false);
        this.setModal(true);
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        if (this.ocultarAlternativo) {
            this.modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame"});
            this.tableExameDesm.setModel(this.modeloDesmembrar);
            this.modeloDesmembrar.setColumnSize(new int[]{70, 80, 0}, this.tableExameDesm);
        } else {
            this.modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame", "Alternativo", "Recipiente"});
            this.tableExameDesm.setModel(this.modeloDesmembrar);
            this.modeloDesmembrar.setColumnSize(new int[]{70, 80, 0, 80, 80}, this.tableExameDesm);
        }
        this.buttonOKExameDesm.setMargin(new Insets(2, 2, 2, 2));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDesmExame, this.constraints);
        this.constraints.gridx = 3;
        this.panelCentro.add((Component)this.labelMatExameDesm, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.txtCodExameDesm.setPreferredSize(new Dimension(70, 20));
        this.txtCodExameDesm.setMinimumSize(new Dimension(70, 20));
        this.panelCentro.add((Component)this.txtCodExameDesm, this.constraints);
        this.constraints.gridx = 1;
        this.buttonBuscaExameDesm.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExameDesm.setMinimumSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.buttonBuscaExameDesm, this.constraints);
        this.constraints.gridx = 3;
        this.comboMatExameDesm.setPreferredSize(new Dimension(100, 20));
        this.comboMatExameDesm.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.comboMatExameDesm, this.constraints);
        this.constraints.gridx = 4;
        this.buttonOKExameDesm.setPreferredSize(new Dimension(40, 20));
        this.buttonOKExameDesm.setMinimumSize(new Dimension(40, 20));
        this.panelCentro.add((Component)this.buttonOKExameDesm, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.txtDescExameDesm.setPreferredSize(new Dimension(100, 20));
        this.txtDescExameDesm.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.txtDescExameDesm, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 7;
        this.panelCentro.add((Component)this.scrollExameDesm, this.constraints);
        this.buttonBuscaExameDesm.setFocusable(false);
        this.txtDescExameDesm.setFocusable(false);
        this.txtDescExameDesm.setEditable(false);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.labelDesmExame.setDisplayedMnemonic('x');
        this.labelDesmExame.setLabelFor(this.txtCodExameDesm);
        Funcoes.imagemPesquisa(this.buttonBuscaExameDesm);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.txtCodExameDesm.setUpperCase(true);
        this.setListeners();
    }

    private void setListeners() {
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desmembrar.this.isOK = true;
                Desmembrar.this.dispose();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desmembrar.this.isOK = false;
                Desmembrar.this.dispose();
            }
        });
        this.buttonBuscaExameDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desmembrar.this.buscaExameDesm();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Desmembrar.this.txtCodExameDesm.grabFocus();
            }
        });
        this.txtCodExameDesm.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Desmembrar.this.txtCodExameDesm.getText()) && (st = Conexao.getStatement()) != null) {
                    try {
                        StringBuilder buf = new StringBuilder("select exa_descricao from exames where fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and exa_codigo = '");
                        buf.append(Desmembrar.this.txtCodExameDesm.getText());
                        buf.append("'");
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            Desmembrar.this.txtDescExameDesm.setText(rs.getString("exa_descricao"));
                            ExameUtil.carregarMateriaisColeta(Desmembrar.this.txtCodExameDesm.getText(), String.valueOf(Variaveis.filialPadrao), Desmembrar.this.comboMatExameDesm);
                        } else {
                            Desmembrar.this.txtDescExameDesm.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Desmembrar.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        ErrorLogger.mostraMensagem(Desmembrar.this, sqlex.getMessage(), sqlex.getStackTrace());
                    }
                }
            }
        });
        this.tableExameDesm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Desmembrar.this.tableExameDesm.getSelectedRow() > -1 && Funcoes.mensagem(Desmembrar.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Desmembrar.this.modeloDesmembrar.removeLine(Desmembrar.this.tableExameDesm.getSelectedRow());
                } else if (e.getKeyCode() == 32 && Desmembrar.this.tableExameDesm.getSelectedRow() > -1) {
                    Desmembrar.this.alteraLinhaDesmembrar(Desmembrar.this.tableExameDesm.getSelectedRow());
                }
            }
        });
        this.tableExameDesm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && Desmembrar.this.tableExameDesm.getSelectedRow() > -1) {
                    Desmembrar.this.alteraLinhaDesmembrar(Desmembrar.this.tableExameDesm.getSelectedRow());
                }
            }
        });
        this.buttonOKExameDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(Desmembrar.this.txtCodExameDesm.getText()) && !Desmembrar.this.txtDescExameDesm.getText().equals("N\u00e3o cadastrado")) {
                    DadosMaterial mat = (DadosMaterial)Desmembrar.this.comboMatExameDesm.getSelectedItem();
                    if (mat == null) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Material inexistente.", 2);
                        return;
                    }
                    String alternativo = Desmembrar.this.buscaAlternativo(Variaveis.filialPadrao, String.valueOf(Desmembrar.this.codigoInterfaceamentoPai), Desmembrar.this.txtCodExameDesm.getText(), String.valueOf(mat.getCodigo()));
                    int localizado = Desmembrar.this.exameJaAdicionado(Desmembrar.this.txtCodExameDesm.getText(), mat);
                    String codRec = Desmembrar.this.getCodigoRecipiente(Desmembrar.this.txtCodExameDesm.getText(), mat.getCodigo());
                    if (Funcoes.textoVazio(codRec)) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "O exame " + Desmembrar.this.txtCodExameDesm.getText() + " n\u00e3o possui recipiente configurado para interface.", 2);
                        ScreenUtil.requisitarFoco(Desmembrar.this.txtCodExameDesm);
                        return;
                    }
                    boolean possuiRelacionamenoLabExterno = false;
                    if (Desmembrar.this.isLabExterno) {
                        try {
                            possuiRelacionamenoLabExterno = new ExameMatColetaLabExternoService().verificaHaAssociacaoExameMaterialLabExterno(Variaveis.filialPadrao, Desmembrar.this.txtCodExameDesm.getText(), String.valueOf(mat.getCodigo()), Desmembrar.this.codigoLabExterno);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel verificar associa\u00e7\u00f5es do exame", ex.getStackTrace());
                        }
                        StringBuilder msg = new StringBuilder();
                        if (!possuiRelacionamenoLabExterno) {
                            msg.append("Exame adicionado como desmembrado: [").append(Desmembrar.this.txtCodExameDesm.getText());
                            msg.append("], deve ser configurado para o laborat\u00f3rio externo: [");
                            msg.append(Desmembrar.this.codigoLabExterno).append("] antes de ser associado.");
                            Funcoes.mensagem(Laboratorio.getInstancia(), msg.toString(), 2);
                            ScreenUtil.requisitarFoco(Desmembrar.this.txtCodExameDesm);
                            return;
                        }
                        msg.setLength(0);
                        if (!Funcoes.textoVazio(Desmembrar.this.examePai) && Desmembrar.this.examePai.trim().equalsIgnoreCase(Desmembrar.this.txtCodExameDesm.getText().trim())) {
                            msg.append("Exame \"").append(Desmembrar.this.txtCodExameDesm.getText()).append("\" n\u00e3o pode ser adicionado como desmembrado dele mesmo.");
                            Funcoes.mensagem(Laboratorio.getInstancia(), msg.toString(), 2);
                            ScreenUtil.requisitarFoco(Desmembrar.this.txtCodExameDesm);
                            return;
                        }
                    }
                    if (Desmembrar.this.isLabExternoHPardini) {
                        if (Desmembrar.this.validaCondicaoAmostra()) {
                            Desmembrar.this.adicionarExaDesmHPardini(mat, alternativo, localizado, codRec);
                        }
                    } else {
                        Desmembrar.this.adicionarExaDesm(mat, alternativo, localizado, codRec);
                    }
                    Desmembrar.this.limparCampos(false);
                }
            }
        });
        this.txtCodExameDesm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Desmembrar.this.buscaExameDesm();
                }
            }
        });
    }

    private boolean validaCondicaoAmostra() {
        if (this.isExibirCondicaoAmostra && Funcoes.textoVazio(this.txtCondicaoAmostra)) {
            Funcoes.mensagem(this, "A condi\u00e7\u00e3o da amostra deve ser informada", 2);
            this.limparCampos(false);
            this.txtCondicaoAmostra.grabFocus();
            return false;
        }
        return true;
    }

    public void setExames(ArrayList a) {
        this.modeloDesmembrar.clear();
        for (int i = 0; i < a.size(); ++i) {
            Object d;
            if (!this.ocultarAlternativo) {
                d = (InterfaceDesmembrar)a.get(i);
                this.modeloDesmembrar.addLine(new Object[]{((InterfaceDesmembrar)d).getCodigo(), ((InterfaceDesmembrar)d).getMaterial(), ((InterfaceDesmembrar)d).getDescricao(), ((InterfaceDesmembrar)d).getAlternativo(), ((InterfaceDesmembrar)d).getCodRec()});
                continue;
            }
            if (a.get(i) instanceof InterfaceDesmembrar) {
                if (this.isLabExternoHPardini) {
                    d = (InterfaceDesmembrar)a.get(i);
                    this.modeloDesmembrar.addLine(new Object[]{((InterfaceDesmembrar)d).getCodigo(), ((InterfaceDesmembrar)d).getDescricao(), ((InterfaceDesmembrar)d).getMaterial(), ((InterfaceDesmembrar)d).getCondicaoAmostra()});
                    continue;
                }
                d = (InterfaceDesmembrar)a.get(i);
                this.modeloDesmembrar.addLine(new Object[]{((InterfaceDesmembrar)d).getCodigo(), ((InterfaceDesmembrar)d).getMaterial(), ((InterfaceDesmembrar)d).getDescricao(), ((InterfaceDesmembrar)d).getCodRec()});
                continue;
            }
            if (!(a.get(i) instanceof ExameMatColetaLabExternoDesmBean)) continue;
            d = (ExameMatColetaLabExternoDesmBean)a.get(i);
            this.modeloDesmembrar.addLine(new Object[]{((ExameMatColetaLabExternoDesmBean)d).getExame_kodigo().getCodigo(), ((ExameMatColetaLabExternoDesmBean)d).getMat_kodigo().getDescricao(), ((ExameMatColetaLabExternoDesmBean)d).getExame_kodigo().getDescricao()});
        }
    }

    public ArrayList getExames() {
        ArrayList<InterfaceDesmembrar> a = new ArrayList<InterfaceDesmembrar>();
        for (int i = 0; i < this.modeloDesmembrar.getRowCount(); ++i) {
            if (!this.ocultarAlternativo) {
                a.add(new InterfaceDesmembrar(this.modeloDesmembrar.getValueAt(i, 0).toString(), this.modeloDesmembrar.getValueAt(i, 2).toString(), (DadosMaterial)this.modeloDesmembrar.getValueAt(i, 1), Funcoes.textoVazio(String.valueOf(this.modeloDesmembrar.getValueAt(i, 3))) ? "" : String.valueOf(this.modeloDesmembrar.getValueAt(i, 3)), this.examePai, this.modeloDesmembrar.getValueAt(i, 4).toString()));
                continue;
            }
            if (this.isLabExternoHPardini) {
                String condicaoAmostra = "";
                condicaoAmostra = this.modeloDesmembrar.getValueAt(i, 3).toString();
                a.add(new InterfaceDesmembrar(this.modeloDesmembrar.getValueAt(i, 0).toString(), this.modeloDesmembrar.getValueAt(i, 1).toString(), "", this.examePai, condicaoAmostra, (DadosMaterial)this.modeloDesmembrar.getValueAt(i, 2)));
                continue;
            }
            a.add(new InterfaceDesmembrar(this.modeloDesmembrar.getValueAt(i, 0).toString(), this.modeloDesmembrar.getValueAt(i, 2).toString(), (DadosMaterial)this.modeloDesmembrar.getValueAt(i, 1), "", this.examePai));
        }
        return a;
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void adicionarExaDesmHPardini(DadosMaterial mat, String alternativo, int localizado, String codRec) {
        if (localizado < 0 || this.linhaAlteradaDesmembrar > -1 && localizado == this.linhaAlteradaDesmembrar) {
            if (this.linhaAlteradaDesmembrar > -1) {
                this.modeloDesmembrar.setValueAt(this.txtCodExameDesm.getText(), this.linhaAlteradaDesmembrar, 0);
                this.modeloDesmembrar.setValueAt(this.txtDescExameDesm.getText(), this.linhaAlteradaDesmembrar, 1);
                this.modeloDesmembrar.setValueAt(mat, this.linhaAlteradaDesmembrar, 2);
                this.modeloDesmembrar.setValueAt(this.txtCondicaoAmostra.getText(), this.linhaAlteradaDesmembrar, 3);
                this.linhaAlteradaDesmembrar = -1;
            } else {
                this.modeloDesmembrar.addLine(new Object[]{this.txtCodExameDesm.getText(), this.txtDescExameDesm.getText(), mat, this.txtCondicaoAmostra.getText(), this.isExibirCondicaoAmostra});
            }
        }
        this.limparCampos(true);
        this.txtCodExameDesm.grabFocus();
    }

    private void adicionarExaDesm(DadosMaterial mat, String alternativo, int localizado, String codRec) {
        if (localizado < 0 || this.linhaAlteradaDesmembrar > -1 && localizado == this.linhaAlteradaDesmembrar) {
            if (this.linhaAlteradaDesmembrar > -1) {
                this.modeloDesmembrar.setValueAt(this.txtCodExameDesm.getText(), this.linhaAlteradaDesmembrar, 0);
                this.modeloDesmembrar.setValueAt(this.txtDescExameDesm.getText(), this.linhaAlteradaDesmembrar, 2);
                this.modeloDesmembrar.setValueAt(mat, this.linhaAlteradaDesmembrar, 1);
                if (!this.ocultarAlternativo) {
                    this.modeloDesmembrar.setValueAt(alternativo, this.linhaAlteradaDesmembrar, 3);
                }
                this.linhaAlteradaDesmembrar = -1;
            } else if (!this.ocultarAlternativo) {
                this.modeloDesmembrar.addLine(new Object[]{this.txtCodExameDesm.getText(), mat, this.txtDescExameDesm.getText(), alternativo, codRec});
            } else {
                this.modeloDesmembrar.addLine(new Object[]{this.txtCodExameDesm.getText(), mat, this.txtDescExameDesm.getText()});
            }
        }
        this.limparCampos(true);
        this.txtCodExameDesm.grabFocus();
    }

    private void alteraLinhaDesmembrar(int linha) {
        this.linhaAlteradaDesmembrar = linha;
        this.txtCodExameDesm.setText(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 0).toString());
        this.txtDescExameDesm.setText(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 2).toString());
        try {
            ExameUtil.carregarMateriaisColeta(this.txtCodExameDesm.getText(), String.valueOf(Variaveis.filialPadrao), this.comboMatExameDesm);
        }
        catch (SQLException sqlex) {
            ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace());
        }
        if (this.isLabExternoHPardini) {
            this.comboMatExameDesm.setSelectedItem(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 2).toString());
            this.txtDescExameDesm.setText(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 1).toString());
        } else {
            this.comboMatExameDesm.setSelectedItem(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 1).toString());
        }
        if (this.isLabExternoHPardini && this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 3) != null) {
            this.txtCondicaoAmostra.setText(this.modeloDesmembrar.getValueAt(this.linhaAlteradaDesmembrar, 3).toString());
        } else {
            this.txtCondicaoAmostra.setText("");
        }
        this.txtCodExameDesm.grabFocus();
    }

    private void buscaExameDesm() {
        Hashtable resultado = Pesquisas.exame(this, false, false);
        if (resultado != null) {
            this.txtCodExameDesm.setText(resultado.get("exa_codigo").toString());
        }
        this.txtCodExameDesm.requestFocus();
    }

    private void limparCampos(boolean limpar) {
        if (limpar) {
            this.txtCodExameDesm.clear();
            this.txtDescExameDesm.clear();
            this.txtCondicaoAmostra.clear();
            this.comboMatExameDesm.removeAllItems();
        }
    }
}

