/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ApresentarBotaoEditor;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class DesbloquearExames
extends AbstractDialogoOKCancelar {
    private final int COLUNA_FILIAL = 0;
    private final int COLUNA_CODIGO = 1;
    private final int COLUNA_MATERIAL = 2;
    private final int COLUNA_DESCRICAO = 3;
    private final int COLUNA_BOTAO = 4;
    private final int COLUNA_OBJETO = 5;
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private TTextField textLocalizar = new TTextField();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Mat", "Exame", "#"}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }
    };
    private JTable tabela = new JTable(this.modelo);

    public DesbloquearExames(Frame pai, int codigoLabExterno) {
        super(pai, "Verificar exames importados");
        this.buttonOK.setVisible(false);
        this.buttonCancelar.setText("Fechar");
        this.textLocalizar.setPreferredSize(new Dimension(100, 20));
        this.textLocalizar.setMinimumSize(new Dimension(100, 20));
        JPanel panelLocalizar = new JPanel(new BorderLayout());
        panelLocalizar.add((Component)this.labelLocalizar, "West");
        panelLocalizar.add((Component)this.textLocalizar, "Center");
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JScrollPane(this.tabela), "Center");
        panel.add((Component)panelLocalizar, "South");
        this.tabela.setDefaultRenderer(Boolean.class, new ApresentarBotaoEditor(this.tabela, codigoLabExterno));
        this.tabela.setDefaultEditor(Boolean.class, new ApresentarBotaoEditor(this.tabela, codigoLabExterno));
        this.modelo.setColumnSize(new int[]{35, 60, 40, 0, 100}, this.tabela);
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                int pos = DesbloquearExames.this.modelo.localizarContendo(3, DesbloquearExames.this.textLocalizar.getText());
                if (pos > -1) {
                    DesbloquearExames.this.tabela.getSelectionModel().setSelectionInterval(pos, pos);
                    DesbloquearExames.this.tabela.scrollRectToVisible(DesbloquearExames.this.tabela.getCellRect(pos, 0, false));
                }
            }
        });
        this.setSize(730, 350);
        this.setLocationRelativeTo(pai);
    }

    public void carregarExames(ExameMatColetaVO[] exames) {
        if (exames == null) {
            return;
        }
        this.modelo.clear();
        for (ExameMatColetaVO exame : exames) {
            this.modelo.addLine(new Object[]{exame.getFilial().getCodigo().toString(), exame.getExame().getCodigo(), exame.getMaterial().getAbreviatura(), exame.getExame().getDescricao(), new Boolean(true), exame});
        }
        this.modelo.ordenarColuna(3);
    }
}

