/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

class CopiarMaterial
extends AbstractDialogoOKCancelar
implements ActionListener {
    JRadioButton radioCopiaTabela = ComponenteFactory.novoJRadioButton("Copiar da linha selecionada", 'e', this, null, null);
    JRadioButton radioOutro = ComponenteFactory.novoJRadioButton("Copiar do exame selecionado", 'o', this, null, null);
    JLabel labelCodigo = ComponenteFactory.novoJLabel("", new Dimension(69, 20), new TitledBorder(""));
    JLabel labelMaterial = ComponenteFactory.novoJLabel("", new Dimension(69, 20), new TitledBorder(""));
    JLabel labelDescricao = ComponenteFactory.novoJLabel("", new Dimension(69, 20), new TitledBorder(""));
    JButton buttonBuscaExame = ComponenteFactory.novoJButton((ActionListener)this, null, new Dimension(20, 20), true, false);
    ButtonGroup grupo = new ButtonGroup();
    private String codigoMaterialSelecionado = "";
    public static final int TABELA = 1;
    public static final int SELECAO = 2;

    public static CopiarMaterial getNovaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new CopiarMaterial((Dialog)owner, "Copiar material");
        }
        if (owner instanceof Frame) {
            return new CopiarMaterial((Frame)owner, "Copiar material");
        }
        return null;
    }

    public CopiarMaterial(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    public CopiarMaterial(Frame pai, String titulo) {
        super(pai, titulo);
        this.montarTela();
    }

    private void montarTela() {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        this.setSize(new Dimension(400, 160));
        this.setResizable(false);
        this.radioCopiaTabela.setSelected(true);
        this.grupo.add(this.radioCopiaTabela);
        this.grupo.add(this.radioOutro);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.radioCopiaTabela, c);
        c.gridy = 1;
        panel.add((Component)this.radioOutro, c);
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelCodigo.setMinimumSize(this.labelCodigo.getPreferredSize());
        panel.add((Component)this.labelCodigo, c);
        c.gridx = 1;
        this.buttonBuscaExame.setMinimumSize(this.buttonBuscaExame.getPreferredSize());
        this.buttonBuscaExame.setMaximumSize(this.buttonBuscaExame.getPreferredSize());
        panel.add((Component)this.buttonBuscaExame, c);
        c.gridx = 2;
        this.labelMaterial.setMinimumSize(this.labelMaterial.getPreferredSize());
        panel.add((Component)this.labelMaterial, c);
        c.gridx = 3;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelDescricao.setMinimumSize(this.labelDescricao.getPreferredSize());
        panel.add((Component)this.labelDescricao, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.radioOutro || e.getSource() == this.radioCopiaTabela) {
            this.buttonBuscaExame.setEnabled(e.getSource() == this.radioOutro);
        } else if (e.getSource() == this.buttonBuscaExame) {
            this.buscaExame();
        } else {
            super.actionPerformed(e);
        }
    }

    private void buscaExame() {
        Hashtable resultado = Pesquisas.exameAMBSetor(this, false, false);
        if (resultado != null) {
            this.labelCodigo.setText(resultado.get("exa_codigo").toString());
            this.labelMaterial.setText(resultado.get("mco_descricao").toString());
            this.labelDescricao.setText(resultado.get("exa_descricao").toString());
            this.codigoMaterialSelecionado = resultado.get("mco_codigo").toString();
        }
    }

    public int getOpcaoSelecionada() {
        return this.radioCopiaTabela.getModel().isSelected() ? 1 : 2;
    }

    public String getCodigoExame() {
        return this.labelCodigo.getText();
    }

    public String getCodigoMaterial() {
        return this.codigoMaterialSelecionado;
    }
}

