/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosConversao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

class Conversao
extends JDialog
implements DisposeListener {
    private ArrayList conversao;
    private JPanel panel;
    private TTextField txtCodUnidade;
    private TTextField txtDescUnidade;
    private TTextField txtFator;
    private JLabel labelComissao;
    private JButton botaoConv;
    private JTable tabelaUnidade;
    private JScrollPane scroll;
    private JButton botaoOK;
    private JLabel labelConv;
    private ModeloGridTable modelo;
    private JButton botaoCancelar;
    private JButton botaoSalvar;
    private JComboBox comboOperacao;
    private String unidadePai;
    private boolean ok = false;

    public Conversao(Frame owner, String title) {
        super(owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.iniciar(owner, title);
    }

    public Conversao(Dialog owner, String title) {
        super(owner, title);
        this.iniciar(owner, title);
    }

    public void iniciar(Component owner, String title) {
        this.getContentPane().setLayout(new BorderLayout());
        this.setResizable(false);
        this.conversao = new ArrayList();
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        Dimension dimensionPanel = new Dimension(200, 200);
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(ScreenUtil.criarBordaVazia());
        this.botaoConv = new JButton("");
        Funcoes.imagemPesquisa(this.botaoConv);
        this.txtCodUnidade = new TTextField(8);
        this.txtFator = new TTextField(10, 2, 4);
        this.txtDescUnidade = new TTextField(80);
        this.txtDescUnidade.setEditable(false);
        this.txtDescUnidade.setFocusable(false);
        this.botaoOK = new JButton("OK");
        this.modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Unidade", "Opera\u00e7\u00e3o", "Fator"});
        this.tabelaUnidade = new JTable(this.modelo);
        this.modelo.setColumnSize(new int[]{70, 0, 80, 70}, this.tabelaUnidade);
        this.scroll = new JScrollPane(this.tabelaUnidade);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.labelConv = new JLabel("Unidade");
        this.labelComissao = new JLabel("Fator");
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoConv.setFocusable(false);
        this.botaoCancelar = new JButton("Cancelar");
        this.botaoCancelar.setMnemonic('C');
        this.botaoSalvar = new JButton("OK");
        this.botaoSalvar.setMnemonic('O');
        this.comboOperacao = new JComboBox<String>(new String[]{"Multiplicar", "Dividir"});
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addMnemonic();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.panel.add((Component)this.labelConv, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        this.panel.add((Component)this.labelComissao, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        dimensionPanel = new Dimension(48, 20);
        this.txtCodUnidade.setPreferredSize(dimensionPanel);
        this.txtCodUnidade.setMinimumSize(dimensionPanel);
        this.panel.add((Component)this.txtCodUnidade, gridBagConstraints);
        ++gridBagConstraints.gridx;
        dimensionPanel = new Dimension(20, 20);
        this.botaoConv.setPreferredSize(dimensionPanel);
        this.botaoConv.setMinimumSize(dimensionPanel);
        this.panel.add((Component)this.botaoConv, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.txtDescUnidade.setPreferredSize(dimensionPanel);
        this.txtDescUnidade.setMaximumSize(dimensionPanel);
        this.panel.add((Component)this.txtDescUnidade, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        dimensionPanel = new Dimension(100, 20);
        this.comboOperacao.setPreferredSize(dimensionPanel);
        this.comboOperacao.setMinimumSize(dimensionPanel);
        this.panel.add((Component)this.comboOperacao, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.txtFator.setPreferredSize(dimensionPanel);
        this.txtFator.setMinimumSize(dimensionPanel);
        this.panel.add((Component)this.txtFator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        dimensionPanel = new Dimension(40, 20);
        this.botaoOK.setPreferredSize(dimensionPanel);
        this.botaoOK.setMinimumSize(dimensionPanel);
        this.panel.add((Component)this.botaoOK, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)this.scroll, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        panelBotoes.add(this.botaoSalvar);
        panelBotoes.add(this.botaoCancelar);
        this.panel.add((Component)panelBotoes, gridBagConstraints);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setSize(500, 250);
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        this.txtCodUnidade.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, true), "F2_PRESSIONADO");
        this.txtCodUnidade.getActionMap().put("F2_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conversao.this.buscaUnidade();
            }
        });
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(Conversao.this.txtCodUnidade.getText()) && Conversao.this.unidadePai.equalsIgnoreCase(Conversao.this.txtCodUnidade.getText())) {
                    Funcoes.mensagem(Conversao.this, "A unidade n\u00e3o pode ser convertida para ela mesma", 5);
                    Conversao.this.txtCodUnidade.selectAll();
                    Conversao.this.txtCodUnidade.grabFocus();
                } else if (!Conversao.this.txtDescUnidade.getText().equals("N\u00e3o cadastrado") && Conversao.this.txtCodUnidade.getText().trim().length() > 0 && !Funcoes.textoVazio(Conversao.this.txtFator.getText()) && Conversao.this.modelo.localizar(0, Conversao.this.txtCodUnidade.getText()) < 0) {
                    Conversao.this.modelo.addLine(new String[]{Conversao.this.txtCodUnidade.getText(), Conversao.this.txtDescUnidade.getText(), (String)Conversao.this.comboOperacao.getSelectedItem(), Funcoes.formataDecimal(Conversao.this.txtFator.getMaskDecimal(), Double.parseDouble(Conversao.this.txtFator.getText()))});
                }
                if (Funcoes.textoVazio(Conversao.this.txtFator.getText())) {
                    Conversao.this.txtFator.grabFocus();
                } else {
                    Conversao.this.txtDescUnidade.clear();
                    Conversao.this.txtCodUnidade.clear();
                    Conversao.this.txtFator.clear();
                    Conversao.this.txtCodUnidade.grabFocus();
                }
            }
        });
        this.botaoConv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conversao.this.buscaUnidade();
            }
        });
        this.botaoCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(Conversao.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    Conversao.this.ok = false;
                    Conversao.this.setVisible(false);
                }
            }
        });
        this.botaoSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conversao.this.ok = true;
                Conversao.this.setVisible(false);
            }
        });
        this.tabelaUnidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (Conversao.this.tabelaUnidade.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(Conversao.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    Conversao.this.modelo.removeLine(Conversao.this.tabelaUnidade.getSelectedRow());
                }
            }
        });
        this.txtCodUnidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (Conversao.this.txtCodUnidade.getText().trim().length() > 0) {
                        try {
                            Statement st = Conexao.getStatement();
                            if (st == null) break block6;
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select unm_descricao, unm_codigo from unidademedida where fil_codigo = " + Variaveis.filialPadrao + " and upper(unm_codigo)=upper(" + Conversao.this.txtCodUnidade.getTextDBEscape() + ")");
                                if (rs.next()) {
                                    Conversao.this.txtDescUnidade.setText(rs.getString("unm_descricao"));
                                    Conversao.this.txtCodUnidade.setText(rs.getString("unm_codigo"));
                                    break block6;
                                }
                                Conversao.this.txtDescUnidade.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(Conversao.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                            }
                        }
                        catch (Exception ex) {
                            Funcoes.mensagem(Conversao.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                        }
                    }
                }
            }
        });
        Funcoes.defineUpperCase(this.panel, ParametrosGerais.getUpperCase());
    }

    private void addMnemonic() {
        this.labelConv.setLabelFor(this.txtCodUnidade);
        this.labelConv.setDisplayedMnemonic('U');
        this.labelComissao.setLabelFor(this.txtFator);
        this.labelComissao.setDisplayedMnemonic('F');
        this.botaoOK.setMnemonic('O');
    }

    public ArrayList getConversao() {
        this.conversao.clear();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String fator = Funcoes.limpaDecimal((String)this.modelo.getLine(i).get("Fator"));
            this.conversao.add(new DadosConversao((String)this.modelo.getLine(i).get("C\u00f3digo"), (String)this.modelo.getLine(i).get("Unidade"), (String)this.modelo.getLine(i).get("Opera\u00e7\u00e3o"), Double.parseDouble(fator)));
        }
        return this.conversao;
    }

    public void setConversao(ArrayList conv) {
        if (conv != null) {
            this.conversao = conv;
        }
        for (int i = 0; i < this.conversao.size(); ++i) {
            double fator = ((DadosConversao)this.conversao.get(i)).getFator();
            this.modelo.addLine(new Object[]{String.valueOf(((DadosConversao)this.conversao.get(i)).getCodigo()), ((DadosConversao)this.conversao.get(i)).getDescricao(), ((DadosConversao)this.conversao.get(i)).getOperacao(), Funcoes.formataDecimal(this.txtFator.getMaskDecimal(), fator)});
        }
    }

    private void buscaUnidade() {
        Hashtable resultado = Pesquisas.unidadeMedida(this, true);
        if (resultado != null) {
            this.txtCodUnidade.setText(resultado.get("unm_codigo").toString());
        }
        this.txtCodUnidade.requestFocus();
    }

    public boolean isOK() {
        return this.ok;
    }

    public void setUnidadePai(String unidade) {
        this.unidadePai = unidade;
    }
}

