/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosConvenio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

class ConveniosAutorizados
extends JDialog
implements DisposeListener {
    private ArrayList convenios = new ArrayList();
    private JPanel panel = new JPanel(null);
    private TTextField txtCodConv = new TTextField(5, 1);
    private TTextField txtDescConv = new TTextField(80);
    private TTextField txtVlrComissao = new TTextField(10, 2, 4);
    private JLabel labelComissao = new JLabel("% Comiss\u00e3o");
    private JButton botaoConv = ComponenteFactory.novoJButton(null, true);
    private JTable tabelaConv;
    private JScrollPane scroll;
    private JButton botaoOK = new JButton("OK");
    private JLabel labelConv = new JLabel("Conv\u00eanio");
    private ModeloGridTable modelo;
    private JButton botaoFechar = new JButton("Fechar");

    public ConveniosAutorizados(JFrame owner, String title) {
        super((Frame)owner, title);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.montaTela(owner);
    }

    private void montaTela(JFrame owner) {
        this.getContentPane().setLayout(new BorderLayout());
        this.txtDescConv.setEditable(false);
        this.txtDescConv.setFocusable(false);
        String[] colunas = new String[]{"C\u00f3digo", "Conv\u00eanio", "Comiss\u00e3o"};
        int[] size = new int[]{70, 0, 80};
        this.modelo = new ModeloGridTable(colunas);
        this.tabelaConv = new JTable(this.modelo);
        this.modelo.setColumnSize(size, this.tabelaConv);
        this.scroll = new JScrollPane(this.tabelaConv);
        this.labelConv.setBounds(new Rectangle(5, 4, 70, 15));
        this.labelComissao.setBounds(new Rectangle(278, 4, 75, 15));
        this.txtCodConv.setBounds(new Rectangle(5, 19, 48, 20));
        this.botaoConv.setBounds(new Rectangle(54, 19, 20, 20));
        this.txtDescConv.setBounds(new Rectangle(76, 19, 200, 20));
        this.txtVlrComissao.setBounds(new Rectangle(278, 19, 98, 20));
        this.botaoOK.setBounds(new Rectangle(378, 19, 40, 20));
        this.botaoOK.setMargin(new Insets(2, 2, 2, 2));
        this.botaoConv.setFocusable(false);
        this.scroll.setBounds(new Rectangle(5, 41, 413, 217));
        this.botaoFechar.setMnemonic('F');
        this.botaoFechar.setBounds(341, 261, 75, 25);
        this.panel.add((Component)this.labelConv, null);
        this.panel.add((Component)this.txtCodConv, null);
        this.panel.add((Component)this.botaoConv, null);
        this.panel.add((Component)this.txtDescConv, null);
        this.panel.add(this.txtVlrComissao);
        this.panel.add(this.labelComissao);
        this.panel.add((Component)this.botaoOK, null);
        this.panel.add((Component)this.scroll, null);
        this.panel.add((Component)this.botaoFechar, null);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setSize(438, 332);
        this.setLocation(ScreenUtil.getCentralizado(owner.getBounds(), this.getSize()));
        this.setModal(true);
        Funcoes.montaEnter((JComponent)this.panel);
        this.txtCodConv.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0, true), "F2_PRESSIONADO");
        this.txtCodConv.getActionMap().put("F2_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConveniosAutorizados.this.buscaConvenio();
            }
        });
        this.botaoOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConveniosAutorizados.this.txtDescConv.getText().equals("N\u00e3o cadastrado") && ConveniosAutorizados.this.txtCodConv.getText().trim().length() > 0 && !Funcoes.textoVazio(ConveniosAutorizados.this.txtVlrComissao.getText()) && ConveniosAutorizados.this.modelo.localizar(0, ConveniosAutorizados.this.txtCodConv.getText()) < 0) {
                    ConveniosAutorizados.this.modelo.addLine(new String[]{ConveniosAutorizados.this.txtCodConv.getText(), ConveniosAutorizados.this.txtDescConv.getText(), ConveniosAutorizados.this.txtVlrComissao.getText()});
                }
                ConveniosAutorizados.this.txtCodConv.clear();
                ConveniosAutorizados.this.txtDescConv.clear();
                ConveniosAutorizados.this.txtVlrComissao.clear();
                ConveniosAutorizados.this.txtCodConv.selectAll();
                ConveniosAutorizados.this.txtCodConv.grabFocus();
            }
        });
        this.botaoConv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConveniosAutorizados.this.buscaConvenio();
            }
        });
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConveniosAutorizados.this.setVisible(false);
            }
        });
        this.tabelaConv.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && Funcoes.mensagem(ConveniosAutorizados.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConveniosAutorizados.this.modelo.removeLine(ConveniosAutorizados.this.tabelaConv.getSelectedRow());
                }
            }
        });
        this.txtCodConv.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (ConveniosAutorizados.this.txtCodConv.getText().trim().length() > 0) {
                        try {
                            Statement st = Conexao.getStatement();
                            if (st == null) break block6;
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select con_fantasia from convenios where fil_codigo=" + Variaveis.filialPadrao + " and con_codigo=" + ConveniosAutorizados.this.txtCodConv.getText());
                                if (rs.next()) {
                                    ConveniosAutorizados.this.txtDescConv.setText(rs.getString("con_fantasia"));
                                    ConveniosAutorizados.this.txtVlrComissao.setText("0");
                                    break block6;
                                }
                                ConveniosAutorizados.this.txtDescConv.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(ConveniosAutorizados.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                            }
                        }
                        catch (Exception ex) {
                            Funcoes.mensagem(ConveniosAutorizados.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + ex.getMessage(), 1);
                        }
                    }
                }
            }
        });
    }

    public ArrayList getComissoes() {
        this.convenios.clear();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String comissao = Funcoes.limpaDecimal((String)this.modelo.getLine(i).get("Comiss\u00e3o"));
            DadosConvenio dados = new DadosConvenio(Integer.parseInt((String)this.modelo.getLine(i).get("C\u00f3digo")), (String)this.modelo.getLine(i).get("Conv\u00eanio"), Double.parseDouble(comissao));
            this.convenios.add(dados);
        }
        return this.convenios;
    }

    public void setConvenios(ArrayList conv) {
        if (conv != null) {
            this.convenios = conv;
        }
        for (int i = 0; i < this.convenios.size(); ++i) {
            double comissao = ((DadosConvenio)this.convenios.get(i)).getComissaoMedico();
            this.modelo.addLine(new Object[]{String.valueOf(((DadosConvenio)this.convenios.get(i)).getCodConvenio()), ((DadosConvenio)this.convenios.get(i)).getNomeConvenio(), Funcoes.formataDecimal("0.0000", comissao)});
        }
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(this, true, false);
        if (resultado != null) {
            this.txtCodConv.setText(resultado.get("con_codigo").toString());
        }
        this.txtCodConv.requestFocus();
    }
}

