/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.Convenio;
import jalis.laboratorio.cadastro.ConvenioApoiado;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class ConveniosApoiado
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static final int COLUNA_APOIADO = 0;
    private static final int COLUNA_APOIO = 1;
    private static final int COLUNA_DESCRICAO = 2;
    JLabel labelCodigoApoiado = new JLabel("C\u00f3digo no apoiado:");
    JLabel labelCodigoApoio = new JLabel("C\u00f3digo do apoio:");
    JLabel labelConvenio = new JLabel("");
    TTextField textCodigoApoiado = new TTextField(5, 1);
    TTextField textCodigoApoio = new TTextField(5, 1);
    ModeloGridTable modeloConvApoio = new ModeloGridTable(new String[]{"Apoiado", "Apoio", "Fantasia"});
    JTable tableConvApoio = new JTable(this.modeloConvApoio);
    JScrollPane scrollConvApoio = new JScrollPane(this.tableConvApoio);
    JButton buttonOKConvApoio = ComponenteFactory.novoJButton("OK", this);
    JButton buttonBuscaConv = ComponenteFactory.novoJButton(this, true);
    int alterandoLinha = -1;

    public static ConveniosApoiado novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new ConveniosApoiado((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new ConveniosApoiado((Dialog)owner);
        }
        return null;
    }

    public ConveniosApoiado(Frame owner) {
        super(owner, "Conv\u00eanios do Apoiado");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public ConveniosApoiado(Dialog owner) {
        super(owner, "Conv\u00eanios do Apoiado");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKConvApoio) {
            this.adicionarConvenioApoio();
        } else {
            super.actionPerformed(e);
        }
    }

    private void iniciar() {
        this.setSize(new Dimension(450, 300));
        this.setResizable(false);
        Dimension d = new Dimension(40, 20);
        this.buttonOKConvApoio.setPreferredSize(d);
        this.buttonOKConvApoio.setMinimumSize(d);
        this.buttonOKConvApoio.setMaximumSize(d);
        this.buttonOKConvApoio.setMargin(new Insets(2, 2, 2, 2));
        d = new Dimension(50, 20);
        this.textCodigoApoiado.setPreferredSize(d);
        this.textCodigoApoiado.setMinimumSize(d);
        this.textCodigoApoiado.setMaximumSize(d);
        d = new Dimension(50, 20);
        this.textCodigoApoio.setPreferredSize(d);
        this.textCodigoApoio.setMinimumSize(d);
        this.textCodigoApoio.setMaximumSize(d);
        this.buttonBuscaConv.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaConv.setPreferredSize(d);
        this.buttonBuscaConv.setMinimumSize(d);
        this.buttonBuscaConv.setMaximumSize(d);
        this.labelConvenio.setText("");
        d = new Dimension(200, 20);
        this.labelConvenio.setPreferredSize(d);
        this.labelConvenio.setMinimumSize(d);
        this.labelConvenio.setMaximumSize(d);
        this.modeloConvApoio.setColumnSize(new int[]{60, 60, 0}, this.tableConvApoio);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.labelCodigoApoiado, c);
        ++c.gridx;
        c.fill = 0;
        panel.add((Component)this.textCodigoApoiado, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(1, 0, 0, 0);
        c.weightx = 0.0;
        panel.add((Component)this.labelCodigoApoio, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.textCodigoApoio, c);
        ++c.gridx;
        panel.add((Component)this.buttonBuscaConv, c);
        ++c.gridx;
        this.labelConvenio.setBorder(new TitledBorder(""));
        panel.add((Component)this.labelConvenio, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        c.anchor = 13;
        panel.add((Component)this.buttonOKConvApoio, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)this.scrollConvApoio, c);
        this.buttonBuscaConv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ConveniosApoiado.this.buttonBuscaConv) {
                    ConveniosApoiado.this.buscaConvenioApoio();
                }
            }
        });
        this.textCodigoApoio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConveniosApoiado.this.buscaConvenioApoio();
                }
            }
        });
        this.textCodigoApoio.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ConveniosApoiado.this.textCodigoApoio)) {
                    Statement st = Conexao.getStatement();
                    StringBuilder buf = new StringBuilder("select con_fantasia from convenios where fil_codigo = ");
                    buf.append(Variaveis.filialPadrao).append(" and con_codigo = ").append(ConveniosApoiado.this.textCodigoApoio.getText());
                    try {
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (!rs.next()) {
                            ConveniosApoiado.this.labelConvenio.setText("N\u00e3o cadastrado");
                            return;
                        }
                        ConveniosApoiado.this.labelConvenio.setText(rs.getString("con_fantasia"));
                    }
                    catch (SQLException err) {
                        ErrorLogger.mostraMensagem(null, err.getMessage(), err.getStackTrace(), "adicionarConvenioApoio");
                    }
                } else {
                    ConveniosApoiado.this.labelConvenio.setText("");
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.tableConvApoio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ConveniosApoiado.this.tableConvApoio.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(ConveniosApoiado.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConveniosApoiado.this.modeloConvApoio.removeLine(ConveniosApoiado.this.tableConvApoio.getSelectedRow());
                } else if (ConveniosApoiado.this.tableConvApoio.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    ConveniosApoiado.this.alterandoLinha = ConveniosApoiado.this.tableConvApoio.getSelectedRow();
                    ConveniosApoiado.this.textCodigoApoiado.setText(ConveniosApoiado.this.modeloConvApoio.getValueAt(ConveniosApoiado.this.alterandoLinha, 0).toString());
                    ConveniosApoiado.this.textCodigoApoio.setText(ConveniosApoiado.this.modeloConvApoio.getValueAt(ConveniosApoiado.this.alterandoLinha, 1).toString());
                    ConveniosApoiado.this.textCodigoApoiado.grabFocus();
                }
            }
        });
    }

    private void adicionarConvenioApoio() {
        if (!Funcoes.textoVazio(this.textCodigoApoio) && this.textCodigoApoio.getText().equals(Convenio.txtCodigo.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo do conv\u00eanio n\u00e3o pode ser o mesmo do conv\u00eanio de apoio.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoApoio);
            return;
        }
        if (Funcoes.textoVazio(this.textCodigoApoiado)) {
            Funcoes.mensagem(this, "C\u00f3digo do conv\u00eanio apoiado deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoApoiado);
            return;
        }
        if (Funcoes.textoVazio(this.textCodigoApoio)) {
            Funcoes.mensagem(this, "C\u00f3digo do conv\u00eanio deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoApoio);
            return;
        }
        if (!Funcoes.textoVazio(this.textCodigoApoio) && (Funcoes.textoVazio(this.labelConvenio.getText()) || this.labelConvenio.getText().equals("N\u00e3o cadastrado"))) {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select con_fantasia from convenios where fil_codigo = ");
            buf.append(Variaveis.filialPadrao).append(" and con_codigo = ").append(this.textCodigoApoio.getText());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) {
                    Funcoes.mensagem(this, "Conv\u00eanio informado n\u00e3o cadastrado.", 2);
                    ScreenUtil.requisitarFoco(this.textCodigoApoio);
                    return;
                }
                this.labelConvenio.setText(rs.getString("con_fantasia"));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "adicionarConvenioApoio");
            }
        }
        if (this.modeloConvApoio.localizar(0, this.textCodigoApoiado.getText()) >= 0) {
            Funcoes.mensagem(this, "C\u00f3digo do conv\u00eanio do Apoiado j\u00e1 est\u00e1 relacionado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoApoiado);
            return;
        }
        if (this.alterandoLinha == -1) {
            this.modeloConvApoio.addLine(new String[]{this.textCodigoApoiado.getText(), this.textCodigoApoio.getText(), this.labelConvenio.getText()});
        } else {
            this.modeloConvApoio.setValueAt(this.textCodigoApoiado.getText(), this.alterandoLinha, 0);
            this.modeloConvApoio.setValueAt(this.textCodigoApoio.getText(), this.alterandoLinha, 1);
            this.modeloConvApoio.setValueAt(this.labelConvenio.getText(), this.alterandoLinha, 2);
            this.alterandoLinha = -1;
        }
        this.textCodigoApoiado.clear();
        this.textCodigoApoio.clear();
        this.labelConvenio.setText("");
        ScreenUtil.requisitarFoco(this.textCodigoApoiado);
    }

    private void buscaConvenioApoio() {
        Hashtable resultado = Pesquisas.convenio(this, false, false);
        if (resultado != null) {
            this.textCodigoApoio.setText(resultado.get("con_codigo").toString());
            this.labelConvenio.setText(resultado.get("con_fantasia").toString());
        }
        this.textCodigoApoiado.requestFocus();
    }

    public void setConveniosApoiado(ArrayList<ConvenioApoiado> conveniosApoiado) {
        this.modeloConvApoio.clear();
        for (ConvenioApoiado c : conveniosApoiado) {
            this.modeloConvApoio.addLine(new String[]{c.apoiado, c.apoio, c.descricaoApoio});
        }
    }

    public ArrayList<ConvenioApoiado> getConveniosApoiado() {
        ArrayList<ConvenioApoiado> c = new ArrayList<ConvenioApoiado>();
        for (int i = 0; i < this.modeloConvApoio.getRowCount(); ++i) {
            c.add(new ConvenioApoiado(this.modeloConvApoio.getValueAt(i, 0).toString(), this.modeloConvApoio.getValueAt(i, 1).toString(), this.modeloConvApoio.getValueAt(i, 2).toString()));
        }
        return c;
    }
}

