/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.ContatoConvenio;
import jalis.util.ComponenteUtils;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class ContatosConvenio
extends AbstractDialogoOKCancelar
implements ActionListener {
    JLabel labelContatoNome = new JLabel("Nome:");
    JLabel labelContatoFone = new JLabel("Fone:");
    JLabel labelContatoCelular = new JLabel("Celular:");
    JLabel labelContatoCargo = new JLabel("Cargo:");
    JLabel labelContatoEmail = new JLabel("E-mail:");
    TTextField textContatoNome = new TTextField(150, 3);
    TTextFieldTelefone textContatoFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextFieldTelefone textContatoCelular = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
    TTextField textContatoCargo = new TTextField(100);
    TTextField textContatoEmail = new TTextField(100);
    ModeloGridTable modeloContatos = new ModeloGridTable(new String[]{"Nome", "Fone", "Celular", "Cargo", "E-mail"});
    JTable tableContatos = new JTable(this.modeloContatos){

        @Override
        public String getToolTipText() {
            int row = ContatosConvenio.this.tableContatos.rowAtPoint(ContatosConvenio.this.tableContatos.getMousePosition());
            if (row >= 0) {
                String nome = (String)ContatosConvenio.this.modeloContatos.getValueAt(row, 0);
                String fone = (String)ContatosConvenio.this.modeloContatos.getValueAt(row, 1);
                String celular = (String)ContatosConvenio.this.modeloContatos.getValueAt(row, 2);
                String cargo = (String)ContatosConvenio.this.modeloContatos.getValueAt(row, 3);
                String email = (String)ContatosConvenio.this.modeloContatos.getValueAt(row, 4);
                return nome + " | " + fone + " | " + celular + " | " + cargo + " | " + email;
            }
            return null;
        }
    };
    JScrollPane scrollContatos = new JScrollPane(this.tableContatos);
    JButton buttonOKContatos = ComponenteFactory.novoJButton("OK", this);
    final int COLUNA_NOME = 0;
    final int COLUNA_FONE = 1;
    final int COLUNA_CELULAR = 2;
    final int COLUNA_CARGO = 3;
    final int COLUNA_EMAIL = 4;
    int alterandoLinha = -1;

    public static ContatosConvenio novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new ContatosConvenio((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new ContatosConvenio((Dialog)owner);
        }
        return null;
    }

    public ContatosConvenio(Frame owner) {
        super(owner, "Contatos");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public ContatosConvenio(Dialog owner) {
        super(owner, "Contatos");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    private void iniciar() {
        this.setSize(new Dimension(670, 300));
        this.setResizable(false);
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.textContatoFone, this.textContatoCelular);
        Dimension d = new Dimension(20, 20);
        this.scrollContatos.setPreferredSize(d);
        d = new Dimension(20, 20);
        this.textContatoNome.setPreferredSize(d);
        d = new Dimension(110, 20);
        this.textContatoFone.setPreferredSize(d);
        this.textContatoFone.setMinimumSize(d);
        this.textContatoFone.setMaximumSize(d);
        d = new Dimension(110, 20);
        this.textContatoCelular.setPreferredSize(d);
        this.textContatoCelular.setMinimumSize(d);
        this.textContatoCelular.setMaximumSize(d);
        d = new Dimension(110, 20);
        this.textContatoCargo.setPreferredSize(d);
        this.textContatoCargo.setMinimumSize(d);
        this.textContatoCargo.setMaximumSize(d);
        d = new Dimension(20, 20);
        this.textContatoEmail.setPreferredSize(d);
        this.textContatoEmail.setMinimumSize(d);
        this.textContatoEmail.setMaximumSize(d);
        d = new Dimension(40, 20);
        this.buttonOKContatos.setPreferredSize(d);
        this.buttonOKContatos.setMinimumSize(d);
        this.buttonOKContatos.setMaximumSize(d);
        this.buttonOKContatos.setMargin(new Insets(2, 2, 2, 2));
        this.modeloContatos.setColumnSize(new int[]{0, 100, 100, 90, 110}, this.tableContatos);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.labelContatoNome, c);
        ++c.gridx;
        c.gridwidth = 3;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.textContatoNome, c);
        c.gridwidth = 1;
        c.gridx += 3;
        c.insets = new Insets(1, 20, 0, 0);
        c.weightx = 0.0;
        panel.add((Component)this.labelContatoFone, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.textContatoFone, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        panel.add((Component)this.labelContatoCelular, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.textContatoCelular, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.labelContatoCargo, c);
        ++c.gridx;
        panel.add((Component)this.textContatoCargo, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.labelContatoEmail, c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)this.textContatoEmail, c);
        c.gridx += 5;
        c.gridwidth = 1;
        c.weightx = 0.0;
        panel.add((Component)this.buttonOKContatos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.scrollContatos, c);
        this.tableContatos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (ContatosConvenio.this.tableContatos.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(ContatosConvenio.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ContatosConvenio.this.modeloContatos.removeLine(ContatosConvenio.this.tableContatos.getSelectedRow());
                } else if (ContatosConvenio.this.tableContatos.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    ContatosConvenio.this.alterandoLinha = ContatosConvenio.this.tableContatos.getSelectedRow();
                    ContatosConvenio.this.textContatoNome.setText(ContatosConvenio.this.modeloContatos.getValueAt(ContatosConvenio.this.alterandoLinha, 0).toString());
                    ContatosConvenio.this.textContatoFone.setText(ContatosConvenio.this.modeloContatos.getValueAt(ContatosConvenio.this.alterandoLinha, 1).toString());
                    ContatosConvenio.this.textContatoCelular.setText(ContatosConvenio.this.modeloContatos.getValueAt(ContatosConvenio.this.alterandoLinha, 2).toString());
                    ContatosConvenio.this.textContatoCargo.setText(ContatosConvenio.this.modeloContatos.getValueAt(ContatosConvenio.this.alterandoLinha, 3).toString());
                    ContatosConvenio.this.textContatoEmail.setText(ContatosConvenio.this.modeloContatos.getValueAt(ContatosConvenio.this.alterandoLinha, 4).toString());
                    ContatosConvenio.this.textContatoNome.grabFocus();
                }
            }
        });
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.textContatoEmail.setUpperCase(false);
        ScreenUtil.requisitarFoco(this.textContatoNome);
    }

    private int[] calculaTamanhoColunas() {
        if (this.tableContatos != null) {
            FontMetrics met = this.tableContatos.getFontMetrics(this.tableContatos.getFont());
            int[] tamCols = new int[this.modeloContatos.getColumnCount()];
            for (int i = 0; i < tamCols.length; ++i) {
                int tamanho = met.stringWidth(this.modeloContatos.getColumnName(i)) + 18;
                for (int j = 0; j < this.modeloContatos.getRowCount(); ++j) {
                    int tmp = 15;
                    if (met != null && this.modeloContatos.getValueAt(j, i) != null) {
                        tmp = met.stringWidth(this.modeloContatos.getValueAt(j, i).toString()) + 10;
                    }
                    if (tmp <= tamanho) continue;
                    tamanho = tmp;
                }
                tamCols[i] = tamanho;
            }
            return tamCols;
        }
        return new int[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKContatos) {
            this.adicionarContato();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarContato() {
        if (Funcoes.textoVazio(this.textContatoNome)) {
            Funcoes.mensagem(this, "Algum nome/descri\u00e7\u00e3o deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textContatoNome);
            return;
        }
        if (Funcoes.textoVazio(this.textContatoFone) && Funcoes.textoVazio(this.textContatoCelular) && Funcoes.textoVazio(this.textContatoEmail)) {
            Funcoes.mensagem(this, "Algum telefone ou e-mail deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textContatoFone);
            return;
        }
        if (!Funcoes.textoVazio(this.textContatoEmail.getText()) && this.textContatoEmail.getText().indexOf("@") <= 0) {
            Funcoes.mensagem(this, "E-mail inv\u00e1lido", 2);
            this.textContatoEmail.selectAll();
            this.textContatoEmail.grabFocus();
            return;
        }
        if (this.alterandoLinha == -1) {
            this.modeloContatos.addLine(new String[]{this.textContatoNome.getText(), this.textContatoFone.getText(), this.textContatoCelular.getText(), this.textContatoCargo.getText(), this.textContatoEmail.getText()});
        } else {
            this.modeloContatos.setValueAt(this.textContatoNome.getText(), this.alterandoLinha, 0);
            this.modeloContatos.setValueAt(this.textContatoFone.getText(), this.alterandoLinha, 1);
            this.modeloContatos.setValueAt(this.textContatoCelular.getText(), this.alterandoLinha, 2);
            this.modeloContatos.setValueAt(this.textContatoCargo.getText(), this.alterandoLinha, 3);
            this.modeloContatos.setValueAt(this.textContatoEmail.getText(), this.alterandoLinha, 4);
            this.alterandoLinha = -1;
        }
        this.textContatoNome.clear();
        this.textContatoFone.clear();
        this.textContatoCelular.clear();
        this.textContatoCargo.clear();
        this.textContatoEmail.clear();
        ScreenUtil.requisitarFoco(this.textContatoNome);
    }

    public void setContatos(ArrayList<ContatoConvenio> contatos) {
        this.modeloContatos.clear();
        for (ContatoConvenio c : contatos) {
            this.modeloContatos.addLine(new String[]{c.nome, c.fone, c.celular, c.cargo, c.email});
        }
    }

    public ArrayList<ContatoConvenio> getContatos() {
        ArrayList<ContatoConvenio> c = new ArrayList<ContatoConvenio>();
        for (int i = 0; i < this.modeloContatos.getRowCount(); ++i) {
            c.add(new ContatoConvenio(this.modeloContatos.getValueAt(i, 0).toString(), this.modeloContatos.getValueAt(i, 1).toString(), this.modeloContatos.getValueAt(i, 2).toString(), this.modeloContatos.getValueAt(i, 3).toString(), this.modeloContatos.getValueAt(i, 4).toString()));
        }
        return c;
    }
}

