/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.InterfaceDesmembrar;
import jalis.laboratorio.util.ExameMatColetaLabExtDesm;
import jalis.service.cadastro.exame.ExameMatColetaLabExternoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfirmarCondicaoAmostra
extends JDialog {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(this.grid);
    private JButton buttonSalvar = new JButton("Salvar");
    private JLabel labelDesmExame = new JLabel("Exame");
    private TTextField txtCodExameDesm = new TTextField(5);
    private JButton buttonBuscaExameDesm = new JButton();
    private TTextField txtDescExameDesm = new TTextField();
    private JLabel labelMatExameDesm = new JLabel("Material");
    private TTextField txtMatExameDesm = new TTextField();
    private JButton buttonOKExameDesm = new JButton("OK");
    private JTable tableExameDesm = new JTable();
    private JScrollPane scrollExameDesm = new JScrollPane(this.tableExameDesm);
    private ModeloGridTable modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Exame", "Alternativo"});
    private JLabel labelCondicaoAmostra = new JLabel("Condi\u00e7\u00e3o da amostra");
    private TTextField txtCondicaoAmostra = new TTextField(80);
    private boolean isOK = false;
    private boolean isAlterouRegistro = false;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_MATERIAL = 2;
    private final int COLUNA_CONDICAO_AMOSTRA = 3;
    private int linhaAlterada = -1;
    private boolean ocultarAlternativo = false;
    private boolean isLabExterno = false;
    private String codigoLabExterno;
    private String examePai;
    private String matExaPai;
    private String reqCodigo;
    private ArrayList<ExameMatColetaLabExtDesm> listExames = new ArrayList();

    public ConfirmarCondicaoAmostra(Dialog owner, String examePai, String matExamePai, String codigoLabExterno, String reqCodigo) {
        super(owner);
        this.examePai = examePai;
        this.matExaPai = matExamePai;
        this.codigoLabExterno = codigoLabExterno;
        this.reqCodigo = reqCodigo;
        this.montaTela(owner, examePai);
    }

    public void montaTela(Dialog owner, String exame) {
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(930, 355);
        this.setLocationRelativeTo(owner);
        this.setTitle("Informar condi\u00e7\u00e3o da amostra do desmembrado " + exame);
        this.setResizable(false);
        this.setModal(true);
        this.desabilitarCampos();
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonSalvar);
        this.modeloDesmembrar = new ModeloGridTable(new String[]{"C\u00f3digo", "Exame", "Material", "Condi\u00e7\u00e3o da Amostra"});
        this.tableExameDesm.setModel(this.modeloDesmembrar);
        this.modeloDesmembrar.setColumnSize(new int[]{60, 600, 99, 170}, this.tableExameDesm);
        this.buttonOKExameDesm.setMargin(new Insets(2, 2, 2, 2));
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDesmExame, this.constraints);
        this.constraints.gridx = 3;
        this.panelCentro.add((Component)this.labelMatExameDesm, this.constraints);
        this.constraints.gridx = 4;
        this.panelCentro.add((Component)this.labelCondicaoAmostra, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.txtCodExameDesm.setPreferredSize(new Dimension(60, 20));
        this.txtCodExameDesm.setMinimumSize(new Dimension(60, 20));
        this.panelCentro.add((Component)this.txtCodExameDesm, this.constraints);
        this.constraints.gridx = 3;
        this.txtMatExameDesm.setPreferredSize(new Dimension(120, 20));
        this.txtMatExameDesm.setMinimumSize(new Dimension(120, 20));
        this.panelCentro.add((Component)this.txtMatExameDesm, this.constraints);
        this.constraints.gridx = 4;
        this.txtCondicaoAmostra.setPreferredSize(new Dimension(125, 20));
        this.txtCondicaoAmostra.setMinimumSize(new Dimension(125, 20));
        this.panelCentro.add((Component)this.txtCondicaoAmostra, this.constraints);
        this.constraints.gridx = 5;
        this.buttonOKExameDesm.setPreferredSize(new Dimension(40, 20));
        this.buttonOKExameDesm.setMinimumSize(new Dimension(40, 20));
        this.panelCentro.add((Component)this.buttonOKExameDesm, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.txtDescExameDesm.setPreferredSize(new Dimension(100, 20));
        this.txtDescExameDesm.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.txtDescExameDesm, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        this.constraints.gridwidth = 7;
        this.panelCentro.add((Component)this.scrollExameDesm, this.constraints);
        this.buttonBuscaExameDesm.setFocusable(false);
        this.txtDescExameDesm.setFocusable(false);
        this.txtDescExameDesm.setEditable(false);
        this.buttonSalvar.setMnemonic('S');
        this.labelDesmExame.setDisplayedMnemonic('x');
        this.labelDesmExame.setLabelFor(this.txtCodExameDesm);
        Funcoes.imagemPesquisa(this.buttonBuscaExameDesm);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.txtCodExameDesm.setUpperCase(true);
        this.buscaExaDesm();
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfirmarCondicaoAmostra.this.isOK = true;
                ConfirmarCondicaoAmostra.this.atualizaDados();
                ConfirmarCondicaoAmostra.this.dispose();
            }
        });
        this.buttonOKExameDesm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfirmarCondicaoAmostra.this.linhaAlterada > -1 && ConfirmarCondicaoAmostra.this.isCondicaoInformada()) {
                    ConfirmarCondicaoAmostra.this.modeloDesmembrar.setValueAt(ConfirmarCondicaoAmostra.this.txtCodExameDesm.getText(), ConfirmarCondicaoAmostra.this.linhaAlterada, 0);
                    ConfirmarCondicaoAmostra.this.modeloDesmembrar.setValueAt(ConfirmarCondicaoAmostra.this.txtDescExameDesm.getText(), ConfirmarCondicaoAmostra.this.linhaAlterada, 1);
                    ConfirmarCondicaoAmostra.this.modeloDesmembrar.setValueAt(ConfirmarCondicaoAmostra.this.txtMatExameDesm.getText(), ConfirmarCondicaoAmostra.this.linhaAlterada, 2);
                    ConfirmarCondicaoAmostra.this.modeloDesmembrar.setValueAt(ConfirmarCondicaoAmostra.this.txtCondicaoAmostra.getText(), ConfirmarCondicaoAmostra.this.linhaAlterada, 3);
                    ConfirmarCondicaoAmostra.this.isAlterouRegistro = true;
                    ConfirmarCondicaoAmostra.this.limpaCampos();
                }
            }
        });
        this.tableExameDesm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && ConfirmarCondicaoAmostra.this.tableExameDesm.getSelectedRow() > -1) {
                    ConfirmarCondicaoAmostra.this.alteraLinhaDesmembrar(ConfirmarCondicaoAmostra.this.tableExameDesm.getSelectedRow());
                }
            }
        });
        this.tableExameDesm.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ConfirmarCondicaoAmostra.this.tableExameDesm.getSelectedRow() > -1) {
                    ConfirmarCondicaoAmostra.this.alteraLinhaDesmembrar(ConfirmarCondicaoAmostra.this.tableExameDesm.getSelectedRow());
                }
            }
        });
    }

    private void desabilitarCampos() {
        this.txtCodExameDesm.setEnabled(false);
        this.txtDescExameDesm.setEnabled(false);
        this.txtMatExameDesm.setEnabled(false);
    }

    private void limpaCampos() {
        this.txtCodExameDesm.clear();
        this.txtDescExameDesm.clear();
        this.txtMatExameDesm.clear();
        this.txtCondicaoAmostra.clear();
        this.linhaAlterada = -1;
    }

    private void atualizaDados() {
        if (this.isAlterouRegistro) {
            for (int i = 0; i < this.modeloDesmembrar.getRowCount(); ++i) {
                this.atualizaDadosExa(this.modeloDesmembrar.getValueAt(i, 0).toString(), this.modeloDesmembrar.getValueAt(i, 3).toString());
            }
        }
    }

    private void atualizaDadosExa(String codExa, String condicao) {
        for (ExameMatColetaLabExtDesm exa : this.listExames) {
            if (!exa.getCodExaFilho().equalsIgnoreCase(codExa)) continue;
            exa.setCondicaoAmostra(condicao);
            break;
        }
    }

    public boolean contemExamesFilho() {
        return this.listExames.size() > 0;
    }

    private boolean isCondicaoInformada() {
        if (Funcoes.textoVazio(this.txtCondicaoAmostra)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A condi\u00e7\u00e3o da amostra deve ser informada", 2);
            ScreenUtil.requisitarFoco(this.txtCodExameDesm);
            return false;
        }
        return true;
    }

    public ArrayList getExames() {
        ArrayList<InterfaceDesmembrar> exames = new ArrayList<InterfaceDesmembrar>();
        for (ExameMatColetaLabExtDesm exaFilho : this.listExames) {
            DadosMaterial mat = new DadosMaterial(Integer.parseInt(exaFilho.getMatExaFilho()), exaFilho.getDescMatExaFilho(), false, false);
            InterfaceDesmembrar interfaceDesmembrar = new InterfaceDesmembrar(exaFilho.getCodExaFilho(), exaFilho.getDescExaFilho(), "", this.examePai, exaFilho.getCondicaoAmostra(), mat);
            interfaceDesmembrar.setCodRec(this.reqCodigo);
            exames.add(interfaceDesmembrar);
        }
        return exames;
    }

    private void buscaExaDesm() {
        try {
            ExameMatColetaLabExternoService service = new ExameMatColetaLabExternoService();
            this.listExames.addAll(service.buscaExamesDesm(Variaveis.filialPadrao, this.examePai, this.matExaPai, this.codigoLabExterno));
            for (ExameMatColetaLabExtDesm exaFilho : this.listExames) {
                this.modeloDesmembrar.addLine(new Object[]{exaFilho.getCodExaFilho(), exaFilho.getDescExaFilho(), exaFilho.getDescMatExaFilho(), exaFilho.getCondicaoAmostra()});
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar exames desmembrados.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void alteraLinhaDesmembrar(int linha) {
        this.linhaAlterada = linha;
        this.txtCodExameDesm.setText(this.modeloDesmembrar.getValueAt(linha, 0).toString());
        this.txtDescExameDesm.setText(this.modeloDesmembrar.getValueAt(linha, 1).toString());
        this.txtMatExameDesm.setText(this.modeloDesmembrar.getValueAt(linha, 2).toString());
        this.txtCondicaoAmostra.setText(this.modeloDesmembrar.getValueAt(linha, 3).toString());
    }

    public boolean isOK() {
        return this.isOK;
    }
}

