/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.exportacao.texto.CampoDetalhe;
import jalis.laboratorio.exportacao.texto.CampoValor;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfiguradorResultadoTexto
extends AbstractDialogoOKCancelar
implements ActionListener {
    public static final String EXPORTAR_TEXTO = "exportartexto";
    private final int COLUNA_CAMPO = 0;
    private final int COLUNA_ALTERNATIVO = 1;
    private final int COLUNA_DETALHES = 2;
    private final int COLUNA_DETALHES_VALOR = 0;
    private final int COLUNA_DETALHES_TROCA = 1;
    private JComboBox comboCampos = ComponenteFactory.novoJComboBox(new Dimension(40, 20));
    private JLabel labelCampos = ComponenteFactory.novoJLabel("Campos", 'm', null, this.comboCampos);
    private TTextField textAlternativo = new TTextField();
    private JButton buttonOKCampo = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Campo", "Alternativo"});
    private JTable table = new JTable(this.modelo);
    private JScrollPane scroll = new JScrollPane(this.table);
    private JPanel panelDetalhes = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Detalhes"));
    private ModeloGridTable modeloDetalhes = new ModeloGridTable(new String[]{"Resultado", "Valor"});
    private JTable tableDetalhes = ComponenteFactory.novoJTable(this.modeloDetalhes);
    private JScrollPane scrollDetalhes = new JScrollPane(this.tableDetalhes);
    private JLabel labelValor = new JLabel("Valor");
    private JLabel labelTroca = new JLabel("Converter");
    private TTextField textValor = new TTextField();
    private TTextField textTroca = new TTextField();
    private JButton buttonOKDetalhes = ComponenteFactory.novoJButton("OK", '\u0000', this, null, new Dimension(40, 20));
    private JButton buttonAcima = ComponenteFactory.novoJButton("\u25b2", this);
    private JButton buttonAbaixo = ComponenteFactory.novoJButton("\u25bc", this);
    private int editandoLinha = -1;

    public static ConfiguradorResultadoTexto novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new ConfiguradorResultadoTexto((Dialog)pai, "Resultado Texto");
        }
        return new ConfiguradorResultadoTexto((Frame)pai, "Resultado Texto");
    }

    public ConfiguradorResultadoTexto(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorResultadoTexto(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(400, 400));
        this.setResizable(false);
        this.setModal(true);
        this.buttonAcima.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAbaixo.setMargin(new Insets(0, 0, 0, 0));
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        panel.add((Component)this.labelCampos, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.comboCampos.setMinimumSize(new Dimension(40, 20));
        panel.add((Component)this.comboCampos, c);
        c.gridx = 1;
        this.textAlternativo.setPreferredSize(new Dimension(100, 20));
        panel.add((Component)this.textAlternativo, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKCampo.setMinimumSize(new Dimension(40, 20));
        this.buttonOKCampo.setMaximumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKCampo, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.scroll, c);
        c.gridx = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.panelDetalhes, c);
        this.montaDetalhes();
        GridBagConstraints c2 = new GridBagConstraints();
        c.gridy = 0;
        this.buttonAcima.setPreferredSize(new Dimension(40, 20));
        this.buttonAbaixo.setPreferredSize(new Dimension(40, 20));
        this.buttonAcima.setMinimumSize(new Dimension(40, 20));
        this.buttonAbaixo.setMinimumSize(new Dimension(40, 20));
        p.add((Component)this.buttonAcima, c2);
        c2.gridy = 1;
        p.add((Component)this.buttonAbaixo, c2);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoTexto.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoTexto.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConfiguradorResultadoTexto.this.modelo.removeLine(ConfiguradorResultadoTexto.this.table.getSelectedRow());
                } else if (e.getKeyCode() == 32 && ConfiguradorResultadoTexto.this.table.getSelectedRow() > -1) {
                    ConfiguradorResultadoTexto.this.editandoLinha = ConfiguradorResultadoTexto.this.table.getSelectedRow();
                    ConfiguradorResultadoTexto.this.textAlternativo.setText(ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.editandoLinha, 1).toString());
                    ConfiguradorResultadoTexto.this.comboCampos.setSelectedItem(ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.editandoLinha, 0).toString());
                    ScreenUtil.requisitarFoco(ConfiguradorResultadoTexto.this.textAlternativo);
                }
            }
        });
        this.tableDetalhes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorResultadoTexto.this.tableDetalhes.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorResultadoTexto.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    String valor = ConfiguradorResultadoTexto.this.modeloDetalhes.getValueAt(ConfiguradorResultadoTexto.this.tableDetalhes.getSelectedRow(), 0).toString();
                    ConfiguradorResultadoTexto.this.modeloDetalhes.removeLine(ConfiguradorResultadoTexto.this.tableDetalhes.getSelectedRow());
                    if (ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2) != null && ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2) instanceof ArrayList) {
                        ArrayList detalhes = (ArrayList)ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2);
                        for (int i = 0; i < detalhes.size(); ++i) {
                            CampoDetalhe d = (CampoDetalhe)detalhes.get(i);
                            if (!d.getValor().equalsIgnoreCase(valor)) continue;
                            detalhes.remove(i);
                            break;
                        }
                    }
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ConfiguradorResultadoTexto.this.modeloDetalhes.clear();
                if (ConfiguradorResultadoTexto.this.table.getSelectedRow() > -1 && ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2) != null && ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2) instanceof ArrayList) {
                    ArrayList detalhes = (ArrayList)ConfiguradorResultadoTexto.this.modelo.getValueAt(ConfiguradorResultadoTexto.this.table.getSelectedRow(), 2);
                    for (CampoDetalhe d : detalhes) {
                        ConfiguradorResultadoTexto.this.modeloDetalhes.addLine(new String[]{d.getValor(), d.getTroca()});
                    }
                }
            }
        });
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void montaDetalhes() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.panelDetalhes.add((Component)this.labelValor, c);
        c.gridx = 1;
        c.gridwidth = 2;
        this.panelDetalhes.add((Component)this.labelTroca, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.comboCampos.setMinimumSize(new Dimension(40, 20));
        this.panelDetalhes.add((Component)this.textValor, c);
        c.gridx = 1;
        this.textAlternativo.setPreferredSize(new Dimension(100, 20));
        this.panelDetalhes.add((Component)this.textTroca, c);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKDetalhes.setMinimumSize(new Dimension(40, 20));
        this.buttonOKDetalhes.setMaximumSize(new Dimension(40, 20));
        this.panelDetalhes.add((Component)this.buttonOKDetalhes, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDetalhes.add((Component)this.scrollDetalhes, c);
    }

    public void setCampos(String[] campos) {
        if (campos != null) {
            this.comboCampos.removeAllItems();
            for (String s : campos) {
                this.comboCampos.addItem(s);
            }
        }
    }

    public String getXml() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            buf.append("<campo>");
            buf.append(StringUtil.getTag("ordem", String.valueOf(i)));
            buf.append(StringUtil.getTag("nome", this.modelo.getValueAt(i, 0).toString()));
            buf.append(StringUtil.getTag("valor", this.modelo.getValueAt(i, 1).toString()));
            if (this.modelo.getValueAt(i, 2) != null && this.modelo.getValueAt(i, 2) instanceof ArrayList) {
                ArrayList detalhes = (ArrayList)this.modelo.getValueAt(i, 2);
                buf.append("<camposdetalhes>");
                for (CampoDetalhe d : detalhes) {
                    buf.append("<campodetalhe>");
                    buf.append(StringUtil.getTag("valordetalhe", d.getValor()));
                    buf.append(StringUtil.getTag("trocadetalhe", d.getTroca()));
                    buf.append("</campodetalhe>");
                }
                buf.append("</camposdetalhes>");
            }
            buf.append("</campo>");
        }
        return StringUtil.getTag(EXPORTAR_TEXTO, buf.toString());
    }

    public void setXml(String xml) {
        if (xml != null) {
            List<CampoValor> campos = ConfiguradorResultadoTexto.getListaRelacionamentoCampos(xml);
            this.modelo.clear();
            for (CampoValor campo : campos) {
                this.modelo.addLine(new Object[]{campo.getCampo(), campo.getValor(), campo.getDetalhes()});
            }
        }
    }

    public static LinkedHashMap<String, CampoValor> getRelacionamentoCampos(String xml) {
        LinkedHashMap<String, CampoValor> hash = new LinkedHashMap<String, CampoValor>();
        List<CampoValor> lista = ConfiguradorResultadoTexto.getListaRelacionamentoCampos(xml);
        for (CampoValor c : lista) {
            hash.put(c.getCampo(), c);
        }
        return hash;
    }

    public static List<CampoValor> getListaRelacionamentoCampos(String xml) {
        ArrayList<CampoValor> lista = new ArrayList<CampoValor>();
        if (xml != null && !Funcoes.textoVazio(StringUtil.getValor(xml, EXPORTAR_TEXTO))) {
            String[] campos;
            for (String s : campos = StringUtil.getValores(StringUtil.getValor(xml, EXPORTAR_TEXTO), "campo")) {
                String tmp = StringUtil.getValor(s, "ordem");
                boolean validaOrdem = StringUtil.validaInteiro(tmp);
                int ordem = validaOrdem ? StringUtil.getInt(s, "ordem") : Integer.MAX_VALUE;
                String nome = StringUtil.getValor(s, "nome");
                String valor = StringUtil.getValor(s, "valor");
                String detalhes = StringUtil.getValor(s, "camposdetalhes");
                ArrayList<CampoDetalhe> d = new ArrayList<CampoDetalhe>();
                if (!Funcoes.textoVazio(detalhes)) {
                    String[] camposDetalhes;
                    for (String x : camposDetalhes = StringUtil.getValores(detalhes, "campodetalhe")) {
                        d.add(new CampoDetalhe(StringUtil.getValor(x, "valordetalhe"), StringUtil.getValor(x, "trocadetalhe")));
                    }
                }
                lista.add(new CampoValor(ordem, nome, valor, null, d));
            }
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                int retorno;
                int ordem2;
                int ordem1 = ((CampoValor)o1).getOrdem();
                int n = ordem1 > (ordem2 = ((CampoValor)o2).getOrdem()) ? 1 : (retorno = ordem1 < ordem2 ? -1 : 0);
                if (retorno == 0 && ordem1 == Integer.MAX_VALUE) {
                    return ((CampoValor)o1).getValor().compareTo(((CampoValor)o2).getValor());
                }
                return retorno;
            }
        });
        return lista;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAbaixo) {
            int linha = this.table.getSelectedRow();
            if (linha < this.table.getRowCount() - 1) {
                String tmp1 = this.modelo.getValueAt(linha, 0).toString();
                String tmp2 = this.modelo.getValueAt(linha, 1).toString();
                ArrayList tmp3 = (ArrayList)this.modelo.getValueAt(linha, 2);
                this.modelo.setValueAt(this.modelo.getValueAt(linha + 1, 0).toString(), linha, 0);
                this.modelo.setValueAt(this.modelo.getValueAt(linha + 1, 1).toString(), linha, 1);
                this.modelo.setValueAt((ArrayList)this.modelo.getValueAt(linha + 1, 2), linha, 2);
                this.modelo.setValueAt(tmp1, linha + 1, 0);
                this.modelo.setValueAt(tmp2, linha + 1, 1);
                this.modelo.setValueAt(tmp3, linha + 1, 2);
                this.table.setRowSelectionInterval(linha + 1, linha + 1);
            }
        } else if (e.getSource() == this.buttonAcima) {
            int linha = this.table.getSelectedRow();
            if (linha > 0) {
                String tmp1 = this.modelo.getValueAt(linha, 0).toString();
                String tmp2 = this.modelo.getValueAt(linha, 1).toString();
                ArrayList tmp3 = (ArrayList)this.modelo.getValueAt(linha, 2);
                this.modelo.setValueAt(this.modelo.getValueAt(linha - 1, 0).toString(), linha, 0);
                this.modelo.setValueAt(this.modelo.getValueAt(linha - 1, 1).toString(), linha, 1);
                this.modelo.setValueAt((ArrayList)this.modelo.getValueAt(linha - 1, 2), linha, 2);
                this.modelo.setValueAt(tmp1, linha - 1, 0);
                this.modelo.setValueAt(tmp2, linha - 1, 1);
                this.modelo.setValueAt(tmp3, linha - 1, 2);
                this.table.setRowSelectionInterval(linha - 1, linha - 1);
            }
        } else if (e.getSource() == this.buttonOKCampo) {
            this.adicionar();
        } else if (e.getSource() == this.buttonOKDetalhes) {
            this.adicionaDetalhes();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionar() {
        if (this.editandoLinha > -1) {
            this.modelo.setValueAt(this.textAlternativo.getText(), this.editandoLinha, 1);
            this.modelo.setValueAt(this.comboCampos.getSelectedItem().toString(), this.editandoLinha, 0);
            this.editandoLinha = -1;
        } else if (this.modelo.localizar(0, this.comboCampos.getSelectedItem().toString()) < 0) {
            this.modelo.addLine(new Object[]{this.comboCampos.getSelectedItem().toString(), this.textAlternativo.getText(), new ArrayList()});
        }
        this.textAlternativo.clear();
        ScreenUtil.requisitarFoco(this.comboCampos);
    }

    private void adicionaDetalhes() {
        if (this.table.getSelectedRow() > -1 && this.modelo.getValueAt(this.table.getSelectedRow(), 2) != null && this.modelo.getValueAt(this.table.getSelectedRow(), 2) instanceof ArrayList && this.modeloDetalhes.localizar(0, this.textValor.getText()) < 0) {
            ArrayList detalhes = (ArrayList)this.modelo.getValueAt(this.table.getSelectedRow(), 2);
            detalhes.add(new CampoDetalhe(this.textValor.getText(), this.textTroca.getText()));
            this.modeloDetalhes.addLine(new String[]{this.textValor.getText(), this.textTroca.getText()});
        }
        this.textValor.clear();
        this.textTroca.clear();
        ScreenUtil.requisitarFoco(this.textValor);
    }
}

