/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosLocais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.cadastro.Incerteza;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ConfiguradorIncerteza
extends AbstractDialogoOKCancelar
implements ActionListener {
    private JButton buttonModelo = ComponenteFactory.novoJButton("Modelo", this);
    private JButton buttonAcima = ComponenteFactory.novoJButton("\u25b2", this);
    private JButton buttonAbaixo = ComponenteFactory.novoJButton("\u25bc", this);
    private JButton buttonOKDescricao = ComponenteFactory.novoJButton("OK", this);
    private TTextField textDescricao = new TTextField(50);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"#", "Descri\u00e7\u00e3o"});
    private JTable table = new JTable(this.modelo);
    private final int COLUNA_ORDEM = 0;
    private final int COLUNA_DESCRICAO = 1;
    private final int COLUNA_MODELO = 2;
    private String perguntasFilial = "";
    private String perguntasExame = "";
    private String cabecalhoGeral = "";
    private Map<String, Map<String, String>> historicos = null;

    public ConfiguradorIncerteza(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public ConfiguradorIncerteza(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public static ConfiguradorIncerteza novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new ConfiguradorIncerteza((Frame)pai, "Incerteza");
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorIncerteza((Dialog)pai, "Incerteza");
        }
        return null;
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(new Dimension(300, 420));
        this.setLocationRelativeTo(this.getParent());
        this.getPanelBotoesEsquerda().add(this.buttonModelo);
        this.buttonAcima.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAbaixo.setMargin(new Insets(0, 0, 0, 0));
        this.modelo.setColumnSize(new int[]{30, 0}, this.table);
        JPanel panelOrdem = new JPanel(new GridBagLayout());
        panelOrdem.setPreferredSize(new Dimension(40, 20));
        panelOrdem.setMinimumSize(new Dimension(40, 20));
        GridBagConstraints c1 = new GridBagConstraints();
        c1.weighty = 1.0;
        c1.gridx = 0;
        c1.gridy = 0;
        c1.fill = 3;
        panelOrdem.add((Component)new JPanel(), c1);
        c1.gridy = 3;
        panelOrdem.add((Component)new JPanel(), c1);
        c1.gridy = 1;
        c1.fill = 0;
        c1.weighty = 0.0;
        this.buttonAcima.setPreferredSize(new Dimension(20, 20));
        this.buttonAcima.setMinimumSize(new Dimension(20, 20));
        panelOrdem.add((Component)this.buttonAcima, c1);
        c1.gridy = 2;
        this.buttonAbaixo.setPreferredSize(new Dimension(20, 20));
        this.buttonAbaixo.setMinimumSize(new Dimension(20, 20));
        panelOrdem.add((Component)this.buttonAbaixo, c1);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel("Descri\u00e7\u00e3o");
        Insets insets = c.insets;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 2;
        panelCentral.add((Component)label, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.textDescricao.setPreferredSize(new Dimension(250, 20));
        this.textDescricao.setMinimumSize(new Dimension(250, 20));
        panelCentral.add((Component)this.textDescricao, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.buttonOKDescricao.setPreferredSize(new Dimension(40, 20));
        this.buttonOKDescricao.setMinimumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.buttonOKDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panelCentral.add((Component)new JScrollPane(this.table), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 3;
        panelCentral.add((Component)panelOrdem, c);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConfiguradorIncerteza.this.table.getSelectedRow() > -1 && Funcoes.mensagem(ConfiguradorIncerteza.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    int linha = ConfiguradorIncerteza.this.table.getSelectedRow();
                    int contador = Integer.parseInt(ConfiguradorIncerteza.this.modelo.getValueAt(linha, 0).toString());
                    ConfiguradorIncerteza.this.modelo.removeLine(linha);
                    if (linha <= ConfiguradorIncerteza.this.table.getRowCount()) {
                        for (int i = linha; i < ConfiguradorIncerteza.this.table.getRowCount(); ++i) {
                            ConfiguradorIncerteza.this.modelo.setValueAt(String.valueOf(contador++), i, 0);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOKDescricao) {
            int pos = this.modelo.localizar(1, this.textDescricao.getText());
            if (pos < 0) {
                this.modelo.addLine(new String[]{String.valueOf(this.modelo.getRowCount() + 1), this.textDescricao.getText(), ""});
                this.textDescricao.clear();
            } else {
                Funcoes.mensagem(this, "A incerteza informada j\u00e1 existe.", 1);
            }
            this.textDescricao.selectAll();
            ScreenUtil.requisitarFoco(this.textDescricao);
        } else if (e.getSource() == this.buttonModelo) {
            this.configurarModelo();
        } else if (e.getSource() == this.buttonAcima) {
            int linha = this.table.getSelectedRow();
            if (linha > 0) {
                String tmp1 = this.modelo.getValueAt(linha, 1).toString();
                String tmp2 = this.modelo.getValueAt(linha, 2).toString();
                this.modelo.setValueAt(this.modelo.getValueAt(linha - 1, 1).toString(), linha, 1);
                this.modelo.setValueAt(this.modelo.getValueAt(linha - 1, 2).toString(), linha, 2);
                this.modelo.setValueAt(tmp1, linha - 1, 1);
                this.modelo.setValueAt(tmp2, linha - 1, 2);
                this.table.setRowSelectionInterval(linha - 1, linha - 1);
            }
        } else if (e.getSource() == this.buttonAbaixo) {
            int linha = this.table.getSelectedRow();
            if (linha > -1 && linha < this.table.getRowCount() - 1) {
                String tmp1 = this.modelo.getValueAt(linha, 1).toString();
                String tmp2 = this.modelo.getValueAt(linha, 2).toString();
                this.modelo.setValueAt(this.modelo.getValueAt(linha + 1, 1).toString(), linha, 1);
                this.modelo.setValueAt(this.modelo.getValueAt(linha + 1, 2), linha, 2);
                this.modelo.setValueAt(tmp1, linha + 1, 1);
                this.modelo.setValueAt(tmp2, linha + 1, 2);
                this.table.setRowSelectionInterval(linha + 1, linha + 1);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void configurarModelo() {
        int linha = this.table.getSelectedRow();
        if (linha < 0) {
            return;
        }
        DialogoConfigurador configurador = new DialogoConfigurador((Dialog)this, "Configurando incerteza", true, false);
        configurador.setTipoConfiguracao(0);
        String[] perguntasFilialRequisicao = null;
        if (!Funcoes.textoVazio(this.perguntasFilial)) {
            Digitacao dig = new Digitacao();
            dig.carregarCampos(this.perguntasFilial, true);
            Map<String, Object> perguntasRequisicao = Resultado.getCamposResultado(dig.getResultado());
            perguntasFilialRequisicao = perguntasRequisicao.keySet().toArray(new String[perguntasRequisicao.size()]);
        }
        if (perguntasFilialRequisicao != null) {
            configurador.setCamposBanco(ArraysUtil.concatenar(Impressao.CAMPOS_EXAME, perguntasFilialRequisicao));
        } else {
            configurador.setCamposBanco(Impressao.CAMPOS_EXAME);
        }
        configurador.setFormatacaoExterna(this.perguntasExame);
        configurador.setImpressoraPadraoSistema(Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraLaudo")));
        if (this.cabecalhoGeral != null && !Funcoes.textoVazio(this.cabecalhoGeral)) {
            configurador.setAtributosDaPagina(this.cabecalhoGeral);
            configurador.setCabecalhoImpressaoSistema(this.cabecalhoGeral);
        }
        configurador.setHistoricos(this.historicos);
        configurador.setAtributos(this.modelo.getValueAt(linha, 2) != null ? this.modelo.getValueAt(linha, 2).toString() : "");
        configurador.setVisible(true);
        if (configurador.ok()) {
            String atributos = "";
            if (configurador.contemConfiguracao()) {
                atributos = configurador.getAtributos();
                this.modelo.setValueAt(atributos, linha, 2);
            }
        }
    }

    public void setPerguntasFilial(String perguntasFilial) {
        this.perguntasFilial = perguntasFilial;
    }

    public void setPerguntasExame(String perguntasExame) {
        this.perguntasExame = perguntasExame;
    }

    public void setCabecalhoGeral(String cabecalhoGeral) {
        this.cabecalhoGeral = cabecalhoGeral;
    }

    public void setHistoricos(Map<String, Map<String, String>> historicos) {
        this.historicos = historicos;
    }

    public void setIncerteza(ArrayList<Incerteza> incerteza) {
        if (incerteza != null && incerteza.size() > 0) {
            for (Incerteza in : incerteza) {
                this.modelo.addLine(new String[]{String.valueOf(in.getContador()), in.getDescricao(), in.getXml()});
            }
        }
    }

    public ArrayList<Incerteza> getIncerteza() {
        ArrayList<Incerteza> retorno = new ArrayList<Incerteza>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            retorno.add(new Incerteza(i + 1, this.modelo.getValueAt(i, 1).toString(), this.modelo.getValueAt(i, 2).toString()));
        }
        return retorno;
    }
}

