/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.cadastro.ExcecoesDevedor;
import jalis.laboratorio.cadastro.FiliaisAgrupadas;
import jalis.laboratorio.cadastro.TelaAssinatura;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfiguradorDadosWeb
extends JDialog
implements ActionListener {
    JPanel panelCentral = new JPanel(null);
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private static String OK = "OK";
    private static String CANCELADO = "CANCELADO";
    private JLabel labelBase = new JLabel("C\u00f3digo:");
    private JLabel labelSite = new JLabel("Site:");
    private JLabel labelEmail = new JLabel("E-mail:");
    private JLabel labelIncompleto = new JLabel("Incompletos:");
    private JLabel labelProibido = new JLabel("Proibido:");
    private JLabel labelResponsavel = new JLabel("Respons\u00e1vel:");
    private JLabel labelDevedor = new JLabel("Devedor:");
    private JLabel labelQtdePagina = new JLabel("Qtde. P\u00e1gina:");
    private TTextField txtBase = new TTextField(10);
    private TTextField txtSite = new TTextField(100);
    private TTextField txtEmail = new TTextField(100);
    private TTextField txtFraseIncompleto = new TTextField(250);
    private TTextField txtFraseProibido = new TTextField(250);
    private TTextField txtFraseResponsavel = new TTextField(250);
    private TTextField txtFraseDevedor = new TTextField(250);
    private TTextField txtQtdePagina = new TTextField(3);
    private JCheckBox checkDevedora = ComponenteFactory.novoJCheckBox("Visualizar requisi\u00e7\u00f5es devedoras", this);
    private JCheckBox checkVerAssinado = new JCheckBox("Visualizar laudos sem assinatura");
    private JCheckBox checkCPF = new JCheckBox("Considerar C.P.F. para buscar paciente");
    private JCheckBox checkImprimir = new JCheckBox("Apresentar bot\u00e3o [Clique para imprimir]");
    private JCheckBox checkAssinatura = ComponenteFactory.novoJCheckBox("Apresentar assinatura no rodap\u00e9 do exame", this);
    private JCheckBox checkMensagem = ComponenteFactory.novoJCheckBox("Apresentar mensagens de conv\u00eanio em Popup", null);
    private JCheckBox checkResultadoJanela = ComponenteFactory.novoJCheckBox("Apresentar resultados em janela separada", null);
    private JCheckBox checkCabecalhoConfigurado = ComponenteFactory.novoJCheckBox("Utilizar cabe\u00e7alho configurado", null);
    private JCheckBox checkResultadoTexto = ComponenteFactory.novoJCheckBox("Enviar o resultado texto para web", this);
    private JCheckBox checkResultadoStandAlone = ComponenteFactory.novoJCheckBox("Enviar o resultado atrav\u00e9s do Stand-alone", this);
    private JCheckBox checkResultadoPdf = ComponenteFactory.novoJCheckBox("Enviar o resultado como pdf para web", this);
    private JCheckBox checkAssinaturaExame = ComponenteFactory.novoJCheckBox("Utilizar assinatura padr\u00e3o por exame", this);
    private JCheckBox checkEmailConvenio = new JCheckBox("Enviar e-mail para Conv\u00eanio");
    private JCheckBox checkEmailDestino = new JCheckBox("Enviar e-mail para Destino");
    private JCheckBox checkEmailEntidade = new JCheckBox("Enviar e-mail para Entidade");
    private JCheckBox checkEmailMedico = new JCheckBox("Enviar e-mail para M\u00e9dico");
    private JCheckBox checkEmailPaciente = new JCheckBox("Enviar e-mail para Paciente");
    private JCheckBox checkImagemConvenio = new JCheckBox("Imagem Conv\u00eanio");
    private JCheckBox checkImagemDestino = new JCheckBox("Imagem Destino");
    private JButton buttonAssinatura = ComponenteFactory.novoJButton("Assinatura", 't', this, null, null, false);
    private JButton buttonFiliais = ComponenteFactory.novoJButton("Filiais", 'F', this, null, null, true);
    private JButton buttonExcecoes = ComponenteFactory.novoJButton("Exce\u00e7\u00f5es", '\u0000', this, null, null, true);
    private boolean ok = false;
    private String imagemAssinatura = "";
    private String filiais = "";
    private boolean excecaoPaciente = false;
    private boolean excecaoConvenio = false;
    private boolean excecaoMedico = false;
    private boolean excecaoDestino = false;
    private boolean excecaoEntidade = false;

    public ConfiguradorDadosWeb(Frame owner) {
        super(owner, "Dados web");
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.setSize(690, 420);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.buttonExcecoes.setVisible(false);
        this.panelBotoes.add(this.buttonExcecoes);
        this.panelBotoes.add(this.buttonFiliais);
        this.panelBotoes.add(this.buttonAssinatura);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentral.add(this.labelBase);
        this.panelCentral.add(this.labelSite);
        this.panelCentral.add(this.labelEmail);
        this.panelCentral.add(this.labelIncompleto);
        this.panelCentral.add(this.labelProibido);
        this.panelCentral.add(this.labelResponsavel);
        this.panelCentral.add(this.labelDevedor);
        this.panelCentral.add(this.labelQtdePagina);
        this.panelCentral.add(this.txtBase);
        this.panelCentral.add(this.txtSite);
        this.panelCentral.add(this.txtEmail);
        this.panelCentral.add(this.txtFraseIncompleto);
        this.panelCentral.add(this.txtFraseProibido);
        this.panelCentral.add(this.txtFraseResponsavel);
        this.panelCentral.add(this.txtFraseDevedor);
        this.panelCentral.add(this.txtQtdePagina);
        this.panelCentral.add(this.checkEmailConvenio);
        this.panelCentral.add(this.checkEmailDestino);
        this.panelCentral.add(this.checkEmailEntidade);
        this.panelCentral.add(this.checkEmailMedico);
        this.panelCentral.add(this.checkEmailPaciente);
        this.panelCentral.add(this.checkDevedora);
        this.panelCentral.add(this.checkVerAssinado);
        this.panelCentral.add(this.checkCPF);
        this.panelCentral.add(this.checkImprimir);
        this.panelCentral.add(this.checkAssinatura);
        this.panelCentral.add(this.checkMensagem);
        this.panelCentral.add(this.checkResultadoJanela);
        this.panelCentral.add(this.checkCabecalhoConfigurado);
        this.panelCentral.add(this.checkResultadoTexto);
        this.panelCentral.add(this.checkResultadoStandAlone);
        this.panelCentral.add(this.checkResultadoPdf);
        this.panelCentral.add(this.checkAssinaturaExame);
        this.panelCentral.add(this.checkImagemConvenio);
        this.panelCentral.add(this.checkImagemDestino);
        this.labelBase.setBounds(new Rectangle(5, 14, 90, 14));
        this.txtBase.setBounds(new Rectangle(95, 12, 100, 20));
        this.labelSite.setBounds(new Rectangle(5, 35, 90, 14));
        this.txtSite.setBounds(new Rectangle(95, 33, 590, 20));
        this.labelEmail.setBounds(new Rectangle(5, 56, 90, 14));
        this.txtEmail.setBounds(new Rectangle(95, 54, 590, 20));
        this.labelIncompleto.setBounds(new Rectangle(5, 77, 90, 14));
        this.txtFraseIncompleto.setBounds(new Rectangle(95, 75, 590, 20));
        this.labelProibido.setBounds(new Rectangle(5, 98, 90, 14));
        this.txtFraseProibido.setBounds(new Rectangle(95, 96, 590, 20));
        this.labelResponsavel.setBounds(new Rectangle(5, 119, 90, 14));
        this.txtFraseResponsavel.setBounds(new Rectangle(95, 117, 590, 20));
        this.labelDevedor.setBounds(new Rectangle(5, 140, 90, 14));
        this.txtFraseDevedor.setBounds(new Rectangle(95, 138, 590, 20));
        this.labelQtdePagina.setBounds(new Rectangle(5, 159, 90, 14));
        this.txtQtdePagina.setBounds(new Rectangle(95, 159, 50, 20));
        this.checkDevedora.setBounds(new Rectangle(92, 180, 300, 15));
        this.checkVerAssinado.setBounds(new Rectangle(92, 196, 300, 15));
        this.checkCPF.setBounds(new Rectangle(92, 212, 300, 15));
        this.checkImprimir.setBounds(new Rectangle(92, 228, 300, 15));
        this.checkAssinatura.setBounds(new Rectangle(92, 244, 310, 15));
        this.checkMensagem.setBounds(new Rectangle(92, 260, 315, 15));
        this.checkResultadoJanela.setBounds(new Rectangle(92, 276, 300, 15));
        this.checkCabecalhoConfigurado.setBounds(new Rectangle(92, 292, 300, 15));
        this.checkResultadoTexto.setBounds(new Rectangle(92, 308, 300, 15));
        this.checkResultadoStandAlone.setBounds(new Rectangle(92, 324, 300, 15));
        this.checkResultadoPdf.setBounds(new Rectangle(410, 180, 300, 15));
        this.checkAssinaturaExame.setBounds(new Rectangle(410, 196, 300, 15));
        this.checkEmailConvenio.setBounds(new Rectangle(410, 212, 230, 15));
        this.checkEmailDestino.setBounds(new Rectangle(410, 228, 200, 15));
        this.checkEmailEntidade.setBounds(new Rectangle(410, 244, 200, 15));
        this.checkEmailMedico.setBounds(new Rectangle(410, 260, 200, 15));
        this.checkEmailPaciente.setBounds(new Rectangle(410, 276, 200, 15));
        this.checkImagemConvenio.setBounds(new Rectangle(410, 292, 200, 15));
        this.checkImagemDestino.setBounds(new Rectangle(410, 308, 200, 15));
        this.txtBase.setEnabled(false);
        Funcoes.defineUpperCase(this.panelCentral, ParametrosGerais.getUpperCase());
        this.txtBase.setUpperCase(false);
        this.txtEmail.setUpperCase(false);
    }

    private void mostrarExcecoes() {
        ExcecoesDevedor ex = ExcecoesDevedor.novaInstancia(this);
        if (ex != null) {
            ex.setExcecoes(this.excecaoPaciente, this.excecaoMedico, this.excecaoConvenio, this.excecaoEntidade, this.excecaoDestino);
            ex.setVisible(true);
            if (ex.getOK()) {
                this.excecaoPaciente = ex.getExcecaoPaciente();
                this.excecaoMedico = ex.getExcecaoMedico();
                this.excecaoConvenio = ex.getExcecaoConvenio();
                this.excecaoEntidade = ex.getExcecaoEntidade();
                this.excecaoDestino = ex.getExcecaoDestino();
            }
        }
    }

    public void setPermitirConfigurarFiliais(boolean b) {
        this.buttonFiliais.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonExcecoes) {
            this.mostrarExcecoes();
        } else if (e.getSource() == this.checkDevedora) {
            this.buttonExcecoes.setVisible(!this.checkDevedora.isSelected());
        } else if (e.getSource() == this.buttonAssinatura) {
            this.adicionarAssinatura();
        } else if (e.getSource() == this.buttonFiliais) {
            this.configurarFiliais();
        } else if (e.getSource() == this.checkAssinatura) {
            this.buttonAssinatura.setEnabled(this.checkAssinatura.isSelected());
            if (!this.checkAssinatura.isSelected()) {
                this.checkAssinaturaExame.setSelected(false);
            }
        } else if (e.getSource() == this.checkAssinaturaExame) {
            if (this.checkAssinaturaExame.isSelected()) {
                this.checkAssinatura.setSelected(true);
            }
        } else if (this.isResultadoPDF(e)) {
            this.validaConfiguracaoWebPDF();
            this.checkResultadoStandAlone.setSelected(false);
        } else if (this.isStandAlone(e)) {
            this.validaConfiguracaoStandAlone();
            this.checkResultadoPdf.setSelected(false);
        } else if (this.isResultadoTexto(e)) {
            this.validaConfiguracaoWebTexto();
        } else if (this.validaCampos()) {
            this.ok = e.getSource() == this.buttonSalvar;
            this.dispose();
        }
    }

    private boolean isResultadoPDF(ActionEvent e) {
        return e.getSource() == this.checkResultadoPdf;
    }

    private boolean isResultadoTexto(ActionEvent e) {
        return e.getSource() == this.checkResultadoTexto;
    }

    private boolean isStandAlone(ActionEvent e) {
        return e.getSource() == this.checkResultadoStandAlone;
    }

    private void validaConfiguracaoStandAlone() {
        if (this.isTipoResultadoTexto()) {
            Funcoes.mensagem(this, "O resultado em texto n\u00e3o pode ser enviado em conjunto com o resultado pdf e/ou Stand-alone", 2);
            this.checkResultadoTexto.setSelected(false);
        }
    }

    private void validaConfiguracaoWebTexto() {
        if (this.isTipoResultadoPdfOuTexo()) {
            Funcoes.mensagem(this, "O resultado em texto n\u00e3o pode ser enviado em conjunto com o resultado pdf e/ou Stand-alone", 2);
            this.checkResultadoPdf.setSelected(false);
            this.checkResultadoStandAlone.setSelected(false);
        }
    }

    private void validaConfiguracaoWebPDF() {
        if (this.isTipoResultadoTexto()) {
            Funcoes.mensagem(this, "O resultado em pdf n\u00e3o pode ser enviado em conjunto com o resultado texto", 2);
            this.checkResultadoTexto.setSelected(false);
        }
    }

    private boolean isTipoResultadoTexto() {
        return this.checkResultadoTexto.isSelected();
    }

    private boolean isTipoResultadoPdfOuTexo() {
        return this.checkResultadoTexto.isSelected() && this.checkResultadoPdf.isSelected() || this.checkResultadoStandAlone.isSelected();
    }

    public void setAssinatura(String assinatura) {
        this.imagemAssinatura = assinatura;
    }

    public String getAssinatura() {
        return this.imagemAssinatura;
    }

    public String getFiliais() {
        return this.filiais;
    }

    private void configurarFiliais() {
        FiliaisAgrupadas f = new FiliaisAgrupadas(this);
        f.setFiliais(this.filiais);
        f.setVisible(true);
        if (f.isOK()) {
            this.filiais = f.getFiliais();
        }
    }

    private void adicionarAssinatura() {
        TelaAssinatura tela = TelaAssinatura.novaInstancia(this);
        if (tela != null) {
            tela.setImagem(this.imagemAssinatura);
            tela.setVisible(true);
            if (tela.isOK()) {
                this.imagemAssinatura = tela.getImagem();
            }
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtBase.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da base n\u00e3o informado", 1);
            this.txtBase.selectAll();
            this.txtBase.grabFocus();
        }
        return true;
    }

    public boolean ok() {
        return this.ok;
    }

    public void setExcecoes(boolean paciente, boolean medico, boolean convenio, boolean entidade, boolean destino) {
        this.excecaoConvenio = convenio;
        this.excecaoPaciente = paciente;
        this.excecaoMedico = medico;
        this.excecaoDestino = destino;
        this.excecaoEntidade = entidade;
    }

    public boolean getExcecaoPaciente() {
        return this.excecaoPaciente;
    }

    public boolean getExcecaoMedico() {
        return this.excecaoMedico;
    }

    public boolean getExcecaoConvenio() {
        return this.excecaoConvenio;
    }

    public boolean getExcecaoDestino() {
        return this.excecaoDestino;
    }

    public boolean getExcecaoEntidade() {
        return this.excecaoEntidade;
    }

    public String getBase() {
        return this.txtBase.getText();
    }

    public String getFraseIncompleto() {
        return this.txtFraseIncompleto.getText();
    }

    public String getFraseDevedor() {
        return this.txtFraseDevedor.getText();
    }

    public String getFraseResponsavel() {
        return this.txtFraseResponsavel.getText();
    }

    public String getFraseProibido() {
        return this.txtFraseProibido.getText();
    }

    public String getEmail() {
        return this.txtEmail.getText();
    }

    public String getSite() {
        return this.txtSite.getText();
    }

    public boolean getMostrarDevedora() {
        return this.checkDevedora.isSelected();
    }

    public boolean getMostrarNaoAssinado() {
        return this.checkVerAssinado.isSelected();
    }

    public boolean getUsarCPF() {
        return this.checkCPF.isSelected();
    }

    public boolean getBotaoImprimir() {
        return this.checkImprimir.isSelected();
    }

    public boolean getMostrarAssinatura() {
        return this.checkAssinatura.isSelected();
    }

    public boolean getMensagemPopup() {
        return this.checkMensagem.isSelected();
    }

    public boolean getResultadoEmJanela() {
        return this.checkResultadoJanela.isSelected();
    }

    public boolean getCabecalhoConfigurado() {
        return this.checkCabecalhoConfigurado.isSelected();
    }

    public boolean getEnviarResultadoTexto() {
        return this.checkResultadoTexto.isSelected();
    }

    public boolean getResultadoStandAlone() {
        return this.checkResultadoStandAlone.isSelected();
    }

    public boolean getEnviarResultadoPdf() {
        return this.checkResultadoPdf.isSelected();
    }

    public boolean getAssinaturaExame() {
        return this.checkAssinaturaExame.isSelected();
    }

    public void setBase(String base) {
        this.txtBase.setText(base);
    }

    public void setFraseIncompleto(String frase) {
        this.txtFraseIncompleto.setText(frase);
    }

    public void setFraseDevedor(String frase) {
        this.txtFraseDevedor.setText(frase);
    }

    public void setFraseResponsavel(String frase) {
        this.txtFraseResponsavel.setText(frase);
    }

    public void setFraseProibido(String frase) {
        this.txtFraseProibido.setText(frase);
    }

    public void setEmail(String email) {
        this.txtEmail.setText(email);
    }

    public void setSite(String site) {
        this.txtSite.setText(site);
    }

    public void setMostrarDevedora(boolean b) {
        this.checkDevedora.setSelected(b);
        this.buttonExcecoes.setVisible(!b);
    }

    public void setMostrarNaoAssinado(boolean b) {
        this.checkVerAssinado.setSelected(b);
    }

    public void setUsarCPF(boolean b) {
        this.checkCPF.setSelected(b);
    }

    public void setBotaoImprimir(boolean b) {
        this.checkImprimir.setSelected(b);
    }

    public void setMostrarAssinatura(boolean b) {
        this.checkAssinatura.setSelected(b);
        this.buttonAssinatura.setEnabled(b);
    }

    public void setMensagemPopup(boolean b) {
        this.checkMensagem.setSelected(b);
    }

    public void setResultadoEmJanela(boolean b) {
        this.checkResultadoJanela.setSelected(b);
    }

    public void setCabecalhConfiguracao(boolean b) {
        this.checkCabecalhoConfigurado.setSelected(b);
    }

    public void setEnviarResultadoTexto(boolean b) {
        this.checkResultadoTexto.setSelected(b);
    }

    public void setResultadoStandAlone(boolean b) {
        this.checkResultadoStandAlone.setSelected(b);
    }

    public void setEnviarResultadoPdf(boolean b) {
        this.checkResultadoPdf.setSelected(b);
    }

    public String getQtdePagina() {
        return this.txtQtdePagina.getText();
    }

    public void setQtdePagina(int qtdePagina) {
        this.txtQtdePagina.setText(String.valueOf(qtdePagina));
    }

    public boolean isEmailConvenio() {
        return this.checkEmailConvenio.isSelected();
    }

    public void setEmailConvenio(boolean b) {
        this.checkEmailConvenio.setSelected(b);
    }

    public boolean isEmailDestino() {
        return this.checkEmailDestino.isSelected();
    }

    public void setEmailDestino(boolean b) {
        this.checkEmailDestino.setSelected(b);
    }

    public boolean isEmailEntidade() {
        return this.checkEmailEntidade.isSelected();
    }

    public void setEmailEntidade(boolean b) {
        this.checkEmailEntidade.setSelected(b);
    }

    public boolean isEmailMedico() {
        return this.checkEmailMedico.isSelected();
    }

    public void setEmailMedico(boolean b) {
        this.checkEmailMedico.setSelected(b);
    }

    public boolean isEmailPaciente() {
        return this.checkEmailPaciente.isSelected();
    }

    public void setEmailPaciente(boolean b) {
        this.checkEmailPaciente.setSelected(b);
    }

    public boolean isImagemConvenio() {
        return this.checkImagemConvenio.isSelected();
    }

    public void setImagemConvenio(boolean b) {
        this.checkImagemConvenio.setSelected(b);
    }

    public boolean isImagemDestino() {
        return this.checkImagemDestino.isSelected();
    }

    public void setImagemDestino(boolean b) {
        this.checkImagemDestino.setSelected(b);
    }

    public void setFiliais(String filiais) {
        this.filiais = filiais;
    }

    public void setAssinaturaExame(boolean b) {
        this.checkAssinaturaExame.setSelected(b);
    }
}

