/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.cadastro.AvisoAgendamentoSMS;
import jalis.laboratorio.cadastro.TelefonesResumo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.matricial.EditorSMS;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ConfiguradorDadosSMS
extends JDialog
implements ActionListener {
    private static final String FRASE_BOTAO_CONFIGURACAO = "Selecione os campos que ser\u00e3o apresentados na mensagem";
    private static final String CONFIGURANDO_CAMPOS = "Configurando campos";
    private static final String FORMATO_HORA = "HH:mm";
    private static final String MENSAGEM_CONFIGURADA_COM_SUCESSO = "Mensagem configurada com sucesso!";
    private JPanel panelCentral = new JPanel(null);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = ComponenteFactory.novoJButton("OK", 'O', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private String fraseAniversario;
    private String fraseRequisicao;
    private String fraseRecoleta;
    private String fraseSenhaWeb;
    private String fraseResultado;
    private String fraseAgendamento;
    private JCheckBox checkAniversario = ComponenteFactory.novoJCheckBox("Enviar SMS de anivers\u00e1rio", this);
    private TTextField txtFraseAniversario = new TTextField();
    private JButton buttonCamposAniversario = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkResultados = ComponenteFactory.novoJCheckBox("Enviar SMS de aviso resultados prontos", this);
    private JCheckBox checkAgruparMultiguia = ComponenteFactory.novoJCheckBox("Agrupar requisi\u00e7\u00f5es multiguias", 'A', this);
    private TTextField txtFraseResultado = new TTextField();
    private JButton buttonCamposResultado = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkSenhaWeb = ComponenteFactory.novoJCheckBox("Enviar SMS com a senha web", this);
    private TTextField txtFraseSenhaWeb = new TTextField();
    private JButton buttonCamposSenhaWeb = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkRecoleta = ComponenteFactory.novoJCheckBox("Enviar SMS com aviso de recoleta de material", this);
    private TTextField txtFraseRecoleta = new TTextField();
    private JButton buttonCamposRecoleta = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkResumoFinanceiro = ComponenteFactory.novoJCheckBox("Enviar SMS de resumo financeiro", this);
    private TTextField textFonesResumoFinanceiro = new TTextField();
    private JButton buttonFonesResumoFinanceiro = ComponenteFactory.novoJButton("...", (ActionListener)this, "Configure os telefones que podem receber mensagens de resumo financeiro");
    private JCheckBox checkRequisicao = ComponenteFactory.novoJCheckBox("Enviar SMS de requisi\u00e7\u00e3o", this);
    private TTextField textFraseRequisicao = new TTextField();
    private JButton buttonCamposRequisicao = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkAgendamento = ComponenteFactory.novoJCheckBox("Enviar SMS do agendamento", this);
    private TTextField textFraseAgendamento = new TTextField();
    private JButton buttonCamposAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JCheckBox checkAvisoAgendamento = ComponenteFactory.novoJCheckBox("Enviar SMS de aviso de agendamento", this);
    private TTextField textFraseAvisoAgendamento = new TTextField();
    private JButton buttonAvisoAgendamento = ComponenteFactory.novoJButton("...", this);
    private TTextField textHoraEnviarSMSResumo = new TTextField(5, 6);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private TTextField textHoraEnvioSMSAniversario = new TTextField(5, 6);
    private TTextField textHoraEnvioSMSAgendamento = new TTextField(5, 6);
    private JLabel labelHoraAniversario = new JLabel("Hor\u00e1rio para enviar SMS de anivers\u00e1rio:");
    private JLabel labelHoraAgendamento = new JLabel("Hor\u00e1rio para enviar SMS de agendamento:");
    private boolean ok = false;
    private String filial = "";
    private AvisoAgendamentoSMS avisoAgendamentoSMS = null;
    private List<Registro> mensagemSMSAvisoAgendamento = null;
    private JPopupMenu menuCampos = new JPopupMenu();
    private TTextField campoParaAdicionar = null;
    public static final String[] camposDisponiveis = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "dataEntregaPrevistaRequisicao", "horaEntregaPrevistaRequisicao", "codigoPacienteWeb", "dataHoraAgenda", "primeiroNomePaciente", "nomeSocialPaciente", "primeiroNomeSocialPaciente", "codigoConvenio"};

    public ConfiguradorDadosSMS(Frame owner) {
        super(owner, "Dados SMS");
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.setSize(710, 500);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.add((Component)this.panelCentral, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentral.add(this.txtFraseAniversario);
        this.panelCentral.add(this.txtFraseResultado);
        this.panelCentral.add(this.txtFraseSenhaWeb);
        this.panelCentral.add(this.txtFraseRecoleta);
        this.panelCentral.add(this.textFraseRequisicao);
        this.panelCentral.add(this.textFraseAgendamento);
        this.panelCentral.add(this.textFraseAvisoAgendamento);
        this.panelCentral.add(this.checkAniversario);
        this.panelCentral.add(this.checkResultados);
        this.panelCentral.add(this.checkAgruparMultiguia);
        this.panelCentral.add(this.checkSenhaWeb);
        this.panelCentral.add(this.checkRecoleta);
        this.panelCentral.add(this.checkRequisicao);
        this.panelCentral.add(this.checkAgendamento);
        this.panelCentral.add(this.checkAvisoAgendamento);
        this.panelCentral.add(this.buttonCamposAniversario);
        this.panelCentral.add(this.buttonCamposResultado);
        this.panelCentral.add(this.buttonCamposSenhaWeb);
        this.panelCentral.add(this.buttonCamposRecoleta);
        this.panelCentral.add(this.buttonCamposRequisicao);
        this.panelCentral.add(this.buttonCamposAgendamento);
        this.panelCentral.add(this.buttonAvisoAgendamento);
        this.panelCentral.add(this.textHoraEnvioSMSAgendamento);
        this.panelCentral.add(this.checkResumoFinanceiro);
        this.panelCentral.add(this.textFonesResumoFinanceiro);
        this.panelCentral.add(this.buttonFonesResumoFinanceiro);
        this.panelCentral.add(this.textHoraEnviarSMSResumo);
        this.panelCentral.add(this.textHoraInicial);
        this.panelCentral.add(this.textHoraFinal);
        this.panelCentral.add(this.textHoraEnvioSMSAniversario);
        this.checkAniversario.setBounds(new Rectangle(5, 12, 300, 15));
        this.txtFraseAniversario.setBounds(new Rectangle(8, 30, 652, 20));
        this.buttonCamposAniversario.setBounds(new Rectangle(660, 30, 20, 20));
        this.buttonCamposAniversario.setFocusable(false);
        this.checkResultados.setBounds(new Rectangle(5, 52, 300, 15));
        this.checkAgruparMultiguia.setBounds(new Rectangle(305, 52, 300, 15));
        this.txtFraseResultado.setBounds(new Rectangle(8, 70, 652, 20));
        this.buttonCamposResultado.setBounds(new Rectangle(660, 70, 20, 20));
        this.buttonCamposResultado.setFocusable(false);
        this.checkSenhaWeb.setBounds(new Rectangle(5, 92, 300, 15));
        this.txtFraseSenhaWeb.setBounds(new Rectangle(8, 110, 652, 20));
        this.buttonCamposSenhaWeb.setBounds(new Rectangle(660, 110, 20, 20));
        this.buttonCamposSenhaWeb.setFocusable(false);
        this.checkRecoleta.setBounds(new Rectangle(5, 132, 360, 15));
        this.txtFraseRecoleta.setBounds(new Rectangle(8, 150, 652, 20));
        this.buttonCamposRecoleta.setBounds(new Rectangle(660, 150, 20, 20));
        this.buttonCamposRecoleta.setFocusable(false);
        this.checkResumoFinanceiro.setBounds(new Rectangle(5, 172, 360, 15));
        this.textFonesResumoFinanceiro.setBounds(new Rectangle(8, 190, 652, 20));
        this.buttonFonesResumoFinanceiro.setBounds(new Rectangle(660, 190, 20, 20));
        this.buttonFonesResumoFinanceiro.setFocusable(false);
        this.checkRequisicao.setBounds(new Rectangle(5, 212, 360, 15));
        this.textFraseRequisicao.setBounds(new Rectangle(8, 230, 652, 20));
        this.buttonCamposRequisicao.setBounds(new Rectangle(660, 230, 20, 20));
        this.buttonCamposRequisicao.setFocusable(false);
        this.checkAgendamento.setBounds(new Rectangle(5, 252, 360, 15));
        this.textFraseAgendamento.setBounds(new Rectangle(8, 268, 652, 20));
        this.buttonCamposAgendamento.setBounds(new Rectangle(660, 268, 20, 20));
        this.buttonCamposAgendamento.setFocusable(false);
        this.checkAvisoAgendamento.setBounds(new Rectangle(5, 292, 360, 15));
        this.textFraseAvisoAgendamento.setBounds(new Rectangle(8, 308, 652, 20));
        this.textFraseAvisoAgendamento.setEditable(false);
        this.buttonAvisoAgendamento.setBounds(new Rectangle(660, 308, 20, 20));
        this.buttonAvisoAgendamento.setFocusable(false);
        this.labelHoraAgendamento.setBounds(new Rectangle(5, 330, 260, 20));
        this.panelCentral.add(this.labelHoraAgendamento);
        this.textHoraEnvioSMSAgendamento.setBounds(260, 330, 70, 20);
        this.textHoraEnvioSMSAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
        this.textFonesResumoFinanceiro.setEditable(false);
        JLabel lab1 = new JLabel("Hor\u00e1rio para gerar o resumo financeiro:");
        lab1.setBounds(new Rectangle(5, 352, 260, 20));
        this.panelCentral.add(lab1);
        this.textHoraEnviarSMSResumo.setBounds(260, 352, 70, 20);
        this.textHoraEnviarSMSResumo.setEnabled(this.checkResumoFinanceiro.isSelected());
        this.labelHoraAniversario.setBounds(new Rectangle(5, 374, 260, 20));
        this.textHoraEnvioSMSAniversario.setEnabled(this.checkAniversario.isSelected());
        this.panelCentral.add(this.labelHoraAniversario);
        this.textHoraEnvioSMSAniversario.setBounds(260, 374, 70, 20);
        JLabel lab = new JLabel("Hora inicial:");
        lab.setBounds(new Rectangle(5, 396, 90, 20));
        this.panelCentral.add(lab);
        this.textHoraInicial.setBounds(82, 396, 70, 20);
        JLabel lab2 = new JLabel("Hora final:");
        lab2.setBounds(new Rectangle(187, 396, 80, 20));
        this.panelCentral.add(lab2);
        this.textHoraFinal.setBounds(260, 396, 70, 20);
        for (String c : camposDisponiveis) {
            JMenuItem item = new JMenuItem(c);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            try {
                this.campoParaAdicionar.getDocument().insertString(this.campoParaAdicionar.getCaretPosition(), "[" + ((JMenuItem)e.getSource()).getText() + "]", null);
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCamposAniversario) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseAniversario);
            editor.setVisible(true);
            if (editor.ok()) {
                this.txtFraseAniversario.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseAniversario = editor.getFormato();
            }
        } else if (e.getSource() == this.buttonCamposResultado) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseResultado);
            editor.setVisible(true);
            if (editor.ok()) {
                this.txtFraseResultado.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseResultado = editor.getFormato();
            }
        } else if (e.getSource() == this.buttonCamposSenhaWeb) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseSenhaWeb);
            editor.setVisible(true);
            if (editor.ok()) {
                this.txtFraseSenhaWeb.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseSenhaWeb = editor.getFormato();
            }
        } else if (e.getSource() == this.buttonCamposRecoleta) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseRecoleta);
            editor.setVisible(true);
            if (editor.ok()) {
                this.txtFraseRecoleta.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseRecoleta = editor.getFormato();
            }
        } else if (e.getSource() == this.buttonCamposRequisicao) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseRequisicao);
            editor.setVisible(true);
            if (editor.ok()) {
                this.textFraseRequisicao.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseRequisicao = editor.getFormato();
            }
        } else if (e.getSource() == this.checkAniversario) {
            this.txtFraseAniversario.setEnabled(this.checkAniversario.isSelected());
            this.buttonCamposAniversario.setEnabled(this.checkAniversario.isSelected());
            this.textHoraEnvioSMSAniversario.setEnabled(this.checkAniversario.isSelected());
        } else if (e.getSource() == this.checkResultados) {
            this.checkAgruparMultiguia.setEnabled(this.checkResultados.isSelected());
            this.txtFraseResultado.setEnabled(this.checkResultados.isSelected());
            this.buttonCamposResultado.setEnabled(this.checkResultados.isSelected());
        } else if (e.getSource() == this.checkSenhaWeb) {
            this.txtFraseSenhaWeb.setEnabled(this.checkSenhaWeb.isSelected());
            this.buttonCamposSenhaWeb.setEnabled(this.checkSenhaWeb.isSelected());
        } else if (e.getSource() == this.checkRecoleta) {
            this.txtFraseRecoleta.setEnabled(this.checkRecoleta.isSelected());
            this.buttonCamposRecoleta.setEnabled(this.checkRecoleta.isSelected());
        } else if (e.getSource() == this.checkRequisicao) {
            this.textFraseRequisicao.setEnabled(this.checkRequisicao.isSelected());
            this.buttonCamposRequisicao.setEnabled(this.checkRequisicao.isSelected());
        } else if (e.getSource() == this.checkResumoFinanceiro) {
            this.textFonesResumoFinanceiro.setEnabled(this.checkResumoFinanceiro.isSelected());
            this.buttonFonesResumoFinanceiro.setEnabled(this.checkResumoFinanceiro.isSelected());
            this.textHoraEnviarSMSResumo.setEnabled(this.checkResumoFinanceiro.isSelected());
        } else if (e.getSource() == this.checkAgendamento) {
            this.textFraseAgendamento.setEnabled(this.checkAgendamento.isSelected());
            this.buttonCamposAgendamento.setEnabled(this.checkAgendamento.isSelected());
        } else if (e.getSource() == this.checkAvisoAgendamento) {
            this.textFraseAvisoAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
            this.buttonAvisoAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
            this.textHoraEnvioSMSAgendamento.setEnabled(this.checkAvisoAgendamento.isSelected());
            this.avisoAgendamentoSMS = this.checkAvisoAgendamento.isSelected() ? AvisoAgendamentoSMS.novaInstancia(this) : null;
        } else if (e.getSource() == this.buttonFonesResumoFinanceiro) {
            TelefonesResumo fo = TelefonesResumo.novaInstancia(this);
            if (fo != null) {
                fo.setTelefones(this.textFonesResumoFinanceiro.getText());
                fo.setVisible(true);
                if (fo.getOK()) {
                    this.textFonesResumoFinanceiro.setText(fo.getTelefones());
                }
            }
        } else if (e.getSource() == this.buttonAvisoAgendamento) {
            this.configuraAvisosSMS();
        } else if (e.getSource() == this.buttonCamposAgendamento) {
            EditorSMS editor = new EditorSMS(this, CONFIGURANDO_CAMPOS, true);
            editor.setCampoDoBanco(camposDisponiveis);
            editor.setFormato(this.fraseAgendamento);
            editor.setVisible(true);
            if (editor.ok()) {
                this.textFraseAgendamento.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
                this.fraseAgendamento = editor.getFormato();
            }
        } else if (e.getSource() == this.buttonSalvar) {
            this.ok = this.validaCampos();
            this.setVisible(!this.ok);
        }
    }

    private boolean validaCampos() {
        if (this.checkAniversario.isSelected() && Funcoes.textoVazio(this.txtFraseAniversario.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de anivers\u00e1rio n\u00e3o preenchida.", 2);
            this.txtFraseAniversario.selectAll();
            this.txtFraseAniversario.grabFocus();
            return false;
        }
        if (this.checkResultados.isSelected() && Funcoes.textoVazio(this.txtFraseResultado.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de resultados n\u00e3o preenchida.", 2);
            this.txtFraseResultado.selectAll();
            this.txtFraseResultado.grabFocus();
            return false;
        }
        if (this.checkSenhaWeb.isSelected() && Funcoes.textoVazio(this.txtFraseSenhaWeb.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de senha web n\u00e3o preenchida.", 2);
            this.txtFraseSenhaWeb.selectAll();
            this.txtFraseSenhaWeb.grabFocus();
            return false;
        }
        if (this.checkRecoleta.isSelected() && Funcoes.textoVazio(this.txtFraseRecoleta.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de recoleta n\u00e3o preenchida.", 2);
            this.txtFraseRecoleta.selectAll();
            this.txtFraseRecoleta.grabFocus();
            return false;
        }
        if (this.checkRequisicao.isSelected() && Funcoes.textoVazio(this.textFraseRequisicao.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de requisi\u00e7\u00e3o n\u00e3o preenchida.", 2);
            this.textFraseRequisicao.selectAll();
            this.textFraseRequisicao.grabFocus();
            return false;
        }
        if (this.checkAgendamento.isSelected() && Funcoes.textoVazio(this.textFraseAgendamento.getText())) {
            Funcoes.mensagem(this, "Frase para SMS do agendamento n\u00e3o preenchida.", 2);
            this.textFraseAgendamento.selectAll();
            this.textFraseAgendamento.grabFocus();
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && Funcoes.textoVazio(this.textFonesResumoFinanceiro.getText())) {
            Funcoes.mensagem(this, "Nenhum telefone para enviar a mensagem de resumo financeiro foi informado.", 2);
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && !Funcoes.textoVazio(this.textHoraEnviarSMSResumo.getText()) && !Funcoes.verificaHora(this.textHoraEnviarSMSResumo.getText())) {
            Funcoes.mensagem(this, "Hora para enviar resumo financeiro incorreta.", 2);
            this.textHoraEnviarSMSResumo.selectAll();
            this.textHoraEnviarSMSResumo.grabFocus();
            return false;
        }
        if (this.checkResumoFinanceiro.isSelected() && Funcoes.verificaHora(this.textHoraEnviarSMSResumo.getText()) && Funcoes.verificaHora(this.textHoraInicial.getText()) && Funcoes.verificaHora(this.textHoraFinal.getText()) && (Funcoes.comparaHora(this.textHoraEnviarSMSResumo.getText(), this.textHoraInicial.getText()) < 0 || Funcoes.comparaHora(this.textHoraEnviarSMSResumo.getText(), this.textHoraFinal.getText()) > 0)) {
            Funcoes.mensagem(this, "A hora informada para gerar o resumo financeiro esta fora do intervalo de hor\u00e1rio para enviar SMS.", 2);
            this.textHoraEnviarSMSResumo.selectAll();
            this.textHoraEnviarSMSResumo.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraInicial.getText()) && !Funcoes.verificaHora(this.textHoraInicial.getText())) {
            Funcoes.mensagem(this, "Hora inicial incorreta.", 2);
            this.textHoraInicial.selectAll();
            this.textHoraInicial.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraFinal.getText()) && !Funcoes.verificaHora(this.textHoraFinal.getText())) {
            Funcoes.mensagem(this, "Hora final incorreta.", 2);
            this.textHoraFinal.selectAll();
            this.textHoraFinal.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraEnvioSMSAniversario.getText()) && !Funcoes.verificaHora(this.textHoraEnvioSMSAniversario.getText())) {
            Funcoes.mensagem(this, "Hora para envio de SMS de anivers\u00e1rio incorreta.", 2);
            this.textHoraEnvioSMSAniversario.selectAll();
            this.textHoraEnvioSMSAniversario.grabFocus();
            return false;
        }
        if (this.checkAvisoAgendamento.isSelected() && !Funcoes.textoVazio(this.textFraseAvisoAgendamento.getText()) && Funcoes.textoVazio(this.textHoraEnvioSMSAgendamento.getText())) {
            Funcoes.mensagem(this, "Hora para envio SMS de agendamento n\u00e3o preenchida.", 2);
            return false;
        }
        if (this.checkAvisoAgendamento.isSelected() && Funcoes.textoVazio(this.textFraseAvisoAgendamento.getText())) {
            Funcoes.mensagem(this, "Frase para SMS de aviso de agendamento n\u00e3o preenchida.", 2);
            this.txtFraseSenhaWeb.selectAll();
            this.txtFraseSenhaWeb.grabFocus();
            return false;
        }
        return true;
    }

    private void configuraAvisosSMS() {
        if (this.avisoAgendamentoSMS == null) {
            this.avisoAgendamentoSMS = AvisoAgendamentoSMS.novaInstancia(this);
        }
        if (this.avisoAgendamentoSMS != null) {
            this.avisoAgendamentoSMS.adicionaMensagemGrid(this.getFilial());
            this.avisoAgendamentoSMS.setVisible(true);
            if (this.avisoAgendamentoSMS.getOK()) {
                this.setMensagensAvisoAgendamento(this.avisoAgendamentoSMS.getMensagensSMS());
                this.setTextAvisoAgendamento(this.retornaDiasRegistro(this.avisoAgendamentoSMS.getMensagensSMS()));
            }
        }
    }

    private ArrayList<Integer> retornaDiasRegistro(ArrayList<Registro> lista) {
        ArrayList<Integer> diasConfigurados = new ArrayList<Integer>();
        for (Registro reg : lista) {
            String dia = (String)reg.getValor("dias");
            diasConfigurados.add(Integer.valueOf(dia));
        }
        Collections.sort(diasConfigurados);
        return diasConfigurados;
    }

    public boolean ok() {
        return this.ok;
    }

    public boolean isAniversario() {
        return this.checkAniversario.isSelected();
    }

    public void setAniversario(boolean aniversario) {
        this.checkAniversario.setSelected(aniversario);
        this.txtFraseAniversario.setEnabled(aniversario);
        this.buttonCamposAniversario.setEnabled(aniversario);
        this.textHoraEnvioSMSAniversario.setEnabled(aniversario);
    }

    public String getFraseAniversario() {
        return this.fraseAniversario;
    }

    public void setFraseAniversario(String fraseAniversario) {
        this.fraseAniversario = fraseAniversario;
        if (!StringUtil.isEmpty(fraseAniversario)) {
            this.txtFraseAniversario.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public boolean isResultado() {
        return this.checkResultados.isSelected();
    }

    public void setResultado(boolean resultado) {
        this.checkResultados.setSelected(resultado);
        this.checkAgruparMultiguia.setEnabled(resultado);
        this.txtFraseResultado.setEnabled(resultado);
        this.buttonCamposResultado.setEnabled(resultado);
    }

    public boolean isAgruparMultiguia() {
        return this.checkAgruparMultiguia.isSelected();
    }

    public void setAgruparMultiguia(boolean agrupar) {
        this.checkAgruparMultiguia.setSelected(agrupar);
    }

    public String getFraseResultado() {
        return this.fraseResultado;
    }

    public void setFraseResultados(String fraseResultado) {
        this.fraseResultado = fraseResultado;
        if (!StringUtil.isEmpty(fraseResultado)) {
            this.txtFraseResultado.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public boolean isSenhaWeb() {
        return this.checkSenhaWeb.isSelected();
    }

    public void setSenhaWeb(boolean senhaWeb) {
        this.checkSenhaWeb.setSelected(senhaWeb);
        this.txtFraseSenhaWeb.setEnabled(senhaWeb);
        this.buttonCamposSenhaWeb.setEnabled(senhaWeb);
    }

    public String getFraseSenhaWeb() {
        return this.fraseSenhaWeb;
    }

    public void setFraseSenhaWeb(String fraseSenhaWeb) {
        this.fraseSenhaWeb = fraseSenhaWeb;
        if (!StringUtil.isEmpty(fraseSenhaWeb)) {
            this.txtFraseSenhaWeb.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public boolean isRecoleta() {
        return this.checkRecoleta.isSelected();
    }

    public void setRecoleta(boolean recoleta) {
        this.checkRecoleta.setSelected(recoleta);
        this.txtFraseRecoleta.setEnabled(recoleta);
        this.buttonCamposRecoleta.setEnabled(recoleta);
    }

    public String getFraseRecoleta() {
        return this.fraseRecoleta;
    }

    public void setFraseRecoleta(String fraseRecoleta) {
        this.fraseRecoleta = fraseRecoleta;
        if (!StringUtil.isEmpty(fraseRecoleta)) {
            this.txtFraseRecoleta.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public boolean isResumoFinanceiro() {
        return this.checkResumoFinanceiro.isSelected();
    }

    public void setResumoFinanceiro(boolean resumo) {
        this.checkResumoFinanceiro.setSelected(resumo);
        this.textFonesResumoFinanceiro.setEnabled(resumo);
        this.buttonFonesResumoFinanceiro.setEnabled(resumo);
        this.textHoraEnviarSMSResumo.setEnabled(resumo);
    }

    public String getFonesResumoFinanceiro() {
        return this.textFonesResumoFinanceiro.getText();
    }

    public void setFonesResumoFinanceiro(String fones) {
        this.textFonesResumoFinanceiro.setText(fones);
    }

    public void setHoraAgendamento(Date hora) {
        if (hora != null) {
            this.textHoraEnvioSMSAgendamento.setText(Funcoes.formataData(FORMATO_HORA, hora));
        } else {
            this.textHoraEnvioSMSAgendamento.clear();
        }
    }

    public void setHoraInicial(Date hora) {
        if (hora != null) {
            this.textHoraInicial.setText(Funcoes.formataData(FORMATO_HORA, hora));
        } else {
            this.textHoraInicial.clear();
        }
    }

    public void setHoraFinal(Date hora) {
        if (hora != null) {
            this.textHoraFinal.setText(Funcoes.formataData(FORMATO_HORA, hora));
        } else {
            this.textHoraFinal.clear();
        }
    }

    public void setHoraSMSEnvioAniversario(Date hora) {
        if (hora != null) {
            this.textHoraEnvioSMSAniversario.setText(Funcoes.formataData(FORMATO_HORA, hora));
        } else {
            this.textHoraEnvioSMSAniversario.clear();
        }
    }

    public Date getHoraInicial() {
        if (Funcoes.verificaHora(this.textHoraInicial.getText())) {
            return Funcoes.stringToTime(this.textHoraInicial.getText());
        }
        return null;
    }

    public Date getHoraFinal() {
        if (Funcoes.verificaHora(this.textHoraFinal.getText())) {
            return Funcoes.stringToTime(this.textHoraFinal.getText());
        }
        return null;
    }

    public Date getHoraAgendamento() {
        if (Funcoes.verificaHora(this.textHoraEnvioSMSAgendamento.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioSMSAgendamento.getText());
        }
        return null;
    }

    public Date getHoraSMSEnvioAniversario() {
        if (Funcoes.verificaHora(this.textHoraEnvioSMSAniversario.getText())) {
            return Funcoes.stringToTime(this.textHoraEnvioSMSAniversario.getText());
        }
        return null;
    }

    public Date getHoraEnviarSMSResumoFinanceiro() {
        if (Funcoes.verificaHora(this.textHoraEnviarSMSResumo.getText())) {
            return Funcoes.stringToTime(this.textHoraEnviarSMSResumo.getText());
        }
        return null;
    }

    public void setHoraEnviarSMSResumoFinanceiro(Date hora) {
        if (hora != null) {
            this.textHoraEnviarSMSResumo.setText(Funcoes.formataData(FORMATO_HORA, hora));
        } else {
            this.textHoraEnviarSMSResumo.clear();
        }
    }

    public boolean isRequisicao() {
        return this.checkRequisicao.isSelected();
    }

    public boolean isAgendamento() {
        return this.checkAgendamento.isSelected();
    }

    public boolean isAvisoAgendamento() {
        return this.checkAvisoAgendamento.isSelected();
    }

    public void setRequisicao(boolean ativar) {
        this.checkRequisicao.setSelected(ativar);
        this.textFraseRequisicao.setEnabled(ativar);
        this.buttonCamposRequisicao.setEnabled(ativar);
    }

    public void setAgendamento(boolean ativar) {
        this.checkAgendamento.setSelected(ativar);
        this.textFraseAgendamento.setEnabled(ativar);
        this.buttonCamposAgendamento.setEnabled(ativar);
    }

    public void setAvisoAgendamento(boolean ativar) {
        this.checkAvisoAgendamento.setSelected(ativar);
        this.textFraseAvisoAgendamento.setEnabled(ativar);
        this.buttonAvisoAgendamento.setEnabled(ativar);
        this.textHoraEnvioSMSAgendamento.setEnabled(ativar);
    }

    public void setTextAvisoAgendamento(List<Integer> diasConfigurados) {
        String dias = "";
        if (!diasConfigurados.isEmpty()) {
            for (Integer d : diasConfigurados) {
                dias = dias + String.valueOf(d) + "; ";
            }
            this.textFraseAvisoAgendamento.setText(dias);
        } else {
            this.textFraseAvisoAgendamento.setText("");
        }
    }

    public void setMensagensAvisoAgendamento(List<Registro> lista) {
        this.mensagemSMSAvisoAgendamento = lista;
    }

    public List<Registro> getMensagensAvisoAgendamento() {
        return this.mensagemSMSAvisoAgendamento;
    }

    public String getFraseRequisicao() {
        return this.fraseRequisicao;
    }

    public void setFraseRequisicao(String fraseRequisicao) {
        this.fraseRequisicao = fraseRequisicao;
        if (!StringUtil.isEmpty(fraseRequisicao)) {
            this.textFraseRequisicao.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public String getFraseAgendamento() {
        return this.fraseAgendamento;
    }

    public void setFraseAgendamento(String fraseAgendamento) {
        this.fraseAgendamento = fraseAgendamento;
        if (!StringUtil.isEmpty(fraseAgendamento)) {
            this.textFraseAgendamento.setText(MENSAGEM_CONFIGURADA_COM_SUCESSO);
        }
    }

    public String getFilial() {
        return this.filial;
    }

    public void setFilial(String filial) {
        this.filial = filial;
    }
}

