/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameBean;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameSituacaoBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.exame.SituacaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.exame.ExameService;
import jalis.service.cadastro.exame.MaterialColetaService;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.service.cadastro.exame.SituacaoService;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConfiguradorCotaMaximaExames
extends AbstractDialogoOKCancelar {
    private final int COLUNA_EXAME_CODIGO_EXAME = 0;
    private final int COLUNA_EXAME_DESCRICAO_EXAME = 1;
    private final int COLUNA_EXAME_CODIGO_MATERIAL = 2;
    private final int COLUNA_EXAME_DESCRICAO_MATERIAL = 3;
    private final int COLUNA_EXAME_CODIGO_METODOLOGIA = 4;
    private final int COLUNA_EXAME_DESCRICAO_METODOLOGIA = 5;
    private final int COLUNA_EXAME_QUANTIDADE = 6;
    private final int COLUNA_CONVENO_COTA = ParametrosGerais.getPrecoMetodologia() ? 7 : 5;
    private final int COLUNA_SITUACAO_CODIGO_SITUACAO = 0;
    private final int COLUNA_SITUACAO_DESCRICAO_SITUACAO = 1;
    private JPanel painelSituacoes = new JPanel(new GridBagLayout());
    private JPanel painelExames = new JPanel(new GridBagLayout());
    private JLabel labelCodigo = new JLabel("C\u00f3digo");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o");
    private JLabel labelDescSituacao = new JLabel();
    private JLabel labelExame = new JLabel("Exame");
    private JLabel labelDescExame = new JLabel();
    private JLabel labelMetodologia = new JLabel("Metodologia");
    private JLabel labelQuantidade = new JLabel("Qtde.");
    private JLabel labelMaterial = new JLabel("Material");
    private TTextField textSituacao = new TTextField(5, 1);
    private TTextField textExame = new TTextField(5, 3);
    private TTextField textQuantidade = new TTextField(5, 1);
    private JButton buttonPesquisaSituacao = new JButton();
    private JButton buttonPesquisaExame = new JButton();
    private JButton buttonOKSituacao = new JButton("OK");
    private JButton buttonOKExame = new JButton("OK");
    private ModeloGridTable modeloSituacoes = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    private JTable tableSituacoes = new JTable(this.modeloSituacoes);
    private JScrollPane scrollSituacoes = new JScrollPane(this.tableSituacoes);
    private ModeloGridTable modeloExames = ParametrosGerais.getPrecoMetodologia() ? new ModeloGridTable(new String[]{"Exame", "Descri\u00e7\u00e3o", "Material", "Descri\u00e7\u00e3o", "Met.", "Descri\u00e7\u00e3o", "Qtde."}) : new ModeloGridTable(new String[]{"Exame", "Descri\u00e7\u00e3o", "Material", "Descri\u00e7\u00e3o", "Qtde."});
    private JTable tableExames = new JTable(this.modeloExames);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private Set<ConvenioCotaExameBean> beansCotaTemp = new HashSet<ConvenioCotaExameBean>();
    private Set<ConvenioCotaExameSituacaoBean> beansSituacaoTemp = new HashSet<ConvenioCotaExameSituacaoBean>();
    private SituacaoVO situacaoAux = null;
    private ExameVO exameAux = null;
    private MaterialColetaVO materialAux = null;
    private MetodologiaVO metodologiaAux = null;
    private Integer quantidadeAux = null;
    private ConvenioService convenioService = new ConvenioService();
    private Integer convenio;
    private Integer filial;
    private String tipoPolitica;
    private Set<ConvenioCotaExameBean> list;
    private Set<ConvenioCotaExameSituacaoBean> listSituacao;
    private boolean isEditando = false;
    private SteppedComboBox comboBoxMaterial = new SteppedComboBox();
    private SteppedComboBox comboBoxMetodologia = new SteppedComboBox();
    private int linhaEditando = 0;

    public static ConfiguradorCotaMaximaExames getInstancia(Window pai, Integer convenio, Integer filial, Set<ConvenioCotaExameBean> list, Set<ConvenioCotaExameSituacaoBean> listSituacao, String tipoPolitica) throws Exception {
        String titulo;
        String string = titulo = tipoPolitica.equalsIgnoreCase(StringUtil.textoDBEscape("E")) ? "Configurando cota m\u00ednima de exames" : "Configurando cota m\u00e1xima de exames";
        if (pai instanceof Dialog) {
            return new ConfiguradorCotaMaximaExames((Dialog)pai, titulo, convenio, filial, list, listSituacao, tipoPolitica);
        }
        return new ConfiguradorCotaMaximaExames((Frame)pai, titulo, convenio, filial, list, listSituacao, tipoPolitica);
    }

    public Set<ConvenioCotaExameBean> getListaCota() {
        HashSet<ConvenioCotaExameBean> beans = new HashSet<ConvenioCotaExameBean>();
        for (int x = 0; x < this.modeloExames.getRowCount(); ++x) {
            beans.add((ConvenioCotaExameBean)this.modeloExames.getValueAt(x, this.COLUNA_CONVENO_COTA));
        }
        return beans;
    }

    public Set<ConvenioCotaExameSituacaoBean> getListaCotaSituacao() {
        HashSet<ConvenioCotaExameSituacaoBean> beans = new HashSet<ConvenioCotaExameSituacaoBean>();
        for (int x = 0; x < this.modeloSituacoes.getRowCount(); ++x) {
            beans.add((ConvenioCotaExameSituacaoBean)this.modeloSituacoes.getValueAt(x, 2));
        }
        return beans;
    }

    public ConfiguradorCotaMaximaExames(Frame pai, String titulo, Integer convenio, Integer filial, Set<ConvenioCotaExameBean> list, Set<ConvenioCotaExameSituacaoBean> listSituacao, String tipoPolitica) throws Exception {
        super(pai, titulo);
        this.montaTela();
        this.list = list;
        this.listSituacao = listSituacao;
        this.tipoPolitica = tipoPolitica;
        this.convenio = convenio;
        this.filial = filial;
        this.carregaDados();
    }

    public ConfiguradorCotaMaximaExames(Dialog pai, String titulo, Integer convenio, Integer filial, Set<ConvenioCotaExameBean> list, Set<ConvenioCotaExameSituacaoBean> listSituacao, String tipoPolitica) throws Exception {
        super(pai, titulo);
        this.montaTela();
        this.list = list;
        this.listSituacao = listSituacao;
        this.tipoPolitica = tipoPolitica;
        this.convenio = convenio;
        this.filial = filial;
        this.carregaDados();
    }

    private void carregaDados() throws Exception {
        Collection<Object> convenioCotas = new ArrayList();
        convenioCotas = this.list != null && !this.list.isEmpty() ? this.list : this.convenioService.retornaConvenioCotaExame(this.filial, this.convenio, this.tipoPolitica);
        this.beansCotaTemp.addAll(convenioCotas);
        for (ConvenioCotaExameBean convenioCotaExameBean : convenioCotas) {
            if (ParametrosGerais.getPrecoMetodologia()) {
                this.modeloExames.addLine(new Object[]{convenioCotaExameBean.getExame().getCodigo(), convenioCotaExameBean.getExame().getDescricao(), convenioCotaExameBean.getMaterialColeta().getCodigo(), convenioCotaExameBean.getMaterialColeta().getDescricao(), convenioCotaExameBean.getMetodologia().getCodigo(), convenioCotaExameBean.getMetodologia().getDescricao(), convenioCotaExameBean.getQuantidade().intValue(), convenioCotaExameBean});
                continue;
            }
            this.modeloExames.addLine(new Object[]{convenioCotaExameBean.getExame().getCodigo(), convenioCotaExameBean.getExame().getDescricao(), convenioCotaExameBean.getMaterialColeta().getCodigo(), convenioCotaExameBean.getMaterialColeta().getDescricao(), convenioCotaExameBean.getQuantidade().intValue(), convenioCotaExameBean});
        }
        Collection<Object> listCotaExameSituacao = new ArrayList();
        listCotaExameSituacao = this.listSituacao != null && !this.listSituacao.isEmpty() ? this.listSituacao : this.convenioService.retornaConvenioCotaExameSituacao(this.filial, this.convenio.toString(), this.tipoPolitica);
        this.beansSituacaoTemp.addAll(listCotaExameSituacao);
        for (ConvenioCotaExameSituacaoBean convenioCotaExameSituacaoBean : listCotaExameSituacao) {
            this.modeloSituacoes.addLine(new Object[]{convenioCotaExameSituacaoBean.getSituacao().getCodigo(), convenioCotaExameSituacaoBean.getSituacao().getDescricao(), convenioCotaExameSituacaoBean});
        }
    }

    public Set<ConvenioCotaExameSituacaoBean> getBeansSituacaoTemp() {
        return this.beansSituacaoTemp;
    }

    public Set<ConvenioCotaExameBean> getBeansCotaTemp() {
        return this.beansCotaTemp;
    }

    private void montaTela() {
        this.setSize(680, 550);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        this.getPanelCentral().setLayout(new GridBagLayout());
        Funcoes.defineUpperCase(this.getPanelCentral(), ParametrosGerais.getUpperCase());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getPanelCentral().add((Component)this.painelExames, c);
        ++c.gridy;
        this.getPanelCentral().add((Component)this.painelSituacoes, c);
        this.montaPainelExames();
        this.montaPainelSituacoes();
        this.comboBoxMaterial.addItem("Selecione");
        this.comboBoxMetodologia.addItem("Selecione");
        this.comboBoxMetodologia.setPreferredSize(new Dimension(70, 20));
        this.montaListeners();
        Funcoes.montaEnter((JComponent)this.getPanelCentral());
        ScreenUtil.requisitarFoco(this.textExame);
    }

    private void montaListeners() {
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConfiguradorCotaMaximaExames.this.tableExames.setFocusable(true);
                ScreenUtil.requisitarFoco(ConfiguradorCotaMaximaExames.this.tableExames);
                if (ConfiguradorCotaMaximaExames.this.linhaEditando != ConfiguradorCotaMaximaExames.this.tableExames.getSelectedRow()) {
                    ConfiguradorCotaMaximaExames.this.textExame.setText("");
                    ConfiguradorCotaMaximaExames.this.comboBoxMaterial.removeAllItems();
                    ConfiguradorCotaMaximaExames.this.comboBoxMaterial.addItem("Selecione");
                    ConfiguradorCotaMaximaExames.this.comboBoxMetodologia.removeAllItems();
                    ConfiguradorCotaMaximaExames.this.comboBoxMetodologia.addItem("Selecione");
                    ConfiguradorCotaMaximaExames.this.textQuantidade.setText("");
                    ConfiguradorCotaMaximaExames.this.labelDescExame.setText("");
                    ConfiguradorCotaMaximaExames.this.isEditando = false;
                }
            }
        });
        this.comboBoxMaterial.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ConfiguradorCotaMaximaExames.this.carregaMetodologia(e.getStateChange());
            }
        });
        this.comboBoxMetodologia.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && ParametrosGerais.getPrecoMetodologia()) {
                    ConfiguradorCotaMaximaExames.this.metodologiaAux = (MetodologiaVO)ConfiguradorCotaMaximaExames.this.comboBoxMetodologia.getSelectedItem();
                }
            }
        });
        this.buttonPesquisaExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorCotaMaximaExames.this.pesquisaExame();
            }
        });
        this.buttonPesquisaSituacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorCotaMaximaExames.this.pesquisaSituacao();
            }
        });
        this.textExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorCotaMaximaExames.this.buttonPesquisaExame.doClick();
                }
            }
        });
        this.textSituacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConfiguradorCotaMaximaExames.this.buttonPesquisaSituacao.doClick();
                }
            }
        });
        this.textSituacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(ConfiguradorCotaMaximaExames.this.textSituacao)) {
                    ConfiguradorCotaMaximaExames.this.labelDescSituacao.setText("");
                } else {
                    ConfiguradorCotaMaximaExames.this.carregaDadosSituacao(ConfiguradorCotaMaximaExames.this.textSituacao.getText());
                }
            }
        });
        this.textExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(ConfiguradorCotaMaximaExames.this.textExame)) {
                    ConfiguradorCotaMaximaExames.this.labelDescExame.setText("");
                    ConfiguradorCotaMaximaExames.this.comboBoxMaterial.removeAllItems();
                    ConfiguradorCotaMaximaExames.this.comboBoxMaterial.addItem("Selecione");
                    ConfiguradorCotaMaximaExames.this.comboBoxMetodologia.removeAllItems();
                    ConfiguradorCotaMaximaExames.this.comboBoxMetodologia.addItem("Selecione");
                } else {
                    ConfiguradorCotaMaximaExames.this.carregaDadosExame(ConfiguradorCotaMaximaExames.this.textExame.getText());
                }
            }
        });
        this.buttonOKExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorCotaMaximaExames.this.adicionaExame();
            }
        });
        this.buttonOKSituacao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorCotaMaximaExames.this.adicionaSituacao();
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ConfiguradorCotaMaximaExames.this.removeExameSelecionado();
                } else if (ConfiguradorCotaMaximaExames.this.tableExames.getSelectedRow() > -1 && e.getKeyCode() == 32) {
                    ConfiguradorCotaMaximaExames.this.linhaEditando = ConfiguradorCotaMaximaExames.this.tableExames.getSelectedRow();
                    ConfiguradorCotaMaximaExames.this.editarExameCota(ConfiguradorCotaMaximaExames.this.tableExames.getSelectedRow());
                    ScreenUtil.requisitarFoco(ConfiguradorCotaMaximaExames.this.textExame);
                }
            }
        });
        this.tableSituacoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ConfiguradorCotaMaximaExames.this.removeSituacaoSelecionada();
                }
            }
        });
    }

    protected void pesquisaExame() {
        Hashtable retorno = Pesquisas.exame(this, true, true);
        if (retorno != null) {
            this.preencheDadosExame(retorno.get("exa_codigo").toString(), retorno.get("exa_descricao").toString());
            ScreenUtil.requisitarFoco(this.comboBoxMaterial);
        }
    }

    protected void pesquisaSituacao() {
        Hashtable retorno = Pesquisas.situacao(this, true, false);
        if (retorno != null) {
            this.preencheDadosSituacao(retorno.get("sit_codigo").toString(), retorno.get("sit_descricao").toString());
        }
    }

    private void preencheDadosExame(String codigo, String descricao) {
        this.textExame.setText(codigo);
        this.labelDescExame.setText(descricao);
        this.exameAux = new ExameVO();
        this.exameAux.setCodigo(codigo);
        this.exameAux.setDescricao(descricao);
        try {
            ExameUtil.carregarMateriaisColetaSemConvenioProibido(codigo, Variaveis.filialPadrao, this.convenio.toString(), this.comboBoxMaterial);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar combo de material do exame.", e.getStackTrace());
        }
        if (this.comboBoxMaterial.getSelectedIndex() == 0) {
            this.comboBoxMaterial.setSelectedIndex(0);
        }
    }

    private void preencheDadosSituacao(String codigo, String descricao) {
        this.textSituacao.setText(codigo);
        this.labelDescSituacao.setText(descricao);
        if (codigo != null) {
            this.situacaoAux = new SituacaoVO();
            this.situacaoAux.setCodigo(Integer.parseInt(codigo));
            this.situacaoAux.setDescricao(descricao);
        }
    }

    protected void removeSituacaoSelecionada() {
        int row;
        int confirmaExclusao = Funcoes.mensagem(this, "Deseja excluir a situa\u00e7\u00e3o.", 4);
        if (confirmaExclusao == 0 && (row = this.tableSituacoes.getSelectedRow()) > -1) {
            this.modeloSituacoes.removeLine(row);
        }
    }

    protected void adicionaSituacao() {
        if (this.situacaoAux == null) {
            Funcoes.mensagem(this, "A situa\u00e7\u00e3o deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textSituacao);
            return;
        }
        if (this.verificaSituacaoInserida()) {
            Funcoes.mensagem(this, "A situa\u00e7\u00e3o j\u00e1 foi inserida.", 2);
            ScreenUtil.requisitarFoco(this.textSituacao);
            this.textSituacao.selectAll();
            return;
        }
        ConvenioCotaExameSituacaoBean bean = new ConvenioCotaExameSituacaoBean();
        bean.setSituacao(this.situacaoAux);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(this.filial);
        bean.setFilial(filialVO);
        ConvenioVO convenioVO = new ConvenioVO();
        convenioVO.setCodigo(this.convenio);
        bean.setConvenio(convenioVO);
        this.modeloSituacoes.addLine(new Object[]{this.situacaoAux.getCodigo(), this.situacaoAux.getDescricao(), bean});
        this.situacaoAux = null;
        this.preencheDadosSituacao(null, null);
        ScreenUtil.requisitarFoco(this.textSituacao);
    }

    protected void carregaDadosSituacao(String codigo) {
        HashSet situacao = null;
        try {
            situacao = (HashSet)new SituacaoService().loadVO(" where fil_codigo = " + Variaveis.filialPadrao + " and sit_codigo = " + codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da situa\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (situacao != null && situacao.size() > 0) {
            this.situacaoAux = (SituacaoVO)situacao.toArray()[0];
            this.preencheDadosSituacao(this.situacaoAux.getCodigo().toString(), this.situacaoAux.getDescricao());
        } else {
            this.situacaoAux = null;
            this.labelDescSituacao.setText("N\u00e3o cadastrado");
        }
    }

    private boolean verificaSituacaoInserida() {
        for (int i = 0; i < this.modeloSituacoes.getRowCount(); ++i) {
            if (!this.modeloSituacoes.getValueAt(i, 0).toString().equals(this.situacaoAux.getCodigo().toString())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void adicionaExame() {
        if (this.exameAux == null) {
            Funcoes.mensagem(this, "O exame deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textExame);
            return;
        }
        if (this.materialAux == null) {
            Funcoes.mensagem(this, "O material de coleta deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.comboBoxMaterial);
            return;
        }
        if (ParametrosGerais.getPrecoMetodologia() && this.metodologiaAux == null) {
            Funcoes.mensagem(this, "A metodologia deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.comboBoxMetodologia);
            return;
        }
        if (Funcoes.textoVazio(this.textQuantidade)) {
            Funcoes.mensagem(this, "A quantidade deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return;
        }
        this.quantidadeAux = Integer.parseInt(this.textQuantidade.getText());
        if (this.quantidadeAux <= 0) {
            Funcoes.mensagem(this, "A quantidade \u00e9 inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return;
        }
        if (!this.isEditando && this.verificaExameInserido()) {
            Funcoes.mensagem(this, "O exame j\u00e1 foi inserido como o mesmo material.", 2);
            ScreenUtil.requisitarFoco(this.textExame);
            this.textExame.selectAll();
            return;
        }
        ConvenioCotaExameBean convenioCotaExameBean = new ConvenioCotaExameBean();
        ConvenioVO convenioVO = new ConvenioVO();
        convenioVO.setCodigo(this.convenio);
        convenioCotaExameBean.setCodigo(convenioVO);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(this.filial);
        convenioCotaExameBean.setFilial(filialVO);
        if (this.comboBoxMaterial.getSelectedItem() == null) {
            Funcoes.mensagem(this, "Informe o material.", 2);
            ScreenUtil.requisitarFoco(this.comboBoxMaterial);
            return;
        }
        if (!(this.comboBoxMaterial.getSelectedItem() instanceof DadosMaterial)) {
            Funcoes.mensagem(this, "Informe o material.", 2);
            ScreenUtil.requisitarFoco(this.comboBoxMaterial);
            return;
        }
        DadosMaterial m = (DadosMaterial)this.comboBoxMaterial.getSelectedItem();
        this.materialAux = new MaterialColetaVO();
        this.materialAux.setCodigo(m.getCodigo());
        this.materialAux.setAbreviatura(m.getAbreviatura());
        this.materialAux.setDescricao(m.getDescricao());
        if (ParametrosGerais.getPrecoMetodologia()) {
            if (this.comboBoxMetodologia.getSelectedItem() == null) {
                Funcoes.mensagem(this, "Informe a metodologia.", 2);
                ScreenUtil.requisitarFoco(this.comboBoxMetodologia);
                return;
            }
            if (!(this.comboBoxMetodologia.getSelectedItem() instanceof MetodologiaVO)) {
                Funcoes.mensagem(this, "Informe a metodologia.", 2);
                ScreenUtil.requisitarFoco(this.comboBoxMetodologia);
                return;
            }
            this.metodologiaAux = (MetodologiaVO)this.comboBoxMetodologia.getSelectedItem();
        }
        if (this.isEditando) {
            int linhaEdicao = this.tableExames.getSelectedRow();
            ConvenioCotaExameBean bean = (ConvenioCotaExameBean)this.modeloExames.getValueAt(linhaEdicao, this.COLUNA_CONVENO_COTA);
            if (!(this.exameAux.getCodigo().equals(bean.getExame().getCodigo()) && this.materialAux.getCodigo().equals(bean.getMaterialColeta().getCodigo()) || !this.verificaExameInserido())) {
                Funcoes.mensagem(this, "O exame j\u00e1 foi inserido como o mesmo material.", 2);
                ScreenUtil.requisitarFoco(this.textExame);
                this.textExame.selectAll();
                return;
            }
            this.modeloExames.removeLine(linhaEdicao);
        }
        convenioCotaExameBean.setExame(this.exameAux);
        convenioCotaExameBean.setMaterialColeta(this.materialAux);
        if (ParametrosGerais.getPrecoMetodologia()) {
            convenioCotaExameBean.setMetodologia(this.metodologiaAux);
        }
        convenioCotaExameBean.setQuantidade(Double.parseDouble(this.quantidadeAux.toString()));
        if (ParametrosGerais.getPrecoMetodologia()) {
            this.modeloExames.addLine(new Object[]{this.exameAux.getCodigo(), this.exameAux.getDescricao(), this.materialAux.getCodigo(), this.materialAux.getDescricao(), this.metodologiaAux.getCodigo(), this.metodologiaAux.getDescricao(), this.quantidadeAux, convenioCotaExameBean});
        } else {
            this.modeloExames.addLine(new Object[]{this.exameAux.getCodigo(), this.exameAux.getDescricao(), this.materialAux.getCodigo(), this.materialAux.getDescricao(), this.quantidadeAux, convenioCotaExameBean});
        }
        this.exameAux = null;
        this.materialAux = null;
        this.metodologiaAux = null;
        this.quantidadeAux = null;
        this.preencheDadosExame(null, null);
        this.preencheDadosMaterial(null, null);
        this.textQuantidade.clear();
        this.isEditando = false;
        this.comboBoxMaterial.removeAllItems();
        this.comboBoxMaterial.addItem("Selecione");
        this.comboBoxMetodologia.removeAllItems();
        this.comboBoxMetodologia.addItem("Selecione");
        ScreenUtil.requisitarFoco(this.textExame);
    }

    private boolean verificaExameInserido() {
        if (ParametrosGerais.getPrecoMetodologia()) {
            this.metodologiaAux = (MetodologiaVO)this.comboBoxMetodologia.getSelectedItem();
        }
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            if (!this.modeloExames.getValueAt(i, 0).toString().equals(this.exameAux.getCodigo().toString()) || !this.modeloExames.getValueAt(i, 2).toString().equals(this.materialAux.getCodigo().toString())) continue;
            return true;
        }
        return false;
    }

    protected void removeExameSelecionado() {
        int row;
        if (this.isEditando) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover durante a edi\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textExame);
            return;
        }
        int confirmaExclusao = Funcoes.mensagem(this, "Deseja excluir o exame.", 4);
        if (confirmaExclusao == 0 && (row = this.tableExames.getSelectedRow()) > -1) {
            this.modeloExames.removeLine(row);
        }
    }

    protected void editarExameCota(int selectedRow) {
        this.isEditando = true;
        ConvenioCotaExameBean bean = (ConvenioCotaExameBean)this.modeloExames.getValueAt(selectedRow, this.COLUNA_CONVENO_COTA);
        this.exameAux = bean.getExame();
        this.materialAux = bean.getMaterialColeta();
        if (ParametrosGerais.getPrecoMetodologia()) {
            this.metodologiaAux = bean.getMetodologia();
        }
        this.carregaDadosExame(bean.getExame().getCodigo());
        this.carregaDadosMaterial(bean.getMaterialColeta().getCodigo().toString());
        if (ParametrosGerais.getPrecoMetodologia()) {
            this.carregaDadosMetodologia(bean.getMetodologia().getCodigo() != null ? bean.getMetodologia().getCodigo().toString() : "0");
        }
        this.textQuantidade.setText("" + bean.getQuantidade().intValue());
    }

    private void preencheDadosMaterial(String codigo, String descricao) {
        if (codigo != null) {
            for (int i = 0; i < this.comboBoxMaterial.getItemCount(); ++i) {
                DadosMaterial m = (DadosMaterial)this.comboBoxMaterial.getItemAt(i);
                if (m.getCodigo() != Integer.parseInt(codigo)) continue;
                this.comboBoxMaterial.setSelectedIndex(i);
                break;
            }
        } else {
            this.comboBoxMaterial.addItem("Selecione");
            this.comboBoxMetodologia.removeAllItems();
            this.comboBoxMetodologia.addItem("Selecione");
        }
    }

    protected void carregaDadosExame(String codigo) {
        ExameVO exame = null;
        try {
            exame = (ExameVO)new ExameService().getVO(Variaveis.filialPadrao, codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (exame != null) {
            this.exameAux = exame;
            this.preencheDadosExame(exame.getCodigo(), exame.getDescricao());
            this.materialAux = new MaterialColetaVO();
            if (this.comboBoxMaterial.getItemCount() > 0 && this.comboBoxMaterial.getItemAt(0) instanceof DadosMaterial) {
                DadosMaterial material = (DadosMaterial)this.comboBoxMaterial.getSelectedItem();
                if (material != null && !this.isEditando) {
                    this.materialAux.setAbreviatura(material.getAbreviatura());
                    this.materialAux.setCodigo(material.getCodigo());
                    this.materialAux.setDescricao(material.getDescricao());
                    this.comboBoxMaterial.setSelectedItem(material);
                } else if (this.isEditando) {
                    int linhaEdicao = this.tableExames.getSelectedRow();
                    ConvenioCotaExameBean bean = (ConvenioCotaExameBean)this.modeloExames.getValueAt(linhaEdicao, this.COLUNA_CONVENO_COTA);
                    for (int i = 0; i < this.comboBoxMaterial.getItemCount(); ++i) {
                        DadosMaterial mat = (DadosMaterial)this.comboBoxMaterial.getItemAt(i);
                        if (mat.getCodigo() != bean.getMaterialColeta().getCodigo().intValue()) continue;
                        this.comboBoxMaterial.setSelectedIndex(i);
                        break;
                    }
                }
                this.carregaMetodologia(2);
            }
            ScreenUtil.requisitarFoco(this.comboBoxMaterial);
        } else {
            this.exameAux = null;
            this.labelDescExame.setText("N\u00e3o cadastrado");
        }
    }

    protected void carregaDadosMaterial(String codigo) {
        MaterialColetaVO material = null;
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("mco_codigo", codigo);
            material = (MaterialColetaVO)new MaterialColetaService().getVO(chaves);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do material de coleta.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
        if (material != null) {
            this.materialAux = material;
            this.preencheDadosMaterial(material.getCodigo().toString(), material.getDescricao());
        } else {
            this.materialAux = null;
            this.comboBoxMaterial.addItem("Selecione");
            this.comboBoxMetodologia.removeAllItems();
            this.comboBoxMetodologia.addItem("Selecione");
        }
    }

    protected void carregaDadosMetodologia(String codigo) {
        if (ParametrosGerais.getPrecoMetodologia()) {
            MetodologiaVO metodologia = null;
            try {
                metodologia = (MetodologiaVO)new MetodologiaService().getVO(Variaveis.filialPadrao, codigo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da metodologia.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            if (metodologia != null) {
                this.metodologiaAux = metodologia;
                this.comboBoxMetodologia.setSelectedItem(this.metodologiaAux);
            } else {
                this.metodologiaAux = null;
            }
        }
    }

    protected void carregaMetodologia(int event) {
        block6: {
            DadosMaterial material;
            if (event == 2 && ParametrosGerais.getPrecoMetodologia() && (material = (DadosMaterial)this.comboBoxMaterial.getSelectedItem()) != null) {
                this.materialAux = new MaterialColetaVO();
                this.materialAux.setAbreviatura(material.getAbreviatura());
                this.materialAux.setCodigo(material.getCodigo());
                this.materialAux.setDescricao(material.getDescricao());
                FilialVO filialVO = new FilialVO();
                filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                this.materialAux.setFilial(filialVO);
                try {
                    List<String> metodologia = new MetodologiaService().retornaCodigoMetodologia(Variaveis.filialPadrao, this.textExame.getText(), material.getCodigo());
                    this.comboBoxMetodologia.removeAllItems();
                    if (!metodologia.isEmpty() && metodologia != null) {
                        for (String met : metodologia) {
                            this.metodologiaAux = (MetodologiaVO)new MetodologiaService().getVO(Variaveis.filialPadrao, met.toString());
                            this.comboBoxMetodologia.addItem(this.metodologiaAux);
                        }
                    }
                    if (!this.isEditando) break block6;
                    ConvenioCotaExameBean bean = (ConvenioCotaExameBean)this.modeloExames.getValueAt(this.linhaEditando, this.COLUNA_CONVENO_COTA);
                    for (int i = 0; i < this.comboBoxMetodologia.getItemCount(); ++i) {
                        MetodologiaVO m = (MetodologiaVO)this.comboBoxMetodologia.getItemAt(i);
                        if (!m.getCodigo().equals(bean.getMetodologia().getCodigo())) continue;
                        this.comboBoxMetodologia.setSelectedIndex(i);
                        break;
                    }
                }
                catch (Exception e2) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar metodologia do exame.\n" + e2.getMessage(), e2.getStackTrace());
                }
            }
        }
    }

    private void montaPainelExames() {
        this.painelExames.setBorder(new TitledBorder("Exames da cota"));
        ScreenUtil.setBorda(new Component[]{this.labelDescExame}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelExame.setDisplayedMnemonic('E');
        this.labelExame.setLabelFor(this.textExame);
        this.painelExames.add((Component)this.labelExame, c);
        c.gridx += 3;
        c.gridwidth = 1;
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.comboBoxMaterial);
        this.painelExames.add((Component)this.labelMaterial, c);
        if (ParametrosGerais.getPrecoMetodologia()) {
            ++c.gridx;
            c.gridwidth = 2;
            this.labelMetodologia.setDisplayedMnemonic('t');
            this.labelMetodologia.setLabelFor(this.comboBoxMetodologia);
            this.painelExames.add((Component)this.labelMetodologia, c);
        }
        ++c.gridx;
        c.gridwidth = 4;
        this.labelQuantidade.setDisplayedMnemonic('Q');
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        this.painelExames.add((Component)this.labelQuantidade, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.textExame.setMinimumSize(new Dimension(60, 20));
        this.textExame.setMaximumSize(new Dimension(60, 20));
        this.textExame.setPreferredSize(new Dimension(60, 20));
        this.textExame.setUpperCase(true);
        this.painelExames.add((Component)this.textExame, c);
        ++c.gridx;
        this.buttonPesquisaExame.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisaExame.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonPesquisaExame);
        this.buttonPesquisaExame.setFocusable(false);
        this.painelExames.add((Component)this.buttonPesquisaExame, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDescExame.setMinimumSize(new Dimension(200, 20));
        this.labelDescExame.setPreferredSize(new Dimension(200, 20));
        this.painelExames.add((Component)this.labelDescExame, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.comboBoxMaterial.setMinimumSize(new Dimension(110, 20));
        this.comboBoxMaterial.setPreferredSize(new Dimension(110, 20));
        this.painelExames.add((Component)this.comboBoxMaterial, c);
        if (ParametrosGerais.getPrecoMetodologia()) {
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.comboBoxMetodologia.setMinimumSize(new Dimension(110, 20));
            this.comboBoxMetodologia.setPreferredSize(new Dimension(110, 20));
            this.painelExames.add((Component)this.comboBoxMetodologia, c);
        }
        ++c.gridx;
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.textQuantidade.setMinimumSize(new Dimension(50, 20));
        this.textQuantidade.setPreferredSize(new Dimension(50, 20));
        this.painelExames.add((Component)this.textQuantidade, c);
        ++c.gridx;
        this.buttonOKExame.setMinimumSize(new Dimension(30, 20));
        this.buttonOKExame.setPreferredSize(new Dimension(30, 20));
        this.buttonOKExame.setMargin(new Insets(0, 0, 0, 0));
        this.painelExames.add((Component)this.buttonOKExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 11;
        this.scrollExames.setMinimumSize(new Dimension(20, 120));
        this.scrollExames.setPreferredSize(new Dimension(20, 120));
        this.painelExames.add((Component)this.scrollExames, c);
        if (ParametrosGerais.getPrecoMetodologia()) {
            this.modeloExames.setColumnSize(new int[]{80, 0, 60, 0, 60, 0, 50}, this.tableExames);
        } else {
            this.modeloExames.setColumnSize(new int[]{80, 0, 60, 0, 50}, this.tableExames);
        }
    }

    private void montaPainelSituacoes() {
        this.painelSituacoes.setBorder(new TitledBorder("Situa\u00e7\u00f5es extracota"));
        ScreenUtil.setBorda(new Component[]{this.labelDescSituacao}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelCodigo.setDisplayedMnemonic('d');
        this.labelCodigo.setLabelFor(this.textSituacao);
        this.painelSituacoes.add((Component)this.labelCodigo, c);
        c.gridx = 2;
        this.painelSituacoes.add((Component)this.labelDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        this.textSituacao.setMinimumSize(new Dimension(70, 20));
        this.textSituacao.setPreferredSize(new Dimension(70, 20));
        this.painelSituacoes.add((Component)this.textSituacao, c);
        ++c.gridx;
        this.buttonPesquisaSituacao.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisaSituacao.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonPesquisaSituacao);
        this.buttonPesquisaSituacao.setFocusable(false);
        this.painelSituacoes.add((Component)this.buttonPesquisaSituacao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.labelDescSituacao.setMinimumSize(new Dimension(20, 20));
        this.labelDescSituacao.setPreferredSize(new Dimension(20, 20));
        this.painelSituacoes.add((Component)this.labelDescSituacao, c);
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.buttonOKSituacao.setMinimumSize(new Dimension(30, 20));
        this.buttonOKSituacao.setPreferredSize(new Dimension(30, 20));
        this.buttonOKSituacao.setMargin(new Insets(0, 0, 0, 0));
        this.painelSituacoes.add((Component)this.buttonOKSituacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.scrollSituacoes.setMinimumSize(new Dimension(20, 120));
        this.scrollSituacoes.setPreferredSize(new Dimension(20, 120));
        this.painelSituacoes.add((Component)this.scrollSituacoes, c);
        this.modeloSituacoes.setColumnSize(new int[]{60, 0}, this.tableSituacoes);
    }
}

