/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.model.bean.cadastro.ColetaBean;
import jalis.model.bean.cadastro.TaxaBean;
import jalis.model.bean.cadastro.TaxaColetaBean;
import jalis.model.vo.cadastro.ColetaVO;
import jalis.model.vo.cadastro.TaxaColetaVO;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.ColetaService;
import jalis.service.cadastro.TaxaColetaService;
import jalis.service.cadastro.TaxaService;
import jalis.util.CEP;
import jalis.util.ComponenteUtils;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.InsetsUIResource;

public class Coleta
extends FrmCadPadrao
implements ActionListener {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TTextField txtCidade;
    private JButton jButton1;
    private JButton jButton2;
    private TTextField txtDescCidade;
    private JLabel jLabel4;
    private TTextField txtEndereco;
    private JLabel jLabel5;
    private TTextField txtComplemento;
    private JLabel jLabel6;
    private TTextField txtCodBairro;
    private TTextField txtDescBairro;
    private JLabel jLabel7;
    private TTextField txtCEP;
    private JLabel jLabel8;
    private TTextFieldTelefone txtFone;
    private JLabel jLabel9;
    private TTextField txtComissao;
    private JLabel jLabel10;
    private JLabel jPercComis;
    private TTextField txtDescontoProducao;
    private TitledBorder tbComissDesc;
    private JLabel jPercDesc;
    private JPanel panelDescontoComissao;
    private String retornoParaPesquisa = "";
    private JTabbedPane abasInferior = new JTabbedPane();
    private JPanel jPanelTaxas = new JPanel();
    private JLabel jLabelCodTaxa = new JLabel("C\u00f3digo");
    private JLabel jLabelDescTaxa = new JLabel();
    private TTextField textFieldCodTaxa = new TTextField(9, 1);
    private JButton buttonPesqTaxa = ComponenteFactory.novoJButton(this, true);
    private JLabel jLabelVlrDescTaxa = new JLabel();
    private JButton buttonAddTaxa = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton bBuscaCep = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloGridTable = null;
    private JTable table = null;
    private JScrollPane scroll = null;
    private TaxaVO taxaVO = new TaxaVO();
    private TaxaBean taxaBean = new TaxaBean();
    private TaxaService serviceTaxa = new TaxaService();
    private Set<TaxaColetaVO> taxaColetaVOs = new HashSet<TaxaColetaVO>();
    private TaxaColetaVO taxaColetaVO = new TaxaColetaVO();
    private ColetaBean coletaBean = new ColetaBean();
    private ColetaService coletaService = new ColetaService();
    private TaxaColetaService serviceTaxaColeta = new TaxaColetaService();
    private JCheckBox checkMarcarComoExterno = new JCheckBox("Marcar exames como material externo");

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Coleta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0100500001"));
        this.setModuloEdita(Long.parseLong("0100500002"));
        this.setModuloApaga(Long.parseLong("0100500003"));
    }

    public Coleta() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Coleta");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodigo.setUpperCase(true);
        this.txtCodBairro.setUpperCase(true);
    }

    public void jbInit() throws Exception {
        this.setName("Coleta");
        this.setLabelDescricao("Cadastro de locais de coleta");
        this.setLabelFormulario("Cadastro de coletas");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_local_coleta.jpg"));
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtCidade = new TTextField(5, 1);
        this.txtCidade.setName("txtCidade");
        this.jButton1 = new JButton();
        this.jButton1.setName("jButton1");
        this.jButton2 = new JButton();
        this.jButton2.setName("jButton2");
        this.txtDescCidade = new TTextField(80);
        this.txtDescCidade.setName("txtDescCidade");
        this.txtDescBairro = new TTextField(80);
        this.txtDescBairro.setName("txtDescBairro");
        this.jLabel4 = new JLabel();
        this.txtEndereco = new TTextField(80);
        this.txtEndereco.setName("txtEndereco");
        this.jLabel5 = new JLabel();
        this.txtComplemento = new TTextField(50);
        this.txtComplemento.setName("txtComplemento");
        this.jLabel6 = new JLabel();
        this.txtCodBairro = new TTextField(5);
        this.txtCodBairro.setName("txtCodBairro");
        this.jLabel7 = new JLabel();
        this.txtCEP = new TTextField(9, 9);
        this.txtCEP.setName("txtCEP");
        this.jLabel8 = new JLabel();
        this.txtFone = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
        this.txtFone.setName("txtFone");
        this.jLabel9 = new JLabel();
        this.jPercComis = new JLabel("%");
        this.txtComissao = new TTextField(6, 2, 2);
        this.txtComissao.setName("txtComissao");
        this.jLabel10 = new JLabel();
        this.jPercDesc = new JLabel("%");
        this.txtDescontoProducao = new TTextField(6, 2, 2);
        this.txtDescontoProducao.setName("txtDescontoProducao");
        this.panelDescontoComissao = new JPanel(new GridBagLayout());
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.txtCodigo.setText("");
        this.jLabel1.setBounds(new Rectangle(5, 9, 55, 14));
        this.txtCodigo.setBounds(new Rectangle(97, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(97, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(5, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.jLabel3.setText("Cidade:");
        this.jLabel3.setBounds(new Rectangle(5, 51, 63, 14));
        this.txtCidade.setBounds(new Rectangle(97, 49, 69, 20));
        this.jButton1.setBounds(new Rectangle(167, 49, 20, 20));
        this.jButton1.setFocusable(false);
        this.jButton1.setText("");
        Funcoes.imagemPesquisa(this.jButton1);
        this.txtDescCidade.setText("");
        this.txtDescCidade.setEditable(false);
        this.txtDescCidade.setFocusable(false);
        this.txtDescCidade.setBounds(new Rectangle(188, 49, 309, 20));
        this.jLabel4.setText("Endere\u00e7o:");
        this.jLabel4.setBounds(new Rectangle(5, 72, 63, 14));
        this.txtEndereco.setText("");
        this.txtEndereco.setBounds(new Rectangle(97, 70, 400, 20));
        this.jLabel5.setText("Complemento:");
        this.jLabel5.setBounds(new Rectangle(5, 93, 92, 14));
        this.txtComplemento.setText("");
        this.txtComplemento.setBounds(new Rectangle(97, 91, 400, 20));
        this.jLabel6.setText("Bairro:");
        this.jLabel6.setBounds(new Rectangle(5, 114, 63, 14));
        this.txtCodBairro.setText("");
        this.txtCodBairro.setBounds(new Rectangle(97, 112, 69, 20));
        this.jButton2.setBounds(new Rectangle(167, 112, 20, 20));
        this.jButton2.setFocusable(false);
        this.jButton2.setText("");
        Funcoes.imagemPesquisa(this.jButton2);
        this.txtDescBairro.setText("");
        this.txtDescBairro.setEditable(false);
        this.txtDescBairro.setFocusable(false);
        this.txtDescBairro.setBounds(new Rectangle(188, 112, 130, 20));
        this.jLabel7.setBounds(new Rectangle(346, 114, 35, 14));
        this.jLabel7.setText("CEP:");
        this.txtCEP.setBounds(new Rectangle(381, 112, 93, 20));
        this.txtCEP.setText("");
        this.bBuscaCep.setText("CEP:");
        this.bBuscaCep.setBounds(new Rectangle(476, 112, 20, 20));
        this.bBuscaCep.setText("");
        this.jLabel8.setBounds(new Rectangle(5, 135, 63, 14));
        this.jLabel8.setText("Fone:");
        this.txtFone.setBounds(new Rectangle(97, 133, 116, 20));
        this.txtFone.clear();
        this.checkMarcarComoExterno.setBounds(97, 155, 300, 20);
        this.checkMarcarComoExterno.setName("checkMarcarComoExterno");
        this.panelDescontoComissao.setBounds(new Rectangle(5, 180, 493, 75));
        this.jPanelTaxas.setBounds(new Rectangle(5, 156, 493, 75));
        GridBagConstraints bagLayoutComissaoDesconto = new GridBagConstraints();
        bagLayoutComissaoDesconto.gridx = 0;
        bagLayoutComissaoDesconto.gridy = 0;
        bagLayoutComissaoDesconto.weightx = 0.0;
        bagLayoutComissaoDesconto.weighty = 0.0;
        bagLayoutComissaoDesconto.anchor = 17;
        bagLayoutComissaoDesconto.insets = new Insets(1, 0, 0, 1);
        bagLayoutComissaoDesconto.fill = 0;
        this.jLabel9.setText("Comiss\u00e3o:");
        this.panelDescontoComissao.add((Component)this.jLabel9, bagLayoutComissaoDesconto);
        this.txtComissao.setPreferredSize(new Dimension(55, 20));
        this.txtComissao.setMinimumSize(new Dimension(55, 20));
        this.txtComissao.setText("");
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.txtComissao, bagLayoutComissaoDesconto);
        ++bagLayoutComissaoDesconto.gridx;
        this.jPercComis.setPreferredSize(new Dimension(30, 14));
        this.jPercComis.setMinimumSize(new Dimension(30, 14));
        this.panelDescontoComissao.add((Component)this.jPercComis, bagLayoutComissaoDesconto);
        bagLayoutComissaoDesconto.weightx = 1.0;
        bagLayoutComissaoDesconto.fill = 2;
        this.panelDescontoComissao.add((Component)new JLabel(), bagLayoutComissaoDesconto);
        bagLayoutComissaoDesconto.weightx = 0.0;
        bagLayoutComissaoDesconto.fill = 0;
        this.jLabel10.setText("Desconto de produ\u00e7\u00e3o:");
        bagLayoutComissaoDesconto.gridx = 0;
        ++bagLayoutComissaoDesconto.gridy;
        this.panelDescontoComissao.add((Component)this.jLabel10, bagLayoutComissaoDesconto);
        this.txtDescontoProducao.setPreferredSize(new Dimension(55, 20));
        this.txtDescontoProducao.setMinimumSize(new Dimension(55, 20));
        this.txtDescontoProducao.setText("");
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.txtDescontoProducao, bagLayoutComissaoDesconto);
        this.jPercDesc.setPreferredSize(new Dimension(30, 14));
        ++bagLayoutComissaoDesconto.gridx;
        this.panelDescontoComissao.add((Component)this.jPercDesc, bagLayoutComissaoDesconto);
        ++bagLayoutComissaoDesconto.gridy;
        bagLayoutComissaoDesconto.weightx = 1.0;
        bagLayoutComissaoDesconto.weighty = 1.0;
        bagLayoutComissaoDesconto.gridwidth = 3;
        bagLayoutComissaoDesconto.fill = 1;
        this.panelDescontoComissao.add((Component)new JLabel(), bagLayoutComissaoDesconto);
        ComponenteUtils.novaMascaraTelefone(ParametrosGerais.getMascaraFone(), this.txtFone);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel8, null);
        this.painelCentral.add((Component)this.jLabel6, null);
        this.painelCentral.add((Component)this.jLabel5, null);
        this.painelCentral.add((Component)this.jLabel4, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.txtFone, null);
        this.painelCentral.add((Component)this.checkMarcarComoExterno, null);
        this.painelCentral.add((Component)this.txtCodBairro, null);
        this.painelCentral.add((Component)this.jButton2, null);
        this.painelCentral.add((Component)this.txtDescBairro, null);
        this.painelCentral.add((Component)this.txtComplemento, null);
        this.painelCentral.add((Component)this.txtEndereco, null);
        this.painelCentral.add((Component)this.txtCidade, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.jButton1, null);
        this.painelCentral.add((Component)this.bBuscaCep, null);
        this.painelCentral.add((Component)this.txtDescCidade, null);
        this.painelCentral.add((Component)this.jLabel7, null);
        this.painelCentral.add((Component)this.txtCEP, null);
        this.jPanelTaxas.setLayout(new GridBagLayout());
        this.abasInferior.setBounds(new Rectangle(5, 185, 493, 200));
        this.abasInferior.add((Component)this.panelDescontoComissao, "Comiss\u00e3o/Desconto");
        this.abasInferior.setName("abasInferior");
        GridBagConstraints layoutTaxa = new GridBagConstraints();
        layoutTaxa.fill = 13;
        layoutTaxa.anchor = 17;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridy = 0;
        layoutTaxa.weightx = 0.0;
        layoutTaxa.weighty = 0.0;
        layoutTaxa.insets = new Insets(1, 0, 0, 1);
        this.jPanelTaxas.add((Component)this.jLabelCodTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        ++layoutTaxa.gridx;
        this.jPanelTaxas.add((Component)this.jLabelDescTaxa, layoutTaxa);
        layoutTaxa.gridx = 0;
        ++layoutTaxa.gridy;
        layoutTaxa.insets = new InsetsUIResource(1, 0, 0, 0);
        this.textFieldCodTaxa.setPreferredSize(new Dimension(80, 20));
        this.textFieldCodTaxa.setName("textFieldCodTaxa");
        this.textFieldCodTaxa.setMinimumSize(new Dimension(80, 20));
        this.jPanelTaxas.add((Component)this.textFieldCodTaxa, layoutTaxa);
        layoutTaxa.insets = new InsetsUIResource(1, 0, 0, 1);
        ++layoutTaxa.gridx;
        this.buttonPesqTaxa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesqTaxa.setName("buttonPesqTaxa");
        this.buttonPesqTaxa.setMinimumSize(new Dimension(20, 20));
        this.jPanelTaxas.add((Component)this.buttonPesqTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.jLabelVlrDescTaxa.setPreferredSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setMinimumSize(new Dimension(20, 20));
        this.jLabelVlrDescTaxa.setBorder(new TitledBorder(""));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.fill = 2;
        this.jPanelTaxas.add((Component)this.jLabelVlrDescTaxa, layoutTaxa);
        ++layoutTaxa.gridx;
        this.buttonAddTaxa.setPreferredSize(new Dimension(40, 20));
        this.buttonAddTaxa.setName("buttonAddTaxa");
        this.buttonAddTaxa.setMinimumSize(new Dimension(40, 20));
        layoutTaxa.weightx = 0.0;
        layoutTaxa.fill = 13;
        this.jPanelTaxas.add((Component)this.buttonAddTaxa, layoutTaxa);
        this.modeloGridTable = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Autom\u00e1tica"}){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Class[] valores = new Class[]{Integer.class, String.class, Boolean.class};
                return valores[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                boolean[] valores = new boolean[]{false, false, true};
                return valores[columnIndex];
            }
        };
        this.table = new JTable(this.modeloGridTable);
        this.table.setName("table");
        this.modeloGridTable.setColumnSize(new int[]{72, 0, 70}, this.table);
        this.scroll = new JScrollPane(this.table);
        this.scroll.setPreferredSize(new Dimension(100, 100));
        this.scroll.setMinimumSize(new Dimension(100, 100));
        layoutTaxa.weightx = 1.0;
        layoutTaxa.weighty = 1.0;
        ++layoutTaxa.gridy;
        layoutTaxa.gridx = 0;
        layoutTaxa.gridwidth = 4;
        layoutTaxa.fill = 1;
        this.jPanelTaxas.add((Component)this.scroll, layoutTaxa);
        this.abasInferior.add((Component)this.jPanelTaxas, "Taxas");
        this.painelCentral.add(this.abasInferior);
        this.abasInferior.setName("abasInferior");
        this.controlaCampos();
        this.textFieldCodTaxa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Coleta.this.buttonPesqTaxa.doClick();
                }
            }
        });
        this.textFieldCodTaxa.setName("textFieldCodTaxa");
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    int resp = Funcoes.mensagem(Coleta.this.painelCentral, "Deseja remover a taxa da composi\u00e7\u00e3o ?", 4);
                    if (resp == 0) {
                        Coleta.this.modeloGridTable.removeLine(row);
                    }
                    Coleta.this.ordenarTabelaTaxa();
                }
            }
        });
        this.textFieldCodTaxa.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    Coleta.this.jLabelVlrDescTaxa.setText("");
                    if (!Funcoes.textoVazio(Coleta.this.textFieldCodTaxa.getText())) {
                        Coleta.this.taxaVO = (TaxaVO)Coleta.this.serviceTaxa.getVO(Variaveis.filialPadrao, Coleta.this.textFieldCodTaxa.getText());
                        if (Coleta.this.taxaVO != null) {
                            Coleta.this.textFieldCodTaxa.setText(Coleta.this.taxaVO.getCodigo().toString());
                            Coleta.this.jLabelVlrDescTaxa.setText(Coleta.this.taxaVO.getDescricao());
                        } else {
                            Coleta.this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
                            Coleta.this.textFieldCodTaxa.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(Coleta.this.painelCentral, "N\u00e3o foi poss\u00edvel consultar setor.", 1);
                }
            }
        });
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coleta.this.buscaCidade();
            }
        });
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Coleta.this.buscaBairro();
            }
        });
        this.bBuscaCep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CEP.buscarCEP(null, Coleta.this.txtCEP, Coleta.this.txtEndereco, Coleta.this.txtCidade, Coleta.this.txtDescCidade, Coleta.this.txtCodBairro, Coleta.this.txtDescBairro, Coleta.this);
                ScreenUtil.requisitarFoco(Coleta.this.txtCEP);
            }
        });
        this.txtCEP.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    CEP.buscarCEP(null, Coleta.this.txtCEP, Coleta.this.txtEndereco, Coleta.this.txtCidade, Coleta.this.txtDescCidade, Coleta.this.txtCodBairro, Coleta.this.txtDescBairro, Coleta.this);
                }
            }
        });
        this.txtCEP.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean validaCEP;
                if (!Funcoes.textoVazio(Coleta.this.txtCEP) && e.getOppositeComponent() != null && e.getOppositeComponent().getParent() == Coleta.this.txtCEP.getParent() && !(validaCEP = CEP.cepValido(Coleta.this.txtCEP))) {
                    ScreenUtil.requisitarFoco(Coleta.this.txtCEP);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.txtCidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (Coleta.this.txtCidade.getText().trim().length() > 0) {
                        Statement st = Conexao.getStatement();
                        if (st != null) {
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select cid_nome, cid_uf from cidades where fil_codigo = " + Variaveis.filialPadrao + " and cid_codigo=" + Coleta.this.txtCidade.getText());
                                if (rs.next()) {
                                    Coleta.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                                    break block6;
                                }
                                Coleta.this.txtDescCidade.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(Coleta.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                                Coleta.this.setStatus(1);
                                Coleta.this.controlaCampos();
                            }
                        }
                    } else {
                        Coleta.this.txtDescCidade.setText("N\u00e3o cadastrado");
                    }
                }
            }
        });
        this.txtCodBairro.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                block6: {
                    if (Coleta.this.txtCodBairro.getText().trim().length() > 0) {
                        Statement st = Conexao.getStatement();
                        if (st != null) {
                            try {
                                ResultSet rs = Conexao.executeQuery(st, "select bai_descricao from bairro where fil_codigo = " + Variaveis.filialPadrao + " and upper(bai_codigo)=upper(" + Coleta.this.txtCodBairro.getTextDBEscape() + ")");
                                if (rs.next()) {
                                    Coleta.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                    break block6;
                                }
                                Coleta.this.txtDescBairro.setText("N\u00e3o cadastrado");
                            }
                            catch (SQLException sqlex) {
                                Funcoes.mensagem(Coleta.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                                Coleta.this.setStatus(1);
                                Coleta.this.controlaCampos();
                            }
                        }
                    } else {
                        Coleta.this.txtDescBairro.setText("");
                    }
                }
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Coleta.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder buf = new StringBuilder("select a.col_descricao, a.cid_codigo, a.col_cep, a.col_endereco, a.col_cep, ");
                            buf.append(" a.col_complemento, a.col_fone, b.cid_nome, b.cid_uf, c.bai_descricao, a.bai_codigo, a.col_comissao, a.col_descontoproducao , a.col_marcarexterno ");
                            buf.append("from coletas a left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo=b.cid_codigo ");
                            buf.append("left  join bairro c on a.fil_codigo = c.fil_codigo and upper(a.bai_codigo)=upper(c.bai_codigo) ");
                            buf.append(" where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(a.col_codigo)=upper(");
                            buf.append(Coleta.this.txtCodigo.getTextDBEscape());
                            buf.append(")");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                if (Coleta.this.getStatus() == 2) {
                                    Coleta.this.setStatus(3);
                                }
                                Coleta.this.txtDescricao.setText(rs.getString("col_descricao"));
                                Coleta.this.txtCidade.setText(rs.getString("cid_codigo"));
                                if (!DBUtil.campoNull(rs.getString("cid_nome"))) {
                                    Coleta.this.txtDescCidade.setText(rs.getString("cid_nome") + " (" + rs.getString("cid_uf") + ")");
                                }
                                Coleta.this.txtEndereco.setText(rs.getString("col_endereco"));
                                Coleta.this.txtComplemento.setText(rs.getString("col_complemento"));
                                Coleta.this.txtCodBairro.setText(rs.getString("bai_codigo"));
                                Coleta.this.txtDescBairro.setText(rs.getString("bai_descricao"));
                                Coleta.this.txtCEP.setText(rs.getString("col_cep"));
                                Coleta.this.txtFone.setText(rs.getString("col_fone"));
                                Coleta.this.txtComissao.setText(rs.getString("col_comissao") == null ? "" : Funcoes.formataDecimal(Coleta.this.txtComissao.getMaskDecimal(), rs.getDouble("col_comissao")));
                                Coleta.this.txtDescontoProducao.setText(rs.getString("col_descontoproducao") == null ? "" : Funcoes.formataDecimal(Coleta.this.txtDescontoProducao.getMaskDecimal(), rs.getDouble("col_descontoproducao")));
                                Coleta.this.checkMarcarComoExterno.setSelected(rs.getBoolean("col_marcarexterno"));
                                Coleta.this.txtCodigo.setEnabled(false);
                                try {
                                    Set taxaColetaBeans = Coleta.this.serviceTaxaColeta.load(" where col_codigo = " + Coleta.this.txtCodigo.getTextDBEscape() + " and fil_codigo = " + Variaveis.filialPadrao);
                                    for (TaxaColetaBean taxaColetaBean : taxaColetaBeans) {
                                        Coleta.this.modeloGridTable.addLine(new Object[]{taxaColetaBean.getTaxa().getCodigo(), taxaColetaBean.getTaxa().getDescricao(), taxaColetaBean.getAutomatica(), taxaColetaBean.getTaxa()});
                                    }
                                    Coleta.this.ordenarTabelaTaxa();
                                }
                                catch (Exception ex) {
                                    ErrorLogger.mostraMensagem(Coleta.this.getTopLevelAncestor(), "Erro ao buscar a lista de taxas do registro de coleta.", ex.getStackTrace());
                                }
                            } else if (Coleta.this.getStatus() == 3) {
                                Funcoes.mensagem(Coleta.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Coleta.this.setStatus(1);
                                Coleta.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Coleta.this, sqlex.getMessage(), sqlex.getStackTrace(), "Coleta");
                    }
                }
            }
        });
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.coleta(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("col_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(5, 3));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("col_codigo", this.txtCodigo.getText());
                    chaves.put("fil_codigo", Variaveis.filialPadrao);
                    ColetaBean coletaBean = (ColetaBean)this.coletaService.getBean(chaves);
                    coletaBean.setTaxaColetaVOs(this.getTaxaColetaVOsModelo());
                    this.coletaService.delete(coletaBean, coletaBean.getCodigo(), Variaveis.filialPadrao, ParametrosGerais.getCopiaColeta());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Coleta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.txtCodigo.setDocument(new TTextField().criaDocument(5, 18));
        this.txtCodigo.setUpperCase(true);
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCidade.setText(String.valueOf(ParametrosGerais.getCidCodigo()));
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.valueOf(Variaveis.filialPadrao));
                CidadeVO cidadeVO = new CidadeVO();
                cidadeVO.setCodigo(Integer.parseInt(this.txtCidade.getText()));
                BairroVO bairroVO = new BairroVO();
                bairroVO.setCodigo(this.txtCodBairro.getText());
                this.coletaBean.setFilial(filial);
                this.coletaBean.setCodigo(this.txtCodigo.getText());
                this.coletaBean.setDescricao(this.txtDescricao.getText());
                this.coletaBean.setCidColeta(cidadeVO);
                this.coletaBean.setEndereco(this.txtEndereco.getText());
                this.coletaBean.setComplemento(this.txtComplemento.getText());
                this.coletaBean.setBairro(bairroVO);
                this.coletaBean.setCep(this.txtCEP.getText());
                this.coletaBean.setFone(this.txtFone.getText());
                this.coletaBean.setComissao(Double.valueOf(!Funcoes.textoVazio(this.txtComissao.getText()) ? Funcoes.limpaDecimal(this.txtComissao.getText()) : "0"));
                this.coletaBean.setDescontoProducao(Double.parseDouble(!Funcoes.textoVazio(this.txtDescontoProducao.getText()) ? Funcoes.limpaDecimal(this.txtDescontoProducao.getText()) : "0"));
                this.coletaBean.setTaxaColetaVOs(this.getTaxaColetaVOsModelo());
                this.coletaBean.setMarcarExterno(this.checkMarcarComoExterno.isSelected());
                if (this.getStatus() == 2) {
                    this.coletaService.insert(this.coletaBean, this.txtCodigo.getText(), Variaveis.filialPadrao, ParametrosGerais.getCopiaColeta());
                }
                if (this.getStatus() == 3) {
                    this.coletaService.update(this.coletaBean, this.txtCodigo.getText(), Variaveis.filialPadrao, ParametrosGerais.getCopiaColeta());
                }
                Util.gravaAlteracaoColeta(statement, this.txtCodigo.getText());
                this.retornoParaPesquisa = this.txtCodigo.getText();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Coleta");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCidade.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEndereco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComplemento.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodBairro.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCEP.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtFone.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtComissao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescontoProducao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton1.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.jButton2.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.bBuscaCep.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textFieldCodTaxa.setEditable(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonAddTaxa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonPesqTaxa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkMarcarComoExterno.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.txtCidade.setText("");
        this.txtDescCidade.setText("");
        this.txtEndereco.setText("");
        this.txtComplemento.setText("");
        this.txtCodBairro.setText("");
        this.txtDescBairro.setText("");
        this.txtCEP.setText("");
        this.txtFone.clear();
        this.txtComissao.setText("");
        this.txtDescontoProducao.setText("");
        this.modeloGridTable.clear();
        this.jLabelVlrDescTaxa.setText("");
        this.textFieldCodTaxa.clear();
        this.checkMarcarComoExterno.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select col_codigo from coletas where fil_codigo = " + Variaveis.filialPadrao + " and upper(col_codigo)=upper(" + this.txtCodigo.getTextDBEscape().trim() + ")");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Coleta j\u00e1 cadastrada", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (Funcoes.textoVazio(this.txtDescCidade.getText()) || Funcoes.textoVazio(this.txtCidade) || this.txtDescCidade.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe a cidade.", 2);
            ScreenUtil.requisitarFoco(this.txtCidade);
            return false;
        }
        if (Funcoes.textoVazio(this.txtDescBairro.getText()) || Funcoes.textoVazio(this.txtCodBairro) || this.txtDescBairro.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Informe um bairro.", 2);
            ScreenUtil.requisitarFoco(this.txtCodBairro);
            return false;
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo cidade n\u00e3o informado", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (this.txtCidade.getText().trim().length() > 0 && this.txtDescCidade.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cidade n\u00e3o localizada", 1);
            this.txtCidade.selectAll();
            this.txtCidade.grabFocus();
            return false;
        }
        if (this.txtCodBairro.getText().trim().length() > 0 && this.txtDescBairro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Bairro n\u00e3o localizado", 1);
            this.txtCodBairro.selectAll();
            this.txtCodBairro.grabFocus();
            return false;
        }
        if (this.txtComissao.getText().trim().length() > 0 && Double.parseDouble(Funcoes.limpaDecimal(this.txtComissao.getText())) > 100.0) {
            Funcoes.mensagem(this, "Campo comiss\u00e3o com valor incorreto", 1);
            this.txtComissao.selectAll();
            this.txtComissao.grabFocus();
            return false;
        }
        if (this.txtDescontoProducao.getText().trim().length() > 0 && Double.parseDouble(Funcoes.limpaDecimal(this.txtDescontoProducao.getText())) > 100.0) {
            Funcoes.mensagem(this, "Campo comiss\u00e3o com valor incorreto", 1);
            this.txtDescontoProducao.selectAll();
            this.txtDescontoProducao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCEP)) return true;
        if (CEP.tamanhoDoCepCorreto(this.txtCEP)) return true;
        Funcoes.mensagem(this, "CEP Inv\u00e1lido", 1);
        this.txtCEP.grabFocus();
        return false;
    }

    private void buscaCidade() {
        Hashtable resultado = Pesquisas.cidade(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCidade.setText(resultado.get("cid_codigo").toString());
        }
        this.txtCidade.requestFocus();
    }

    private void buscaBairro() {
        Hashtable resultado = Pesquisas.bairro(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodBairro.setText(resultado.get("bai_codigo").toString());
        }
        this.txtCodBairro.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCidade.hasFocus()) {
            this.buscaCidade();
        } else if (this.txtCodBairro.hasFocus()) {
            this.buscaBairro();
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0100500000");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "col_codigo";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonPesqTaxa)) {
            this.pesquisarTaxa();
        } else if (e.getSource().equals(this.buttonAddTaxa)) {
            if (this.taxaJaAdicionada()) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Taxa j\u00e1 foi informada", 2);
                this.jLabelVlrDescTaxa.setText("");
                this.textFieldCodTaxa.clear();
                ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
                return;
            }
            this.addicionarTaxa();
        }
    }

    private boolean taxaJaAdicionada() {
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            TaxaVO tVO = (TaxaVO)this.modeloGridTable.getValueAt(i, 3);
            if (tVO == null || this.taxaVO == null || this.taxaVO.getCodigo() == null || !tVO.getCodigo().equals(this.taxaVO.getCodigo())) continue;
            return true;
        }
        return false;
    }

    private void addicionarTaxa() {
        if (this.taxaVO != null && this.taxaVO.getCodigo() != null) {
            this.modeloGridTable.addLine(new Object[]{this.taxaVO.getCodigo(), this.taxaVO.getDescricao(), false, this.taxaVO});
            this.ordenarTabelaTaxa();
            this.taxaVO = null;
            this.jLabelVlrDescTaxa.setText("");
            this.textFieldCodTaxa.clear();
            ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
        } else {
            Funcoes.mensagem(this.getTopLevelAncestor(), "Informe a taxa.", 2);
            ScreenUtil.requisitarFoco(this.textFieldCodTaxa);
        }
    }

    private Set<TaxaColetaVO> getTaxaColetaVOsModelo() {
        HashSet<TaxaColetaVO> coletaVOs = new HashSet<TaxaColetaVO>();
        FilialVO filial = new FilialVO();
        ColetaVO coletaVO = new ColetaVO();
        coletaVO.setCodigo(this.coletaBean.getCodigo());
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        for (int i = 0; i < this.modeloGridTable.getRowCount(); ++i) {
            TaxaColetaVO taxaColetaVO = new TaxaColetaVO();
            taxaColetaVO.setFilial(filial);
            taxaColetaVO.setColeta(coletaVO);
            taxaColetaVO.setTaxa((TaxaVO)this.modeloGridTable.getValueAt(i, 3));
            taxaColetaVO.setAutomatica((Boolean)this.modeloGridTable.getValueAt(i, 2));
            coletaVOs.add(taxaColetaVO);
        }
        return coletaVOs;
    }

    private void pesquisarTaxa() {
        this.taxaVO = (TaxaVO)this.serviceTaxa.pesquisaVO(this.getTopLevelAncestor(), new TaxaVO(), "Pesquisando taxas", true);
        if (this.taxaVO != null) {
            this.textFieldCodTaxa.setText(this.taxaVO.getCodigo().toString());
            this.jLabelVlrDescTaxa.setText(this.taxaVO.getDescricao());
        } else {
            this.textFieldCodTaxa.selectAll();
            this.jLabelVlrDescTaxa.setText("N\u00e3o cadastrado");
        }
    }

    private void ordenarTabelaTaxa() {
        this.modeloGridTable.ordenarColunaSemTrocarSentido(this.modeloGridTable.findColumn("C\u00f3digo"));
    }
}

