/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class Cidade
extends FrmCadPadrao {
    private JComboBox comboEstado;
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel labelIBGE = new JLabel("IBGE:");
    private TTextField textIBGE = new TTextField(7, 1);
    private JLabel labelEmailLaudoOficial = new JLabel("E-mail SIPOA:");
    private TTextField txtEmailLaudoOficial = new TTextField(500, 17);
    private String retornoParaPesquisa = "";

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Cidade.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0100100001"));
        this.setModuloEdita(Long.parseLong("0100100002"));
        this.setModuloApaga(Long.parseLong("0100100003"));
    }

    public Cidade() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Cidade");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Cidade");
        this.comboEstado = new JComboBox<String>(ConstantesGerais.ESTADOS);
        this.comboEstado.setName("comboEstado");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setLabelDescricao("Cadastro de cidades");
        this.setLabelFormulario("Cadastro de cidades");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_cidade.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 90, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(92, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(92, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 90, 14));
        this.jLabel2.setText("Nome:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('m');
        this.jLabel3.setText("Estado:");
        this.jLabel3.setBounds(new Rectangle(7, 52, 90, 14));
        this.comboEstado.setBounds(new Rectangle(92, 50, 67, 20));
        this.comboEstado.setName("comboEstado");
        this.labelIBGE.setBounds(200, 52, 50, 14);
        this.textIBGE.setBounds(235, 50, 100, 20);
        this.textIBGE.setName("textIBGE");
        this.labelEmailLaudoOficial.setBounds(7, 73, 90, 20);
        this.txtEmailLaudoOficial.setBounds(92, 73, 400, 20);
        this.txtEmailLaudoOficial.setName("txtEmailLaudoOficial");
        if (!Funcoes.textoVazio(ParametrosGerais.getUfDefault())) {
            this.comboEstado.setSelectedItem(ParametrosGerais.getUfDefault());
        }
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.jLabel3, null);
        this.painelCentral.add((Component)this.comboEstado, null);
        this.painelCentral.add(this.labelIBGE);
        this.painelCentral.add(this.textIBGE);
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            this.painelCentral.add(this.labelEmailLaudoOficial);
            this.painelCentral.add(this.txtEmailLaudoOficial);
        }
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Cidade.this.txtCodigo.getText().trim().length() > 0 && Funcoes.isNumeric(Cidade.this.txtCodigo.getText().trim())) {
                    Statement st = Conexao.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select cid_nome, cid_uf, cid_codigoibge, cid_emaillaudooficial from cidades where fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and cid_codigo = ");
                            buf.append(Cidade.this.txtCodigo.getText());
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs.next()) {
                                Cidade.this.txtDescricao.setText(rs.getString("cid_nome"));
                                String uf = rs.getString("cid_uf");
                                Cidade.this.comboEstado.setSelectedItem(uf);
                                Cidade.this.textIBGE.setText(rs.getString("cid_codigoibge"));
                                Cidade.this.txtEmailLaudoOficial.setText(rs.getString("cid_emaillaudooficial"));
                                Cidade.this.txtCodigo.setEnabled(false);
                            } else {
                                Funcoes.mensagem(Cidade.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Cidade.this.setStatus(1);
                                Cidade.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Cidade.this, sqlex.getMessage(), sqlex.getStackTrace(), "Cidade");
                    }
                }
            }
        });
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.cidade(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("cid_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("cidades", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("cid_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaCidade());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Cidade");
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.getStatus() == 2 ? DBUtil.getSequencia(statement, "cidades", true) : this.txtCodigo.getText();
                SalvaDados salvar = new SalvaDados("cidades", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("cid_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("cid_nome", 0, true, false, this.txtDescricao.getTextDBEscape());
                salvar.adicionaCampo("cid_uf", 0, true, false, StringUtil.textoDBEscape(this.comboEstado.getSelectedItem().toString()));
                salvar.adicionaCampo("cid_codigoibge", 2, true, false, this.textIBGE.getText());
                salvar.adicionaCampo("cid_emaillaudooficial", 0, true, false, this.txtEmailLaudoOficial.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaCidade(), "cidades", Integer.parseInt(codigo));
                Util.gravaAlteracaoCidade(statement, codigo);
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Cidade");
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboEstado.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textIBGE.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtEmailLaudoOficial.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
        this.textIBGE.clear();
        this.txtEmailLaudoOficial.clear();
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3) {
            if (this.txtCodigo.getText().trim().length() == 0) {
                Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
                this.txtCodigo.grabFocus();
                return false;
            }
            if (this.txtCodigo.getText().trim().length() > 0 && !Funcoes.isNumeric(this.txtCodigo.getText())) {
                Funcoes.mensagem(this, "Campo c\u00f3digo com valor incorreto", 1);
                this.txtCodigo.selectAll();
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo nome n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && !Funcoes.textoVazio(this.txtEmailLaudoOficial.getText()) && !this.txtEmailLaudoOficial.isConteudoValido()) {
            this.txtEmailLaudoOficial.selectAll();
            this.txtEmailLaudoOficial.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0100100000");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cid_codigo";
    }
}

