/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;

public class Cid10
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private String retornoParaPesquisa = "";

    public Cid10() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Cid10");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.txtCodigo.setUpperCase(true);
    }

    public void jbInit() throws Exception {
        this.setName("Cid10");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(200);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.setLabelDescricao("Cadastro dos c\u00f3digos de doen\u00e7a internacional");
        this.setLabelFormulario("Cadastro de CID-10");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_cid10.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.controlaCampos();
        this.painelCentral.add(this.jLabel1);
        this.painelCentral.add(this.jLabel2);
        this.painelCentral.add(this.txtCodigo);
        this.painelCentral.add(this.txtDescricao);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Cid10.this.txtCodigo.getText())) {
                    Statement st;
                    block6: {
                        st = Conexao.getStatement();
                        try {
                            ResultSet rs;
                            if (st != null && (rs = Conexao.executeQuery(st, "select c10_codigo, c10_descricao from cid10 where c10_codigo= " + Cid10.this.txtCodigo.getTextDBEscape())).next()) {
                                Cid10.this.txtDescricao.setText(rs.getString("c10_descricao"));
                                Cid10.this.txtCodigo.setEnabled(false);
                            }
                            if (st == null) break block6;
                            st.close();
                        }
                        catch (SQLException sqlex) {
                            try {
                                ErrorLogger.mostraMensagem(Cid10.this, sqlex.getMessage(), sqlex.getStackTrace(), "Cid10 (82)");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                    }
                    Conexao.fecharStatement(st);
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Cid10.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101901501"));
        this.setModuloEdita(Long.parseLong("0101901502"));
        this.setModuloApaga(Long.parseLong("0101901503"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.cid10(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("c10_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("cid10", 1);
                    salvar.setAdicionarAspasSimplesString(false);
                    salvar.adicionaCampo("c10_codigo", 0, false, true, this.txtCodigo.getTextDBEscape());
                    Conexao.execute(Variaveis.filialPadrao, statement, salvar.getComando());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Cid10 (161)");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                SalvaDados salvar = new SalvaDados("cid10", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("c10_codigo", 0, false, true, StringUtil.textoDBEscape(codigo));
                salvar.adicionaCampo("c10_descricao", 0, true, false, this.txtDescricao.getTextDBEscape());
                Conexao.execute(Variaveis.filialPadrao, statement, salvar.getComando());
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Cid10");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
    }

    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 3 && Funcoes.textoVazio(this.txtCodigo.getText())) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101901500");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cid10_codigo";
    }
}

