/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.CentroCustoBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class CentroCusto
extends FrmCadPadraoBean {
    private JLabel labelReduzido = new JLabel("Reduzido:");
    private JLabel labelPai = new JLabel("Pai:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelConta = new JLabel("Conta:");
    private TTextField textReduzido = new TTextField(5, 1);
    private TTextField textDescricao = new TTextField(100, 3);
    private TTextField textCodigoPai = new TTextField(5, 1);
    private TTextField textDescricaoPai = new TTextField();
    private TTextField textConta = new TTextField(50, 3);
    private TTextField textContaPai = new TTextField(50, 3);
    private JButton buttonBuscaPai = new JButton();
    private JLabel labelTipoOperacao = new JLabel("Tipo Opera\u00e7\u00e3o:");
    private JComboBox comboTipoOperacao = ComponenteFactory.novoJComboBox(new String[]{"Adi\u00e7\u00e3o", "Subtra\u00e7\u00e3o"});
    private String retornoParaPesquisa = "";

    public CentroCusto() {
        this.setName("CentroCusto");
        this.setLabelDescricao("Cadastro de centros de custo");
        this.setLabelFormulario("Cadastro de centros de custo");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/centro_custo.jpg"));
        Dimension d = new Dimension(60, 20);
        this.textReduzido.setPreferredSize(d);
        this.textReduzido.setName("textReduzido");
        this.textReduzido.setMinimumSize(d);
        d = new Dimension(370, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setMinimumSize(d);
        d = new Dimension(60, 20);
        this.textCodigoPai.setPreferredSize(d);
        this.textCodigoPai.setName("textCodigoPai");
        this.textCodigoPai.setMinimumSize(d);
        this.textCodigoPai.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CentroCusto.this.buscaPai(CentroCusto.this.textCodigoPai.getText());
                if (!CentroCusto.this.validaUltimoNivel()) {
                    CentroCusto.this.comboTipoOperacao.setEnabled(false);
                } else {
                    CentroCusto.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        this.comboTipoOperacao.setName("comboTipoOperacao");
        this.buttonBuscaPai.setFocusable(false);
        this.buttonBuscaPai.setName("buttonBuscaPai");
        this.buttonBuscaPai.setText("");
        d = new Dimension(20, 20);
        this.buttonBuscaPai.setPreferredSize(d);
        this.buttonBuscaPai.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonBuscaPai);
        this.buttonBuscaPai.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CentroCusto.this.buscaPai();
                if (!CentroCusto.this.validaUltimoNivel()) {
                    CentroCusto.this.comboTipoOperacao.setEnabled(false);
                } else {
                    CentroCusto.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        d = new Dimension(290, 20);
        this.textDescricaoPai.setPreferredSize(d);
        this.textDescricaoPai.setName("textDescricaoPai");
        this.textDescricaoPai.setMinimumSize(d);
        this.textDescricaoPai.setEditable(false);
        this.textDescricaoPai.setFocusable(false);
        d = new Dimension(100, 20);
        this.textConta.setPreferredSize(d);
        this.textConta.setName("textConta");
        this.textConta.setMinimumSize(d);
        this.textConta.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Funcoes.textoVazio(CentroCusto.this.textConta.getText())) {
                    CentroCusto.this.montaMascara();
                    CentroCusto.this.verificaProximaConta();
                    if (!CentroCusto.this.validaUltimoNivel()) {
                        CentroCusto.this.comboTipoOperacao.setEnabled(false);
                    } else {
                        CentroCusto.this.comboTipoOperacao.setEnabled(true);
                    }
                }
            }
        });
        d = new Dimension(60, 20);
        this.textContaPai.setPreferredSize(d);
        this.textContaPai.setName("textContaPai");
        this.textContaPai.setMinimumSize(d);
        this.textContaPai.setEditable(false);
        this.textContaPai.setFocusable(false);
        d = new Dimension(100, 20);
        this.comboTipoOperacao.setPreferredSize(d);
        this.comboTipoOperacao.setMinimumSize(d);
        this.comboTipoOperacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!CentroCusto.this.validaUltimoNivel()) {
                    CentroCusto.this.comboTipoOperacao.setEnabled(false);
                } else {
                    CentroCusto.this.comboTipoOperacao.setEnabled(true);
                }
            }
        });
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.insets = new Insets(1, 0, 1, 0);
        this.painelCentral.add((Component)this.labelReduzido, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textReduzido, c);
        this.textReduzido.setName("textReduzido");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this.painelCentral.add((Component)this.labelPai, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigoPai, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaPai, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textDescricaoPai, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelConta, c);
        ++c.gridx;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.textContaPai, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textConta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelTipoOperacao, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.comboTipoOperacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.service = new CentroCustoService();
        this.controlaCampos();
    }

    @Override
    protected void controlaCampos() {
        this.textReduzido.setEnabled(false);
        this.textDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.textCodigoPai.setEnabled(this.getStatus() == 2);
        this.textConta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipoOperacao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaPai.setEnabled(this.getStatus() == 2);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        String conta;
        CentroCustoBean bean = new CentroCustoBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3) {
            bean.setReduzido(Integer.parseInt(this.textReduzido.getText()));
        }
        if ((conta = this.textContaPai.getText()).trim().length() > 0) {
            conta = conta + ".";
        }
        conta = conta + this.textConta.getText();
        int nivel = 0;
        if (!Funcoes.textoVazio(this.textContaPai.getText())) {
            nivel += this.textContaPai.getText().split("\\.").length;
        }
        if (!Funcoes.textoVazio(this.textConta.getText())) {
            nivel += this.textConta.getText().split("\\.").length;
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setConta(conta);
        bean.setNivel(nivel);
        if (this.comboTipoOperacao.getSelectedIndex() >= 0 && this.validaUltimoNivel()) {
            bean.setOperacao(Tipos.getTipoOperacao(this.comboTipoOperacao.getSelectedItem().toString()));
        }
        if (!Funcoes.textoVazio(this.textCodigoPai.getText()) && !this.textDescricaoPai.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            bean.setPai(Integer.parseInt(this.textCodigoPai.getText()));
        }
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaCentroCusto();
    }

    @Override
    protected void limparCampos() {
        this.textReduzido.setText("");
        this.textDescricao.setText("");
        this.textCodigoPai.setText("");
        this.textDescricaoPai.setText("");
        this.textConta.setText("");
        this.textContaPai.setText("");
        this.textConta.setFormatterFactory(null);
        this.comboTipoOperacao.setSelectedIndex(-1);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando Centros de Custo", false);
            if (vo != null) {
                CentroCustoBean centroBean = (CentroCustoBean)this.service.voToBean((CentroCustoVO)vo, CentroCustoBean.class);
                return centroBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:233");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        CentroCustoBean centroBean = (CentroCustoBean)bean;
        this.textReduzido.setText(Integer.toString(centroBean.getReduzido()));
        if (centroBean.getPai() != null) {
            this.textCodigoPai.setText(centroBean.getPai().toString());
            this.buscaPai(Integer.toString(centroBean.getPai()));
        }
        this.montaMascara();
        this.textDescricao.setText(centroBean.getDescricao());
        String conta = centroBean.getConta();
        if (conta.indexOf(".") >= 0) {
            this.textContaPai.setText(conta.substring(0, conta.lastIndexOf(".")));
            this.textConta.setValue(conta.substring(conta.lastIndexOf(".") + 1, conta.length()));
        } else {
            this.textConta.setText(conta);
        }
        if (centroBean.getOperacao() != null) {
            this.comboTipoOperacao.setSelectedItem(Tipos.tipoOperacao(centroBean.getOperacao()));
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Descri\u00e7\u00e3o da conta n\u00e3o preenchida!", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.textConta.getText())) {
            Funcoes.mensagem(this, "Conta n\u00e3o definida!", 2);
            ScreenUtil.requisitarFoco(this.textConta);
            return false;
        }
        if (this.validaUltimoNivel() && this.comboTipoOperacao.getSelectedIndex() < 0) {
            Funcoes.mensagem(this, "Selecione um tipo de opera\u00e7\u00e3o para o Centro de Custo.", 2);
            if (this.comboTipoOperacao.isFocusable()) {
                this.comboTipoOperacao.grabFocus();
            }
            return false;
        }
        return !Funcoes.textoVazio(this.textDescricao.getText()) && !Funcoes.textoVazio(this.textConta.getText()) && this.validaConta();
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(CentroCusto.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600300401"));
        this.setModuloEdita(Long.parseLong("0600300402"));
        this.setModuloApaga(Long.parseLong("0600300403"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300400");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textCodigoPai);
    }

    private boolean validaConta() {
        boolean retorno = true;
        try {
            CentroCustoVO vo;
            String conta = this.textContaPai.getText().trim();
            if (!Funcoes.textoVazio(conta)) {
                conta = conta + ".";
            }
            conta = conta + this.textConta.getText().trim();
            if (!Funcoes.textoVazio(this.textReduzido.getText()) && (vo = (CentroCustoVO)this.service.getVO(this.textReduzido.getText())) != null && vo.getConta().equalsIgnoreCase(conta)) {
                return true;
            }
            if (((CentroCustoService)this.service).contaExiste(conta)) {
                Funcoes.mensagem(this, "Conta j\u00e1 cadastrada.", 2);
                ScreenUtil.requisitarFoco(this.textConta);
                return false;
            }
            if (!Funcoes.textoVazio(this.textReduzido.getText()) && ((CentroCustoService)this.service).contaExisteFilhos(this.textReduzido.getText())) {
                Funcoes.mensagem(this, "Conta possui filhos e n\u00e3o pode ser alterada.", 2);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:239");
            retorno = false;
            return retorno;
        }
    }

    @Override
    public void excluir() {
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.preencherCampos(bean);
            if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
                try {
                    String conta = Integer.toString(((CentroCustoBean)bean).getReduzido());
                    boolean retorno = ((CentroCustoService)this.service).contaExisteFilhos(conta);
                    if (retorno) {
                        Funcoes.mensagem(this, "Conta n\u00e3o pode ser excluida, po\u00eds existem contas filhas dependentes.", 2);
                        this.limparCampos();
                        return;
                    }
                    this.service.gravaAutoCopiaSemCommit(bean, 2, Variaveis.filialPadrao, this.getCopiaFiliais());
                    Conexao.arquivaSQL();
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "CentroCusto:364");
                }
            }
            this.limparCampos();
        }
    }

    private void buscaPai(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoPai.setText("");
            this.textDescricaoPai.setText("");
            return;
        }
        try {
            CentroCustoVO pai = (CentroCustoVO)((CentroCustoService)this.service).getVO(Variaveis.filialPadrao, codigo);
            this.validaPai(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:358");
        }
    }

    private void buscaPai() {
        try {
            this.textCodigoPai.setText("");
            this.textDescricaoPai.setText("");
            CentroCustoVO pai = (CentroCustoVO)((CentroCustoService)this.service).pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando centros de custo", false);
            this.validaPai(pai);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:395");
        }
    }

    private void validaPai(CentroCustoVO pai) {
        try {
            if (pai != null) {
                int sM;
                int sP = pai.getConta().split("\\.").length;
                if (sP == (sM = ParametrosGerais.getMascaraCentroCusto().split("\\.").length)) {
                    Funcoes.mensagem(this, "Conta do \u00daltimo Nivel n\u00e3o pode ser pai!", 2);
                    this.textCodigoPai.setText("");
                    this.textDescricaoPai.setText("");
                    ScreenUtil.requisitarFoco(this.textCodigoPai);
                    return;
                }
                this.textCodigoPai.setText(pai.getReduzido().toString());
                this.textDescricaoPai.setText(pai.getDescricao());
                this.textContaPai.setText(pai.getConta());
                CentroCustoBean p = (CentroCustoBean)this.service.voToBean(pai, CentroCustoBean.class);
                String mascara = ParametrosGerais.getMascaraCentroCusto();
                this.textConta.setEnabled(p.getNivel() != mascara.split("\\.").length);
            } else {
                this.textDescricaoPai.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:358");
        }
    }

    private void montaMascara() {
        this.textConta.setText("");
        this.textConta.setFormatterFactory(null);
        try {
            this.textConta.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(this.getMascaraFilho())));
        }
        catch (ParseException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:417");
        }
    }

    private void verificaProximaConta() {
        CentroCustoVO centro = null;
        String maskConta = this.getMascaraFilho();
        int nivel = this.textContaPai.getText().length() + maskConta.length();
        if (!Funcoes.textoVazio(this.textContaPai.getText())) {
            ++nivel;
        }
        try {
            centro = ((CentroCustoService)this.service).getMaiorConta(this.textContaPai.getText(), Integer.toString(nivel));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CentroCusto:461");
        }
        int proximaConta = 1;
        String conta = "";
        if (centro != null) {
            conta = centro.getConta();
            conta = conta.substring(conta.lastIndexOf(".") + 1);
            proximaConta += Integer.parseInt(conta);
        }
        conta = Funcoes.preencheZero(proximaConta, this.getMascaraFilho().length());
        this.textConta.setText(conta);
    }

    public String getMascaraFilho() {
        String mascara = ParametrosGerais.getMascaraCentroCusto();
        String[] niveis = mascara.split("\\.");
        String mask = "";
        if (Funcoes.textoVazio(this.textCodigoPai.getText())) {
            mask = niveis[0];
        } else {
            String[] niveisPai = this.textContaPai.getText().split("\\.");
            mask = niveis[niveisPai.length];
        }
        return mask;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoPai.hasFocus()) {
            this.buscaPai();
        }
    }

    private boolean validaUltimoNivel() {
        int sM;
        int sP;
        String centro = this.textContaPai.getText();
        if (!Funcoes.textoVazio(centro)) {
            centro = centro + ".";
        }
        return (sP = (centro = centro + this.textConta.getText()).split("\\.").length) == (sM = ParametrosGerais.getMascaraCentroCusto().split("\\.").length);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((CentroCustoBean)bean).getReduzido().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:86");
            }
        }
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ccu_reduzido";
    }
}

