/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CelulaEstoque
extends FrmCadPadraoBean {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private TTextField textCodigo = new TTextField(3, 3);
    private TTextField textDescricao = new TTextField(100, 3);
    private JCheckBox checkPadrao = new JCheckBox("Padr\u00e3o");
    private JCheckBox checkInativa = new JCheckBox("Inativa");
    private JCheckBox checkBaixarAutomatico = new JCheckBox("Baixar estoque automaticamente quando adicionar material");
    public static final Long ACESSO_TELA = new Long(101300500L);
    public static final Long ACESSO_INSERIR = new Long(101300501L);
    public static final Long ACESSO_EDITAR = new Long(101300502L);
    public static final Long ACESSO_APAGAR = new Long(101300503L);
    private String retornoParaPesquisa = "";

    public CelulaEstoque() {
        this.setName("CelulaEstoque");
        this.setLabelFormulario("Cadastro de c\u00e9lulas de estoque");
        this.setLabelDescricao("Cadastro de c\u00e9lulas de estoque para armazenamento de materiais");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_materiais_celula_estoque.jpg"));
        this.textCodigo.setEnabled(false);
        this.textCodigo.setName("textCodigo");
        Dimension d = new Dimension(60, 20);
        this.textCodigo.setSize(d);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setMinimumSize(d);
        this.textCodigo.setMaximumSize(d);
        d = new Dimension(300, 20);
        this.textDescricao.setSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.textDescricao.setMaximumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 0);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.painelCentral.add((Component)this.checkPadrao, c);
        this.checkPadrao.setName("checkPadrao");
        ++c.gridy;
        this.painelCentral.add((Component)this.checkInativa, c);
        this.checkInativa.setName("checkInativa");
        ++c.gridy;
        this.checkBaixarAutomatico.setToolTipText("Todas as entradas de estoque conciliadas na c\u00e9lula gerar\u00e3o uma sa\u00edda de estoque autom\u00e1tica.");
        this.painelCentral.add((Component)this.checkBaixarAutomatico, c);
        this.checkBaixarAutomatico.setName("checkBaixarAutomatico");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        this.service = new CelulaEstoqueService();
        this.controlaCampos();
        Funcoes.defineUpperCase(this.painelCentral, ParametrosGerais.getUpperCase());
    }

    @Override
    public void excluir() {
        final CelulaEstoqueBean beanDelete = (CelulaEstoqueBean)this.pesquisar();
        if (beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CelulaEstoque.this.preencherCampos(beanDelete);
                    if (Funcoes.mensagem(CelulaEstoque.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            if (!((CelulaEstoqueService)CelulaEstoque.this.service).verificaOutraCelulaPadrao(beanDelete)) {
                                int resposta = JOptionPane.showOptionDialog(CelulaEstoque.this, "N\u00e3o h\u00e1 uma c\u00e9lula de estoque padr\u00e3o.\nDeseja cancelar a exclus\u00e3o ou escolher outra c\u00e9lula de estoque?", "C\u00e9lula padr\u00e3o", 0, 2, null, new String[]{"Cancelar exclus\u00e3o", "Escolher outra c\u00e9lula"}, "Cancelar exclus\u00e3o");
                                if (resposta == 0) {
                                    CelulaEstoque.this.limparCampos();
                                    return;
                                }
                                AbstractThreadVO vo = CelulaEstoque.this.service.pesquisaVO(CelulaEstoque.this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Escolha a nova c\u00e9lula padr\u00e3o", true);
                                CelulaEstoqueBean bean = null;
                                if (vo != null) {
                                    try {
                                        bean = (CelulaEstoqueBean)CelulaEstoque.this.service.voToBean((CelulaEstoqueVO)vo, CelulaEstoqueBean.class);
                                        if (bean != null) {
                                            bean.setPadrao(true);
                                            CelulaEstoque.this.service.update(bean, null, bean.getFilial().getCodigo().toString(), null);
                                        }
                                    }
                                    catch (Exception e) {
                                        ErrorLogger.mostraMensagem(CelulaEstoque.this, "N\u00e3o foi poss\u00edvel configurar a c\u00e9lula padr\u00e3o.", e.getStackTrace(), "CelulaEstoque:122");
                                    }
                                } else {
                                    Funcoes.mensagem(CelulaEstoque.this, "Nenhuma c\u00e9lula foi selecionada.\nA exclus\u00e3o ser\u00e1 cancelada.", 2);
                                    CelulaEstoque.this.limparCampos();
                                    return;
                                }
                            }
                            CelulaEstoque.this.service.gravaAutoCopiaSemCommit(beanDelete, 2, Variaveis.filialPadrao, CelulaEstoque.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(CelulaEstoque.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "CelulaEstoque: 136");
                        }
                    }
                    CelulaEstoque.this.limparCampos();
                }
            });
        }
    }

    @Override
    protected void controlaCampos() {
        boolean ativar = this.getStatus() == 3 || this.getStatus() == 2;
        this.textDescricao.setEnabled(ativar);
        this.checkPadrao.setEnabled(ativar);
        this.checkInativa.setEnabled(ativar);
        this.checkBaixarAutomatico.setEnabled(ativar);
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        CelulaEstoqueBean bean = new CelulaEstoqueBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        if (this.getStatus() == 3 && Funcoes.isNumeric(this.textCodigo.getText())) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setFilial(filial);
        bean.setDescricao(this.textDescricao.getText());
        bean.setPadrao(this.checkPadrao.isSelected());
        bean.setInativa(this.checkInativa.isSelected());
        bean.setBaixarAutomatico(this.checkBaixarAutomatico.isSelected());
        return bean;
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaCelulaEstoque();
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.setText("");
        this.textDescricao.setText("");
        this.checkPadrao.setSelected(false);
        this.checkInativa.setSelected(false);
        this.checkBaixarAutomatico.setSelected(false);
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Pesquisando c\u00e9lulas", false);
            if (vo != null) {
                CelulaEstoqueBean CelulaEstoqueBean2 = (CelulaEstoqueBean)this.service.voToBean((CelulaEstoqueVO)vo, CelulaEstoqueBean.class);
                return CelulaEstoqueBean2;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CelulaEstoque:187");
        }
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        CelulaEstoqueBean celulaBean = (CelulaEstoqueBean)bean;
        this.textCodigo.setText(String.valueOf(celulaBean.getCodigo()));
        this.textDescricao.setText(celulaBean.getDescricao());
        this.checkPadrao.setSelected(celulaBean.getPadrao() != null && celulaBean.getPadrao() != false);
        this.checkInativa.setSelected(celulaBean.getInativa() != null && celulaBean.getInativa() != false);
        this.checkBaixarAutomatico.setSelected(celulaBean.getBaixarAutomatico() != null && celulaBean.getBaixarAutomatico() != false);
        this.textCodigo.setEnabled(false);
    }

    @Override
    public boolean validaCampos() {
        boolean haCelulaPadrao = false;
        if (Funcoes.textoVazio(this.textDescricao.getText())) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o preenchido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        try {
            haCelulaPadrao = ((CelulaEstoqueService)this.service).verificaOutraCelulaPadrao((CelulaEstoqueBean)this.getBeanPreenchido());
        }
        catch (ThreadDaoException tde) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel verificar se h\u00e1 outra c\u00e9lula marcada como padr\u00e3o.", 2);
            return false;
        }
        if (this.checkPadrao.isSelected() && haCelulaPadrao) {
            int resposta = Funcoes.mensagem(this, "Outra c\u00e9lula j\u00e1 est\u00e1 definida como padr\u00e3o.\nDeseja que a c\u00e9lula corrente seja a nova c\u00e9lula padr\u00e3o?", 4, true);
            if (resposta == 1) {
                this.checkPadrao.setSelected(false);
            }
        } else if (!(!this.checkInativa.isSelected() && this.checkPadrao.isSelected() || haCelulaPadrao)) {
            int resposta = JOptionPane.showOptionDialog(this, "N\u00e3o h\u00e1 c\u00e9lula padr\u00e3o.\nDeseja manter essa c\u00e9lula como padr\u00e3o ou escolher outra c\u00e9lula?", "C\u00e9lula padr\u00e3o", 0, 2, null, new String[]{"Manter", "Escolher outra c\u00e9lula"}, "Manter");
            if (resposta == 0) {
                this.checkPadrao.setSelected(true);
            } else {
                AbstractThreadVO vo = this.service.pesquisaVO(this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Escolha a nova c\u00e9lula padr\u00e3o", true);
                CelulaEstoqueBean bean = null;
                if (vo != null) {
                    try {
                        bean = (CelulaEstoqueBean)this.service.voToBean((CelulaEstoqueVO)vo, CelulaEstoqueBean.class);
                        if (bean != null) {
                            bean.setPadrao(true);
                            this.service.update(bean, null, bean.getFilial().getCodigo().toString(), null);
                        }
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel configurar a c\u00e9lula padr\u00e3o.", e.getStackTrace(), "CelulaEstoque:233");
                    }
                } else {
                    Funcoes.mensagem(this, "Nenhuma c\u00e9lula foi selecionada.\nA c\u00e9lula corrente ser\u00e1 marcada como padr\u00e3o novamente.", 2);
                    this.checkPadrao.setSelected(true);
                }
            }
        }
        return true;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(CelulaEstoque.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0101300501"));
        this.setModuloEdita(Long.parseLong("0101300502"));
        this.setModuloApaga(Long.parseLong("0101300503"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0101300500");
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void salvar() {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                new CelulaEstoqueService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = ((CelulaEstoqueBean)bean).getCodigo().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel salvar a c\u00e9lula de estoque.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cel_codigo";
    }
}

