/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CategoriaProduto
extends FrmCadPadrao {
    private TTextField txtCodigo = ComponenteFactory.novoTTextField(20, 1);
    private TTextField txtDescricao = ComponenteFactory.novoTTextField(80, 3);
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private String retornoParaPesquisa = "";

    public CategoriaProduto() {
        try {
            this.setModuloAcesso(CategoriaProduto.getModuloAcesso());
            this.setModuloEdita(Long.parseLong("0105300101"));
            this.setModuloApaga(Long.parseLong("0105300102"));
            this.setModuloInsere(Long.parseLong("0105300103"));
            this.jbInit();
            this.controlaCampos();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Taxa");
        }
    }

    private void jbInit() {
        this.painelCentral.setLayout(new BorderLayout());
        this.setLabelDescricao("Cadastro de categorias de produto");
        this.setLabelFormulario("Cadastro de categorias de produto");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_categoriaproduto.jpg"));
        GridBagConstraints cons = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        cons.fill = 0;
        cons.anchor = 18;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(0, 1, 0, 1);
        panel.add((Component)this.labelCodigo, cons);
        ++cons.gridx;
        this.txtCodigo.setPreferredSize(new Dimension(70, 20));
        this.txtCodigo.setMinimumSize(new Dimension(70, 20));
        this.txtCodigo.setEnabled(false);
        panel.add((Component)this.txtCodigo, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.labelDescricao, cons);
        ++cons.gridx;
        this.txtDescricao.setPreferredSize(new Dimension(400, 20));
        this.txtDescricao.setMinimumSize(new Dimension(400, 20));
        cons.fill = 0;
        cons.weightx = 1.0;
        panel.add((Component)this.txtDescricao, cons);
        this.painelCentral.add((Component)panel, "North");
    }

    protected void controlaCampos() {
        this.txtDescricao.setEnabled(this.habilitaDesabilitaCampo());
    }

    protected void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            Statement statement = Conexao.getStatementTratandoShutdown();
            try {
                String codigo = this.getStatus() == 2 ? DBUtil.getSequencia(statement, "categoriaprodutoalimentos", true) : this.txtCodigo.getText();
                StringBuilder buff = new StringBuilder();
                SalvaDados salvar = new SalvaDados("categoriaprodutoalimentos", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("cpl_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("cpl_descricao", 0, false, false, this.txtDescricao.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaCategoriaProdutoAlimentos(), "categoriaprodutoalimentos", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar dados.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtDescricao.getText())) {
            Funcoes.mensagem(this, "Informe a descri\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.txtDescricao);
            return false;
        }
        return true;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cpl_codigo";
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0105300100");
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("categoriaprodutoalimentos", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("cpl_codigo", 2, false, true, this.txtCodigo.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", Variaveis.filialPadrao);
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Categoria de Produto");
            }
        }
        this.limparCampos();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.categoriaDeProduto(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("cpl_codigo").toString());
            this.txtDescricao.setText(resultado.get("cpl_descricao").toString());
            this.txtDescricao.setHorizontalAlignment(2);
            this.txtDescricao.updateUI();
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }
}

