/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;

class CalcularIntervalo
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static final String TITULO = "Calcular intervalo";
    private final JLabel labelInicial = new JLabel();
    private final JLabel labelFinal = new JLabel();
    private final JLabel labelVlrInicial = new JLabel();
    private final JLabel labelVlrFinal = new JLabel();
    private final JLabel labelQuantidade = new JLabel("Quantidade:");
    private final TTextField textQuantidade = new TTextField(3, 1);
    private String horaInicial = null;
    private String horaFinal = null;

    public CalcularIntervalo(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public CalcularIntervalo(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public static CalcularIntervalo novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new CalcularIntervalo((Frame)pai, TITULO);
        }
        if (pai instanceof Dialog) {
            return new CalcularIntervalo((Dialog)pai, TITULO);
        }
        return null;
    }

    public Point getQuantidadeIntervalos() {
        if (!Funcoes.textoVazio(this.horaInicial) && !Funcoes.textoVazio(this.horaFinal) && Funcoes.isNumeric(this.textQuantidade.getText())) {
            Calendar iniAux = Calendar.getInstance();
            iniAux.set(10, Integer.parseInt(this.horaInicial.substring(0, this.horaInicial.indexOf(":"))));
            iniAux.set(12, Integer.parseInt(this.horaInicial.substring(this.horaInicial.indexOf(":") + 1)));
            Calendar finAux = Calendar.getInstance();
            finAux.set(10, Integer.parseInt(this.horaFinal.substring(0, this.horaInicial.indexOf(":"))));
            finAux.set(12, Integer.parseInt(this.horaFinal.substring(this.horaInicial.indexOf(":") + 1)));
            int valor = Funcoes.minutesBetween(iniAux.getTime(), finAux.getTime());
            int qtde = valor / Integer.parseInt(this.textQuantidade.getText());
            int resto = valor % Integer.parseInt(this.textQuantidade.getText());
            return new Point(qtde, resto);
        }
        return null;
    }

    private void montaTela(Container pai) {
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelCentro.add((Component)this.labelInicial, c);
        ++c.gridx;
        c.weightx = 1.0;
        panelCentro.add((Component)this.labelVlrInicial, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        panelCentro.add((Component)this.labelFinal, c);
        ++c.gridx;
        panelCentro.add((Component)this.labelVlrFinal, c);
        ++c.gridy;
        c.gridx = 0;
        this.textQuantidade.setPreferredSize(new Dimension(30, 20));
        this.textQuantidade.setMinimumSize(new Dimension(30, 20));
        panelCentro.add((Component)this.labelQuantidade, c);
        ++c.gridx;
        panelCentro.add((Component)this.textQuantidade, c);
        this.setModal(true);
        this.setSize(new Dimension(230, 125));
        this.setResizable(false);
        this.setLocationRelativeTo(pai);
        ScreenUtil.requisitarFoco(this.textQuantidade);
    }

    public void setHoraInicial(String horaInicial) {
        this.horaInicial = horaInicial;
        this.labelInicial.setText("Hor\u00e1rio inicial:");
        this.labelVlrInicial.setText("<html><font color=RED>" + horaInicial + "</font></html>");
    }

    public void setHoraFinal(String horaFinal) {
        this.horaFinal = horaFinal;
        this.labelFinal.setText("Hor\u00e1rio final:");
        this.labelVlrFinal.setText("<html><font color=RED>" + horaFinal + "</font></html>");
    }

    public int getIntervalo() {
        return 1;
    }
}

