/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.model.vo.cadastro.auxiliares.CategoriaProdutoVO;
import jalis.service.cadastro.auxiliares.CategoriaProdutoService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CadastroProdutos
extends FrmCadPadrao
implements ActionListener {
    private TTextField txtCodigo = ComponenteFactory.novoTTextField(20, 1);
    private TTextField txtDescricao = ComponenteFactory.novoTTextField(80, 3);
    private TTextField txtCodCategoria = ComponenteFactory.novoTTextField(5, 1);
    private TTextField txtDescCategoria = ComponenteFactory.novoTTextField(80, 3);
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelCategoria = new JLabel("Categoria: ");
    private JButton buttonBuscaCategoria = ComponenteFactory.novoJButton(this, true);
    private String retornoParaPesquisa = "";
    private CategoriaProdutoService categoriaService = new CategoriaProdutoService();

    public CadastroProdutos() {
        try {
            this.setModuloAcesso(CadastroProdutos.getModuloAcesso());
            this.setModuloEdita(Long.parseLong("0105400101"));
            this.setModuloApaga(Long.parseLong("0105400102"));
            this.setModuloInsere(Long.parseLong("0105400103"));
            this.jbInit();
            this.controlaCampos();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Taxa");
        }
    }

    private void jbInit() {
        this.painelCentral.setLayout(new BorderLayout());
        this.setLabelDescricao("Cadastro de produtos");
        this.setLabelFormulario("Cadastro de produtos");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/cad_motivo_cancel_on.jpg"));
        GridBagConstraints cons = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        cons.fill = 0;
        cons.anchor = 17;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(0, 1, 0, 0);
        panel.add((Component)this.labelCodigo, cons);
        ++cons.gridx;
        this.txtCodigo.setPreferredSize(new Dimension(70, 20));
        this.txtCodigo.setMinimumSize(new Dimension(70, 20));
        this.txtCodigo.setEnabled(false);
        panel.add((Component)this.txtCodigo, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panel.add((Component)this.labelDescricao, cons);
        ++cons.gridx;
        cons.gridwidth = 3;
        cons.weightx = 3.0;
        this.txtDescricao.setPreferredSize(new Dimension(400, 20));
        this.txtDescricao.setMinimumSize(new Dimension(400, 20));
        panel.add((Component)this.txtDescricao, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        panel.add((Component)this.labelCategoria, cons);
        ++cons.gridx;
        this.txtCodCategoria.setPreferredSize(new Dimension(70, 20));
        this.txtCodCategoria.setMinimumSize(new Dimension(70, 20));
        this.txtCodCategoria.setMaximumSize(new Dimension(70, 20));
        panel.add((Component)this.txtCodCategoria, cons);
        ++cons.gridx;
        this.buttonBuscaCategoria.setFocusable(false);
        this.buttonBuscaCategoria.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaCategoria.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCategoria.setMaximumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonBuscaCategoria, cons);
        ++cons.gridx;
        this.txtDescCategoria.setEditable(false);
        this.txtDescCategoria.setFocusable(false);
        this.txtDescCategoria.setPreferredSize(new Dimension(308, 20));
        this.txtDescCategoria.setMinimumSize(new Dimension(308, 20));
        this.txtDescCategoria.setMaximumSize(new Dimension(308, 20));
        panel.add((Component)this.txtDescCategoria, cons);
        this.painelCentral.add((Component)panel, "North");
        this.txtCodCategoria.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    CadastroProdutos.this.buscaDadosCategoria();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(CadastroProdutos.this, e1.getMessage(), e1.getStackTrace(), "Cadastro de Produto (229)");
                }
            }
        });
    }

    protected void controlaCampos() {
        this.txtDescricao.setEnabled(this.habilitaDesabilitaCampo());
        this.txtCodCategoria.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonBuscaCategoria.setEnabled(this.habilitaDesabilitaCampo());
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.produto(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("pal_codigo").toString());
            this.txtDescricao.setText(resultado.get("pal_descricao").toString());
            this.txtCodCategoria.setText(resultado.get("cpl_codigo").toString());
            this.txtDescCategoria.setText(resultado.get("cpl_descricao").toString());
            this.txtDescCategoria.setHorizontalAlignment(2);
            this.txtDescCategoria.updateUI();
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    protected void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
        this.txtCodCategoria.clear();
        this.txtDescCategoria.clear();
    }

    @Override
    public void salvar() {
        if (this.validaCampos()) {
            Statement statement = Conexao.getStatementTratandoShutdown();
            try {
                String codigo = this.getStatus() == 2 ? DBUtil.getSequencia(statement, "produtoalimentos", true) : this.txtCodigo.getText();
                StringBuilder buff = new StringBuilder();
                SalvaDados salvar = new SalvaDados("produtoalimentos", this.getStatus() == 2 ? 0 : 2);
                salvar.setAdicionarAspasSimplesString(false);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("cpl_codigo", 2, false, true, this.txtCodCategoria.getText());
                salvar.adicionaCampo("pal_codigo", 2, false, true, codigo);
                salvar.adicionaCampo("pal_descricao", 0, false, false, this.txtDescricao.getTextDBEscape());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaProdutoAlimentos(), "produtoalimentos", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar dados.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0105400100");
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("produtoalimentos", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("pal_codigo", 2, false, true, this.txtCodigo.getText());
                    salvar.adicionaCampo("cpl_codigo", 2, false, true, this.txtCodCategoria.getText());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", Variaveis.filialPadrao);
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), ex.getMessage(), ex.getStackTrace(), "Cadastro de Produto");
            }
        }
        this.limparCampos();
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtDescricao.grabFocus();
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtDescricao.getText())) {
            Funcoes.mensagem(this, "Informe a descri\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.txtDescricao);
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodCategoria.getText()) || this.txtDescCategoria.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Categoria Inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.txtCodCategoria);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "pal_codigo";
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodCategoria.hasFocus()) {
            this.buscaCategoria();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaCategoria) {
            this.buscaCategoria();
        }
    }

    private void buscaCategoria() {
        CategoriaProdutoVO categoria = new CategoriaProdutoVO();
        categoria = (CategoriaProdutoVO)this.categoriaService.pesquisaVO(this.getTopLevelAncestor(), categoria, "Pesquisando Categorias de Produtos", true);
        if (categoria != null) {
            this.txtCodCategoria.setText(String.valueOf(categoria.getCodigo()));
            this.txtDescCategoria.setText(categoria.getDescricao());
        }
    }

    private void buscaDadosCategoria() throws Exception {
        if (!Funcoes.textoVazio(this.txtCodCategoria.getText())) {
            CategoriaProdutoVO categoriaVO = (CategoriaProdutoVO)this.categoriaService.getVO(this.txtCodCategoria.getText());
            if (categoriaVO != null) {
                this.txtCodCategoria.setText(String.valueOf(categoriaVO.getCodigo()));
                this.txtDescCategoria.setText(categoriaVO.getDescricao());
            } else {
                this.txtDescCategoria.setText("N\u00e3o cadastrado");
            }
        }
    }
}

