/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Convenio;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

class BloqueioFiliais
extends JDialog
implements ActionListener {
    private static final String DESCRICAO_TELA = "Bloqueio de filiais";
    private JButton buttonFechar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonOk = ComponenteFactory.novoJButton("OK", 'O', this);
    private JLabel jLabelFilial = new JLabel("Filial:");
    private JLabel jLabelFilialDescricao = new JLabel();
    private JButton buttonPesquisaFilial = ComponenteFactory.novoJButton(this, true);
    private TTextField textFieldCodigoFilial = ComponenteFactory.novoTTextField(10, 1);
    private JButton buttonAddFilial = ComponenteFactory.novoJButton("OK", 'O', this);
    private ModeloGridTable modeloFilial = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    private JTable tableFilial = new JTable(this.modeloFilial);
    private JScrollPane scrollFilial = new JScrollPane(this.tableFilial);
    private FilialService filialService = new FilialService();
    private FilialVO filialVO = new FilialVO();
    private boolean confirmouBloqueioFilial = false;
    private String filialParaBloqueio = "";
    private ConvenioVO convenioVO;
    private Set<FilialVO> filialVOsTemp = new HashSet<FilialVO>();
    private Convenio telaconvenio;

    public BloqueioFiliais() {
    }

    public BloqueioFiliais(Frame pai) {
        super(pai, DESCRICAO_TELA, true);
        this.iniciar();
    }

    public BloqueioFiliais(Dialog pai) {
        super(pai, DESCRICAO_TELA, true);
        this.iniciar();
    }

    public void setConvenioVO(ConvenioVO convenioVO) {
        this.convenioVO = convenioVO;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            this.confirmouBloqueioFilial = true;
            this.filialVOsTemp.clear();
            for (int linha = 0; linha < this.modeloFilial.getRowCount(); ++linha) {
                FilialVO vo = (FilialVO)this.modeloFilial.getValueAt(linha, 2);
                this.filialVOsTemp.add(vo);
            }
            this.telaconvenio.gettextFieldFilialBloqueada().clear();
            this.telaconvenio.gettextFieldFilialBloqueada().setText(this.getFilialParaBloqueio());
            this.dispose();
        } else if (e.getSource() == this.buttonFechar) {
            this.confirmouBloqueioFilial = false;
            this.filialVOsTemp.clear();
            this.modeloFilial.clear();
            this.telaconvenio.gettextFieldFilialBloqueada().clear();
            this.telaconvenio.gettextFieldFilialBloqueada().setText(this.convenioVO.getFiliaisProibidas());
            this.dispose();
        } else if (e.getSource() == this.buttonAddFilial) {
            this.addFilialAoModelo();
        } else if (e.getSource() == this.buttonPesquisaFilial) {
            this.pesquisarFilial();
        }
    }

    private void addFilialAoModelo() {
        if (this.filialVO != null && this.filialVO.getCodigo() != null) {
            for (int linha = 0; linha < this.modeloFilial.getRowCount(); ++linha) {
                FilialVO vo = (FilialVO)this.modeloFilial.getValueAt(linha, 2);
                if (!vo.getCodigo().equals(this.filialVO.getCodigo())) continue;
                Funcoes.mensagem(this, "Filial j\u00e1 foi adicionada", 2);
                return;
            }
            this.addLinhaFilial(this.filialVO);
            this.textFieldCodigoFilial.setText("");
            this.jLabelFilialDescricao.setText("");
            this.filialVO = null;
            ScreenUtil.requisitarFoco(this.textFieldCodigoFilial);
        } else {
            this.textFieldCodigoFilial.setText("");
            this.jLabelFilialDescricao.setText("");
            ScreenUtil.requisitarFoco(this.textFieldCodigoFilial);
        }
    }

    private void addLinhaFilial(FilialVO filialVO) {
        for (int linha = 0; linha < this.modeloFilial.getRowCount(); ++linha) {
            FilialVO vo = (FilialVO)this.modeloFilial.getValueAt(linha, 2);
            if (!vo.getCodigo().equals(filialVO.getCodigo())) continue;
            return;
        }
        this.modeloFilial.addLine(new Object[]{filialVO.getCodigo(), filialVO.getDescricao(), filialVO});
    }

    public boolean isConfirmouBloqueioFilial() {
        return this.confirmouBloqueioFilial;
    }

    private void iniciar() {
        JPanel panelPrincipal = new JPanel(new GridBagLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.setPreferredSize(new Dimension(510, 218));
        ScreenUtil.setBorda(new JComponent[]{this.jLabelFilialDescricao}, new TitledBorder(""));
        this.modeloFilial.setColumnSize(new int[]{80, 0}, this.tableFilial);
        GridBagConstraints bagConstraintsTela = new GridBagConstraints();
        bagConstraintsTela.insets = new Insets(1, 0, 0, 1);
        bagConstraintsTela.gridy = 0;
        bagConstraintsTela.gridx = 0;
        bagConstraintsTela.weightx = 1.0;
        bagConstraintsTela.weighty = 1.0;
        bagConstraintsTela.fill = 1;
        bagConstraintsTela.anchor = 17;
        GridBagConstraints bagConstraintsComponentes = new GridBagConstraints();
        bagConstraintsComponentes.insets = new Insets(1, 0, 0, 1);
        bagConstraintsComponentes.gridy = 0;
        bagConstraintsComponentes.gridx = 0;
        bagConstraintsComponentes.weightx = 0.0;
        bagConstraintsComponentes.weighty = 0.0;
        bagConstraintsComponentes.fill = 13;
        bagConstraintsComponentes.anchor = 13;
        panelPrincipal.add((Component)this.jLabelFilial, bagConstraintsComponentes);
        ++bagConstraintsComponentes.gridx;
        this.textFieldCodigoFilial.setPreferredSize(new Dimension(80, 20));
        this.textFieldCodigoFilial.setMinimumSize(new Dimension(80, 20));
        panelPrincipal.add((Component)this.textFieldCodigoFilial, bagConstraintsComponentes);
        ++bagConstraintsComponentes.gridx;
        bagConstraintsComponentes.insets = new Insets(1, 0, 0, 0);
        this.buttonPesquisaFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisaFilial.setMinimumSize(new Dimension(20, 20));
        panelPrincipal.add((Component)this.buttonPesquisaFilial, bagConstraintsComponentes);
        bagConstraintsComponentes.insets = new Insets(1, 0, 0, 1);
        ++bagConstraintsComponentes.gridx;
        this.jLabelFilialDescricao.setPreferredSize(new Dimension(322, 20));
        this.jLabelFilialDescricao.setMinimumSize(new Dimension(322, 20));
        panelPrincipal.add((Component)this.jLabelFilialDescricao, bagConstraintsComponentes);
        bagConstraintsComponentes.fill = 13;
        ++bagConstraintsComponentes.gridx;
        this.buttonAddFilial.setPreferredSize(new Dimension(55, 20));
        this.buttonAddFilial.setMinimumSize(new Dimension(55, 20));
        panelPrincipal.add((Component)this.buttonAddFilial, bagConstraintsComponentes);
        bagConstraintsComponentes.gridx = 0;
        ++bagConstraintsComponentes.gridy;
        bagConstraintsComponentes.gridwidth = 5;
        bagConstraintsComponentes.fill = 1;
        this.scrollFilial.setPreferredSize(new Dimension(40, 120));
        this.scrollFilial.setMinimumSize(new Dimension(40, 120));
        panelPrincipal.add((Component)this.scrollFilial, bagConstraintsComponentes);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.buttonOk);
        jPanel.add(this.buttonFechar);
        bagConstraintsTela.gridy = 2;
        bagConstraintsTela.gridx = 0;
        bagConstraintsTela.gridwidth = 5;
        panelPrincipal.add((Component)jPanel, bagConstraintsTela);
        this.textFieldCodigoFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    BloqueioFiliais.this.pesquisarFilial();
                }
            }
        });
        this.textFieldCodigoFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    BloqueioFiliais.this.jLabelFilialDescricao.setText("");
                    if (!Funcoes.textoVazio(BloqueioFiliais.this.textFieldCodigoFilial.getText())) {
                        BloqueioFiliais.this.filialVO = (FilialVO)BloqueioFiliais.this.filialService.getVO(BloqueioFiliais.this.textFieldCodigoFilial.getText());
                        if (BloqueioFiliais.this.filialVO != null) {
                            BloqueioFiliais.this.textFieldCodigoFilial.setText(BloqueioFiliais.this.filialVO.getCodigo().toString());
                            BloqueioFiliais.this.jLabelFilialDescricao.setText(BloqueioFiliais.this.filialVO.getDescricao());
                        } else {
                            BloqueioFiliais.this.jLabelFilialDescricao.setText("N\u00e3o cadastrado");
                            BloqueioFiliais.this.textFieldCodigoFilial.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(BloqueioFiliais.this, "N\u00e3o foi poss\u00edvel consultar filial.", 1);
                }
            }
        });
        this.tableFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(BloqueioFiliais.this, "Deseja remover a filial da composi\u00e7\u00e3o ?", 4)) == 0) {
                    BloqueioFiliais.this.modeloFilial.removeLine(row);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        Funcoes.montaEnter((JComponent)panelPrincipal);
        ScreenUtil.centralizar(this);
    }

    public Set<FilialVO> getFilialVOsTemp() {
        return this.filialVOsTemp;
    }

    public void montarTabelaComDados() {
        this.modeloFilial.clear();
        if (this.convenioVO != null && !Funcoes.textoVazio(this.convenioVO.getFiliaisProibidas())) {
            try {
                Set filialVOs = new HashSet();
                if (!Funcoes.textoVazio(this.convenioVO.getFiliaisProibidas())) {
                    StringBuilder whereSql = new StringBuilder();
                    whereSql.append(" where fil_codigo in ( ").append(this.convenioVO.getFiliaisProibidas()).append(")");
                    filialVOs = this.filialService.loadVO(whereSql.toString());
                    if (this.filialVOsTemp.isEmpty() && !this.confirmouBloqueioFilial) {
                        this.filialVOsTemp.addAll(filialVOs);
                    }
                }
                for (FilialVO filialVO : this.filialVOsTemp) {
                    this.addLinhaFilial(filialVO);
                }
            }
            catch (Exception e) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel preencher tabela de filiais proibidas.", 1);
            }
        } else {
            for (FilialVO filialVO : this.filialVOsTemp) {
                this.addLinhaFilial(filialVO);
            }
        }
        this.textFieldCodigoFilial.setText("");
        this.jLabelFilialDescricao.setText("");
    }

    public String getFilialParaBloqueio() {
        this.filialParaBloqueio = "";
        int total = this.modeloFilial.getRowCount();
        for (int linha = 0; linha < total; ++linha) {
            FilialVO filialVO = (FilialVO)this.modeloFilial.getValueAt(linha, 2);
            this.filialParaBloqueio = this.filialParaBloqueio + filialVO.getCodigo().toString();
            if (linha >= total - 1) continue;
            this.filialParaBloqueio = this.filialParaBloqueio + ", ";
        }
        return this.filialParaBloqueio;
    }

    private void pesquisarFilial() {
        this.filialVO = (FilialVO)this.filialService.pesquisaVO(Laboratorio.getInstancia(), new FilialVO(), "Buscando filiais", true);
        if (this.filialVO != null) {
            this.textFieldCodigoFilial.setText(this.filialVO.getCodigo().toString());
            this.jLabelFilialDescricao.setText(this.filialVO.getDescricao());
            ScreenUtil.requisitarFoco(this.textFieldCodigoFilial);
        }
    }

    public BloqueioFiliais novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new BloqueioFiliais((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new BloqueioFiliais((Dialog)pai);
        }
        return null;
    }

    public void limparVariaveis() {
        this.confirmouBloqueioFilial = false;
        this.filialVOsTemp.clear();
    }

    public void setTelaconvenio(Convenio telaconvenio) {
        this.telaconvenio = telaconvenio;
    }
}

