/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.triagem.BanhoMariaBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.model.vo.cadastro.triagem.BanhoMariaVO;
import jalis.service.cadastro.exame.SetorService;
import jalis.service.cadastro.triagem.BanhoMariaService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class BanhoMaria
extends FrmCadPadraoBean
implements ActionListener {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelSetor = new JLabel("Setor:");
    private JLabel labelUsuario = new JLabel("Respons\u00e1vel:");
    private JLabel labelVlrSetor = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private TTextField textCodigo = new TTextField(12, 1);
    private TTextField textDescricao = new TTextField(80, 3);
    private TTextField textSetor = new TTextField(12, 1);
    private TTextField textUsuario = new TTextField(20, 3);
    private JCheckBox checkInativo = new JCheckBox("Inativo");
    private JButton buttonSetor = new JButton();
    private JButton buttonUsuario = new JButton();
    private JPanel panelEquipamento = new JPanel(new GridBagLayout());
    private String retornoParaPesquisa = "";
    UsuarioVO usuarioAux = null;
    SetorVO setorAux = null;

    public BanhoMaria() {
        this.montaTela();
        this.service = new BanhoMariaService();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setName("BanhoMaria");
        this.setLabelFormulario("Cadastro de Banho-Maria");
        this.setLabelDescricao("Cadastro de banho-maria");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/banho-maria.jpg"));
        Dimension d = new Dimension(75, 20);
        this.textCodigo.setPreferredSize(d);
        this.textCodigo.setName("textCodigo");
        this.textCodigo.setMinimumSize(d);
        this.textSetor.setPreferredSize(d);
        this.textSetor.setName("textSetor");
        this.textSetor.setMinimumSize(d);
        this.textUsuario.setPreferredSize(d);
        this.textUsuario.setName("textUsuario");
        this.textUsuario.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setName("textDescricao");
        this.textDescricao.setMinimumSize(d);
        this.labelVlrSetor.setPreferredSize(d);
        this.labelVlrSetor.setMinimumSize(d);
        this.labelVlrUsuario.setPreferredSize(d);
        this.labelVlrUsuario.setMinimumSize(d);
        this.buttonSetor.setFocusable(false);
        this.buttonSetor.setName("buttonSetor");
        this.buttonSetor.setPreferredSize(d);
        this.buttonSetor.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonSetor);
        this.buttonUsuario.setFocusable(false);
        this.buttonUsuario.setName("buttonUsuario");
        this.buttonUsuario.setPreferredSize(d);
        this.buttonUsuario.setMinimumSize(d);
        Funcoes.imagemPesquisa(this.buttonUsuario);
        ScreenUtil.setBorda(new Component[]{this.labelVlrSetor, this.labelVlrUsuario}, new TitledBorder(""));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelDescricao.setDisplayedMnemonic('r');
        this.labelDescricao.setLabelFor(this.textDescricao);
        this.painelCentral.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.textDescricao, c);
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        this.checkInativo.setMnemonic('I');
        this.painelCentral.add((Component)this.checkInativo, c);
        this.checkInativo.setName("checkInativo");
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.panelEquipamento, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelCentral.add((Component)new JPanel(), c);
        this.panelEquipamento.setBorder(new TitledBorder("Informa\u00e7\u00f5es do Equipamento"));
        c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelSetor.setDisplayedMnemonic('t');
        this.labelSetor.setLabelFor(this.textSetor);
        this.panelEquipamento.add((Component)this.labelSetor, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        this.panelEquipamento.add((Component)this.textSetor, c);
        ++c.gridx;
        this.panelEquipamento.add((Component)this.buttonSetor, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.fill = 2;
        this.panelEquipamento.add((Component)this.labelVlrSetor, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelUsuario.setDisplayedMnemonic('p');
        this.labelUsuario.setLabelFor(this.textUsuario);
        this.panelEquipamento.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        this.panelEquipamento.add((Component)this.textUsuario, c);
        ++c.gridx;
        this.panelEquipamento.add((Component)this.buttonUsuario, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.fill = 2;
        this.panelEquipamento.add((Component)this.labelVlrUsuario, c);
        this.buttonSetor.addActionListener(this);
        this.buttonUsuario.addActionListener(this);
        this.textSetor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    BanhoMaria.this.buttonSetor.doClick();
                }
            }
        });
        this.textUsuario.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    BanhoMaria.this.buttonUsuario.doClick();
                }
            }
        });
        this.textSetor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (BanhoMaria.this.setorAux == null || BanhoMaria.this.setorAux.getCodigo() != Integer.parseInt(Funcoes.textoVazio(BanhoMaria.this.textSetor) ? "0" : BanhoMaria.this.textSetor.getText())) {
                    BanhoMaria.this.buscaSetor(BanhoMaria.this.textSetor.getText());
                }
            }
        });
        this.textUsuario.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (BanhoMaria.this.usuarioAux == null || !BanhoMaria.this.usuarioAux.getCodigo().equalsIgnoreCase(Funcoes.textoVazio(BanhoMaria.this.textUsuario) ? "0" : BanhoMaria.this.textUsuario.getText())) {
                    BanhoMaria.this.buscaUsuario(BanhoMaria.this.textUsuario.getText());
                }
            }
        });
        Funcoes.montaEnter((JComponent)this.painelCentral);
        Funcoes.defineUpperCase(this.painelCentral, ParametrosGerais.getUpperCase());
    }

    @Override
    protected void controlaCampos() {
        boolean podeAtivar = this.getStatus() == 3 || this.getStatus() == 2;
        this.textCodigo.setEnabled(false);
        this.textDescricao.setEnabled(podeAtivar);
        this.textSetor.setEnabled(podeAtivar);
        this.textUsuario.setEnabled(podeAtivar);
        this.checkInativo.setEnabled(podeAtivar);
        this.buttonSetor.setEnabled(podeAtivar);
        this.buttonUsuario.setEnabled(podeAtivar);
    }

    @Override
    protected void limparCampos() {
        this.textCodigo.clear();
        this.textDescricao.clear();
        this.textSetor.clear();
        this.textUsuario.clear();
        this.checkInativo.setSelected(false);
        this.labelVlrSetor.setText("");
        this.labelVlrUsuario.setText("");
        this.setorAux = null;
        this.usuarioAux = null;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        try {
            BanhoMariaVO vo = (BanhoMariaVO)((BanhoMariaService)this.service).pesquisaVO(Laboratorio.getInstancia(), new BanhoMariaVO(), "Pesquisando Banhos-Maria", false);
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("ban_codigo", vo.getCodigo());
                BanhoMariaBean gelBean = (BanhoMariaBean)((BanhoMariaService)this.service).getBean(chaves, false);
                return gelBean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        BanhoMariaBean bean = new BanhoMariaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        if (!Funcoes.textoVazio(this.textCodigo)) {
            bean.setCodigo(Integer.parseInt(this.textCodigo.getText()));
        }
        bean.setDescricao(this.textDescricao.getText());
        bean.setInativo(this.checkInativo.isSelected());
        bean.setSetor(this.setorAux);
        bean.setUsuario(this.usuarioAux);
        return bean;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
        if (!(bean instanceof BanhoMariaBean)) {
            return;
        }
        BanhoMariaBean beanAux = (BanhoMariaBean)bean;
        this.textCodigo.setText(beanAux.getCodigo().toString());
        this.textDescricao.setText(beanAux.getDescricao());
        this.checkInativo.setSelected(beanAux.getInativo());
        this.usuarioAux = beanAux.getUsuario();
        if (this.usuarioAux != null) {
            this.textUsuario.setText(this.usuarioAux.getCodigo());
            this.labelVlrUsuario.setText(this.usuarioAux.getDescricao());
        }
        this.setorAux = beanAux.getSetor();
        if (this.setorAux != null) {
            this.textSetor.setText(this.setorAux.getCodigo().toString());
            this.labelVlrSetor.setText(this.setorAux.getDescricao());
        }
    }

    @Override
    protected String getCopiaFiliais() {
        return ParametrosGerais.getCopiaBanhoMaria();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textDescricao)) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar uma descri\u00e7\u00e3o para o banho-maria.", 2);
            ScreenUtil.requisitarFoco(this.textDescricao);
            return false;
        }
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "ban_codigo";
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(BanhoMaria.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0102000301"));
        this.setModuloEdita(Long.parseLong("0102000302"));
        this.setModuloApaga(Long.parseLong("0102000303"));
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0102000300");
    }

    @Override
    public void novo() {
        super.novo();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void editar() {
        super.editar();
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    @Override
    public void salvar(boolean limparCampos) {
        BanhoMariaBean bean;
        if (this.validaCampos() && (bean = (BanhoMariaBean)this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                this.retornoParaPesquisa = bean.getCodigo().toString();
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.arquivaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonSetor) {
            this.pesquisaSetor();
        } else if (e.getSource() == this.buttonUsuario) {
            this.pesquisaUsuario();
        }
    }

    private void pesquisaSetor() {
        SetorVO vo = (SetorVO)new SetorService().pesquisaVO(Laboratorio.getInstancia(), new SetorVO(), "Buscando Setores", true);
        if (vo != null) {
            this.setorAux = vo;
            this.textSetor.setText(vo.getCodigo().toString());
            this.labelVlrSetor.setText(vo.getDescricao());
        }
    }

    private void pesquisaUsuario() {
        UsuarioVO vo = (UsuarioVO)new UsuarioService().pesquisaVO(Laboratorio.getInstancia(), new UsuarioVO(), "Buscando Usu\u00e1rio", true);
        if (vo != null) {
            this.usuarioAux = vo;
            this.textUsuario.setText(vo.getCodigo().toString());
            this.labelVlrUsuario.setText(vo.getDescricao());
        }
    }

    private void buscaSetor(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.setorAux = null;
            this.labelVlrSetor.setText("");
            return;
        }
        try {
            SetorVO setor;
            this.setorAux = setor = (SetorVO)new SetorService().getVO(Variaveis.filialPadrao, codigo);
            if (this.setorAux != null) {
                this.labelVlrSetor.setText(this.setorAux.getDescricao());
            } else {
                this.labelVlrSetor.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar setor.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaUsuario(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.usuarioAux = null;
            this.labelVlrUsuario.setText("");
            return;
        }
        try {
            UsuarioVO usuario;
            this.usuarioAux = usuario = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, codigo);
            if (this.usuarioAux != null) {
                this.labelVlrUsuario.setText(this.usuarioAux.getDescricao());
            } else {
                this.labelVlrUsuario.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
        }
    }
}

