/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.matricial.EditorSMS;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class AvisoAgendamentoSMS
extends AbstractDialogoOKCancelar {
    private ArrayList<Registro> avisosAgendamentoSms = new ArrayList();
    public static final String AVISO_SMS_DIAS = "dias";
    public static final String AVISO_SMS_MENSAGEM = "mensagem";
    private final int COLUNA_MSG = 0;
    private final int COLUNA_DIAS = 1;
    private TTextField textMsg = new TTextField(3000);
    private TTextField textDias = new TTextField(3, 1);
    private JButton buttonCamposAgendamento = ComponenteFactory.novoJButton("...", (ActionListener)this, "Selecione os campos que ser\u00e3o apresentados na mensagem");
    private JButton buttonAdd = ComponenteFactory.novoJButton("OK", 'O', this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Mensagem", "Dias(s)"});
    private JTable tabela = new JTable(this.modelo);
    private JPopupMenu menuCampos = new JPopupMenu();
    private TTextField campoParaAdicionar = null;
    public static final String[] CAMPOS_DISPONIVEIS = new String[]{"codigoPaciente", "cpfPaciente", "senhaWebPaciente", "nomePaciente", "codigoRequisicao", "senhaWebRequisicao", "dataRequisicao", "dataEntregaPrevistaRequisicao", "horaEntregaPrevistaRequisicao", "codigoPacienteWeb", "dataHoraAgenda", "primeiroNomePaciente", "nomeSocialPaciente", "primeiroNomeSocialPaciente", "codigoConvenio"};

    public static AvisoAgendamentoSMS novaInstancia(Window owner) {
        if (owner instanceof Frame) {
            return new AvisoAgendamentoSMS((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new AvisoAgendamentoSMS((Dialog)owner);
        }
        return null;
    }

    public AvisoAgendamentoSMS(Frame owner) {
        super(owner, "Avisos SMS");
        this.montaTela();
    }

    public AvisoAgendamentoSMS(Dialog owner) {
        super(owner, "Avisos SMS");
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(630, 300));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        JPanel p = this.getPanelCentral();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        JLabel labelTitulo = new JLabel("Mensagem");
        p.add((Component)labelTitulo, c);
        ++c.gridx;
        ++c.gridx;
        c.gridy = 0;
        c.anchor = 17;
        JLabel labelDias = new JLabel("Dias(s)");
        p.add((Component)labelDias, c);
        ++c.gridy;
        c.gridx = 0;
        this.textMsg.setPreferredSize(new Dimension(473, 20));
        this.textMsg.setMinimumSize(new Dimension(473, 20));
        this.textMsg.setMaximumSize(new Dimension(473, 20));
        p.add((Component)this.textMsg, c);
        ++c.gridx;
        this.buttonCamposAgendamento.setPreferredSize(new Dimension(20, 20));
        this.buttonCamposAgendamento.setMinimumSize(new Dimension(20, 20));
        this.buttonCamposAgendamento.setMaximumSize(new Dimension(20, 20));
        p.add((Component)this.buttonCamposAgendamento, c);
        ++c.gridx;
        this.textDias.setPreferredSize(new Dimension(70, 20));
        this.textDias.setMinimumSize(new Dimension(70, 20));
        this.textDias.setMaximumSize(new Dimension(70, 20));
        p.add((Component)this.textDias, c);
        ++c.gridx;
        this.buttonAdd.setPreferredSize(new Dimension(40, 20));
        this.buttonAdd.setMinimumSize(new Dimension(40, 20));
        this.buttonAdd.setMaximumSize(new Dimension(40, 20));
        p.add((Component)this.buttonAdd, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 1;
        c.weightx = 4.0;
        c.weighty = 4.0;
        c.gridwidth = 4;
        p.add((Component)new JScrollPane(this.tabela), c);
        this.modelo.setColumnSize(new int[]{0, 50}, this.tabela);
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && AvisoAgendamentoSMS.this.tabela.getSelectedRow() > -1 && Funcoes.mensagem(AvisoAgendamentoSMS.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AvisoAgendamentoSMS.this.modelo.removeLine(AvisoAgendamentoSMS.this.tabela.getSelectedRow());
                } else if (e.getKeyCode() == 32) {
                    String msg = (String)AvisoAgendamentoSMS.this.modelo.getValueAt(AvisoAgendamentoSMS.this.tabela.getSelectedRow(), 0);
                    String dias = (String)AvisoAgendamentoSMS.this.modelo.getValueAt(AvisoAgendamentoSMS.this.tabela.getSelectedRow(), 1);
                    AvisoAgendamentoSMS.this.textMsg.setText(msg);
                    AvisoAgendamentoSMS.this.textDias.setText(dias);
                }
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String msg = (String)AvisoAgendamentoSMS.this.modelo.getValueAt(AvisoAgendamentoSMS.this.tabela.getSelectedRow(), 0);
                    String dias = (String)AvisoAgendamentoSMS.this.modelo.getValueAt(AvisoAgendamentoSMS.this.tabela.getSelectedRow(), 1);
                    AvisoAgendamentoSMS.this.textMsg.setText(msg);
                    AvisoAgendamentoSMS.this.textDias.setText(dias);
                }
            }
        });
        for (String campo : CAMPOS_DISPONIVEIS) {
            JMenuItem item = new JMenuItem(campo);
            this.menuCampos.add(item);
            item.addActionListener(this);
        }
        ScreenUtil.requisitarFoco(this.textMsg);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonAdd) {
            this.adicionaMsgAviso();
        } else if (o instanceof JMenuItem) {
            try {
                this.campoParaAdicionar.getDocument().insertString(this.campoParaAdicionar.getCaretPosition(), "[" + ((JMenuItem)e.getSource()).getText() + "]", null);
            }
            catch (Exception exception) {}
        } else if (o == this.buttonCamposAgendamento) {
            EditorSMS editor = new EditorSMS(this, "Configurando campos", true);
            editor.setCampoDoBanco(CAMPOS_DISPONIVEIS);
            editor.setFormato(this.textMsg.getText());
            editor.setVisible(true);
            if (editor.ok()) {
                this.textMsg.setText(editor.getFormato());
            }
        } else if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok) {
                this.acaoCancelar();
                this.limpaCampos();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.setMensagensSMS();
                this.limpaCampos();
                this.dispose();
            }
        }
    }

    private void adicionaMsgAviso() {
        if (this.validaCampos()) {
            this.modelo.addLine(new String[]{this.textMsg.getText(), this.textDias.getText()});
            this.textMsg.clear();
            this.textDias.clear();
            this.modelo.ordenarColuna(1, -1);
            ScreenUtil.requisitarFoco(this.textMsg);
        }
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textMsg)) {
            Funcoes.mensagem(this, "Informe a mensagem para envio SMS.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.textDias)) {
            Funcoes.mensagem(this, "Informe o dia para envio SMS.", 2);
            return false;
        }
        if (this.modelo.getRowCount() > 0) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                String dia = (String)this.modelo.getValueAt(i, 1);
                if (Integer.valueOf(this.textDias.getText()) != Integer.valueOf(dia)) continue;
                if (Funcoes.mensagem(this, "J\u00e1 existe mensagem configurada para o dia informado, deseja substituir ?", 4) == 0) {
                    this.modelo.removeLine(i);
                    continue;
                }
                ScreenUtil.requisitarFoco(this.textDias);
                return false;
            }
        }
        return true;
    }

    private void limpaCampos() {
        this.modelo.clear();
        this.textMsg.clear();
        this.textDias.clear();
    }

    public ArrayList<Registro> getMensagensSMS() {
        return this.avisosAgendamentoSms;
    }

    public void setMensagensSMS() {
        this.avisosAgendamentoSms = new ArrayList();
        if (this.modelo.getRowCount() > 0) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                Registro reg = new Registro();
                reg.setValor(AVISO_SMS_DIAS, this.modelo.getValueAt(i, 1));
                reg.setValor(AVISO_SMS_MENSAGEM, this.modelo.getValueAt(i, 0));
                this.avisosAgendamentoSms.add(reg);
            }
        }
    }

    public void adicionaMensagemGrid(String filial) {
        if (!Funcoes.textoVazio(filial)) {
            ArrayList<Registro> mensagens = this.getMensagensSMS();
            if (mensagens.isEmpty()) {
                mensagens = this.buscaMensagensAgendamento(filial);
            }
            if (!mensagens.isEmpty()) {
                for (Registro reg : mensagens) {
                    String msg = (String)reg.getValor(AVISO_SMS_MENSAGEM);
                    String dias = (String)reg.getValor(AVISO_SMS_DIAS);
                    this.modelo.addLine(new String[]{msg, dias});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Registro> buscaMensagensAgendamento(String filial) {
        ArrayList<Registro> mensagens = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select frg_dias, frg_mensagem ");
        buf.append(" from fraseagendamentosms ");
        buf.append(" where fil_codigo = ").append(filial);
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                Registro reg = new Registro();
                reg.setValor(AVISO_SMS_DIAS, String.valueOf(rs.getInt("frg_dias")));
                reg.setValor(AVISO_SMS_MENSAGEM, rs.getString("frg_mensagem"));
                mensagens.add(reg);
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return mensagens;
    }
}

