/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.util.TiposApropriacao;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ApropriaCentroCustoBean;
import jalis.model.bean.cadastro.financeiro.ApropriaPlanoContaBean;
import jalis.model.bean.cadastro.financeiro.CentroCustoPlanoContaBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.financeiro.ApropriaCentroCustoService;
import jalis.service.cadastro.financeiro.ApropriaPlanoContaService;
import jalis.service.cadastro.financeiro.CentroCustoPlanoContaService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ApropriacaoAutomatica
extends FrmCadPadrao
implements TreeSelectionListener,
ThreadFinalizadaListener {
    private JTabbedPane abas = new JTabbedPane();
    private JTree treeCredito;
    private JTree treeDebito;
    private JTree treeConvenios;
    private JPanel panelCredito = new JPanel();
    private JPanel panelDebito = new JPanel();
    private JPanel panelConvenios = new JPanel();
    private JPanel panelPrincipal = new JPanel();
    private PainelPlanoCentro panelPlanoConta = new PainelPlanoCentro(TIPO_PLANO_CONTA);
    private PainelPlanoCentro panelCentroCusto = new PainelPlanoCentro(TIPO_CENTRO_CUSTO);
    private JPanel panelLegenda = new JPanel();
    private JScrollPane scrollConvenios = new JScrollPane();
    private JScrollPane scrollCredito = new JScrollPane();
    private JScrollPane scrollDebito = new JScrollPane();
    private final Color COR_PLANO_CONTA_ERRADO = Color.ORANGE;
    private final Color COR_CENTRO_CUSTO_ERRADO = Color.BLUE;
    private final Color COR_PLANO_CONTA_CENTRO_CUSTO_ERRADO = Color.RED;
    private final Color COR_CORRETO = Color.BLACK;
    private ArrayList<ItemApropriacao> arrayItemApropriacao = new ArrayList();
    private static int TIPO_PLANO_CONTA = 0;
    private static int TIPO_CENTRO_CUSTO = 1;
    private boolean isCarregando = false;

    public ApropriacaoAutomatica() {
        this.setName("ApropriacaoAutomatica");
        this.painelCentral.setLayout(new GridBagLayout());
        this.panelPrincipal.setLayout(new GridBagLayout());
        this.panelConvenios.setLayout(new GridBagLayout());
        this.panelConvenios.setBorder(new TitledBorder("Conv\u00eanios"));
        this.setLabelDescricao("Configura\u00e7\u00e3o da Apropria\u00e7\u00e3o Autom\u00e1tica de D\u00e9bitos e Cr\u00e9ditos");
        this.setLabelFormulario("Apropria\u00e7\u00e3o Autom\u00e1tica");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/apropriacao-automatica.jpg"));
        this.abas.insertTab("Cr\u00e9dito", null, this.panelCredito, "", 0);
        this.abas.insertTab("D\u00e9bito", null, this.panelDebito, "", 1);
        this.abas.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ApropriacaoAutomatica.this.carregaDadosItemSelecionado();
            }
        });
        this.abas.setName("abas");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 12;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.6;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelPrincipal.add((Component)this.abas, c);
        ++c.gridx;
        c.weightx = 0.4;
        this.panelPrincipal.add((Component)this.panelConvenios, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 12;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelConvenios.add((Component)this.scrollConvenios, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)this.panelPrincipal, c);
        Dimension d = new Dimension(200, 170);
        this.panelPlanoConta.setPreferredSize(d);
        this.panelPlanoConta.setMinimumSize(d);
        d = new Dimension(200, 170);
        this.panelCentroCusto.setPreferredSize(d);
        this.panelCentroCusto.setMinimumSize(d);
        JPanel painelPlanoCentro = new JPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.anchor = 12;
        g.gridheight = 1;
        g.gridwidth = 1;
        g.insets = new Insets(1, 1, 1, 1);
        g.weightx = 1.0;
        g.weighty = 0.0;
        g.fill = 2;
        painelPlanoCentro.add((Component)this.panelPlanoConta, g);
        g.weightx = 1.0;
        ++g.gridx;
        painelPlanoCentro.add((Component)this.panelCentroCusto, g);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.painelCentral.add((Component)painelPlanoCentro, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.panelLegenda, c);
        this.panelCredito.setLayout(new GridBagLayout());
        this.panelDebito.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelCredito.add((Component)this.scrollCredito, c);
        this.panelDebito.add((Component)this.scrollDebito, c);
        this.panelLegenda.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_PLANO_CONTA_ERRADO);
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 20);
        JLabel aux = new JLabel("Plano de Contas parcialmente/n\u00e3o configurado");
        aux.setFont(aux.getFont().deriveFont(10.0f).deriveFont(0));
        d = new Dimension(300, 20);
        aux.setMinimumSize(d);
        this.panelLegenda.add((Component)aux, c);
        ++c.gridx;
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_CENTRO_CUSTO_ERRADO);
        c.insets = new Insets(0, 0, 0, 2);
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 20);
        aux = new JLabel("Centro de Custo parcialmente/n\u00e3o configurado");
        aux.setFont(aux.getFont().deriveFont(10.0f).deriveFont(0));
        d = new Dimension(300, 20);
        aux.setMinimumSize(d);
        this.panelLegenda.add((Component)aux, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLegenda.add((Component)new JLabel(""), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(this.COR_PLANO_CONTA_CENTRO_CUSTO_ERRADO);
        c.insets = new Insets(0, 0, 0, 2);
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        ++c.gridx;
        aux = new JLabel("Plano de Contas e Centro de Custo parcialmente/n\u00e3o configurados");
        aux.setFont(aux.getFont().deriveFont(10.0f).deriveFont(0));
        d = new Dimension(390, 20);
        aux.setMinimumSize(d);
        c.insets = new Insets(0, 0, 0, 20);
        this.panelLegenda.add((Component)aux, c);
        c.gridx += 2;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLegenda.add((Component)new JLabel(""), c);
        this.botaoExcluir.setVisible(false);
        this.botaoNovo.setVisible(false);
        this.carregaDados();
        this.setStatus(1);
        this.controlaCampos();
    }

    private void carregaDados() {
        final SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Carregando dados");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i;
                for (i = 0; i < 2; ++i) {
                    TiposApropriacao[] tiposApropriacao;
                    String tipoDebitoCredito = i == 0 ? "C" : "D";
                    ItemApropriacao root = new ItemApropriacao(TiposApropriacao.Nenhuma, tipoDebitoCredito, null, false);
                    for (TiposApropriacao aux : tiposApropriacao = TiposApropriacao.getTiposApropriacao()) {
                        new ItemApropriacao(aux, tipoDebitoCredito, aux.getPai(), aux.getApropriaConvenio());
                    }
                    if (ApropriacaoAutomatica.this.arrayItemApropriacao != null) {
                        for (int k = 0; k < ApropriacaoAutomatica.this.arrayItemApropriacao.size(); ++k) {
                            ArrayList convenios;
                            ItemApropriacao item = (ItemApropriacao)ApropriacaoAutomatica.this.arrayItemApropriacao.get(k);
                            if (!item.getTipoDebitoCredito().equals(tipoDebitoCredito)) continue;
                            if (item.getTipoApropriacao() != TiposApropriacao.Nenhuma) {
                                if (item.getTipoApropriacao().getPai() == null) {
                                    item.setItemPai(root);
                                } else {
                                    item.setItemPai(ApropriacaoAutomatica.this.getItemApropriacao(item.getTipoApropriacao().getPai(), tipoDebitoCredito));
                                }
                            }
                            if (!item.isApropriaConvenio || (convenios = ApropriacaoAutomatica.this.carregaDadosConvenios()) == null) continue;
                            for (int j = 0; j < convenios.size(); ++j) {
                                ConvenioApropriacao convApropriacao = new ConvenioApropriacao(item.getTipoApropriacao(), item.getTipoDebitoCredito(), null, (ConvenioVO)convenios.get(j));
                                item.adicionaConvenioApropriacao(convApropriacao);
                            }
                        }
                    }
                    if (ApropriacaoAutomatica.this.treeCredito == null) {
                        ApropriacaoAutomatica.this.treeCredito = new JTree(root);
                        ApropriacaoAutomatica.this.treeCredito.setName("treeCredito");
                        continue;
                    }
                    ApropriacaoAutomatica.this.treeDebito = new JTree(root);
                    ApropriacaoAutomatica.this.treeDebito.setName("treeDebito");
                }
                ApropriacaoAutomatica.this.scrollConvenios.setViewportView(ApropriacaoAutomatica.this.treeConvenios);
                ApropriacaoAutomatica.this.scrollCredito.setViewportView(ApropriacaoAutomatica.this.treeCredito);
                ApropriacaoAutomatica.this.treeCredito.setName("treeCredito");
                for (i = 0; i < ApropriacaoAutomatica.this.treeCredito.getRowCount(); ++i) {
                    ApropriacaoAutomatica.this.treeCredito.expandRow(i);
                }
                ApropriacaoAutomatica.this.scrollDebito.setViewportView(ApropriacaoAutomatica.this.treeDebito);
                ApropriacaoAutomatica.this.treeDebito.setName("treeDebito");
                for (i = 0; i < ApropriacaoAutomatica.this.treeDebito.getRowCount(); ++i) {
                    ApropriacaoAutomatica.this.treeDebito.expandRow(i);
                }
                ApropriacaoAutomatica.this.treeCredito.setCellRenderer(new Renderer());
                ApropriacaoAutomatica.this.treeCredito.addTreeSelectionListener(ApropriacaoAutomatica.this);
                ApropriacaoAutomatica.this.treeDebito.setCellRenderer(new Renderer());
                ApropriacaoAutomatica.this.treeDebito.addTreeSelectionListener(ApropriacaoAutomatica.this);
                ApropriacaoAutomatica.this.treeCredito.setSelectionRow(1);
                ApropriacaoAutomatica.this.treeDebito.setSelectionRow(1);
                ApropriacaoAutomatica.this.carregaDadosItemSelecionado();
                splash.apagar();
            }
        });
    }

    private ArrayList<ConvenioVO> carregaDadosConvenios() {
        ConvenioService service = new ConvenioService();
        try {
            Set aux = service.loadVO(" where fil_codigo = " + Variaveis.filialPadrao + " order by con_codigo ");
            if (aux != null && aux.size() > 0) {
                ArrayList<ConvenioVO> lista = new ArrayList<ConvenioVO>(aux);
                Collections.sort(lista);
                return lista;
            }
            return null;
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados dos conv\u00eanios", 2);
            return null;
        }
    }

    private ItemApropriacao getItemApropriacao(TiposApropriacao item, String tipoDebitoCredito) {
        if (this.arrayItemApropriacao != null) {
            for (ItemApropriacao aux : this.arrayItemApropriacao) {
                if (aux.getTipoApropriacao() != item || !aux.getTipoDebitoCredito().equals(tipoDebitoCredito)) continue;
                return aux;
            }
        }
        return null;
    }

    public void carregaDadosItemSelecionado() {
        JPanel aux = (JPanel)this.abas.getSelectedComponent();
        ItemApropriacao item = null;
        if (this.treeConvenios != null) {
            this.treeConvenios.removeAll();
            this.treeConvenios = null;
        }
        item = aux == this.panelCredito ? (ItemApropriacao)this.treeCredito.getLastSelectedPathComponent() : (ItemApropriacao)this.treeDebito.getLastSelectedPathComponent();
        if (item.isApropriaConvenio) {
            ItemApropriacao root = new ItemApropriacao(TiposApropriacao.Nenhuma, item.getTipoDebitoCredito(), null, false);
            ArrayList<ConvenioApropriacao> convenios = item.getConveniosApropriacao();
            for (int i = 0; i < convenios.size(); ++i) {
                if (!convenios.get(i).getTipoDebitoCredito().equalsIgnoreCase(item.getTipoDebitoCredito())) continue;
                convenios.get(i).setItemPai(root);
            }
            this.treeConvenios = new JTree(root);
            this.treeConvenios.setName("treeConvenios");
            this.scrollConvenios.setViewportView(this.treeConvenios);
            this.treeConvenios.setCellRenderer(new Renderer());
            this.treeConvenios.addTreeSelectionListener(this);
            this.panelConvenios.setVisible(true);
        } else {
            this.panelConvenios.setVisible(false);
        }
        this.panelPlanoConta.carregaDados(item);
        this.panelCentroCusto.carregaDados(item);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300800");
    }

    public static long getModuloInserir() {
        return Long.parseLong("0600300801");
    }

    protected void controlaCampos() {
        this.panelPlanoConta.controlaCampos(!this.isCarregando && this.getStatus() == 2);
        this.panelCentroCusto.controlaCampos(!this.isCarregando && this.getStatus() == 2);
        this.botaoEditar.setEnabled(!this.isCarregando && Acesso.getAcesso(ApropriacaoAutomatica.getModuloInserir()) && this.getStatus() == 1);
        this.botaoCancelar.setEnabled(!this.isCarregando && this.getStatus() != 1);
        this.botaoSalvar.setEnabled(!this.isCarregando && Acesso.getAcesso(ApropriacaoAutomatica.getModuloInserir()) && this.getStatus() == 2);
        this.panelPlanoConta.controlaCampos(!this.isCarregando && Acesso.getAcesso(ApropriacaoAutomatica.getModuloInserir()) && this.getStatus() == 2);
        this.panelCentroCusto.controlaCampos(!this.isCarregando && Acesso.getAcesso(ApropriacaoAutomatica.getModuloInserir()) && this.getStatus() == 2);
        this.botaoFechar.setEnabled(!this.isCarregando && this.getStatus() == 1);
    }

    protected void limparCampos() {
        this.panelPlanoConta.limpaCampos();
        this.panelCentroCusto.limpaCampos();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ItemApropriacao itemApropriacao = (ItemApropriacao)((JTree)e.getSource()).getLastSelectedPathComponent();
        if (e.getSource() != this.treeConvenios && this.treeConvenios != null) {
            this.treeConvenios.clearSelection();
        }
        if (itemApropriacao == null) {
            return;
        }
        if (!(itemApropriacao instanceof ConvenioApropriacao)) {
            if (itemApropriacao.isApropriaConvenio) {
                ItemApropriacao root = new ItemApropriacao(TiposApropriacao.Nenhuma, itemApropriacao.getTipoDebitoCredito(), null, false);
                ArrayList<ConvenioApropriacao> convenios = itemApropriacao.getConveniosApropriacao();
                for (int i = 0; i < convenios.size(); ++i) {
                    if (!convenios.get(i).getTipoDebitoCredito().equalsIgnoreCase(itemApropriacao.getTipoDebitoCredito())) continue;
                    convenios.get(i).setItemPai(root);
                }
                this.treeConvenios = new JTree(root);
                this.scrollConvenios.setViewportView(this.treeConvenios);
                this.treeConvenios.setCellRenderer(new Renderer());
                this.treeConvenios.addTreeSelectionListener(this);
                this.panelConvenios.setVisible(true);
            } else {
                this.panelConvenios.setVisible(false);
            }
        }
        this.panelPlanoConta.carregaDados(itemApropriacao);
        this.panelCentroCusto.carregaDados(itemApropriacao);
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            if (this.arrayItemApropriacao != null) {
                for (int i = 0; i < this.arrayItemApropriacao.size(); ++i) {
                    ItemApropriacao item = this.arrayItemApropriacao.get(i);
                    item.carregaDadosPlanos();
                    item.carregaDadosCentros();
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
            this.carregaDadosItemSelecionado();
            this.treeCredito.repaint();
            this.treeDebito.repaint();
            if (this.treeConvenios != null) {
                this.treeConvenios.repaint();
            }
        }
    }

    @Override
    public void editar() {
        this.setStatus(2);
        this.controlaCampos();
    }

    @Override
    public void excluir() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public void novo() {
    }

    @Override
    public void salvar() {
        if (this.arrayItemApropriacao != null) {
            ApropriaPlanoContaService servicePlano = new ApropriaPlanoContaService();
            ApropriaCentroCustoService serviceCentro = new ApropriaCentroCustoService();
            for (int i = 0; i < this.arrayItemApropriacao.size(); ++i) {
                ItemApropriacao item = this.arrayItemApropriacao.get(i);
                if (item.isAlterado()) {
                    try {
                        servicePlano.deleteTodosPlanosApropriacao(Variaveis.filialPadrao, String.valueOf(item.getTipoApropriacao().getTipo()), item.getTipoDebitoCredito(), null);
                        serviceCentro.deleteTodosCentrosApropriacao(Variaveis.filialPadrao, String.valueOf(item.getTipoApropriacao().getTipo()), item.getTipoDebitoCredito(), null);
                        for (ApropriaPlanoContaBean bean : item.getArrayPlano()) {
                            servicePlano.insert(bean, bean.getCodigoApropriacao(), Variaveis.filialPadrao, null);
                        }
                        for (ApropriaCentroCustoBean bean : item.getArrayCentro()) {
                            serviceCentro.insert(bean, bean.getCodigoApropriacao(), Variaveis.filialPadrao, null);
                        }
                        Conexao.arquivaSQL();
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException itCentro) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar apropria\u00e7\u00e3o autom\u00e1tica.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
                if (!item.isApropriaConvenio) continue;
                ArrayList<ConvenioApropriacao> convenios = item.listaConvenios;
                try {
                    for (int j = 0; j < convenios.size(); ++j) {
                        ConvenioApropriacao convenio = convenios.get(j);
                        if (convenio.isAlterado()) {
                            servicePlano.deleteTodosPlanosApropriacao(Variaveis.filialPadrao, String.valueOf(convenio.getTipoApropriacao().getTipo()), convenio.getTipoDebitoCredito(), convenio.getConvenio().getCodigo().toString());
                            serviceCentro.deleteTodosCentrosApropriacao(Variaveis.filialPadrao, String.valueOf(convenio.getTipoApropriacao().getTipo()), convenio.getTipoDebitoCredito(), convenio.getConvenio().getCodigo().toString());
                            for (ApropriaPlanoContaBean bean : convenio.getArrayPlano()) {
                                servicePlano.insert(bean, bean.getCodigoApropriacao(), Variaveis.filialPadrao, null);
                            }
                            for (ApropriaCentroCustoBean bean : convenio.getArrayCentro()) {
                                serviceCentro.insert(bean, bean.getCodigoApropriacao(), Variaveis.filialPadrao, null);
                            }
                        }
                        Conexao.arquivaSQL();
                    }
                    continue;
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar apropria\u00e7\u00e3o autom\u00e1tica de conv\u00eanio.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public boolean validaCampos() {
        return true;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isCarregando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isCarregando = false;
        this.controlaCampos();
    }

    class Renderer
    implements TreeCellRenderer {
        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color selecionado = UIManager.getColor("Tree.selectionBackground");
            JLabel label = new JLabel(value.toString());
            label.setFont(label.getFont().deriveFont(14.0f));
            label.setOpaque(selected);
            if (selected) {
                label.setBackground(selecionado);
            }
            if (value instanceof ItemApropriacao) {
                ItemApropriacao aux = (ItemApropriacao)value;
                if (aux.isUsadoPercentualTotalPlano() && aux.isUsadoPercentualTotalCentro()) {
                    label.setForeground(ApropriacaoAutomatica.this.COR_CORRETO);
                } else if (!aux.isUsadoPercentualTotalPlano() && !aux.isUsadoPercentualTotalCentro()) {
                    label.setForeground(ApropriacaoAutomatica.this.COR_PLANO_CONTA_CENTRO_CUSTO_ERRADO);
                } else if (!aux.isUsadoPercentualTotalPlano()) {
                    label.setForeground(ApropriacaoAutomatica.this.COR_PLANO_CONTA_ERRADO);
                } else {
                    label.setForeground(ApropriacaoAutomatica.this.COR_CENTRO_CUSTO_ERRADO);
                }
            }
            return label;
        }
    }

    class ItemApropriacao
    extends DefaultMutableTreeNode {
        protected ItemApropriacao itemPai = null;
        protected boolean isAlterado = false;
        protected TiposApropriacao tipoApropriacao = null;
        protected String tipoDebitoCredito = null;
        protected ArrayList<ApropriaPlanoContaBean> arrayApropriacoesPlano = null;
        protected ArrayList<ApropriaCentroCustoBean> arrayApropriacoesCentro = null;
        protected Double percentualUsadoPlano = 0.0;
        protected Double percentualUsadoCentro = 0.0;
        protected boolean isApropriaConvenio = false;
        protected ArrayList<ConvenioApropriacao> listaConvenios = null;

        public ItemApropriacao(TiposApropriacao tipoApropriacao, String tipoDebitoCredito, TiposApropriacao pai, boolean isApropriaConvenio) {
            if (!(this instanceof ConvenioApropriacao) && ApropriacaoAutomatica.this.arrayItemApropriacao != null) {
                ApropriacaoAutomatica.this.arrayItemApropriacao.add(this);
            }
            this.tipoApropriacao = tipoApropriacao;
            this.tipoDebitoCredito = tipoDebitoCredito;
            this.isApropriaConvenio = isApropriaConvenio;
            if (isApropriaConvenio) {
                this.listaConvenios = new ArrayList();
            }
            this.carregaDadosPlanos();
            this.carregaDadosCentros();
        }

        public boolean isApropriaConvenio() {
            return this.isApropriaConvenio;
        }

        public void adicionaConvenioApropriacao(ConvenioApropriacao convApropriacao) {
            if (this.listaConvenios != null) {
                this.listaConvenios.add(convApropriacao);
            }
        }

        public String getTipoDebitoCredito() {
            return this.tipoDebitoCredito;
        }

        @Override
        public String toString() {
            return this.tipoApropriacao.toString();
        }

        public TiposApropriacao getTipoApropriacao() {
            return this.tipoApropriacao;
        }

        public boolean isAlterado() {
            return this.isAlterado;
        }

        public void setAlterado(boolean isAlterado) {
            this.isAlterado = isAlterado;
        }

        public void setItemPai(ItemApropriacao itemPai) {
            this.itemPai = itemPai;
            if (itemPai != null) {
                itemPai.add(this);
            }
        }

        public ItemApropriacao getItemPai() {
            return this.itemPai;
        }

        public boolean isPaiAlterado() {
            if (this.itemPai != null) {
                return this.itemPai.isAlterado();
            }
            return false;
        }

        public void removeCentro(ApropriaCentroCustoBean centro) {
            if (this.arrayApropriacoesCentro != null && centro != null) {
                this.arrayApropriacoesCentro.remove(centro);
                this.isAlterado = true;
            }
        }

        public void removePlano(ApropriaPlanoContaBean plano) {
            if (this.arrayApropriacoesPlano != null && plano != null) {
                this.arrayApropriacoesPlano.remove(plano);
                this.isAlterado = true;
            }
        }

        public void addPlano(ApropriaPlanoContaBean plano) {
            if (this.arrayApropriacoesPlano != null && plano != null) {
                this.arrayApropriacoesPlano.add(plano);
                this.isAlterado = true;
            }
        }

        public void addCentro(ApropriaCentroCustoBean centro) {
            if (this.arrayApropriacoesCentro != null && centro != null) {
                this.arrayApropriacoesCentro.add(centro);
                this.isAlterado = true;
            }
        }

        public ArrayList<ConvenioApropriacao> getConveniosApropriacao() {
            return this.listaConvenios;
        }

        public ArrayList<ApropriaPlanoContaBean> getArrayPlano() {
            return this.arrayApropriacoesPlano;
        }

        public ArrayList<ApropriaCentroCustoBean> getArrayCentro() {
            return this.arrayApropriacoesCentro;
        }

        public void carregaDadosCentros() {
            ArrayList centros = null;
            try {
                centros = new ArrayList(new ApropriaCentroCustoService().getCentrosCustoApropriacao(Variaveis.filialPadrao, String.valueOf(this.tipoApropriacao.getTipo()), this.tipoDebitoCredito, null));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os centros de custo da apropria\u00e7\u00e3o. " + e.getMessage(), e.getStackTrace());
            }
            if (centros != null) {
                this.arrayApropriacoesCentro = centros;
            }
        }

        public void carregaDadosPlanos() {
            ArrayList<ApropriaPlanoContaBean> planos = null;
            try {
                planos = new ArrayList<ApropriaPlanoContaBean>(new ApropriaPlanoContaService().getPlanosContasApropriacao(Variaveis.filialPadrao, String.valueOf(this.tipoApropriacao.getTipo()), this.tipoDebitoCredito, null));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os planos de contas da apropria\u00e7\u00e3o. " + e.getMessage(), e.getStackTrace());
            }
            if (planos != null) {
                this.arrayApropriacoesPlano = planos;
            }
        }

        public boolean isUsadoPercentualTotalPlano() {
            if (this.arrayApropriacoesPlano != null) {
                Iterator<ApropriaPlanoContaBean> it = this.arrayApropriacoesPlano.iterator();
                BigDecimal percTotal = BigDecimal.valueOf(0.0);
                while (it.hasNext()) {
                    ApropriaPlanoContaBean aux = it.next();
                    if (aux == null) continue;
                    percTotal = percTotal.add(BigDecimal.valueOf(aux.getPercentualApropriacao()));
                }
                percTotal = percTotal.setScale(2, RoundingMode.HALF_UP);
                this.percentualUsadoPlano = percTotal.doubleValue();
                if (percTotal.doubleValue() == 100.0) {
                    return true;
                }
            }
            return false;
        }

        public boolean isUsadoPercentualTotalCentro() {
            if (this.arrayApropriacoesCentro != null) {
                Iterator<ApropriaCentroCustoBean> it = this.arrayApropriacoesCentro.iterator();
                BigDecimal percTotal = BigDecimal.valueOf(0.0);
                while (it.hasNext()) {
                    ApropriaCentroCustoBean aux = it.next();
                    if (aux == null) continue;
                    percTotal = percTotal.add(BigDecimal.valueOf(aux.getPercentualApropriacao()));
                }
                percTotal = percTotal.setScale(2, RoundingMode.HALF_UP);
                this.percentualUsadoCentro = percTotal.doubleValue();
                if (percTotal.doubleValue() == 100.0) {
                    return true;
                }
            }
            return false;
        }

        public Double getPercentualUsadoPlano() {
            this.isUsadoPercentualTotalPlano();
            return this.percentualUsadoPlano;
        }

        public Double getPercentualUsadoCentro() {
            this.isUsadoPercentualTotalCentro();
            return this.percentualUsadoCentro;
        }
    }

    class ConvenioApropriacao
    extends ItemApropriacao {
        private ConvenioVO convenio;

        public ConvenioApropriacao(TiposApropriacao tipoApropriacao, String tipoDebitoCredito, TiposApropriacao pai, ConvenioVO convenio) {
            super(tipoApropriacao, tipoDebitoCredito, pai, true);
            this.convenio = null;
            this.convenio = convenio;
            this.carregaDadosPlanos();
            this.carregaDadosCentros();
        }

        @Override
        public String toString() {
            return this.convenio.getCodigo() + " - " + this.convenio.getFantasia();
        }

        public ConvenioVO getConvenio() {
            return this.convenio;
        }

        @Override
        public void carregaDadosPlanos() {
            ArrayList<ApropriaPlanoContaBean> planos = null;
            try {
                planos = new ArrayList<ApropriaPlanoContaBean>(new ApropriaPlanoContaService().getPlanosContasApropriacao(Variaveis.filialPadrao, String.valueOf(this.tipoApropriacao.getTipo()), this.tipoDebitoCredito, this.convenio == null ? null : this.convenio.getCodigo().toString()));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os planos de contas da apropria\u00e7\u00e3o. " + e.getMessage(), e.getStackTrace());
            }
            if (planos != null) {
                this.arrayApropriacoesPlano = planos;
            }
        }

        @Override
        public void carregaDadosCentros() {
            ArrayList centros = null;
            try {
                centros = new ArrayList(new ApropriaCentroCustoService().getCentrosCustoApropriacao(Variaveis.filialPadrao, String.valueOf(this.tipoApropriacao.getTipo()), this.tipoDebitoCredito, this.convenio == null ? null : this.convenio.getCodigo().toString()));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os planos de contas da apropria\u00e7\u00e3o. " + e.getMessage(), e.getStackTrace());
            }
            if (centros != null) {
                this.arrayApropriacoesCentro = centros;
            }
        }
    }

    class PainelPlanoCentro
    extends JPanel {
        private TTextField textCodigo = new TTextField(5, 1);
        private JButton buttonBusca = new JButton();
        private JLabel labelDescricao = new JLabel();
        private TTextField textPercentual = new TTextField(5, 10, 2);
        private JButton buttonOk = new JButton("OK");
        private JTable table = new JTable();
        private JLabel labelTotal = new JLabel("Total: 0,00%");
        private int tipo = -1;
        private ItemApropriacao itemApropriacaoAtivo = null;
        private boolean isAlterando = false;

        public PainelPlanoCentro(int tipo) {
            this.setName("PainelPlanoCentro");
            this.tipo = tipo;
            if (tipo == TIPO_PLANO_CONTA) {
                this.setBorder(BorderFactory.createTitledBorder(this.getBorder(), "Plano de Contas"));
            } else {
                this.setBorder(BorderFactory.createTitledBorder(this.getBorder(), "Centro de Custo"));
            }
            ScreenUtil.setBorda(new Component[]{this.labelDescricao}, new TitledBorder(""));
            Funcoes.imagemPesquisa(this.buttonBusca);
            Dimension d = new Dimension(20, 20);
            this.labelDescricao.setPreferredSize(d);
            this.labelDescricao.setMinimumSize(d);
            d = new Dimension(80, 20);
            this.textCodigo.setPreferredSize(d);
            this.textCodigo.setMinimumSize(d);
            this.textCodigo.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                            PainelPlanoCentro.this.buscaPlanoConta(null);
                        } else {
                            PainelPlanoCentro.this.buscaCentroCusto(null);
                        }
                    }
                }
            });
            this.textCodigo.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() == PainelPlanoCentro.this.textPercentual && !Funcoes.textoVazio(PainelPlanoCentro.this.textCodigo)) {
                        if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                            PainelPlanoCentro.this.buscaPlanoConta(PainelPlanoCentro.this.textCodigo.getText());
                        } else {
                            PainelPlanoCentro.this.buscaCentroCusto(PainelPlanoCentro.this.textCodigo.getText());
                        }
                    }
                }
            });
            d = new Dimension(20, 20);
            this.buttonBusca.setPreferredSize(d);
            this.buttonBusca.setMinimumSize(d);
            this.buttonBusca.setFocusable(false);
            this.buttonBusca.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                        PainelPlanoCentro.this.buscaPlanoConta(null);
                    } else {
                        PainelPlanoCentro.this.buscaCentroCusto(null);
                    }
                }
            });
            this.buttonOk.setMargin(new Insets(0, 0, 0, 0));
            d = new Dimension(40, 20);
            this.buttonOk.setMinimumSize(d);
            this.buttonOk.setMinimumSize(d);
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Funcoes.textoVazio(PainelPlanoCentro.this.textCodigo.getText())) {
                        if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Insira um c\u00f3digo para o plano de contas.", 2);
                        } else {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Insira um c\u00f3digo para o centro de custo.", 2);
                        }
                        if (PainelPlanoCentro.this.textCodigo.isFocusable()) {
                            PainelPlanoCentro.this.textCodigo.grabFocus();
                        }
                        return;
                    }
                    if (Funcoes.textoVazio(PainelPlanoCentro.this.textPercentual.getText())) {
                        if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Insira um percentual para o plano de contas.", 2);
                        } else {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Insira um c\u00f3digo para o centro de custo.", 2);
                        }
                        if (PainelPlanoCentro.this.textCodigo.isFocusable()) {
                            PainelPlanoCentro.this.textCodigo.grabFocus();
                        }
                        return;
                    }
                    if (Double.parseDouble(Funcoes.limpaDecimal(PainelPlanoCentro.this.textPercentual.getText())) > PainelPlanoCentro.this.sugerePercentual()) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "A soma dos percentuais ultrapassar\u00e1 100%.\nO valor m\u00e1ximo poss\u00edvel ser\u00e1 sugerido.", 2);
                        PainelPlanoCentro.this.textPercentual.setText(Funcoes.formataDecimal(PainelPlanoCentro.this.sugerePercentual()));
                        PainelPlanoCentro.this.textPercentual.selectAll();
                        return;
                    }
                    if (PainelPlanoCentro.this.getTipo() == TIPO_PLANO_CONTA) {
                        PainelPlanoCentro.this.adicionaPlanoConta();
                    } else {
                        PainelPlanoCentro.this.adicionaCentroCusto(null);
                    }
                }
            });
            d = new Dimension(70, 20);
            this.textPercentual.setPreferredSize(d);
            this.textPercentual.setMinimumSize(d);
            this.textPercentual.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (Funcoes.textoVazio(PainelPlanoCentro.this.textCodigo)) {
                        return;
                    }
                    Double perc = PainelPlanoCentro.this.sugerePercentual();
                    if (perc > 0.0) {
                        PainelPlanoCentro.this.textPercentual.setText(Funcoes.formataDecimal(perc));
                    } else {
                        PainelPlanoCentro.this.textPercentual.setText(Funcoes.formataDecimal(0.0));
                    }
                    PainelPlanoCentro.this.textPercentual.selectAll();
                }
            });
            DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"C\u00f3digo", "Plano de Contas", "Conta", "Percentual", "Objeto"}){

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    Class returnValue = Object.class;
                    if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                        returnValue = this.getValueAt(0, column).getClass();
                    }
                    return returnValue;
                }
            };
            if (tipo == TIPO_CENTRO_CUSTO) {
                model.setColumnIdentifiers(new String[]{"C\u00f3digo", "Centro de Custo", "Conta", "Percentual", "Objeto"});
            }
            this.table.setModel(model);
            this.table.getColumnModel().getColumn(0).setMinWidth(60);
            this.table.getColumnModel().getColumn(0).setMaxWidth(60);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(2).setMinWidth(75);
            this.table.getColumnModel().getColumn(2).setMaxWidth(75);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(75);
            this.table.getColumnModel().getColumn(3).setMinWidth(80);
            this.table.getColumnModel().getColumn(3).setMaxWidth(80);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
            this.table.removeColumn(this.table.getColumnModel().getColumn(4));
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
            ArrayList<RowSorter.SortKey> lista = new ArrayList<RowSorter.SortKey>();
            lista.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            ((RowSorter)sorter).setSortKeys(lista);
            this.table.setRowSorter(sorter);
            this.table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        PainelPlanoCentro.this.removePlanoCentro();
                        PainelPlanoCentro.this.table.revalidate();
                        PainelPlanoCentro.this.table.repaint();
                    }
                }
            });
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ApropriacaoAutomatica.this.getStatus() == 2) {
                        if (e.getClickCount() == 2) {
                            PainelPlanoCentro.this.alteraPlanoCentro();
                            PainelPlanoCentro.this.table.revalidate();
                            PainelPlanoCentro.this.table.repaint();
                        } else if (e.getClickCount() == 1) {
                            PainelPlanoCentro.this.setPlanoCentroAlterando(false, null);
                        }
                    }
                }
            });
            d = new Dimension(100, 100);
            this.table.setPreferredSize(d);
            this.table.setMinimumSize(d);
            JScrollPane scroll = new JScrollPane(this.table);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 18;
            c.fill = 0;
            c.gridheight = 1;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 3;
            if (tipo == TIPO_PLANO_CONTA) {
                this.add((Component)new JLabel("Plano de Contas"), c);
            } else {
                this.add((Component)new JLabel("Centro de Custo"), c);
            }
            c.gridwidth = 1;
            c.gridx = 3;
            this.add((Component)new JLabel("Percentual"), c);
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)this.textCodigo, c);
            ++c.gridx;
            this.add((Component)this.buttonBusca, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.labelDescricao, c);
            c.weightx = 0.0;
            c.fill = 0;
            ++c.gridx;
            this.add((Component)this.textPercentual, c);
            ++c.gridx;
            this.add((Component)this.buttonOk, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 5;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            this.add((Component)scroll, c);
            c.fill = 0;
            ++c.gridy;
            c.gridx = 3;
            c.gridwidth = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.add((Component)this.labelTotal, c);
        }

        private Double sugerePercentual() {
            if (this.itemApropriacaoAtivo != null) {
                BigDecimal perc = new BigDecimal(100);
                if (this.getTipo() == TIPO_PLANO_CONTA) {
                    if (this.itemApropriacaoAtivo.getArrayPlano() != null) {
                        for (ApropriaPlanoContaBean aux : this.itemApropriacaoAtivo.getArrayPlano()) {
                            if (aux.getPlanoConta().getReduzido() == Integer.parseInt(this.textCodigo.getText())) continue;
                            perc = perc.subtract(BigDecimal.valueOf(aux.getPercentualApropriacao()));
                        }
                    }
                } else if (this.itemApropriacaoAtivo.getArrayCentro() != null) {
                    for (ApropriaCentroCustoBean aux : this.itemApropriacaoAtivo.getArrayCentro()) {
                        if (aux.getCentroCusto().getReduzido() == Integer.parseInt(this.textCodigo.getText())) continue;
                        perc = perc.subtract(BigDecimal.valueOf(aux.getPercentualApropriacao()));
                    }
                }
                perc = perc.setScale(2, RoundingMode.HALF_UP);
                return perc.doubleValue();
            }
            return 0.0;
        }

        public void limpaCampos() {
            this.textCodigo.setText("");
            this.labelDescricao.setText("");
            this.textPercentual.setText("");
            this.labelTotal.setText("Total: 0,00%");
            while (this.table.getModel().getRowCount() > 0) {
                ((DefaultTableModel)this.table.getModel()).removeRow(0);
            }
        }

        public void controlaCampos(boolean isEnabled) {
            this.textCodigo.setEnabled(isEnabled);
            this.textPercentual.setEnabled(isEnabled);
            this.table.setEnabled(isEnabled);
            this.buttonBusca.setEnabled(isEnabled);
            this.buttonOk.setEnabled(isEnabled);
        }

        private void alteraPlanoCentro() {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            int row = this.table.getRowSorter().convertRowIndexToModel(this.table.getSelectedRow());
            this.setPlanoCentroAlterando(true, (AbstractThreadBean)this.table.getModel().getValueAt(row, 4));
        }

        private void setPlanoCentroAlterando(boolean isAlterando, AbstractThreadBean bean) {
            this.isAlterando = isAlterando;
            if (isAlterando) {
                if (bean == null) {
                    return;
                }
                if (this.tipo == TIPO_PLANO_CONTA) {
                    ApropriaPlanoContaBean aux = (ApropriaPlanoContaBean)bean;
                    this.textCodigo.setText(String.valueOf(aux.getPlanoConta().getReduzido()));
                    this.labelDescricao.setText(aux.getPlanoConta().getDescricao());
                    this.textPercentual.setText(String.valueOf(aux.getPercentualApropriacao()));
                    this.textPercentual.selectAll();
                } else {
                    ApropriaCentroCustoBean aux = (ApropriaCentroCustoBean)bean;
                    this.textCodigo.setText(String.valueOf(aux.getCentroCusto().getReduzido()));
                    this.labelDescricao.setText(aux.getCentroCusto().getDescricao());
                    this.textPercentual.setText(String.valueOf(aux.getPercentualApropriacao()));
                    this.textPercentual.selectAll();
                }
                if (this.textPercentual.isFocusable()) {
                    this.textPercentual.grabFocus();
                }
            } else {
                this.textCodigo.setText("");
                this.labelDescricao.setText("");
                this.textPercentual.setText("");
            }
            this.textCodigo.setEnabled(!isAlterando);
        }

        public String getTipoOperacaoPlanos() {
            if (this.tipo == TIPO_PLANO_CONTA) {
                if (this.table.getModel().getRowCount() > 0) {
                    int row = this.table.getRowSorter().convertRowIndexToModel(0);
                    ApropriaPlanoContaBean aux = (ApropriaPlanoContaBean)this.table.getModel().getValueAt(row, 4);
                    if (aux.getPlanoConta().getOperacao() != null) {
                        return aux.getPlanoConta().getOperacao();
                    }
                    return "-1";
                }
            } else {
                return null;
            }
            return null;
        }

        private void removePlanoCentro() {
            if (this.table.getSelectedRow() == -1) {
                return;
            }
            int row = this.table.getRowSorter().convertRowIndexToModel(this.table.getSelectedRow());
            if (this.tipo == TIPO_PLANO_CONTA) {
                ApropriaPlanoContaBean aux = (ApropriaPlanoContaBean)this.table.getModel().getValueAt(row, 4);
                this.itemApropriacaoAtivo.removePlano(aux);
                this.carregaDados(this.itemApropriacaoAtivo);
            } else {
                ApropriaCentroCustoBean aux = (ApropriaCentroCustoBean)this.table.getModel().getValueAt(row, 4);
                this.itemApropriacaoAtivo.removeCentro(aux);
                this.carregaDados(this.itemApropriacaoAtivo);
            }
            ApropriacaoAutomatica.this.treeCredito.repaint();
            ApropriacaoAutomatica.this.treeDebito.repaint();
            if (ApropriacaoAutomatica.this.treeConvenios != null) {
                ApropriacaoAutomatica.this.treeConvenios.repaint();
            }
        }

        private void adicionaPlanoConta() {
            if (this.itemApropriacaoAtivo != null) {
                ApropriaPlanoContaBean bean = null;
                if (this.itemApropriacaoAtivo.getArrayPlano() != null) {
                    for (ApropriaPlanoContaBean aux : this.itemApropriacaoAtivo.getArrayPlano()) {
                        if (aux.getPlanoConta().getReduzido() != Integer.parseInt(this.textCodigo.getText())) continue;
                        BigDecimal perc = new BigDecimal(aux.getPercentualApropriacao());
                        perc = !this.isAlterando ? perc.add(BigDecimal.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())))) : BigDecimal.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())));
                        perc = perc.setScale(2, RoundingMode.HALF_UP);
                        aux.setPercentualApropriacao(perc.doubleValue());
                        if (!this.isAlterando) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "O plano \"" + aux.getPlanoConta().getDescricao() + "\" j\u00e1 foi inserido.\nOs valores ser\u00e3o somados.", 2);
                        }
                        this.itemApropriacaoAtivo.setAlterado(true);
                        bean = aux;
                    }
                }
                if (bean == null) {
                    bean = new ApropriaPlanoContaBean();
                    bean.setCodigoApropriacao(this.itemApropriacaoAtivo.getTipoApropriacao().getTipo());
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    bean.setFilial(filial);
                    bean.setPercentualApropriacao(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())));
                    if (this.itemApropriacaoAtivo instanceof ConvenioApropriacao) {
                        bean.setConvenio(((ConvenioApropriacao)this.itemApropriacaoAtivo).getConvenio());
                    }
                    PlanoContaVO plano = null;
                    try {
                        plano = (PlanoContaVO)new PlanoContaService().getVO(Variaveis.filialPadrao, this.textCodigo.getText());
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ApropriacaoAutomatica:PainelPlanoCentro:adicionaPlanoConta:524");
                    }
                    bean.setPlanoConta(plano);
                    bean.setTipoApropriacao(this.itemApropriacaoAtivo.getTipoDebitoCredito());
                    boolean erro = false;
                    if (plano != null && plano.getOperacao() != null) {
                        if (this.getTipoOperacaoPlanos() != null) {
                            if (plano.getOperacao().equalsIgnoreCase(this.getTipoOperacaoPlanos())) {
                                this.itemApropriacaoAtivo.addPlano(bean);
                            } else {
                                erro = true;
                            }
                        } else {
                            this.itemApropriacaoAtivo.addPlano(bean);
                        }
                    } else {
                        erro = true;
                    }
                    if (erro) {
                        if (plano != null) {
                            Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Plano de Contas: \"" + plano.getDescricao() + "\"\n\u00e9 diferente do tipo de opera\u00e7\u00e3o dos Planos de Contas j\u00e1 inseridos.", 2);
                        } else {
                            Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Plano de Contas \u00e9 diferente do tipo de opera\u00e7\u00e3o dos Planos de Contas j\u00e1 inseridos.", 2);
                        }
                    }
                }
                if (!this.isAlterando && this.insereCentrosCustoAssociados(bean)) {
                    ApropriacaoAutomatica.this.panelCentroCusto.carregaDados(this.itemApropriacaoAtivo);
                }
                this.carregaDados(this.itemApropriacaoAtivo);
                ApropriacaoAutomatica.this.treeCredito.repaint();
                ApropriacaoAutomatica.this.treeDebito.repaint();
                if (ApropriacaoAutomatica.this.treeConvenios != null) {
                    ApropriacaoAutomatica.this.treeConvenios.repaint();
                }
                if (this.textCodigo.isFocusable()) {
                    this.textCodigo.grabFocus();
                }
            }
        }

        private boolean insereCentrosCustoAssociados(ApropriaPlanoContaBean bean) {
            HashSet listaCentros;
            boolean centroInserido = false;
            if (bean == null) {
                return centroInserido;
            }
            PlanoContaVO plano = bean.getPlanoConta();
            if (plano != null && (listaCentros = (HashSet)new CentroCustoPlanoContaService().getBean(bean.getFilial().getCodigo().toString(), bean.getPlanoConta().getReduzido().toString())) != null) {
                for (CentroCustoPlanoContaBean aux : listaCentros) {
                    BigDecimal percNovoCentro = BigDecimal.valueOf(bean.getPercentualApropriacao());
                    percNovoCentro = percNovoCentro.multiply(BigDecimal.valueOf(aux.getPercentual())).divide(BigDecimal.valueOf(100.0));
                    percNovoCentro = percNovoCentro.setScale(2, RoundingMode.HALF_UP);
                    ApropriaCentroCustoBean novoCentro = new ApropriaCentroCustoBean();
                    novoCentro.setCentroCusto(aux.getCentroCusto());
                    novoCentro.setPercentualApropriacao(percNovoCentro.doubleValue());
                    novoCentro.setCodigoApropriacao(bean.getCodigoApropriacao());
                    novoCentro.setFilial(bean.getFilial());
                    novoCentro.setTipoApropriacao(bean.getTipoApropriacao());
                    novoCentro.setConvenio(bean.getConvenio());
                    if (this.itemApropriacaoAtivo instanceof ConvenioApropriacao) {
                        bean.setConvenio(((ConvenioApropriacao)this.itemApropriacaoAtivo).getConvenio());
                    }
                    this.adicionaCentroCusto(novoCentro);
                    centroInserido = true;
                }
            }
            return centroInserido;
        }

        private void adicionaCentroCusto(ApropriaCentroCustoBean beanParam) {
            boolean inserir = true;
            if (this.itemApropriacaoAtivo != null) {
                ApropriaCentroCustoBean bean = beanParam;
                if (this.itemApropriacaoAtivo.getArrayCentro() != null) {
                    for (ApropriaCentroCustoBean aux : this.itemApropriacaoAtivo.getArrayCentro()) {
                        if ((bean != null || aux.getCentroCusto().getReduzido() != Integer.parseInt(this.textCodigo.getText())) && (bean == null || aux.getCentroCusto().getReduzido().intValue() != bean.getCentroCusto().getReduzido().intValue())) continue;
                        BigDecimal perc = BigDecimal.valueOf(aux.getPercentualApropriacao());
                        perc = bean == null ? (!this.isAlterando ? perc.add(BigDecimal.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())))) : BigDecimal.valueOf(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())))) : perc.add(BigDecimal.valueOf(bean.getPercentualApropriacao()));
                        perc = perc.setScale(2, RoundingMode.HALF_UP);
                        aux.setPercentualApropriacao(perc.doubleValue());
                        if (!this.isAlterando) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "O centro \"" + aux.getCentroCusto().getDescricao() + "\" j\u00e1 foi inserido.\nOs valores ser\u00e3o somados.", 2);
                        }
                        this.itemApropriacaoAtivo.setAlterado(true);
                        inserir = false;
                        bean = aux;
                    }
                }
                if (bean == null) {
                    bean = new ApropriaCentroCustoBean();
                    bean.setCodigoApropriacao(this.itemApropriacaoAtivo.getTipoApropriacao().getTipo());
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    bean.setFilial(filial);
                    bean.setPercentualApropriacao(Double.parseDouble(Funcoes.limpaDecimal(this.textPercentual.getText())));
                    if (this.itemApropriacaoAtivo instanceof ConvenioApropriacao) {
                        bean.setConvenio(((ConvenioApropriacao)this.itemApropriacaoAtivo).getConvenio());
                    }
                    CentroCustoVO centro = null;
                    try {
                        centro = (CentroCustoVO)new CentroCustoService().getVO(Variaveis.filialPadrao, this.textCodigo.getText());
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ApropriacaoAutomatica:PainelPlanoCentro:adicionaCentroCusto:548");
                    }
                    bean.setCentroCusto(centro);
                    bean.setTipoApropriacao(this.itemApropriacaoAtivo.getTipoDebitoCredito());
                    if (centro != null && (ApropriacaoAutomatica.this.panelPlanoConta.getTipoOperacaoPlanos() == null || ApropriacaoAutomatica.this.panelPlanoConta.getTipoOperacaoPlanos().equalsIgnoreCase(centro.getOperacao()))) {
                        this.itemApropriacaoAtivo.addCentro(bean);
                    } else if (centro != null) {
                        Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Centro de Custo: \"" + centro.getDescricao() + "\"\n\u00e9 diferente do tipo da opera\u00e7\u00e3o dos Planos de Conta.", 2);
                    } else {
                        Funcoes.mensagem(this, "O tipo de opera\u00e7\u00e3o do Centro de Custo \u00e9 diferente do tipo da opera\u00e7\u00e3o dos Planos de Conta.", 2);
                    }
                } else if (inserir) {
                    this.itemApropriacaoAtivo.addCentro(bean);
                }
                this.carregaDados(this.itemApropriacaoAtivo);
                ApropriacaoAutomatica.this.treeCredito.repaint();
                ApropriacaoAutomatica.this.treeDebito.repaint();
                if (ApropriacaoAutomatica.this.treeConvenios != null) {
                    ApropriacaoAutomatica.this.treeConvenios.repaint();
                }
                if (this.textCodigo.isFocusable()) {
                    this.textCodigo.grabFocus();
                }
            }
        }

        public int getTipo() {
            return this.tipo;
        }

        public void carregaDados(ItemApropriacao item) {
            if (item == null) {
                return;
            }
            this.itemApropriacaoAtivo = item;
            if (ApropriacaoAutomatica.this.getStatus() == 2) {
                this.setPlanoCentroAlterando(false, null);
            }
            this.table.setName("table");
            while (this.table.getModel().getRowCount() > 0) {
                ((DefaultTableModel)this.table.getModel()).removeRow(0);
            }
            this.textCodigo.setText("");
            this.textCodigo.setName("textCodigo");
            this.labelDescricao.setText("");
            this.textPercentual.setText("");
            this.textPercentual.setName("textPercentual");
            if (this.tipo == TIPO_PLANO_CONTA) {
                this.setTotal(item.getPercentualUsadoPlano());
                ArrayList<ApropriaPlanoContaBean> aux = item.getArrayPlano();
                if (aux != null) {
                    for (ApropriaPlanoContaBean aproPlano : aux) {
                        PlanoContaVO plano = aproPlano.getPlanoConta();
                        if (plano == null) continue;
                        Object[] linha = new Object[]{plano.getReduzido(), plano.getDescricao(), plano.getConta(), Funcoes.formataDecimal(aproPlano.getPercentualApropriacao()), aproPlano};
                        ((DefaultTableModel)this.table.getModel()).addRow(linha);
                    }
                }
            } else {
                this.setTotal(item.getPercentualUsadoCentro());
                ArrayList<ApropriaCentroCustoBean> aux = item.getArrayCentro();
                if (aux != null) {
                    for (ApropriaCentroCustoBean aproCentro : aux) {
                        CentroCustoVO centro = aproCentro.getCentroCusto();
                        if (centro == null) continue;
                        Object[] linha = new Object[]{centro.getReduzido(), centro.getDescricao(), centro.getConta(), Funcoes.formataDecimal(aproCentro.getPercentualApropriacao()), aproCentro};
                        ((DefaultTableModel)this.table.getModel()).addRow(linha);
                    }
                }
            }
            this.table.getRowSorter().allRowsChanged();
        }

        private void setTotal(Double perc) {
            this.labelTotal.setText("Total: " + Funcoes.formataDecimal(perc) + "%");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buscaPlanoConta(String codigo) {
            boolean focoCodigo = false;
            try {
                this.textCodigo.setText("");
                this.textCodigo.setName("textCodigo");
                this.labelDescricao.setText("");
                PlanoContaVO plano = null;
                if (codigo == null) {
                    plano = (PlanoContaVO)new PlanoContaService().pesquisaVO(this.getTopLevelAncestor(), new PlanoContaVO(), "Pesquisando planos de conta", true);
                    focoCodigo = true;
                } else {
                    plano = (PlanoContaVO)new PlanoContaService().getVO(Variaveis.filialPadrao, codigo);
                }
                if (plano != null) {
                    this.textCodigo.setText(plano.getReduzido().toString());
                    this.labelDescricao.setText(plano.getDescricao());
                } else {
                    this.labelDescricao.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ApropriacaoAutomatica:PainelPlanoCentro:buscaPlanoConta:553");
            }
            finally {
                if (focoCodigo && this.textCodigo.isFocusable()) {
                    this.textCodigo.grabFocus();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buscaCentroCusto(String codigo) {
            boolean focoCodigo = false;
            try {
                this.textCodigo.setText("");
                this.labelDescricao.setText("");
                CentroCustoVO centro = null;
                if (codigo == null) {
                    centro = (CentroCustoVO)new CentroCustoService().pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando centros de custo", true);
                    focoCodigo = true;
                } else {
                    centro = (CentroCustoVO)new CentroCustoService().getVO(Variaveis.filialPadrao, codigo);
                }
                if (centro != null) {
                    this.textCodigo.setText(centro.getReduzido().toString());
                    this.labelDescricao.setText(centro.getDescricao());
                } else {
                    this.labelDescricao.setText("N\u00e3o cadastrado");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ApropriacaoAutomatica:PainelPlanoCentro:buscaCentroCusto:575");
            }
            finally {
                if (focoCodigo && this.textCodigo.isFocusable()) {
                    this.textCodigo.grabFocus();
                }
            }
        }
    }
}

