/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.service.cadastro.exame.ExameMatColetaLabExternoService;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

class ApresentarBotaoEditor
extends JLabel
implements TableCellRenderer,
TableCellEditor {
    private ExameMatColetaVO selecionado = null;
    private JTable tabela;
    private int codigoLabExterno;
    private final int COLUNA_BLOQUEADO = 4;
    private final int COLUNA_OBJETO = 5;

    public ApresentarBotaoEditor(JTable table, int codigoLabExterno) {
        this.setOpaque(true);
        this.tabela = table;
        this.codigoLabExterno = codigoLabExterno;
        JButton button = new JButton(this.getText());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ApresentarBotaoEditor.this.selecionado != null) {
                    int linha = ApresentarBotaoEditor.this.tabela.getSelectedRow();
                    boolean valorAtual = (Boolean)ApresentarBotaoEditor.this.tabela.getModel().getValueAt(linha, 4);
                    Boolean novoValor = new Boolean(!valorAtual);
                    ApresentarBotaoEditor.this.tabela.getModel().setValueAt(novoValor, linha, 4);
                    ApresentarBotaoEditor.this.definirBloqueado(ApresentarBotaoEditor.this.selecionado, novoValor);
                    ApresentarBotaoEditor.this.mudarTexto(novoValor);
                }
            }
        });
        this.setLayout(new BorderLayout());
        button.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)button, "Center");
    }

    private void mudarTexto(Boolean value) {
        boolean desbloquear = value != null && value != false;
        JButton button = this.pegaBotao(this);
        if (button != null) {
            button.setText(desbloquear ? "Desbloquear" : "Bloquear");
        }
    }

    private JButton pegaBotao(JLabel label) {
        JButton retorno = null;
        if (label.getComponentCount() > 0) {
            for (int i = 0; i < label.getComponentCount(); ++i) {
                if (!(label.getComponent(i) instanceof JButton)) continue;
                retorno = (JButton)label.getComponent(i);
            }
        }
        return retorno;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.mudarTexto((Boolean)value);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.mudarTexto((Boolean)value);
        Object tmp = table.getModel().getValueAt(row, 5);
        this.selecionado = tmp != null && tmp instanceof ExameMatColetaVO ? (ExameMatColetaVO)tmp : null;
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener arg0) {
    }

    @Override
    @Deprecated
    public void cancelCellEditing() {
    }

    @Override
    @Deprecated
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject arg0) {
        return true;
    }

    @Override
    @Deprecated
    public void removeCellEditorListener(CellEditorListener arg0) {
    }

    @Override
    public boolean shouldSelectCell(EventObject arg0) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    private void definirBloqueado(ExameMatColetaVO exameMaterial, boolean situacao) {
        String filiaisAutoCopia = ParametrosGerais.getCopiaExame();
        ExameMatColetaLabExternoService serviceExameMaterialLabExterno = new ExameMatColetaLabExternoService();
        try {
            serviceExameMaterialLabExterno.setMudarSituacaoBloqueadoLaboratorioExterno(exameMaterial, this.codigoLabExterno, situacao, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "Erro ao alterar a situa\u00e7\u00e3o do exame.\n" + e.getMessage(), e.getStackTrace());
            return;
        }
    }
}

