/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.SolicitarPercentual;
import jalis.laboratorio.cadastro.tabelaPreco.TabelaPrecoUtil;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

class AlterarPrecosCBHPMMetodologia
extends JDialog
implements ActionListener {
    private final int COLUNA_CODIGO_EXAME = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO_EXAME = 2;
    private final int COLUNA_DESCRICAO_METODOLOGIA = 3;
    private final int COLUNA_CODIGO_CBHPM = 4;
    private final int COLUNA_PERCENTUAL = 5;
    private final int COLUNA_PORTE = 6;
    private final int COLUNA_CUSTO = 7;
    private final int COLUNA_TOTAL = 8;
    private final int COLUNA_PROIBIR = 9;
    private final int COLUNA_ADICIONAR = 10;
    private final int COLUNA_CODIGO_METODOLOGIA = 11;
    private int CASAS = 4;
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonAlterar = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonLimpaAMB = ComponenteFactory.novoJButton("Limpar C\u00f3digos", this);
    private JButton buttonLimpaValor = ComponenteFactory.novoJButton("Limpar Valores", this);
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("Atualizar exames", this);
    private JButton buttonProibirTodos = ComponenteFactory.novoJButton("Proibir todos", this);
    private JButton buttonLimparProibidos = ComponenteFactory.novoJButton("Limpar proibidos", this);
    private JButton buttonAtualizarPrecoAumentar = ComponenteFactory.novoJButton("Aumentar percentual", this);
    private JButton buttonAtualizarPrecoDiminuir = ComponenteFactory.novoJButton("Diminuir percentual", this);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Metodologia", "C\u00f3digo", "%", "Porte", "Custo", "Total", "Proibir"}){

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return String.class;
                }
                case 7: {
                    return String.class;
                }
                case 8: {
                    return String.class;
                }
                case 9: {
                    return Boolean.class;
                }
                case 10: {
                    return Boolean.class;
                }
                case 11: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            AlterarPrecosCBHPMMetodologia.this.modelo.setValueAt(true, row, 10);
            return col == 9;
        }
    };
    private JTable tableExames = new JTable(this.modelo);
    private JLabel labelCodigo = new JLabel("C\u00f3digo");
    private JLabel labelMaterial = new JLabel("Mat.");
    private JLabel labelExame = new JLabel("Exame");
    private JLabel labelMetodologia = new JLabel("Metodologia");
    private JLabel labelCodigoCBHPM = new JLabel("C\u00f3d. CBHPM");
    private JLabel labelPercentual = new JLabel("Percentual");
    private JLabel labelPorte = new JLabel("Porte");
    private JLabel labelCusto = new JLabel("Custo");
    private JLabel labelUCO = new JLabel("UCO");
    private JLabel labelTotal = new JLabel("Total");
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelVlrMaterial = new JLabel();
    private JLabel labelVlrExame = new JLabel();
    private JLabel labelVlrMetodologia = new JLabel();
    private JLabel labelVlrUCO = new JLabel();
    private JLabel labelVlrTotal = new JLabel();
    private JLabel labelLocalizar = new JLabel("Localizar:");
    private TTextField textCodigoCBHPM = new TTextField(14, 19);
    private TTextField textPercentual = new TTextField(8, 2, 3);
    private TTextField textCusto = new TTextField(8, 2, 3);
    private TTextField textLocalizar = ComponenteFactory.novoTTextField(100, 3, new Dimension(70, 20), new Dimension(70, 20), null, null, null);
    private JComboBox comboPorte = new JComboBox();
    private JCheckBox checkIgnorarMaterial = ComponenteFactory.novoJCheckBox("Alterar o pre\u00e7o ignorando material", 'x');
    private JCheckBox checkIgnorarMetodologia = ComponenteFactory.novoJCheckBox("Alterar pre\u00e7o ignorando metodologia", 'l');
    private JPanel panelLocalizar = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new GridLayout(2, 3));
    private JPanel panelBotoesJanela = new JPanel(new BorderLayout());
    private boolean ok = false;
    private int codigoTabela = -1;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosCBHPMMetodologia novaInstancia(Window owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosCBHPMMetodologia((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosCBHPMMetodologia((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosCBHPMMetodologia(Frame owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public AlterarPrecosCBHPMMetodologia(Dialog owner) {
        super(owner, "Alterar pre\u00e7os de exames");
        this.montaTela();
    }

    public void setTabela(int codigoTabela) {
        this.codigoTabela = codigoTabela;
        this.buscaDados();
    }

    public void setPortes(ArrayList<PorteTabelaCBHPM> portes) {
        this.comboPorte.removeAllItems();
        for (PorteTabelaCBHPM p : portes) {
            this.comboPorte.addItem(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        if (this.codigoTabela == -1) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select dtm.exa_codigo ");
        buf.append("       ,dtm.mco_codigo ");
        buf.append("       ,dtm.dtm_proibido ");
        buf.append("       ,COALESCE(dtm.dtm_valor, 0) as dtm_valor ");
        buf.append("       ,dtm.dtm_codamb ");
        buf.append("       ,COALESCE(dtm.dtm_percentual, 0) as dtm_percentual ");
        buf.append("       ,dtm.tpp_porte ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,COALESCE(tpp.tpp_valor, 0) as tpp_valor ");
        buf.append("       ,COALESCE(tpe.tpe_uco, 0) as tpe_uco ");
        buf.append("       ,met.met_codigo ");
        buf.append("       ,met.met_descricao ");
        buf.append("   from detalhetabelaprecometodologia dtm ");
        buf.append("   join exames exa on dtm.fil_codigo = exa.fil_codigo and dtm.exa_codigo = exa.exa_codigo ");
        buf.append("   left join tabelaprecoexamesporte tpp on dtm.fil_codigo = tpp.fil_codigo and dtm.tpe_codigo = tpp.tpe_codigo and dtm.tpp_porte = tpp.tpp_porte ");
        buf.append("   join tabelaprecoexames tpe on dtm.fil_codigo = tpe.fil_codigo and dtm.tpe_codigo = tpe.tpe_codigo ");
        buf.append("   join metodologia met on dtm.fil_codigo = met.fil_codigo and dtm.met_codigo = met.met_codigo ");
        buf.append("  where dtm.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and dtm.tpe_codigo = ").append(this.codigoTabela);
        buf.append("  order by dtm.exa_codigo ");
        buf.append("          ,dtm.mco_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modelo.clear();
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                material.setShowAbreviatura(true);
                PorteTabelaCBHPM porte = new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor"));
                double total = TabelaPrecoUtil.calculaTotalExameTipoCBHPM(rs.getString("dtm_percentual"), rs.getString("dtm_valor"), rs.getString("tpe_uco"), porte);
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), rs.getString("met_descricao"), DBUtil.campoNull(rs.getString("dtm_codamb")) ? "" : rs.getString("dtm_codamb"), DBUtil.campoNull(rs.getString("dtm_percentual")) ? "" : Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), rs.getDouble("dtm_percentual")), rs.getString("tpp_porte"), DBUtil.campoNull(rs.getString("dtm_valor")) ? "" : Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), rs.getDouble("dtm_valor")), Funcoes.formataDecimal(total), rs.getBoolean("dtm_proibido"), false, rs.getInt("met_codigo")});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private PorteTabelaCBHPM pegaPorte(String porte) {
        for (int i = 0; i < this.comboPorte.getItemCount(); ++i) {
            PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getItemAt(i);
            if (!p.getPorte().equalsIgnoreCase(porte)) continue;
            return p;
        }
        return null;
    }

    public void setPrecos(ArrayList<PrecosAlterados> precos) {
        for (PrecosAlterados p : precos) {
            PorteTabelaCBHPM porte = this.pegaPorte(p.getPorte());
            BigDecimal valorUCO = new BigDecimal(Funcoes.isNumeric(this.labelVlrUCO.getText()) ? Funcoes.limpaDecimal(this.labelVlrUCO.getText()) : "0").setScale(this.CASAS, this.ROUND);
            BigDecimal total = new BigDecimal(String.valueOf(p.getPercentual())).setScale(this.CASAS, this.ROUND).multiply(new BigDecimal(porte != null ? String.valueOf(porte.getValor()) : "0").setScale(this.CASAS, this.ROUND));
            total = total.add(new BigDecimal(String.valueOf(p.getValorCusto())).setScale(this.CASAS, this.ROUND).multiply(valorUCO));
            this.modelo.addLine(new Object[]{p.getCodigoExame(), p.getMaterial(), p.getDescricaoExame(), p.getDescricaoMetodologia(), p.getCodigoAMB(), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), p.getPercentual()), p.getPorte(), Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), p.getValorCusto()), Funcoes.formataDecimal(total.doubleValue()), p.isProibido(), p.isInserindoExame(), p.getCodigoMetodologia()});
        }
    }

    public ArrayList<PrecosAlterados> getPrecosAlterados() {
        ArrayList<PrecosAlterados> precos = new ArrayList<PrecosAlterados>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String codigoExame = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial material = (DadosMaterial)this.modelo.getValueAt(i, 1);
            String descricaoExame = this.modelo.getValueAt(i, 2).toString();
            String cbhpm = this.modelo.getValueAt(i, 4) == null ? null : this.modelo.getValueAt(i, 4).toString();
            Double custo = this.modelo.getValueAt(i, 7) != null && Funcoes.isNumeric(this.modelo.getValueAt(i, 7).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 7).toString())) : 0.0;
            Double percentual = this.modelo.getValueAt(i, 5) != null && Funcoes.isNumeric(this.modelo.getValueAt(i, 5).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 5).toString())) : 0.0;
            String porte = this.modelo.getValueAt(i, 6) != null ? this.modelo.getValueAt(i, 6).toString() : "";
            Boolean proibir = (Boolean)this.modelo.getValueAt(i, 9);
            Boolean adicionar = (Boolean)this.modelo.getValueAt(i, 10);
            Integer codigoMetodologia = this.modelo.getValueAt(i, 11) == null ? null : (Integer)this.modelo.getValueAt(i, 11);
            String descricaoMetodologia = this.modelo.getValueAt(i, 3) == null ? null : this.modelo.getValueAt(i, 3).toString();
            precos.add(new PrecosAlterados(codigoExame, material, descricaoExame, cbhpm, custo, percentual, porte, proibir, adicionar, codigoMetodologia, descricaoMetodologia));
        }
        return precos;
    }

    private void montaTela() {
        this.tableExames.setToolTipText("F2 - Pesquisa avan\u00e7ada");
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosCBHPMMetodologia.this.modelo.mouseClicked(e);
                AlterarPrecosCBHPMMetodologia.this.colunaOrdenada = AlterarPrecosCBHPMMetodologia.this.tableExames.getColumnModel().getColumnIndexAtX(e.getX());
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        this.setModal(true);
        this.setSize(new Dimension(800, 550));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelVlrCodigo, this.labelVlrMaterial, this.labelVlrExame, this.labelVlrTotal, this.labelVlrUCO, this.labelVlrMetodologia}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 1);
        panelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelMaterial, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelExame, c);
        ++c.gridy;
        c.gridx = 0;
        this.labelVlrCodigo.setMinimumSize(new Dimension(70, 20));
        this.labelVlrCodigo.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.labelVlrCodigo, c);
        ++c.gridx;
        this.labelVlrMaterial.setMinimumSize(new Dimension(40, 20));
        this.labelVlrMaterial.setPreferredSize(new Dimension(40, 20));
        panelCentral.add((Component)this.labelVlrMaterial, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 7;
        c.fill = 2;
        this.labelVlrExame.setMinimumSize(new Dimension(20, 20));
        this.labelVlrExame.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelVlrExame, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        panelCentral.add((Component)this.labelMetodologia, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelCodigoCBHPM.setDisplayedMnemonic('B');
        this.labelCodigoCBHPM.setLabelFor(this.textCodigoCBHPM);
        panelCentral.add((Component)this.labelCodigoCBHPM, c);
        ++c.gridx;
        this.labelPercentual.setDisplayedMnemonic('n');
        this.labelPercentual.setLabelFor(this.textPercentual);
        panelCentral.add((Component)this.labelPercentual, c);
        ++c.gridx;
        this.labelPorte.setDisplayedMnemonic('e');
        this.labelPorte.setLabelFor(this.comboPorte);
        panelCentral.add((Component)this.labelPorte, c);
        ++c.gridx;
        this.labelCusto.setDisplayedMnemonic('s');
        this.labelCusto.setLabelFor(this.textCusto);
        panelCentral.add((Component)this.labelCusto, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelUCO, c);
        ++c.gridx;
        panelCentral.add((Component)this.labelTotal, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.fill = 2;
        this.labelVlrMetodologia.setMinimumSize(new Dimension(20, 20));
        this.labelVlrMetodologia.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelVlrMetodologia, c);
        c.gridx += 3;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.textCodigoCBHPM.setPreferredSize(new Dimension(120, 20));
        this.textCodigoCBHPM.setMinimumSize(new Dimension(120, 20));
        panelCentral.add((Component)this.textCodigoCBHPM, c);
        ++c.gridx;
        this.textPercentual.setPreferredSize(new Dimension(70, 20));
        this.textPercentual.setMinimumSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textPercentual, c);
        ++c.gridx;
        this.comboPorte.setPreferredSize(new Dimension(50, 20));
        this.comboPorte.setMinimumSize(new Dimension(50, 20));
        panelCentral.add((Component)this.comboPorte, c);
        ++c.gridx;
        this.textCusto.setPreferredSize(new Dimension(75, 20));
        this.textCusto.setMinimumSize(new Dimension(75, 20));
        panelCentral.add((Component)this.textCusto, c);
        ++c.gridx;
        this.labelVlrUCO.setPreferredSize(new Dimension(75, 20));
        this.labelVlrUCO.setMinimumSize(new Dimension(75, 20));
        panelCentral.add((Component)this.labelVlrUCO, c);
        ++c.gridx;
        this.labelVlrTotal.setPreferredSize(new Dimension(75, 20));
        this.labelVlrTotal.setMinimumSize(new Dimension(75, 20));
        panelCentral.add((Component)this.labelVlrTotal, c);
        ++c.gridx;
        this.buttonAlterar.setPreferredSize(new Dimension(40, 20));
        this.buttonAlterar.setMinimumSize(new Dimension(40, 20));
        this.buttonAlterar.setMnemonic('K');
        panelCentral.add((Component)this.buttonAlterar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelLocalizar.add((Component)this.labelLocalizar, "West");
        this.panelLocalizar.add((Component)this.textLocalizar, "Center");
        this.labelLocalizar.setDisplayedMnemonic('L');
        this.labelLocalizar.setLabelFor(this.textLocalizar);
        panelCentral.add((Component)this.panelLocalizar, c);
        ++c.gridy;
        this.buttonAtualizar.setMnemonic('t');
        this.panelBotoes.add(this.buttonAtualizar);
        this.buttonLimpaAMB.setMnemonic('i');
        this.panelBotoes.add(this.buttonLimpaAMB);
        this.buttonLimpaValor.setMnemonic('r');
        this.panelBotoes.add(this.buttonLimpaValor);
        this.buttonProibirTodos.setMnemonic('P');
        this.panelBotoes.add(this.buttonProibirTodos);
        this.buttonLimparProibidos.setMnemonic('m');
        this.panelBotoes.add(this.buttonLimparProibidos);
        this.buttonAtualizarPrecoAumentar.setMnemonic('u');
        this.panelBotoes.add(this.buttonAtualizarPrecoAumentar);
        ++c.gridy;
        this.buttonAtualizarPrecoDiminuir.setMnemonic('d');
        this.panelBotoes.add(this.buttonAtualizarPrecoDiminuir);
        panelCentral.add((Component)this.panelBotoes, c);
        ++c.gridy;
        JPanel esquerda = new JPanel(new FlowLayout(0));
        esquerda.add(this.checkIgnorarMaterial);
        esquerda.add(this.checkIgnorarMetodologia);
        this.panelBotoesJanela.add((Component)esquerda, "West");
        JPanel direita = new JPanel(new FlowLayout(2));
        direita.add(this.buttonOK);
        direita.add(this.buttonCancelar);
        this.panelBotoesJanela.add((Component)direita, "East");
        panelCentral.add((Component)this.panelBotoesJanela, c);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 140, 105, 60, 40, 70, 70, 40}, this.tableExames);
        this.tableExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AlterarPrecosCBHPMMetodologia.this.tableExames.getSelectedColumn() < 9) {
                    AlterarPrecosCBHPMMetodologia.this.alterarLinha(AlterarPrecosCBHPMMetodologia.this.tableExames.getSelectedRow());
                }
            }
        });
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosCBHPMMetodologia.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosCBHPMMetodologia.this.alterarLinha(AlterarPrecosCBHPMMetodologia.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 113) {
                    AlterarPrecosCBHPMMetodologia.this.pesquisaAvancada();
                }
            }
        });
        this.textLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosCBHPMMetodologia.this.pesquisaAvancada();
                } else {
                    int pos = AlterarPrecosCBHPMMetodologia.this.modelo.localizarParcial(AlterarPrecosCBHPMMetodologia.this.colunaOrdenada, AlterarPrecosCBHPMMetodologia.this.textLocalizar.getText() + (Funcoes.textoVazio(String.valueOf(e.getKeyChar())) ? "" : String.valueOf(e.getKeyChar())));
                    if (pos > -1) {
                        AlterarPrecosCBHPMMetodologia.this.tableExames.setRowSelectionInterval(pos, pos);
                        AlterarPrecosCBHPMMetodologia.this.tableExames.scrollRectToVisible(AlterarPrecosCBHPMMetodologia.this.tableExames.getCellRect(pos, 0, true));
                    }
                }
            }
        });
        this.textPercentual.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPMMetodologia.this.textPercentual.selectAll();
            }
        });
        this.textCusto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPMMetodologia.this.textCusto.selectAll();
            }
        });
        this.textPercentual.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AlterarPrecosCBHPMMetodologia.this.mostraTotal();
            }
        });
        this.textCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AlterarPrecosCBHPMMetodologia.this.mostraTotal();
            }
        });
        this.comboPorte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarPrecosCBHPMMetodologia.this.mostraTotal();
            }
        });
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigoCBHPM);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    private void pesquisaAvancada() {
        Hashtable resultado = Pesquisas.exameAMB(this, false, false);
        if (resultado != null) {
            String codigo = resultado.get("exa_codigo").toString();
            this.modelo.ordenarColuna(0);
            int pos = this.modelo.localizar(0, codigo);
            if (pos > -1) {
                this.tableExames.setRowSelectionInterval(pos, pos);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(pos, 0, true));
            }
        }
    }

    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAlterar) {
            this.alterarPreco();
        } else if (e.getSource() == this.buttonLimpaAMB) {
            this.limpaValores(new int[]{4}, "C\u00f3digos");
        } else if (e.getSource() == this.buttonLimpaValor) {
            this.limpaValores(new int[]{7, 5, 6, 8}, "Percentuais/Portes/Custos");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.atualizar();
        } else if (e.getSource() == this.buttonProibirTodos) {
            if (Funcoes.mensagem(this, "Confirma a proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt(true, i, 9);
                    this.modelo.setValueAt(true, i, 10);
                }
            }
        } else if (e.getSource() == this.buttonLimparProibidos) {
            if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o da proibi\u00e7\u00e3o de todos os exames?", 4) == 0) {
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    this.modelo.setValueAt(false, i, 9);
                    this.modelo.setValueAt(true, i, 10);
                }
            }
        } else if (e.getSource() == this.buttonAtualizarPrecoAumentar || e.getSource() == this.buttonAtualizarPrecoDiminuir) {
            boolean isDiminuirPercentual = e.getSource() == this.buttonAtualizarPrecoDiminuir;
            SolicitarPercentual sp = SolicitarPercentual.novaInstancia(this);
            if (sp != null) {
                sp.setApenasExamesSelecionados(this.tableExames.getSelectedRowCount() > 1);
                sp.setVisible(true);
                if (sp.ok() && sp.getPercentual() > 0.0) {
                    int[] linhas = new int[this.modelo.getRowCount()];
                    if (sp.isApenasExamesSelecionados() && this.tableExames.getSelectedRowCount() > 0) {
                        linhas = this.tableExames.getSelectedRows();
                    } else {
                        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                            linhas[i] = i;
                        }
                    }
                    for (int i : linhas) {
                        if (Funcoes.textoVazio(this.modelo.getValueAt(i, 7).toString()) || !Funcoes.isNumeric(this.modelo.getValueAt(i, 7).toString())) continue;
                        BigDecimal valorAtual = new BigDecimal(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 7).toString())).setScale(this.CASAS, this.ROUND);
                        BigDecimal valor = Funcoes.calculaPercentual(sp.getPercentual(), valorAtual.doubleValue(), sp.isArredondarCentavos(), isDiminuirPercentual, this.CASAS);
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), valor.doubleValue()), i, 7);
                        String percentual = this.modelo.getValueAt(i, 5).toString();
                        String custo = this.modelo.getValueAt(i, 7).toString();
                        String porte = this.modelo.getValueAt(i, 6) != null ? this.modelo.getValueAt(i, 6).toString() : "";
                        this.modelo.setValueAt(Funcoes.formataDecimal(this.calculaTotalExame(percentual, custo, this.labelVlrUCO.getText(), porte)), i, 8);
                        this.modelo.setValueAt(true, i, 10);
                    }
                }
            }
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizar() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select exa.exa_codigo ");
        buf.append("       ,emc.mco_codigo ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,elm.met_codigo ");
        buf.append("       ,met.met_descricao ");
        buf.append("       ,COALESCE(dtp.dtp_percentual, 0) as dtp_percentual ");
        buf.append("       ,dtp.tpp_porte ");
        buf.append("       ,COALESCE(dtp.dtp_valor, 0) as dtp_valor ");
        buf.append("       ,dtp.dtp_codamb ");
        buf.append("       ,COALESCE(tpp.tpp_valor, 0) as tpp_valor ");
        buf.append("       ,COALESCE(tpe.tpe_uco, 0) as tpe_uco ");
        buf.append("       ,COALESCE(dtp.dtp_proibido, false) as dtp_proibido ");
        buf.append("   from exames exa ");
        buf.append("   join examematcoleta emc on exa.fil_codigo = emc.fil_codigo and exa.exa_codigo = emc.exa_codigo ");
        buf.append("   join examelayoutmetodo elm on exa.fil_codigo = elm.fil_codigo and exa.exa_codigo = elm.exa_codigo and emc.mco_codigo = elm.mco_codigo ");
        buf.append("   join metodologia met on elm.fil_codigo = met.fil_codigo and elm.met_codigo = met.met_codigo ");
        buf.append("   left join detalhetabelapreco dtp on emc.fil_codigo = dtp.fil_codigo and emc.exa_codigo = dtp.exa_codigo and emc.mco_codigo = dtp.mco_codigo and dtp.tpe_codigo = ").append(this.codigoTabela);
        buf.append("   left join tabelaprecoexamesporte tpp on dtp.fil_codigo = tpp.fil_codigo and dtp.tpe_codigo = tpp.tpe_codigo and dtp.tpp_porte = tpp.tpp_porte ");
        buf.append("   left join tabelaprecoexames tpe on dtp.fil_codigo = tpe.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo ");
        buf.append("  where exa.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("  order by exa.exa_codigo ");
        buf.append("          ,emc.mco_codigo ");
        buf.append("          ,met.met_descricao ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                DadosMaterial material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rs.getInt("mco_codigo"));
                Integer codigoMetodologia = rs.getInt("met_codigo");
                if (material == null) continue;
                material.setShowAbreviatura(true);
                if (this.achaExame(rs.getString("exa_codigo"), material, codigoMetodologia)) continue;
                BigDecimal total = rs.getBigDecimal("dtp_percentual").setScale(this.CASAS, this.ROUND).multiply(rs.getBigDecimal("tpp_valor").setScale(this.CASAS, this.ROUND));
                total = total.add(rs.getBigDecimal("dtp_valor").setScale(this.CASAS, this.ROUND).multiply(rs.getBigDecimal("tpe_uco").setScale(this.CASAS, this.ROUND)));
                this.modelo.addLine(new Object[]{rs.getString("exa_codigo"), material, rs.getString("exa_descricao"), rs.getString("met_descricao"), rs.getString("dtp_codamb"), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), rs.getDouble("dtp_percentual")), rs.getString("tpp_porte"), Funcoes.formataDecimal(rs.getDouble("dtp_valor")), Funcoes.formataDecimal(total.doubleValue()), rs.getBoolean("dtp_proibido"), true, rs.getInt("met_codigo")});
            }
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.getColunaOrdenacao());
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                this.modelo.setValueAt(true, i, 10);
            }
            Funcoes.mensagem(this, "A atualiza\u00e7\u00e3o de pre\u00e7os dos exames foi conclu\u00edda com sucesso.", 5);
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean achaExame(String exame, DadosMaterial material, int metodologia) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String exameAux = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial materialAux = (DadosMaterial)this.modelo.getValueAt(i, 1);
            int metodologiaAux = (Integer)this.modelo.getValueAt(i, 11);
            if (!exameAux.equalsIgnoreCase(exame) || materialAux.getCodigo() != material.getCodigo() || metodologiaAux != metodologia) continue;
            return true;
        }
        return false;
    }

    private void limpaValores(int[] colunas, String textoLimpar) {
        if (Funcoes.mensagem(this, "Confirma a remo\u00e7\u00e3o dos valores da coluna " + textoLimpar + "?", 4) == 0) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                for (int c : colunas) {
                    if (c >= this.modelo.getColumnCount()) continue;
                    this.modelo.setValueAt("", i, c);
                }
                this.modelo.setValueAt(true, i, 10);
            }
        }
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            String porte;
            this.labelVlrCodigo.setText((String)this.modelo.getValueAt(linha, 0));
            this.labelVlrMaterial.setText(((DadosMaterial)this.modelo.getValueAt(linha, 1)).getAbreviatura());
            this.labelVlrExame.setText((String)this.modelo.getValueAt(linha, 2));
            this.labelVlrMetodologia.setText((String)this.modelo.getValueAt(linha, 3));
            this.textCodigoCBHPM.setText((String)this.modelo.getValueAt(linha, 4));
            this.textPercentual.setText((String)this.modelo.getValueAt(linha, 5));
            String string = porte = this.modelo.getValueAt(linha, 6) != null ? this.modelo.getValueAt(linha, 6).toString() : "";
            if (!Funcoes.textoVazio(porte)) {
                this.comboPorte.setSelectedItem(porte);
            }
            this.textCusto.setText(this.modelo.getValueAt(linha, 7).toString());
            this.labelVlrTotal.setText(this.modelo.getValueAt(linha, 8).toString());
            this.linhaAlterada = linha;
            ScreenUtil.requisitarFoco(this.textCodigoCBHPM);
        }
    }

    private void mostraTotal() {
        PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getSelectedItem();
        this.labelVlrTotal.setText(Funcoes.formataDecimal(TabelaPrecoUtil.calculaTotalExameTipoCBHPM(this.textPercentual.getText(), this.textCusto.getText(), this.labelVlrUCO.getText(), p)));
    }

    private double calculaTotalExame(String percentual, String custo, String uco, String porte) {
        PorteTabelaCBHPM p = this.pegaPorte(porte);
        if (p == null) {
            return 0.0;
        }
        return TabelaPrecoUtil.calculaTotalExameTipoCBHPM(percentual, custo, uco, p);
    }

    public void setValorUCO(double uco) {
        this.labelVlrUCO.setText(Funcoes.formataDecimal(uco));
    }

    private void alterarPreco() {
        int i;
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        if (this.linhaAlterada > -1) {
            linhas.add(this.linhaAlterada);
        }
        if (this.checkIgnorarMaterial.isSelected() && this.checkIgnorarMetodologia.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        } else if (this.checkIgnorarMaterial.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0 || !this.modelo.getValueAt(i, 3).toString().equals(this.labelVlrMetodologia.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        } else if (this.checkIgnorarMetodologia.isSelected()) {
            for (i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equals(this.labelVlrCodigo.getText()) || linhas.indexOf(i) >= 0 || !this.modelo.getValueAt(i, 1).toString().equals(this.labelVlrMaterial.getText()) || linhas.indexOf(i) >= 0) continue;
                linhas.add(i);
            }
        }
        Iterator iterator = linhas.iterator();
        while (iterator.hasNext()) {
            int linha = (Integer)iterator.next();
            this.modelo.setValueAt(this.textCodigoCBHPM.getText(), linha, 4);
            this.modelo.setValueAt(this.comboPorte.getSelectedItem().toString(), linha, 6);
            if (!Funcoes.isNumeric(this.textPercentual.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 5);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(this.textPercentual.getText().replaceAll(",", "."))), linha, 5);
            }
            if (!Funcoes.isNumeric(this.textCusto.getText().replaceAll(",", "."))) {
                this.modelo.setValueAt("0,00", linha, 7);
            } else {
                this.modelo.setValueAt(Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), Double.parseDouble(this.textCusto.getText().replaceAll(",", "."))), linha, 7);
            }
            this.modelo.setValueAt(this.labelVlrTotal.getText(), linha, 8);
            this.modelo.setValueAt(true, linha, 10);
        }
        this.labelVlrCodigo.setText("");
        this.labelVlrMaterial.setText("");
        this.labelVlrExame.setText("");
        this.labelVlrMetodologia.setText("");
        this.textPercentual.clear();
        this.textCodigoCBHPM.clear();
        this.textCusto.clear();
        this.labelVlrTotal.setText("");
        this.linhaAlterada = -1;
        ScreenUtil.requisitarFoco(this.tableExames);
    }
}

