/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.cadastro.DadosPrecoExame;
import jalis.laboratorio.cadastro.ModeloTabRendererExamesConvenio;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

class AlterarPrecosCBHPMConvenio
extends JDialog
implements ActionListener {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_PERCENTUAL = 3;
    private final int COLUNA_PORTE = 4;
    private final int COLUNA_CUSTO = 5;
    private final int COLUNA_TOTAL = 6;
    JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonAlterar = ComponenteFactory.novoJButton("OK", this, null, null);
    ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "%", "Porte", "Custo", "Total"});
    JTable tableExames = new JTable(this.modelo);
    TTextField textCodigoExame = new TTextField(5);
    JComboBox comboMaterial = new JComboBox();
    JButton buttonBuscaExame = ComponenteFactory.novoJButton(this, true);
    JLabel labelExame = ComponenteFactory.novoJLabel("", new Dimension(150, 20));
    JLabel labelUCO = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    JLabel labelTotal = ComponenteFactory.novoJLabel("", new Dimension(69, 20));
    TTextField textPercentual = new TTextField(8, 2, 3);
    JComboBox comboPorte = new JComboBox();
    TTextField textCusto = new TTextField(8, 2, 3);
    private boolean ok = false;
    private int codigoTabela = -1;
    private int linhaAlterada = -1;
    private int colunaOrdenada = 0;

    public static AlterarPrecosCBHPMConvenio novaInstancia(Object owner) {
        if (owner instanceof JFrame) {
            return new AlterarPrecosCBHPMConvenio((Frame)owner);
        }
        if (owner instanceof JDialog) {
            return new AlterarPrecosCBHPMConvenio((Dialog)owner);
        }
        return null;
    }

    public AlterarPrecosCBHPMConvenio(Frame owner) {
        super(owner, "Pre\u00e7os diferenciados");
        this.montaTela();
    }

    public AlterarPrecosCBHPMConvenio(Dialog owner) {
        super(owner, "Pre\u00e7os diferenciados");
        this.montaTela();
    }

    public void setPortes(int codigoTabela, ArrayList<PorteTabelaCBHPM> portes) {
        this.codigoTabela = codigoTabela;
        this.comboPorte.removeAllItems();
        for (PorteTabelaCBHPM p : portes) {
            this.comboPorte.addItem(p);
        }
    }

    private PorteTabelaCBHPM pegaPorte(String porte) {
        for (int i = 0; i < this.comboPorte.getItemCount(); ++i) {
            PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getItemAt(i);
            if (!p.getPorte().equalsIgnoreCase(porte)) continue;
            return p;
        }
        return null;
    }

    public int getCodigoTabela() {
        return this.codigoTabela;
    }

    public void setExames(ArrayList<DadosPrecoExame> precos) {
        for (DadosPrecoExame p : precos) {
            PorteTabelaCBHPM porte = this.pegaPorte(p.getPorte());
            double valorUCO = Funcoes.isNumeric(this.labelUCO.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelUCO.getText())) : 0.0;
            double total = p.getPercentual() * (porte != null ? porte.getValor() : 0.0) + p.getValor() * valorUCO;
            this.modelo.addLine(new Object[]{p.getCodigoExame(), p.getMaterial(), p.getDescricaoExame(), Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), p.getPercentual()), p.getPorte(), Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), p.getValor()), Funcoes.formataDecimal(total)});
        }
    }

    public ArrayList<DadosPrecoExame> getExames() {
        ArrayList<DadosPrecoExame> precos = new ArrayList<DadosPrecoExame>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            precos.add(new DadosPrecoExame(this.modelo.getValueAt(i, 0).toString(), this.modelo.getValueAt(i, 2).toString(), (DadosMaterial)this.modelo.getValueAt(i, 1), Funcoes.isNumeric(this.modelo.getValueAt(i, 5).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 5).toString())) : 0.0, Funcoes.isNumeric(this.modelo.getValueAt(i, 3).toString()) ? Double.parseDouble(Funcoes.limpaDecimal(this.modelo.getValueAt(i, 3).toString())) : 0.0, this.modelo.getValueAt(i, 4) != null ? this.modelo.getValueAt(i, 4).toString() : "", this.codigoTabela));
        }
        return precos;
    }

    private void montaTela() {
        this.textCodigoExame.setUpperCase(true);
        this.tableExames.setDefaultRenderer(Object.class, new ModeloTabRendererExamesConvenio(new int[]{5, 3, 6}));
        this.tableExames.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AlterarPrecosCBHPMConvenio.this.colunaOrdenada = AlterarPrecosCBHPMConvenio.this.tableExames.getColumnModel().getColumnIndexAtX(e.getX());
                AlterarPrecosCBHPMConvenio.this.modelo.mouseClicked(e);
            }
        });
        JPanel panelCentral = new JPanel(new GridBagLayout());
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.setLayout(new BorderLayout());
        this.add((Component)panelCentral, "Center");
        this.setModal(true);
        this.setSize(new Dimension(740, 528));
        this.setResizable(false);
        ScreenUtil.setBorda(new Component[]{this.labelExame, this.labelTotal, this.labelUCO}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        panelCentral.add((Component)new JLabel("C\u00f3digo"), c);
        c.gridx = 2;
        panelCentral.add((Component)new JLabel("Mat."), c);
        c.gridx = 3;
        panelCentral.add((Component)new JLabel("Exame"), c);
        c.gridx = 4;
        panelCentral.add((Component)new JLabel("Percentual"), c);
        c.gridx = 5;
        panelCentral.add((Component)new JLabel("Porte"), c);
        c.gridx = 6;
        panelCentral.add((Component)new JLabel("Custo"), c);
        c.gridx = 7;
        panelCentral.add((Component)new JLabel("UCO"), c);
        c.gridx = 8;
        panelCentral.add((Component)new JLabel("Total"), c);
        c.gridx = 9;
        panelCentral.add((Component)new JPanel(), c);
        c.gridx = 0;
        c.gridy = 1;
        this.textCodigoExame.setMinimumSize(new Dimension(70, 20));
        this.textCodigoExame.setPreferredSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textCodigoExame, c);
        c.gridx = 1;
        this.buttonBuscaExame.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.buttonBuscaExame, c);
        c.gridx = 2;
        this.comboMaterial.setMinimumSize(new Dimension(120, 20));
        this.comboMaterial.setPreferredSize(new Dimension(120, 20));
        panelCentral.add((Component)this.comboMaterial, c);
        c.gridx = 4;
        this.textPercentual.setPreferredSize(new Dimension(80, 20));
        this.textPercentual.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textPercentual, c);
        c.gridx = 5;
        this.comboPorte.setPreferredSize(new Dimension(80, 20));
        this.comboPorte.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.comboPorte, c);
        c.gridx = 6;
        this.textCusto.setPreferredSize(new Dimension(80, 20));
        this.textCusto.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.textCusto, c);
        c.gridx = 7;
        this.labelUCO.setPreferredSize(new Dimension(80, 20));
        this.labelUCO.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.labelUCO, c);
        c.gridx = 8;
        this.labelTotal.setPreferredSize(new Dimension(80, 20));
        this.labelTotal.setMinimumSize(new Dimension(80, 20));
        panelCentral.add((Component)this.labelTotal, c);
        c.gridx = 9;
        this.buttonAlterar.setPreferredSize(new Dimension(40, 20));
        this.buttonAlterar.setMinimumSize(new Dimension(40, 20));
        this.buttonAlterar.setMaximumSize(new Dimension(40, 20));
        panelCentral.add((Component)this.buttonAlterar, c);
        c.gridx = 3;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelExame.setMinimumSize(new Dimension(30, 20));
        panelCentral.add((Component)this.labelExame, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 10;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        panelCentral.add((Component)new JScrollPane(this.tableExames), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 10;
        c.fill = 2;
        c.weighty = 0.0;
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelCentral.add((Component)panelBotoes, c);
        panelBotoes.add(this.buttonOK);
        panelBotoes.add(this.buttonCancelar);
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.montaEnter((JComponent)panelCentral);
        this.modelo.setColumnSize(new int[]{70, 40, 0, 105, 40, 70, 70}, this.tableExames);
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlterarPrecosCBHPMConvenio.this.tableExames.getSelectedRow() > -1) {
                    e.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AlterarPrecosCBHPMConvenio.this.alterarLinha(AlterarPrecosCBHPMConvenio.this.tableExames.getSelectedRow());
                        }
                    });
                } else if (e.getKeyCode() == 127 && AlterarPrecosCBHPMConvenio.this.tableExames.getSelectedRow() > -1 && Funcoes.mensagem(AlterarPrecosCBHPMConvenio.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AlterarPrecosCBHPMConvenio.this.modelo.removeLine(AlterarPrecosCBHPMConvenio.this.tableExames.getSelectedRow());
                }
            }
        });
        this.textPercentual.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPMConvenio.this.textPercentual.selectAll();
            }
        });
        this.textCusto.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AlterarPrecosCBHPMConvenio.this.textCusto.selectAll();
            }
        });
        this.textPercentual.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AlterarPrecosCBHPMConvenio.this.mostraTotal();
            }
        });
        this.textCusto.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AlterarPrecosCBHPMConvenio.this.mostraTotal();
            }
        });
        this.comboPorte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarPrecosCBHPMConvenio.this.mostraTotal();
            }
        });
        this.textCodigoExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof JButton) && !e.isTemporary()) {
                    AlterarPrecosCBHPMConvenio.this.buscaDescricaoExame(null);
                }
            }
        });
        this.textCodigoExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AlterarPrecosCBHPMConvenio.this.pesquisaExame();
                }
            }
        });
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textCodigoExame);
        this.modelo.ordenarColuna(this.colunaOrdenada);
    }

    private void controlaCampos() {
        this.textCodigoExame.setEnabled(this.linhaAlterada < 0);
        this.comboMaterial.setEnabled(this.linhaAlterada < 0);
        this.buttonBuscaExame.setEnabled(this.linhaAlterada < 0);
    }

    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAlterar) {
            this.alterarPreco();
        } else if (e.getSource() == this.buttonBuscaExame) {
            this.pesquisaExame();
        } else {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }
    }

    private int achaExame(String exame, DadosMaterial material) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String e = this.modelo.getValueAt(i, 0).toString();
            DadosMaterial m = (DadosMaterial)this.modelo.getValueAt(i, 1);
            if (!e.equalsIgnoreCase(exame) || m.getCodigo() != material.getCodigo()) continue;
            return i;
        }
        return -1;
    }

    private void alterarLinha(int linha) {
        if (linha > -1) {
            String porte;
            this.textCodigoExame.setText((String)this.modelo.getValueAt(linha, 0));
            this.comboMaterial.removeAllItems();
            this.comboMaterial.addItem((DadosMaterial)this.modelo.getValueAt(linha, 1));
            this.labelExame.setText((String)this.modelo.getValueAt(linha, 2));
            this.textPercentual.setText((String)this.modelo.getValueAt(linha, 3));
            String string = porte = this.modelo.getValueAt(linha, 4) != null ? this.modelo.getValueAt(linha, 4).toString() : "";
            if (!Funcoes.textoVazio(porte)) {
                this.comboPorte.setSelectedItem(porte);
            }
            this.textCusto.setText(this.modelo.getValueAt(linha, 5).toString());
            this.labelTotal.setText(this.modelo.getValueAt(linha, 6).toString());
            this.linhaAlterada = linha;
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.textPercentual);
        }
    }

    private void mostraTotal() {
        PorteTabelaCBHPM p = (PorteTabelaCBHPM)this.comboPorte.getSelectedItem();
        this.labelTotal.setText(Funcoes.formataDecimal(this.calculaTotalExame(this.textPercentual.getText(), this.textCusto.getText(), this.labelUCO.getText(), p)));
    }

    private double calculaTotalExame(String percentual, String custo, String uco, PorteTabelaCBHPM porte) {
        double valorPercentual = 0.0;
        double valorCusto = 0.0;
        double valorPorte = 0.0;
        double valorUco = 0.0;
        if (Funcoes.isNumeric(percentual)) {
            valorPercentual = Double.parseDouble(Funcoes.limpaDecimal(percentual));
        }
        if (Funcoes.isNumeric(custo)) {
            valorCusto = Double.parseDouble(Funcoes.limpaDecimal(custo));
        }
        if (Funcoes.isNumeric(uco)) {
            valorUco = Double.parseDouble(Funcoes.limpaDecimal(uco));
        }
        valorPorte = porte.getValor();
        return valorPercentual * valorPorte + valorCusto * valorUco;
    }

    public void setValorUCO(double uco) {
        this.labelUCO.setText(Funcoes.formataDecimal(uco));
    }

    private void alterarPreco() {
        if (!Funcoes.textoVazio(this.textCodigoExame.getText()) && this.comboMaterial.getSelectedItem() instanceof DadosMaterial) {
            int linha = this.achaExame(this.textCodigoExame.getText(), (DadosMaterial)this.comboMaterial.getSelectedItem());
            String percentual = "0,00";
            if (Funcoes.isNumeric(this.textPercentual.getText())) {
                percentual = Funcoes.formataDecimal(this.textPercentual.getMaskDecimal(), Double.parseDouble(this.textPercentual.getText().replaceAll(",", ".")));
            }
            String custo = "0,00";
            if (Funcoes.isNumeric(this.textCusto.getText())) {
                custo = Funcoes.formataDecimal(this.textCusto.getMaskDecimal(), Double.parseDouble(this.textCusto.getText().replaceAll(",", ".")));
            }
            if (linha > -1) {
                this.modelo.setValueAt(this.comboPorte.getSelectedItem().toString(), linha, 4);
                this.modelo.setValueAt(percentual, linha, 3);
                this.modelo.setValueAt(custo, linha, 5);
                this.modelo.setValueAt(this.labelTotal.getText(), linha, 6);
            } else {
                this.modelo.addLine(new Object[]{this.textCodigoExame.getText(), (DadosMaterial)this.comboMaterial.getSelectedItem(), this.labelExame.getText(), percentual, this.comboPorte.getSelectedItem().toString(), custo, this.labelTotal.getText()});
            }
        }
        this.textCodigoExame.clear();
        this.comboMaterial.removeAllItems();
        this.labelExame.setText("");
        this.textPercentual.clear();
        this.textCusto.clear();
        this.labelTotal.setText("");
        this.linhaAlterada = -1;
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textCodigoExame);
    }

    private void pesquisaExame() {
        this.textCodigoExame.clear();
        this.comboMaterial.grabFocus();
        Hashtable resultado = Pesquisas.exameAMB(this, false, true);
        if (resultado != null) {
            this.textCodigoExame.setText(resultado.get("exa_codigo").toString());
            int codMaterial = Integer.parseInt(resultado.get("mco_codigo").toString());
            DadosMaterial material = null;
            try {
                material = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, codMaterial);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.buscaDescricaoExame(material);
            this.comboMaterial.grabFocus();
        } else {
            this.textCodigoExame.grabFocus();
        }
    }

    private void buscaDescricaoExame(DadosMaterial materialSelecionado) {
        block5: {
            if (!Funcoes.textoVazio(this.textCodigoExame.getText())) {
                try {
                    Statement st = Conexao.getStatement();
                    if (st == null) break block5;
                    ResultSet rs = Conexao.executeQuery(st, "select exa_descricao from exames where fil_codigo=" + Variaveis.filialPadrao + " and upper(exa_codigo)=upper(" + this.textCodigoExame.getTextDBEscape() + ")");
                    if (rs.next()) {
                        this.labelExame.setText(rs.getString("exa_descricao"));
                        ExameUtil.carregarMateriaisColeta(this.textCodigoExame.getText(), Variaveis.filialPadrao, this.comboMaterial, materialSelecionado, false);
                        break block5;
                    }
                    this.labelExame.setText("N\u00e3o cadastrado");
                    ScreenUtil.requisitarFoco(this.textCodigoExame);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AlterarPrecosCBHPMConvenio (5922)");
                }
            } else {
                this.labelExame.setText("");
            }
        }
    }
}

